<?php

/*  thread_view.php: View a single message thread
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: thread_view.php,v 1.55 2004/03/12 07:40:43 sailfrog Exp $
*/

require_once('../lib/wrapper_functions.php');

/* collect and validate incoming vars */
$hm_input = hm_validate_input($_POST, $_GET, 'thread_view');

/* set ini values and check/get the SESSION vars */
if (hm_session_continue($hm_input['id'], $config_file)) {
    $config = $_SESSION['config'];
}
$hm_input['id'] = session_id();
$str = $_SESSION['str'];

/* login to imap */
if (!$imap_stream = hm_imap_login($_SESSION['user'], $_SESSION['pass'], $config,
                                  $hasty_key, false, false)) {
    hm_logged_out($config_file);
}

/* get unseen status */
$unseen = hm_unseen_status($imap_stream, $_SESSION['folders']);

/* select the mailbox for imap */
hm_select_mailbox($imap_stream, $hm_input['mailbox']);

/* sort information */

$cache = false;
if (isset($_SESSION['thread_data'][$hm_input['mailbox']]) && 
    !isset($hm_input['update'])) {
    foreach ($_SESSION['thread_data'][$hm_input['mailbox']] as $index => $array) {
        if (in_array($hm_input['uid'], $array[1])) {
            $sort_info = $array;
            $cache = true;
            break;
        }
    }
}
if (!$cache) {
    $sort_info = &hmw_get_sort_info($imap_stream, 'THREAD_R', 
                                  $hm_input['mailbox'], $hm_input['uid']);
}
foreach ($sort_info[1] as $index => $message) {
    $ref[] = $sort_info[0][$message];
}

/* toolbar */
hm_toolbar($imap_stream, $hm_input['mailbox'], $unseen, false, $str[173]);

$thread_count = count($sort_info[1]);
$parent_array = array ( 3 => $sort_info[0]);
$headers = &hm_get_messages (implode(',', $sort_info[1]), $imap_stream);
$start = true;
$row = 0;
foreach ($sort_info[1] as $uid) {
    $array = $headers[$uid];
    if ($start) {
        echo '<br>
<table width="95%" align="center" cellpadding="1" cellspacing="0" class="tables5">',"\n";
if ($cache) {
echo '   <tr>
      <td colspan="3" nowrap>
      <form action="thread_view.php" method="post">
      <table align="center" cellpadding="4" cellspacing="1" class="tables2">
         <tr>
            <td>
            <small>
            &nbsp;&nbsp;&nbsp;',$str[172],'.&nbsp;&nbsp;&nbsp;
            &nbsp;&nbsp;
            </small>
            </td>
            <td>
            <input type="hidden" name="id" value="',$hm_input['id'],'">
            <input type="hidden" name="mailbox" value="',$hm_input['mailbox'],'">
            <input type="hidden" name="uid" value="',$hm_input['uid'],'">
            <input type="submit" class="button1" name="update" value="',$str[61],'">
            </td>
         </tr>
      </table>
      </form>
      <br>
      </td>
   </tr>',"\n";
}
echo '   <tr>
      <td colspan="3" nowrap align="center">
      <table align="center" width="99%" cellpadding="4" cellspacing="2" class="tables4">
         <tr>
            <td>
            <small>',$str[171],':&nbsp;&nbsp;</small>
            <a class="font2" href="mailbox.php?mailbox=',$hm_input['mailbox'],
            '&amp;id=',urlencode($hm_input['id']),'">',urldecode($hm_input['mailbox']),'
            </a>
            </td>
            <td>
            <small>&nbsp;&nbsp;<b>',$thread_count,
            '&nbsp;</b>',$str[214],':</small>
            &nbsp;&nbsp;&nbsp;<font class="font1">',$array[0],'
            </font>
            </td>
         </tr>
      </table>
      <br>
      </td>
   </tr>
   <tr class="tables1">
      <td>
      &nbsp;
      </td>
   </tr>
   <tr class="tables1">
      <td align="center">
      <table class="tables2" cellpadding="2" cellspacing="0" align="center" width="98%">
      <tr>',"\n";
hm_start_message_listing($hm_input['mailbox']);
echo '   </tr>',"\n";
        $start = false;
    }
    $current = false;
    if (isset($hm_input['uid']) && $hm_input['uid'] == $uid) {
        $current = true;
    }
    hm_print_row($array, false, false, $hm_input['mailbox'], $hm_input['id'], $uid,
                 $parent_array, true, false, false, true, $current, $ref, $row);
    $row++;
}
echo '
         </tr>
      </table>
      </td>
   </tr>
   <tr class="tables1">
      <td>
      &nbsp;
      </td>
   </tr>
</table>
</body>
</html>';

hm_imap_logout($imap_stream); 

?>
