<?php

/*  charsets.php: tables for converting different charsets to UTF-8
 *
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

 *$Id: charsets.php,v 1.3 2003/08/31 06:10:58 sailfrog Exp $
*/

$codes = array(
    'iso-8859-2' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0104', '0xA2' => '0x02D8', '0xA3' => '0x0141',
        '0xA4' => '0x00A4', '0xA5' => '0x013D', '0xA6' => '0x015A', '0xA7' => '0x00A7',
        '0xA8' => '0x00A8', '0xA9' => '0x0160', '0xAA' => '0x015E', '0xAB' => '0x0164',
        '0xAC' => '0x0179', '0xAD' => '0x00AD', '0xAE' => '0x017D', '0xAF' => '0x017B',
        '0xB0' => '0x00B0', '0xB1' => '0x0105', '0xB2' => '0x02DB', '0xB3' => '0x0142',
        '0xB4' => '0x00B4', '0xB5' => '0x013E', '0xB6' => '0x015B', '0xB7' => '0x02C7',
        '0xB8' => '0x00B8', '0xB9' => '0x0161', '0xBA' => '0x015F', '0xBB' => '0x0165',
        '0xBC' => '0x017A', '0xBD' => '0x02DD', '0xBE' => '0x017E', '0xBF' => '0x017C',
        '0xC0' => '0x0154', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x0102',
        '0xC4' => '0x00C4', '0xC5' => '0x0139', '0xC6' => '0x0106', '0xC7' => '0x00C7',
        '0xC8' => '0x010C', '0xC9' => '0x00C9', '0xCA' => '0x0118', '0xCB' => '0x00CB',
        '0xCC' => '0x011A', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x010E',
        '0xD0' => '0x0110', '0xD1' => '0x0143', '0xD2' => '0x0147', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x0150', '0xD6' => '0x00D6', '0xD7' => '0x00D7',
        '0xD8' => '0x0158', '0xD9' => '0x016E', '0xDA' => '0x00DA', '0xDB' => '0x0170',
        '0xDC' => '0x00DC', '0xDD' => '0x00DD', '0xDE' => '0x0162', '0xDF' => '0x00DF',
        '0xE0' => '0x0155', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x0103',
        '0xE4' => '0x00E4', '0xE5' => '0x013A', '0xE6' => '0x0107', '0xE7' => '0x00E7',
        '0xE8' => '0x010D', '0xE9' => '0x00E9', '0xEA' => '0x0119', '0xEB' => '0x00EB',
        '0xEC' => '0x011B', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x010F',
        '0xF0' => '0x0111', '0xF1' => '0x0144', '0xF2' => '0x0148', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x0151', '0xF6' => '0x00F6', '0xF7' => '0x00F7',
        '0xF8' => '0x0159', '0xF9' => '0x016F', '0xFA' => '0x00FA', '0xFB' => '0x0171',
        '0xFC' => '0x00FC', '0xFD' => '0x00FD', '0xFE' => '0x0163', '0xFF' => '0x02D9'),
    'iso-8859-3' => array(    
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0126', '0xA2' => '0x02D8', '0xA3' => '0x00A3',
        '0xA4' => '0x00A4', '0xA6' => '0x0124', '0xA7' => '0x00A7', '0xA8' => '0x00A8',
        '0xA9' => '0x0130', '0xAA' => '0x015E', '0xAB' => '0x011E', '0xAC' => '0x0134',
        '0xAD' => '0x00AD', '0xAF' => '0x017B', '0xB0' => '0x00B0', '0xB1' => '0x0127',
        '0xB2' => '0x00B2', '0xB3' => '0x00B3', '0xB4' => '0x00B4', '0xB5' => '0x00B5',
        '0xB6' => '0x0125', '0xB7' => '0x00B7', '0xB8' => '0x00B8', '0xB9' => '0x0131',
        '0xBA' => '0x015F', '0xBB' => '0x011F', '0xBC' => '0x0135', '0xBD' => '0x00BD',
        '0xBF' => '0x017C', '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2',
        '0xC4' => '0x00C4', '0xC5' => '0x010A', '0xC6' => '0x0108', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD1' => '0x00D1', '0xD2' => '0x00D2', '0xD3' => '0x00D3', '0xD4' => '0x00D4',
        '0xD5' => '0x0120', '0xD6' => '0x00D6', '0xD7' => '0x00D7', '0xD8' => '0x011C',
        '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB', '0xDC' => '0x00DC',
        '0xDD' => '0x016C', '0xDE' => '0x015C', '0xDF' => '0x00DF', '0xE0' => '0x00E0',
        '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE4' => '0x00E4', '0xE5' => '0x010B',
        '0xE6' => '0x0109', '0xE7' => '0x00E7', '0xE8' => '0x00E8', '0xE9' => '0x00E9',
        '0xEA' => '0x00EA', '0xEB' => '0x00EB', '0xEC' => '0x00EC', '0xED' => '0x00ED',
        '0xEE' => '0x00EE', '0xEF' => '0x00EF', '0xF1' => '0x00F1', '0xF2' => '0x00F2',
        '0xF3' => '0x00F3', '0xF4' => '0x00F4', '0xF5' => '0x0121', '0xF6' => '0x00F6',
        '0xF7' => '0x00F7', '0xF8' => '0x011D', '0xF9' => '0x00F9', '0xFA' => '0x00FA',
        '0xFB' => '0x00FB', '0xFC' => '0x00FC', '0xFD' => '0x016D', '0xFE' => '0x015D',
        '0xFF' => '0x02D9'),
    'iso-8859-4' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0104', '0xA2' => '0x0138', '0xA3' => '0x0156',
        '0xA4' => '0x00A4', '0xA5' => '0x0128', '0xA6' => '0x013B', '0xA7' => '0x00A7',
        '0xA8' => '0x00A8', '0xA9' => '0x0160', '0xAA' => '0x0112', '0xAB' => '0x0122',
        '0xAC' => '0x0166', '0xAD' => '0x00AD', '0xAE' => '0x017D', '0xAF' => '0x00AF',
        '0xB0' => '0x00B0', '0xB1' => '0x0105', '0xB2' => '0x02DB', '0xB3' => '0x0157',
        '0xB4' => '0x00B4', '0xB5' => '0x0129', '0xB6' => '0x013C', '0xB7' => '0x02C7',
        '0xB8' => '0x00B8', '0xB9' => '0x0161', '0xBA' => '0x0113', '0xBB' => '0x0123',
        '0xBC' => '0x0167', '0xBD' => '0x014A', '0xBE' => '0x017E', '0xBF' => '0x014B',
        '0xC0' => '0x0100', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x012E',
        '0xC8' => '0x010C', '0xC9' => '0x00C9', '0xCA' => '0x0118', '0xCB' => '0x00CB',
        '0xCC' => '0x0116', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x012A',
        '0xD0' => '0x0110', '0xD1' => '0x0145', '0xD2' => '0x014C', '0xD3' => '0x0136',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x00D7',
        '0xD8' => '0x00D8', '0xD9' => '0x0172', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x0168', '0xDE' => '0x016A', '0xDF' => '0x00DF',
        '0xE0' => '0x0101', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x012F',
        '0xE8' => '0x010D', '0xE9' => '0x00E9', '0xEA' => '0x0119', '0xEB' => '0x00EB',
        '0xEC' => '0x0117', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x012B',
        '0xF0' => '0x0111', '0xF1' => '0x0146', '0xF2' => '0x014D', '0xF3' => '0x0137',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x00F7',
        '0xF8' => '0x00F8', '0xF9' => '0x0173', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x0169', '0xFE' => '0x016B', '0xFF' => '0x02D9'),
    'iso-8859-5' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0401', '0xA2' => '0x0402', '0xA3' => '0x0403',
        '0xA4' => '0x0404', '0xA5' => '0x0405', '0xA6' => '0x0406', '0xA7' => '0x0407',
        '0xA8' => '0x0408', '0xA9' => '0x0409', '0xAA' => '0x040A', '0xAB' => '0x040B',
        '0xAC' => '0x040C', '0xAD' => '0x00AD', '0xAE' => '0x040E', '0xAF' => '0x040F',
        '0xB0' => '0x0410', '0xB1' => '0x0411', '0xB2' => '0x0412', '0xB3' => '0x0413',
        '0xB4' => '0x0414', '0xB5' => '0x0415', '0xB6' => '0x0416', '0xB7' => '0x0417',
        '0xB8' => '0x0418', '0xB9' => '0x0419', '0xBA' => '0x041A', '0xBB' => '0x041B',
        '0xBC' => '0x041C', '0xBD' => '0x041D', '0xBE' => '0x041E', '0xBF' => '0x041F',
        '0xC0' => '0x0420', '0xC1' => '0x0421', '0xC2' => '0x0422', '0xC3' => '0x0423',
        '0xC4' => '0x0424', '0xC5' => '0x0425', '0xC6' => '0x0426', '0xC7' => '0x0427',
        '0xC8' => '0x0428', '0xC9' => '0x0429', '0xCA' => '0x042A', '0xCB' => '0x042B',
        '0xCC' => '0x042C', '0xCD' => '0x042D', '0xCE' => '0x042E', '0xCF' => '0x042F',
        '0xD0' => '0x0430', '0xD1' => '0x0431', '0xD2' => '0x0432', '0xD3' => '0x0433',
        '0xD4' => '0x0434', '0xD5' => '0x0435', '0xD6' => '0x0436', '0xD7' => '0x0437',
        '0xD8' => '0x0438', '0xD9' => '0x0439', '0xDA' => '0x043A', '0xDB' => '0x043B',
        '0xDC' => '0x043C', '0xDD' => '0x043D', '0xDE' => '0x043E', '0xDF' => '0x043F',
        '0xE0' => '0x0440', '0xE1' => '0x0441', '0xE2' => '0x0442', '0xE3' => '0x0443',
        '0xE4' => '0x0444', '0xE5' => '0x0445', '0xE6' => '0x0446', '0xE7' => '0x0447',
        '0xE8' => '0x0448', '0xE9' => '0x0449', '0xEA' => '0x044A', '0xEB' => '0x044B',
        '0xEC' => '0x044C', '0xED' => '0x044D', '0xEE' => '0x044E', '0xEF' => '0x044F',
        '0xF0' => '0x2116', '0xF1' => '0x0451', '0xF2' => '0x0452', '0xF3' => '0x0453',
        '0xF4' => '0x0454', '0xF5' => '0x0455', '0xF6' => '0x0456', '0xF7' => '0x0457',
        '0xF8' => '0x0458', '0xF9' => '0x0459', '0xFA' => '0x045A', '0xFB' => '0x045B',
        '0xFC' => '0x045C', '0xFD' => '0x00A7', '0xFE' => '0x045E', '0xFF' => '0x045F'),
    'iso-8859-6' => array(
        '0x00'  => 'x0000', '0x01'  => 'x0001', '0x02'  => 'x0002', '0x03'  => 'x0003',
        '0x04'  => 'x0004', '0x05'  => 'x0005', '0x06'  => 'x0006', '0x07'  => 'x0007',
        '0x08'  => 'x0008', '0x09'  => 'x0009', '0x0A'  => 'x000A', '0x0B'  => 'x000B',
        '0x0C'  => 'x000C', '0x0D'  => 'x000D', '0x0E'  => 'x000E', '0x0F'  => 'x000F',
        '0x10'  => 'x0010', '0x11'  => 'x0011', '0x12'  => 'x0012', '0x13'  => 'x0013',
        '0x14'  => 'x0014', '0x15'  => 'x0015', '0x16'  => 'x0016', '0x17'  => 'x0017',
        '0x18'  => 'x0018', '0x19'  => 'x0019', '0x1A'  => 'x001A', '0x1B'  => 'x001B',
        '0x1C'  => 'x001C', '0x1D'  => 'x001D', '0x1E'  => 'x001E', '0x1F'  => 'x001F',
        '0x20'  => 'x0020', '0x21'  => 'x0021', '0x22'  => 'x0022', '0x23'  => 'x0023',
        '0x24'  => 'x0024', '0x25'  => 'x0025', '0x26'  => 'x0026', '0x27'  => 'x0027',
        '0x28'  => 'x0028', '0x29'  => 'x0029', '0x2A'  => 'x002A', '0x2B'  => 'x002B',
        '0x2C'  => 'x002C', '0x2D'  => 'x002D', '0x2E'  => 'x002E', '0x2F'  => 'x002F',
        '0x30'  => 'x0030', '0x31'  => 'x0031', '0x32'  => 'x0032', '0x33'  => 'x0033',
        '0x34'  => 'x0034', '0x35'  => 'x0035', '0x36'  => 'x0036', '0x37'  => 'x0037',
        '0x38'  => 'x0038', '0x39'  => 'x0039', '0x3A'  => 'x003A', '0x3B'  => 'x003B',
        '0x3C'  => 'x003C', '0x3D'  => 'x003D', '0x3E'  => 'x003E', '0x3F'  => 'x003F',
        '0x40'  => 'x0040', '0x41'  => 'x0041', '0x42'  => 'x0042', '0x43'  => 'x0043',
        '0x44'  => 'x0044', '0x45'  => 'x0045', '0x46'  => 'x0046', '0x47'  => 'x0047',
        '0x48'  => 'x0048', '0x49'  => 'x0049', '0x4A'  => 'x004A', '0x4B'  => 'x004B',
        '0x4C'  => 'x004C', '0x4D'  => 'x004D', '0x4E'  => 'x004E', '0x4F'  => 'x004F',
        '0x50'  => 'x0050', '0x51'  => 'x0051', '0x52'  => 'x0052', '0x53'  => 'x0053',
        '0x54'  => 'x0054', '0x55'  => 'x0055', '0x56'  => 'x0056', '0x57'  => 'x0057',
        '0x58'  => 'x0058', '0x59'  => 'x0059', '0x5A'  => 'x005A', '0x5B'  => 'x005B',
        '0x5C'  => 'x005C', '0x5D'  => 'x005D', '0x5E'  => 'x005E', '0x5F'  => 'x005F',
        '0x60'  => 'x0060', '0x61'  => 'x0061', '0x62'  => 'x0062', '0x63'  => 'x0063',
        '0x64'  => 'x0064', '0x65'  => 'x0065', '0x66'  => 'x0066', '0x67'  => 'x0067',
        '0x68'  => 'x0068', '0x69'  => 'x0069', '0x6A'  => 'x006A', '0x6B'  => 'x006B',
        '0x6C'  => 'x006C', '0x6D'  => 'x006D', '0x6E'  => 'x006E', '0x6F'  => 'x006F',
        '0x70'  => 'x0070', '0x71'  => 'x0071', '0x72'  => 'x0072', '0x73'  => 'x0073',
        '0x74'  => 'x0074', '0x75'  => 'x0075', '0x76'  => 'x0076', '0x77'  => 'x0077',
        '0x78'  => 'x0078', '0x79'  => 'x0079', '0x7A'  => 'x007A', '0x7B'  => 'x007B',
        '0x7C'  => 'x007C', '0x7D'  => 'x007D', '0x7E'  => 'x007E', '0x7F'  => 'x007F',
        '0x80'  => 'x0080', '0x81'  => 'x0081', '0x82'  => 'x0082', '0x83'  => 'x0083',
        '0x84'  => 'x0084', '0x85'  => 'x0085', '0x86'  => 'x0086', '0x87'  => 'x0087',
        '0x88'  => 'x0088', '0x89'  => 'x0089', '0x8A'  => 'x008A', '0x8B'  => 'x008B',
        '0x8C'  => 'x008C', '0x8D'  => 'x008D', '0x8E'  => 'x008E', '0x8F'  => 'x008F',
        '0x90'  => 'x0090', '0x91'  => 'x0091', '0x92'  => 'x0092', '0x93'  => 'x0093',
        '0x94'  => 'x0094', '0x95'  => 'x0095', '0x96'  => 'x0096', '0x97'  => 'x0097',
        '0x98'  => 'x0098', '0x99'  => 'x0099', '0x9A'  => 'x009A', '0x9B'  => 'x009B',
        '0x9C'  => 'x009C', '0x9D'  => 'x009D', '0x9E'  => 'x009E', '0x9F'  => 'x009F',
        '0xA0'  => 'x00A0', '0xA4'  => 'x00A4', '0xAC'  => 'x060C', '0xAD'  => 'x00AD',
        '0xBB'  => 'x061B', '0xBF'  => 'x061F', '0xC1'  => 'x0621', '0xC2'  => 'x0622',
        '0xC3'  => 'x0623', '0xC4'  => 'x0624', '0xC5'  => 'x0625', '0xC6'  => 'x0626',
        '0xC7'  => 'x0627', '0xC8'  => 'x0628', '0xC9'  => 'x0629', '0xCA'  => 'x062A',
        '0xCB'  => 'x062B', '0xCC'  => 'x062C', '0xCD'  => 'x062D', '0xCE'  => 'x062E',
        '0xCF'  => 'x062F', '0xD0'  => 'x0630', '0xD1'  => 'x0631', '0xD2'  => 'x0632',
        '0xD3'  => 'x0633', '0xD4'  => 'x0634', '0xD5'  => 'x0635', '0xD6'  => 'x0636',
        '0xD7'  => 'x0637', '0xD8'  => 'x0638', '0xD9'  => 'x0639', '0xDA'  => 'x063A',
        '0xE0'  => 'x0640', '0xE1'  => 'x0641', '0xE2'  => 'x0642', '0xE3'  => 'x0643',
        '0xE4'  => 'x0644', '0xE5'  => 'x0645', '0xE6'  => 'x0646', '0xE7'  => 'x0647',
        '0xE8'  => 'x0648', '0xE9'  => 'x0649', '0xEA'  => 'x064A', '0xEB'  => 'x064B',
        '0xEC'  => 'x064C', '0xED'  => 'x064D', '0xEE'  => 'x064E', '0xEF'  => 'x064F',
        '0xF0'  => 'x0650', '0xF1'  => 'x0651', '0xF2'  => 'x0652'),
    'iso-8859-7' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x2018', '0xA2' => '0x2019', '0xA3' => '0x00A3',
        '0xA6' => '0x00A6', '0xA7' => '0x00A7', '0xA8' => '0x00A8', '0xA9' => '0x00A9',
        '0xAB' => '0x00AB', '0xAC' => '0x00AC', '0xAD' => '0x00AD', '0xAF' => '0x2015',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x00B2', '0xB3' => '0x00B3',
        '0xB4' => '0x0384', '0xB5' => '0x0385', '0xB6' => '0x0386', '0xB7' => '0x00B7',
        '0xB8' => '0x0388', '0xB9' => '0x0389', '0xBA' => '0x038A', '0xBB' => '0x00BB',
        '0xBC' => '0x038C', '0xBD' => '0x00BD', '0xBE' => '0x038E', '0xBF' => '0x038F',
        '0xC0' => '0x0390', '0xC1' => '0x0391', '0xC2' => '0x0392', '0xC3' => '0x0393',
        '0xC4' => '0x0394', '0xC5' => '0x0395', '0xC6' => '0x0396', '0xC7' => '0x0397',
        '0xC8' => '0x0398', '0xC9' => '0x0399', '0xCA' => '0x039A', '0xCB' => '0x039B',
        '0xCC' => '0x039C', '0xCD' => '0x039D', '0xCE' => '0x039E', '0xCF' => '0x039F',
        '0xD0' => '0x03A0', '0xD1' => '0x03A1', '0xD3' => '0x03A3', '0xD4' => '0x03A4',
        '0xD5' => '0x03A5', '0xD6' => '0x03A6', '0xD7' => '0x03A7', '0xD8' => '0x03A8',
        '0xD9' => '0x03A9', '0xDA' => '0x03AA', '0xDB' => '0x03AB', '0xDC' => '0x03AC',
        '0xDD' => '0x03AD', '0xDE' => '0x03AE', '0xDF' => '0x03AF', '0xE0' => '0x03B0',
        '0xE1' => '0x03B1', '0xE2' => '0x03B2', '0xE3' => '0x03B3', '0xE4' => '0x03B4',
        '0xE5' => '0x03B5', '0xE6' => '0x03B6', '0xE7' => '0x03B7', '0xE8' => '0x03B8',
        '0xE9' => '0x03B9', '0xEA' => '0x03BA', '0xEB' => '0x03BB', '0xEC' => '0x03BC',
        '0xED' => '0x03BD', '0xEE' => '0x03BE', '0xEF' => '0x03BF', '0xF0' => '0x03C0',
        '0xF1' => '0x03C1', '0xF2' => '0x03C2', '0xF3' => '0x03C3', '0xF4' => '0x03C4',
        '0xF5' => '0x03C5', '0xF6' => '0x03C6', '0xF7' => '0x03C7', '0xF8' => '0x03C8',
        '0xF9' => '0x03C9', '0xFA' => '0x03CA', '0xFB' => '0x03CB', '0xFC' => '0x03CC',
        '0xFD' => '0x03CD', '0xFE' => '0x03CE',),
    'iso-8859-8' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA2' => '0x00A2', '0xA3' => '0x00A3', '0xA4' => '0x00A4',
        '0xA5' => '0x00A5', '0xA6' => '0x00A6', '0xA7' => '0x00A7', '0xA8' => '0x00A8',
        '0xA9' => '0x00A9', '0xAA' => '0x00D7', '0xAB' => '0x00AB', '0xAC' => '0x00AC',
        '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x00AF', '0xB0' => '0x00B0',
        '0xB1' => '0x00B1', '0xB2' => '0x00B2', '0xB3' => '0x00B3', '0xB4' => '0x00B4',
        '0xB5' => '0x00B5', '0xB6' => '0x00B6', '0xB7' => '0x00B7', '0xB8' => '0x00B8',
        '0xB9' => '0x00B9', '0xBA' => '0x00F7', '0xBB' => '0x00BB', '0xBC' => '0x00BC',
        '0xBD' => '0x00BD', '0xBE' => '0x00BE', '0xDF' => '0x2017', '0xE0' => '0x05D0',
        '0xE1' => '0x05D1', '0xE2' => '0x05D2', '0xE3' => '0x05D3', '0xE4' => '0x05D4',
        '0xE5' => '0x05D5', '0xE6' => '0x05D6', '0xE7' => '0x05D7', '0xE8' => '0x05D8',
        '0xE9' => '0x05D9', '0xEA' => '0x05DA', '0xEB' => '0x05DB', '0xEC' => '0x05DC',
        '0xED' => '0x05DD', '0xEE' => '0x05DE', '0xEF' => '0x05DF', '0xF0' => '0x05E0',
        '0xF1' => '0x05E1', '0xF2' => '0x05E2', '0xF3' => '0x05E3', '0xF4' => '0x05E4',
        '0xF5' => '0x05E5', '0xF6' => '0x05E6', '0xF7' => '0x05E7', '0xF8' => '0x05E8',
        '0xF9' => '0x05E9', '0xFA' => '0x05EA', '0xFD' => '0x200E', '0xFE' => '0x200F'),
    'iso-8859-9' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x00A1', '0xA2' => '0x00A2', '0xA3' => '0x00A3',
        '0xA4' => '0x00A4', '0xA5' => '0x00A5', '0xA6' => '0x00A6', '0xA7' => '0x00A7',
        '0xA8' => '0x00A8', '0xA9' => '0x00A9', '0xAA' => '0x00AA', '0xAB' => '0x00AB',
        '0xAC' => '0x00AC', '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x00AF',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x00B2', '0xB3' => '0x00B3',
        '0xB4' => '0x00B4', '0xB5' => '0x00B5', '0xB6' => '0x00B6', '0xB7' => '0x00B7',
        '0xB8' => '0x00B8', '0xB9' => '0x00B9', '0xBA' => '0x00BA', '0xBB' => '0x00BB',
        '0xBC' => '0x00BC', '0xBD' => '0x00BD', '0xBE' => '0x00BE', '0xBF' => '0x00BF',
        '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x011E', '0xD1' => '0x00D1', '0xD2' => '0x00D2', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x00D7',
        '0xD8' => '0x00D8', '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x0130', '0xDE' => '0x015E', '0xDF' => '0x00DF',
        '0xE0' => '0x00E0', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x00E7',
        '0xE8' => '0x00E8', '0xE9' => '0x00E9', '0xEA' => '0x00EA', '0xEB' => '0x00EB',
        '0xEC' => '0x00EC', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x011F', '0xF1' => '0x00F1', '0xF2' => '0x00F2', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x00F7',
        '0xF8' => '0x00F8', '0xF9' => '0x00F9', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x0131', '0xFE' => '0x015F', '0xFF' => '0x00FF'),
    'iso-8859-10' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0104', '0xA2' => '0x0112', '0xA3' => '0x0122',
        '0xA4' => '0x012A', '0xA5' => '0x0128', '0xA6' => '0x0136', '0xA7' => '0x00A7',
        '0xA8' => '0x013B', '0xA9' => '0x0110', '0xAA' => '0x0160', '0xAB' => '0x0166',
        '0xAC' => '0x017D', '0xAD' => '0x00AD', '0xAE' => '0x016A', '0xAF' => '0x014A',
        '0xB0' => '0x00B0', '0xB1' => '0x0105', '0xB2' => '0x0113', '0xB3' => '0x0123',
        '0xB4' => '0x012B', '0xB5' => '0x0129', '0xB6' => '0x0137', '0xB7' => '0x00B7',
        '0xB8' => '0x013C', '0xB9' => '0x0111', '0xBA' => '0x0161', '0xBB' => '0x0167',
        '0xBC' => '0x017E', '0xBD' => '0x2015', '0xBE' => '0x016B', '0xBF' => '0x014B',
        '0xC0' => '0x0100', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x012E',
        '0xC8' => '0x010C', '0xC9' => '0x00C9', '0xCA' => '0x0118', '0xCB' => '0x00CB',
        '0xCC' => '0x0116', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x00D0', '0xD1' => '0x0145', '0xD2' => '0x014C', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x0168',
        '0xD8' => '0x00D8', '0xD9' => '0x0172', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x00DD', '0xDE' => '0x00DE', '0xDF' => '0x00DF',
        '0xE0' => '0x0101', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x012F',
        '0xE8' => '0x010D', '0xE9' => '0x00E9', '0xEA' => '0x0119', '0xEB' => '0x00EB',
        '0xEC' => '0x0117', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x00F0', '0xF1' => '0x0146', '0xF2' => '0x014D', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x0169',
        '0xF8' => '0x00F8', '0xF9' => '0x0173', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x00FD', '0xFE' => '0x00FE', '0xFF' => '0x0138'),
    'iso-8859-11' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0E01', '0xA2' => '0x0E02', '0xA3' => '0x0E03',
        '0xA4' => '0x0E04', '0xA5' => '0x0E05', '0xA6' => '0x0E06', '0xA7' => '0x0E07',
        '0xA8' => '0x0E08', '0xA9' => '0x0E09', '0xAA' => '0x0E0A', '0xAB' => '0x0E0B',
        '0xAC' => '0x0E0C', '0xAD' => '0x0E0D', '0xAE' => '0x0E0E', '0xAF' => '0x0E0F',
        '0xB0' => '0x0E10', '0xB1' => '0x0E11', '0xB2' => '0x0E12', '0xB3' => '0x0E13',
        '0xB4' => '0x0E14', '0xB5' => '0x0E15', '0xB6' => '0x0E16', '0xB7' => '0x0E17',
        '0xB8' => '0x0E18', '0xB9' => '0x0E19', '0xBA' => '0x0E1A', '0xBB' => '0x0E1B',
        '0xBC' => '0x0E1C', '0xBD' => '0x0E1D', '0xBE' => '0x0E1E', '0xBF' => '0x0E1F',
        '0xC0' => '0x0E20', '0xC1' => '0x0E21', '0xC2' => '0x0E22', '0xC3' => '0x0E23',
        '0xC4' => '0x0E24', '0xC5' => '0x0E25', '0xC6' => '0x0E26', '0xC7' => '0x0E27',
        '0xC8' => '0x0E28', '0xC9' => '0x0E29', '0xCA' => '0x0E2A', '0xCB' => '0x0E2B',
        '0xCC' => '0x0E2C', '0xCD' => '0x0E2D', '0xCE' => '0x0E2E', '0xCF' => '0x0E2F',
        '0xD0' => '0x0E30', '0xD1' => '0x0E31', '0xD2' => '0x0E32', '0xD3' => '0x0E33',
        '0xD4' => '0x0E34', '0xD5' => '0x0E35', '0xD6' => '0x0E36', '0xD7' => '0x0E37',
        '0xD8' => '0x0E38', '0xD9' => '0x0E39', '0xDA' => '0x0E3A', '0xDF' => '0x0E3F',
        '0xE0' => '0x0E40', '0xE1' => '0x0E41', '0xE2' => '0x0E42', '0xE3' => '0x0E43',
        '0xE4' => '0x0E44', '0xE5' => '0x0E45', '0xE6' => '0x0E46', '0xE7' => '0x0E47',
        '0xE8' => '0x0E48', '0xE9' => '0x0E49', '0xEA' => '0x0E4A', '0xEB' => '0x0E4B',
        '0xEC' => '0x0E4C', '0xED' => '0x0E4D', '0xEE' => '0x0E4E', '0xEF' => '0x0E4F',
        '0xF0' => '0x0E50', '0xF1' => '0x0E51', '0xF2' => '0x0E52', '0xF3' => '0x0E53',
        '0xF4' => '0x0E54', '0xF5' => '0x0E55', '0xF6' => '0x0E56', '0xF7' => '0x0E57',
        '0xF8' => '0x0E58', '0xF9' => '0x0E59', '0xFA' => '0x0E5A', '0xFB' => '0x0E5B'),
    'iso-8859-14' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x1E02', '0xA2' => '0x1E03', '0xA3' => '0x00A3',
        '0xA4' => '0x010A', '0xA5' => '0x010B', '0xA6' => '0x1E0A', '0xA7' => '0x00A7',
        '0xA8' => '0x1E80', '0xA9' => '0x00A9', '0xAA' => '0x1E82', '0xAB' => '0x1E0B',
        '0xAC' => '0x1EF2', '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x0178',
        '0xB0' => '0x1E1E', '0xB1' => '0x1E1F', '0xB2' => '0x0120', '0xB3' => '0x0121',
        '0xB4' => '0x1E40', '0xB5' => '0x1E41', '0xB6' => '0x00B6', '0xB7' => '0x1E56',
        '0xB8' => '0x1E81', '0xB9' => '0x1E57', '0xBA' => '0x1E83', '0xBB' => '0x1E60',
        '0xBC' => '0x1EF3', '0xBD' => '0x1E84', '0xBE' => '0x1E85', '0xBF' => '0x1E61',
        '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x0174', '0xD1' => '0x00D1', '0xD2' => '0x00D2', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x1E6A',
        '0xD8' => '0x00D8', '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x00DD', '0xDE' => '0x0176', '0xDF' => '0x00DF',
        '0xE0' => '0x00E0', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x00E7',
        '0xE8' => '0x00E8', '0xE9' => '0x00E9', '0xEA' => '0x00EA', '0xEB' => '0x00EB',
        '0xEC' => '0x00EC', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x0175', '0xF1' => '0x00F1', '0xF2' => '0x00F2', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x1E6B',
        '0xF8' => '0x00F8', '0xF9' => '0x00F9', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x00FD', '0xFE' => '0x0177', '0xFF' => '0x00FF'),
    'iso-8859-15' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x00A1', '0xA2' => '0x00A2', '0xA3' => '0x00A3',
        '0xA4' => '0x20AC', '0xA5' => '0x00A5', '0xA6' => '0x0160', '0xA7' => '0x00A7',
        '0xA8' => '0x0161', '0xA9' => '0x00A9', '0xAA' => '0x00AA', '0xAB' => '0x00AB',
        '0xAC' => '0x00AC', '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x00AF',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x00B2', '0xB3' => '0x00B3',
        '0xB4' => '0x017D', '0xB5' => '0x00B5', '0xB6' => '0x00B6', '0xB7' => '0x00B7',
        '0xB8' => '0x017E', '0xB9' => '0x00B9', '0xBA' => '0x00BA', '0xBB' => '0x00BB',
        '0xBC' => '0x0152', '0xBD' => '0x0153', '0xBE' => '0x0178', '0xBF' => '0x00BF',
        '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x00D0', '0xD1' => '0x00D1', '0xD2' => '0x00D2', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x00D7',
        '0xD8' => '0x00D8', '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x00DD', '0xDE' => '0x00DE', '0xDF' => '0x00DF',
        '0xE0' => '0x00E0', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x00E7',
        '0xE8' => '0x00E8', '0xE9' => '0x00E9', '0xEA' => '0x00EA', '0xEB' => '0x00EB',
        '0xEC' => '0x00EC', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x00F0', '0xF1' => '0x00F1', '0xF2' => '0x00F2', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x00F7',
        '0xF8' => '0x00F8', '0xF9' => '0x00F9', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x00FD', '0xFE' => '0x00FE', '0xFF' => '0x00FF'),
    'iso-8859-16' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0080', '0x81' => '0x0081', '0x82' => '0x0082', '0x83' => '0x0083',
        '0x84' => '0x0084', '0x85' => '0x0085', '0x86' => '0x0086', '0x87' => '0x0087',
        '0x88' => '0x0088', '0x89' => '0x0089', '0x8A' => '0x008A', '0x8B' => '0x008B',
        '0x8C' => '0x008C', '0x8D' => '0x008D', '0x8E' => '0x008E', '0x8F' => '0x008F',
        '0x90' => '0x0090', '0x91' => '0x0091', '0x92' => '0x0092', '0x93' => '0x0093',
        '0x94' => '0x0094', '0x95' => '0x0095', '0x96' => '0x0096', '0x97' => '0x0097',
        '0x98' => '0x0098', '0x99' => '0x0099', '0x9A' => '0x009A', '0x9B' => '0x009B',
        '0x9C' => '0x009C', '0x9D' => '0x009D', '0x9E' => '0x009E', '0x9F' => '0x009F',
        '0xA0' => '0x00A0', '0xA1' => '0x0104', '0xA2' => '0x0105', '0xA3' => '0x0141',
        '0xA4' => '0x20AC', '0xA5' => '0x201E', '0xA6' => '0x0160', '0xA7' => '0x00A7',
        '0xA8' => '0x0161', '0xA9' => '0x00A9', '0xAA' => '0x0218', '0xAB' => '0x00AB',
        '0xAC' => '0x0179', '0xAD' => '0x00AD', '0xAE' => '0x017A', '0xAF' => '0x017B',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x010C', '0xB3' => '0x0142',
        '0xB4' => '0x017D', '0xB5' => '0x201D', '0xB6' => '0x00B6', '0xB7' => '0x00B7',
        '0xB8' => '0x017E', '0xB9' => '0x010D', '0xBA' => '0x0219', '0xBB' => '0x00BB',
        '0xBC' => '0x0152', '0xBD' => '0x0153', '0xBE' => '0x0178', '0xBF' => '0x017C',
        '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x0102',
        '0xC4' => '0x00C4', '0xC5' => '0x0106', '0xC6' => '0x00C6', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x0110', '0xD1' => '0x0143', '0xD2' => '0x00D2', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x0150', '0xD6' => '0x00D6', '0xD7' => '0x015A',
        '0xD8' => '0x0170', '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x0118', '0xDE' => '0x021A', '0xDF' => '0x00DF',
        '0xE0' => '0x00E0', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x0103',
        '0xE4' => '0x00E4', '0xE5' => '0x0107', '0xE6' => '0x00E6', '0xE7' => '0x00E7',
        '0xE8' => '0x00E8', '0xE9' => '0x00E9', '0xEA' => '0x00EA', '0xEB' => '0x00EB',
        '0xEC' => '0x00EC', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x0111', '0xF1' => '0x0144', '0xF2' => '0x00F2', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x0151', '0xF6' => '0x00F6', '0xF7' => '0x015B',
        '0xF8' => '0x0171', '0xF9' => '0x00F9', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x0119', '0xFE' => '0x021B', '0xFF' => '0x00FF'),
    'koi8-r' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x2500', '0x81' => '0x2502', '0x82' => '0x250C', '0x83' => '0x2510',
        '0x84' => '0x2514', '0x85' => '0x2518', '0x86' => '0x251C', '0x87' => '0x2524',
        '0x88' => '0x252C', '0x89' => '0x2534', '0x8A' => '0x253C', '0x8B' => '0x2580',
        '0x8C' => '0x2584', '0x8D' => '0x2588', '0x8E' => '0x258C', '0x8F' => '0x2590',
        '0x90' => '0x2591', '0x91' => '0x2592', '0x92' => '0x2593', '0x93' => '0x2320',
        '0x94' => '0x25A0', '0x95' => '0x2219', '0x96' => '0x221A', '0x97' => '0x2248',
        '0x98' => '0x2264', '0x99' => '0x2265', '0x9A' => '0x00A0', '0x9B' => '0x2321',
        '0x9C' => '0x00B0', '0x9D' => '0x00B2', '0x9E' => '0x00B7', '0x9F' => '0x00F7',
        '0xA0' => '0x2550', '0xA1' => '0x2551', '0xA2' => '0x2552', '0xA3' => '0x0451',
        '0xA4' => '0x2553', '0xA5' => '0x2554', '0xA6' => '0x2555', '0xA7' => '0x2556',
        '0xA8' => '0x2557', '0xA9' => '0x2558', '0xAA' => '0x2559', '0xAB' => '0x255A',
        '0xAC' => '0x255B', '0xAD' => '0x255C', '0xAE' => '0x255D', '0xAF' => '0x255E',
        '0xB0' => '0x255F', '0xB1' => '0x2560', '0xB2' => '0x2561', '0xB3' => '0x0401',
        '0xB4' => '0x2562', '0xB5' => '0x2563', '0xB6' => '0x2564', '0xB7' => '0x2565',
        '0xB8' => '0x2566', '0xB9' => '0x2567', '0xBA' => '0x2568', '0xBB' => '0x2569',
        '0xBC' => '0x256A', '0xBD' => '0x256B', '0xBE' => '0x256C', '0xBF' => '0x00A9',
        '0xC0' => '0x044E', '0xC1' => '0x0430', '0xC2' => '0x0431', '0xC3' => '0x0446',
        '0xC4' => '0x0434', '0xC5' => '0x0435', '0xC6' => '0x0444', '0xC7' => '0x0433',
        '0xC8' => '0x0445', '0xC9' => '0x0438', '0xCA' => '0x0439', '0xCB' => '0x043A',
        '0xCC' => '0x043B', '0xCD' => '0x043C', '0xCE' => '0x043D', '0xCF' => '0x043E',
        '0xD0' => '0x043F', '0xD1' => '0x044F', '0xD2' => '0x0440', '0xD3' => '0x0441',
        '0xD4' => '0x0442', '0xD5' => '0x0443', '0xD6' => '0x0436', '0xD7' => '0x0432',
        '0xD8' => '0x044C', '0xD9' => '0x044B', '0xDA' => '0x0437', '0xDB' => '0x0448',
        '0xDC' => '0x044D', '0xDD' => '0x0449', '0xDE' => '0x0447', '0xDF' => '0x044A',
        '0xE0' => '0x042E', '0xE1' => '0x0410', '0xE2' => '0x0411', '0xE3' => '0x0426',
        '0xE4' => '0x0414', '0xE5' => '0x0415', '0xE6' => '0x0424', '0xE7' => '0x0413',
        '0xE8' => '0x0425', '0xE9' => '0x0418', '0xEA' => '0x0419', '0xEB' => '0x041A',
        '0xEC' => '0x041B', '0xED' => '0x041C', '0xEE' => '0x041D', '0xEF' => '0x041E',
        '0xF0' => '0x041F', '0xF1' => '0x042F', '0xF2' => '0x0420', '0xF3' => '0x0421',
        '0xF4' => '0x0422', '0xF5' => '0x0423', '0xF6' => '0x0416', '0xF7' => '0x0412',
        '0xF8' => '0x042C', '0xF9' => '0x042B', '0xFA' => '0x0417', '0xFB' => '0x0428',
        '0xFC' => '0x042D', '0xFD' => '0x0429', '0xFE' => '0x0427', '0xFF' => '0x042A'),
    'windows-1252' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x20AC', '0x81' => '      ', '0x82' => '0x201A', '0x83' => '0x0192',
        '0x84' => '0x201E', '0x85' => '0x2026', '0x86' => '0x2020', '0x87' => '0x2021',
        '0x88' => '0x02C6', '0x89' => '0x2030', '0x8A' => '0x0160', '0x8B' => '0x2039',
        '0x8C' => '0x0152', '0x8D' => '      ', '0x8E' => '0x017D', '0x8F' => '      ',
        '0x90' => '      ', '0x91' => '0x2018', '0x92' => '0x2019', '0x93' => '0x201C',
        '0x94' => '0x201D', '0x95' => '0x2022', '0x96' => '0x2013', '0x97' => '0x2014',
        '0x98' => '0x02DC', '0x99' => '0x2122', '0x9A' => '0x0161', '0x9B' => '0x203A',
        '0x9C' => '0x0153', '0x9D' => '      ', '0x9E' => '0x017E', '0x9F' => '0x0178',
        '0xA0' => '0x00A0', '0xA1' => '0x00A1', '0xA2' => '0x00A2', '0xA3' => '0x00A3',
        '0xA4' => '0x00A4', '0xA5' => '0x00A5', '0xA6' => '0x00A6', '0xA7' => '0x00A7',
        '0xA8' => '0x00A8', '0xA9' => '0x00A9', '0xAA' => '0x00AA', '0xAB' => '0x00AB',
        '0xAC' => '0x00AC', '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x00AF',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x00B2', '0xB3' => '0x00B3',
        '0xB4' => '0x00B4', '0xB5' => '0x00B5', '0xB6' => '0x00B6', '0xB7' => '0x00B7',
        '0xB8' => '0x00B8', '0xB9' => '0x00B9', '0xBA' => '0x00BA', '0xBB' => '0x00BB',
        '0xBC' => '0x00BC', '0xBD' => '0x00BD', '0xBE' => '0x00BE', '0xBF' => '0x00BF',
        '0xC0' => '0x00C0', '0xC1' => '0x00C1', '0xC2' => '0x00C2', '0xC3' => '0x00C3',
        '0xC4' => '0x00C4', '0xC5' => '0x00C5', '0xC6' => '0x00C6', '0xC7' => '0x00C7',
        '0xC8' => '0x00C8', '0xC9' => '0x00C9', '0xCA' => '0x00CA', '0xCB' => '0x00CB',
        '0xCC' => '0x00CC', '0xCD' => '0x00CD', '0xCE' => '0x00CE', '0xCF' => '0x00CF',
        '0xD0' => '0x00D0', '0xD1' => '0x00D1', '0xD2' => '0x00D2', '0xD3' => '0x00D3',
        '0xD4' => '0x00D4', '0xD5' => '0x00D5', '0xD6' => '0x00D6', '0xD7' => '0x00D7',
        '0xD8' => '0x00D8', '0xD9' => '0x00D9', '0xDA' => '0x00DA', '0xDB' => '0x00DB',
        '0xDC' => '0x00DC', '0xDD' => '0x00DD', '0xDE' => '0x00DE', '0xDF' => '0x00DF',
        '0xE0' => '0x00E0', '0xE1' => '0x00E1', '0xE2' => '0x00E2', '0xE3' => '0x00E3',
        '0xE4' => '0x00E4', '0xE5' => '0x00E5', '0xE6' => '0x00E6', '0xE7' => '0x00E7',
        '0xE8' => '0x00E8', '0xE9' => '0x00E9', '0xEA' => '0x00EA', '0xEB' => '0x00EB',
        '0xEC' => '0x00EC', '0xED' => '0x00ED', '0xEE' => '0x00EE', '0xEF' => '0x00EF',
        '0xF0' => '0x00F0', '0xF1' => '0x00F1', '0xF2' => '0x00F2', '0xF3' => '0x00F3',
        '0xF4' => '0x00F4', '0xF5' => '0x00F5', '0xF6' => '0x00F6', '0xF7' => '0x00F7',
        '0xF8' => '0x00F8', '0xF9' => '0x00F9', '0xFA' => '0x00FA', '0xFB' => '0x00FB',
        '0xFC' => '0x00FC', '0xFD' => '0x00FD', '0xFE' => '0x00FE', '0xFF' => '0x00FF'),
    'windows-1251' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0A' => '0x000A', '0x0B' => '0x000B',
        '0x0C' => '0x000C', '0x0D' => '0x000D', '0x0E' => '0x000E', '0x0F' => '0x000F',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1A' => '0x001A', '0x1B' => '0x001B',
        '0x1C' => '0x001C', '0x1D' => '0x001D', '0x1E' => '0x001E', '0x1F' => '0x001F',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2A' => '0x002A', '0x2B' => '0x002B',
        '0x2C' => '0x002C', '0x2D' => '0x002D', '0x2E' => '0x002E', '0x2F' => '0x002F',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3A' => '0x003A', '0x3B' => '0x003B',
        '0x3C' => '0x003C', '0x3D' => '0x003D', '0x3E' => '0x003E', '0x3F' => '0x003F',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4A' => '0x004A', '0x4B' => '0x004B',
        '0x4C' => '0x004C', '0x4D' => '0x004D', '0x4E' => '0x004E', '0x4F' => '0x004F',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5A' => '0x005A', '0x5B' => '0x005B',
        '0x5C' => '0x005C', '0x5D' => '0x005D', '0x5E' => '0x005E', '0x5F' => '0x005F',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6A' => '0x006A', '0x6B' => '0x006B',
        '0x6C' => '0x006C', '0x6D' => '0x006D', '0x6E' => '0x006E', '0x6F' => '0x006F',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7A' => '0x007A', '0x7B' => '0x007B',
        '0x7C' => '0x007C', '0x7D' => '0x007D', '0x7E' => '0x007E', '0x7F' => '0x007F',
        '0x80' => '0x0402', '0x81' => '0x0403', '0x82' => '0x201A', '0x83' => '0x0453',
        '0x84' => '0x201E', '0x85' => '0x2026', '0x86' => '0x2020', '0x87' => '0x2021',
        '0x88' => '0x20AC', '0x89' => '0x2030', '0x8A' => '0x0409', '0x8B' => '0x2039',
        '0x8C' => '0x040A', '0x8D' => '0x040C', '0x8E' => '0x040B', '0x8F' => '0x040F',
        '0x90' => '0x0452', '0x91' => '0x2018', '0x92' => '0x2019', '0x93' => '0x201C',
        '0x94' => '0x201D', '0x95' => '0x2022', '0x96' => '0x2013', '0x97' => '0x2014',
        '0x98' => '      ', '0x99' => '0x2122', '0x9A' => '0x0459', '0x9B' => '0x203A',
        '0x9C' => '0x045A', '0x9D' => '0x045C', '0x9E' => '0x045B', '0x9F' => '0x045F',
        '0xA0' => '0x00A0', '0xA1' => '0x040E', '0xA2' => '0x045E', '0xA3' => '0x0408',
        '0xA4' => '0x00A4', '0xA5' => '0x0490', '0xA6' => '0x00A6', '0xA7' => '0x00A7',
        '0xA8' => '0x0401', '0xA9' => '0x00A9', '0xAA' => '0x0404', '0xAB' => '0x00AB',
        '0xAC' => '0x00AC', '0xAD' => '0x00AD', '0xAE' => '0x00AE', '0xAF' => '0x0407',
        '0xB0' => '0x00B0', '0xB1' => '0x00B1', '0xB2' => '0x0406', '0xB3' => '0x0456',
        '0xB4' => '0x0491', '0xB5' => '0x00B5', '0xB6' => '0x00B6', '0xB7' => '0x00B7',
        '0xB8' => '0x0451', '0xB9' => '0x2116', '0xBA' => '0x0454', '0xBB' => '0x00BB',
        '0xBC' => '0x0458', '0xBD' => '0x0405', '0xBE' => '0x0455', '0xBF' => '0x0457',
        '0xC0' => '0x0410', '0xC1' => '0x0411', '0xC2' => '0x0412', '0xC3' => '0x0413',
        '0xC4' => '0x0414', '0xC5' => '0x0415', '0xC6' => '0x0416', '0xC7' => '0x0417',
        '0xC8' => '0x0418', '0xC9' => '0x0419', '0xCA' => '0x041A', '0xCB' => '0x041B',
        '0xCC' => '0x041C', '0xCD' => '0x041D', '0xCE' => '0x041E', '0xCF' => '0x041F',
        '0xD0' => '0x0420', '0xD1' => '0x0421', '0xD2' => '0x0422', '0xD3' => '0x0423',
        '0xD4' => '0x0424', '0xD5' => '0x0425', '0xD6' => '0x0426', '0xD7' => '0x0427',
        '0xD8' => '0x0428', '0xD9' => '0x0429', '0xDA' => '0x042A', '0xDB' => '0x042B',
        '0xDC' => '0x042C', '0xDD' => '0x042D', '0xDE' => '0x042E', '0xDF' => '0x042F',
        '0xE0' => '0x0430', '0xE1' => '0x0431', '0xE2' => '0x0432', '0xE3' => '0x0433',
        '0xE4' => '0x0434', '0xE5' => '0x0435', '0xE6' => '0x0436', '0xE7' => '0x0437',
        '0xE8' => '0x0438', '0xE9' => '0x0439', '0xEA' => '0x043A', '0xEB' => '0x043B',
        '0xEC' => '0x043C', '0xED' => '0x043D', '0xEE' => '0x043E', '0xEF' => '0x043F',
        '0xF0' => '0x0440', '0xF1' => '0x0441', '0xF2' => '0x0442', '0xF3' => '0x0443',
        '0xF4' => '0x0444', '0xF5' => '0x0445', '0xF6' => '0x0446', '0xF7' => '0x0447',
        '0xF8' => '0x0448', '0xF9' => '0x0449', '0xFA' => '0x044A', '0xFB' => '0x044B',
        '0xFC' => '0x044C', '0xFD' => '0x044D', '0xFE' => '0x044E', '0xFF' => '0x044F'),
    'ibm-850' => array(
        '0x00' => '0x0000', '0x01' => '0x0001', '0x02' => '0x0002', '0x03' => '0x0003',
        '0x04' => '0x0004', '0x05' => '0x0005', '0x06' => '0x0006', '0x07' => '0x0007',
        '0x08' => '0x0008', '0x09' => '0x0009', '0x0a' => '0x000a', '0x0b' => '0x000b',
        '0x0c' => '0x000c', '0x0d' => '0x000d', '0x0e' => '0x000e', '0x0f' => '0x000f',
        '0x10' => '0x0010', '0x11' => '0x0011', '0x12' => '0x0012', '0x13' => '0x0013',
        '0x14' => '0x0014', '0x15' => '0x0015', '0x16' => '0x0016', '0x17' => '0x0017',
        '0x18' => '0x0018', '0x19' => '0x0019', '0x1a' => '0x001a', '0x1b' => '0x001b',
        '0x1c' => '0x001c', '0x1d' => '0x001d', '0x1e' => '0x001e', '0x1f' => '0x001f',
        '0x20' => '0x0020', '0x21' => '0x0021', '0x22' => '0x0022', '0x23' => '0x0023',
        '0x24' => '0x0024', '0x25' => '0x0025', '0x26' => '0x0026', '0x27' => '0x0027',
        '0x28' => '0x0028', '0x29' => '0x0029', '0x2a' => '0x002a', '0x2b' => '0x002b',
        '0x2c' => '0x002c', '0x2d' => '0x002d', '0x2e' => '0x002e', '0x2f' => '0x002f',
        '0x30' => '0x0030', '0x31' => '0x0031', '0x32' => '0x0032', '0x33' => '0x0033',
        '0x34' => '0x0034', '0x35' => '0x0035', '0x36' => '0x0036', '0x37' => '0x0037',
        '0x38' => '0x0038', '0x39' => '0x0039', '0x3a' => '0x003a', '0x3b' => '0x003b',
        '0x3c' => '0x003c', '0x3d' => '0x003d', '0x3e' => '0x003e', '0x3f' => '0x003f',
        '0x40' => '0x0040', '0x41' => '0x0041', '0x42' => '0x0042', '0x43' => '0x0043',
        '0x44' => '0x0044', '0x45' => '0x0045', '0x46' => '0x0046', '0x47' => '0x0047',
        '0x48' => '0x0048', '0x49' => '0x0049', '0x4a' => '0x004a', '0x4b' => '0x004b',
        '0x4c' => '0x004c', '0x4d' => '0x004d', '0x4e' => '0x004e', '0x4f' => '0x004f',
        '0x50' => '0x0050', '0x51' => '0x0051', '0x52' => '0x0052', '0x53' => '0x0053',
        '0x54' => '0x0054', '0x55' => '0x0055', '0x56' => '0x0056', '0x57' => '0x0057',
        '0x58' => '0x0058', '0x59' => '0x0059', '0x5a' => '0x005a', '0x5b' => '0x005b',
        '0x5c' => '0x005c', '0x5d' => '0x005d', '0x5e' => '0x005e', '0x5f' => '0x005f',
        '0x60' => '0x0060', '0x61' => '0x0061', '0x62' => '0x0062', '0x63' => '0x0063',
        '0x64' => '0x0064', '0x65' => '0x0065', '0x66' => '0x0066', '0x67' => '0x0067',
        '0x68' => '0x0068', '0x69' => '0x0069', '0x6a' => '0x006a', '0x6b' => '0x006b',
        '0x6c' => '0x006c', '0x6d' => '0x006d', '0x6e' => '0x006e', '0x6f' => '0x006f',
        '0x70' => '0x0070', '0x71' => '0x0071', '0x72' => '0x0072', '0x73' => '0x0073',
        '0x74' => '0x0074', '0x75' => '0x0075', '0x76' => '0x0076', '0x77' => '0x0077',
        '0x78' => '0x0078', '0x79' => '0x0079', '0x7a' => '0x007a', '0x7b' => '0x007b',
        '0x7c' => '0x007c', '0x7d' => '0x007d', '0x7e' => '0x007e', '0x7f' => '0x007f',
        '0x80' => '0x00c7', '0x81' => '0x00fc', '0x82' => '0x00e9', '0x83' => '0x00e2',
        '0x84' => '0x00e4', '0x85' => '0x00e0', '0x86' => '0x00e5', '0x87' => '0x00e7',
        '0x88' => '0x00ea', '0x89' => '0x00eb', '0x8a' => '0x00e8', '0x8b' => '0x00ef',
        '0x8c' => '0x00ee', '0x8d' => '0x00ec', '0x8e' => '0x00c4', '0x8f' => '0x00c5',
        '0x90' => '0x00c9', '0x91' => '0x00e6', '0x92' => '0x00c6', '0x93' => '0x00f4',
        '0x94' => '0x00f6', '0x95' => '0x00f2', '0x96' => '0x00fb', '0x97' => '0x00f9',
        '0x98' => '0x00ff', '0x99' => '0x00d6', '0x9a' => '0x00dc', '0x9b' => '0x00f8',
        '0x9c' => '0x00a3', '0x9d' => '0x00d8', '0x9e' => '0x00d7', '0x9f' => '0x0192',
        '0xa0' => '0x00e1', '0xa1' => '0x00ed', '0xa2' => '0x00f3', '0xa3' => '0x00fa',
        '0xa4' => '0x00f1', '0xa5' => '0x00d1', '0xa6' => '0x00aa', '0xa7' => '0x00ba',
        '0xa8' => '0x00bf', '0xa9' => '0x00ae', '0xaa' => '0x00ac', '0xab' => '0x00bd',
        '0xac' => '0x00bc', '0xad' => '0x00a1', '0xae' => '0x00ab', '0xaf' => '0x00bb',
        '0xb0' => '0x2591', '0xb1' => '0x2592', '0xb2' => '0x2593', '0xb3' => '0x2502',
        '0xb4' => '0x2524', '0xb5' => '0x00c1', '0xb6' => '0x00c2', '0xb7' => '0x00c0',
        '0xb8' => '0x00a9', '0xb9' => '0x2563', '0xba' => '0x2551', '0xbb' => '0x2557',
        '0xbc' => '0x255d', '0xbd' => '0x00a2', '0xbe' => '0x00a5', '0xbf' => '0x2510',
        '0xc0' => '0x2514', '0xc1' => '0x2534', '0xc2' => '0x252c', '0xc3' => '0x251c',
        '0xc4' => '0x2500', '0xc5' => '0x253c', '0xc6' => '0x00e3', '0xc7' => '0x00c3',
        '0xc8' => '0x255a', '0xc9' => '0x2554', '0xca' => '0x2569', '0xcb' => '0x2566',
        '0xcc' => '0x2560', '0xcd' => '0x2550', '0xce' => '0x256c', '0xcf' => '0x00a4',
        '0xd0' => '0x00f0', '0xd1' => '0x00d0', '0xd2' => '0x00ca', '0xd3' => '0x00cb',
        '0xd4' => '0x00c8', '0xd5' => '0x0131', '0xd6' => '0x00cd', '0xd7' => '0x00ce',
        '0xd8' => '0x00cf', '0xd9' => '0x2518', '0xda' => '0x250c', '0xdb' => '0x2588',
        '0xdc' => '0x2584', '0xdd' => '0x00a6', '0xde' => '0x00cc', '0xdf' => '0x2580',
        '0xe0' => '0x00d3', '0xe1' => '0x00df', '0xe2' => '0x00d4', '0xe3' => '0x00d2',
        '0xe4' => '0x00f5', '0xe5' => '0x00d5', '0xe6' => '0x00b5', '0xe7' => '0x00fe',
        '0xe8' => '0x00de', '0xe9' => '0x00da', '0xea' => '0x00db', '0xeb' => '0x00d9',
        '0xec' => '0x00fd', '0xed' => '0x00dd', '0xee' => '0x00af', '0xef' => '0x00b4',
        '0xf0' => '0x00ad', '0xf1' => '0x00b1', '0xf2' => '0x2017', '0xf3' => '0x00be',
        '0xf4' => '0x00b6', '0xf5' => '0x00a7', '0xf6' => '0x00f7', '0xf7' => '0x00b8',
        '0xf8' => '0x00b0', '0xf9' => '0x00a8', '0xfa' => '0x00b7', '0xfb' => '0x00b9',
        '0xfc' => '0x00b3', '0xfd' => '0x00b2', '0xfe' => '0x25a0', '0xff' => '0x00a0'),
    );

return $codes;

?>
