<?php

/*  bodystructure.php:  routines to parse the imap bodystructure response 
 *
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

 *$Id: bodystructure.php,v 1.14 2004/04/27 16:21:25 sailfrog Exp $
*/


/**
 *  parse the result of an IMAP FETCH BODYSTRUCTURE call
 *
 *  @param   $string string  IMAP bodstructure response
 *  @return          array   a structured multideminsional array with part # indicies
 *
 */
function hm_parse_bodystructure($string) {
    $parts = hm_parse_toplevel($string);
    if (count($parts) <= 2) {
        while ($parts[0][0] == '(') {
            array_shift($parts[0]);
        }
        $structure[1] = hm_parse_single($parts[0], 1);
        if (isset($structure[1]['subs']) && $structure[1]['subtype'] != 'rfc822') {
            $structure["1.1"] = $structure[1];
            foreach ($structure[1]['subs'] as $index => $array) {
                $structure["1.$index"] = $array;
            }
            unset($structure["1.1"]['subs']);
            unset($structure[1]);
        }
    }
    else {
        $max_part = count($parts) - 1;
        $n=1;
        $top_level = "(text|image|video|audio|application|message)";
        for ($l=0;$l<$max_part;$l++) {
            if ((strtolower($parts[$l][1]) == '"message"' &&
                (strtolower($parts[$l][2]) != '"delivery-status"' && 
                 strtolower($parts[$l][2]) != '"rfc822-headers"' && 
                 strtolower($parts[$l][2]) != '"disposition-notification"')) ||
                 strtolower($parts[$l][1]) == '"multipart"' ||
                 strtolower($parts[$l][3]) == '"rfc822"') {
                $structure[$n] = hm_parse_multi($parts[$l], $n);
                $n++;
            }
            else {
                while ($parts[$l][0] == '(') {
                    array_shift($parts[$l]);
                }
                if (preg_match("/$top_level/i", $parts[$l][0])) {
                    $structure[$n] = hm_parse_single($parts[$l], $n);
                    if (isset($structure[$n]['subs'])) {
                        $structure["$n.1"] = $structure[$n];
                        foreach ($structure[$n]['subs'] as $index => $array) {
                            $structure["$n.$index"] = $array;
                        }
                        unset($structure["$n.1"]['subs']);
                        unset($structure[$n]);
                    }
                    $n++;
                }
            }
        }
    }
    return $structure;
}

/**
 *  splits the initial bodystructure response in parts 
 *
 *  @param  $string string  the bodystructure response from IMAP
 *  @param  $manual int     set $limit and $deep manually
 *  @param  $deep   int     number of parens deep to start splitting on
 *  @param  $limit  int     how many parens deep to stop splitting on
 *  @return         array   array of bodystructure parts broken by parens
 *
 */
function hm_parse_toplevel($string, $manual=false, $deep=1, $limit=0) {
    $str = $_SESSION['str'];
    $res = array();
    $quoted_string = "\"[^\"\\\]*(?:\\\.[^\"\\\]*)*\""; 
    $nil           = "nil";
    $word          = "[^(\s|\")]+";
    $open          = "\(";
    $close         = "\)";
    $literal       = "\{(\d*)\}\r\n";
    $n             = 0;
    $i             = 0;

    if (!$manual) {
        if (preg_match("/^\([^\(]/", $string)) {
            $limit = 1;
        }
        else {
            $limit = 2;
        }
    }
    while (strlen($string) > 0) {
        if (preg_match("/^$literal/", $string, $lit_regs)) {
            $lit_size = strlen($lit_regs[0]) + $lit_regs[1] + 2;
            $res[$i][$n] = (substr($string, 0, $lit_size));
            $string = ltrim(substr($string, $lit_size));
            $n++;
        }
        elseif (preg_match("/^\s{0,}($word|$nil|$quoted_string|$open|$close)/i", 
                $string, $regs)) {
            $res[$i][$n] = $regs[1];
            if ($regs[1] == '(') {
                $deep += 1;
            }
            if ($regs[1] == ')') {
                $deep -= 1;
            }
            $n++;
            if ($n > 2 && $deep == $limit) {
                $i++;
                $n = 0;
            }
            $string = ltrim(substr($string, strlen($regs[1])));
        }
        else {
            $_SESSION['notices'][] = $str[212];
            break;
        }
    }
    if (isset($res[$i][0]) && $res[$i][0] == ')') {
        array_pop($res);
    }
    return $res;
}

/**
 *  parse a single message part
 *
 *  @param  $parts          array   array of one message part bodystructure values
 *  @param  $part_number    float   current part for recursive tracking
 *  @return                 array   portion of structure array for single part
 *
 */
function hm_parse_single($parts, $part_number=1) {
    while ($parts[0] == '(') {
        array_shift($parts);
    }
    $struct['type'] = strtolower(str_replace('"', '', $parts[0]));
    $struct['subtype'] = strtolower(str_replace('"', '', $parts[1]));
    $temp_value = '';
    if ($parts[2] == '(') {
        $n = 3;
        $safty_net = 0;
        while ($parts[$n] != ')') {
            if ($safty_net > 8) {
                break;
            }
            $temp_value .= ' '.$parts[$n];
            $n++;
            $safty_net++;
        }
        $parameters = ltrim($temp_value);
        array_splice($parts, 2, ($n-2));
    }
    else {
        $parameters = $temp_value;
    }
    $param_parts = explode('" "', $parameters);
    $param_count = count($param_parts);
    if ($param_count > 1) {
        for($i=0;$i<$param_count;$i++) {
            if (isset($param_parts[$i + 1])) {
                $struct[strtolower(trim($param_parts[$i], '"'))] = 
                    trim($param_parts[$i +1], '"');
                $i++;
            }
        }
    }
    if (!isset($struct['name'])) {
        $names = array(
            'text:plain' => 'message.txt', 'text:enriched' => 'message.rtf',
            'text:html'  => 'message.html');
        if (isset($names[$struct['type'].':'.$struct['subtype']])) {
            $struct['name'] = $names[$struct['type'].':'.$struct['subtype']];
        }
        elseif ($struct['type'] == 'image') {
            $struct['name'] = 'image'.$struct['subtype'];
        }
        else {
            $struct['name'] = 'unkown';
        }
    }
    $struct['id'] = $parts[3];
    $struct['description'] = $parts[4];
    $struct['encoding'] = strtolower(str_replace('"', '', $parts[5]));
    $struct['rawsize'] = $parts[6];
    $struct['size'] = hm_size_format($parts[6]);
    $struct['remainder'] = implode(' ', array_slice($parts, 7));
    $top_level = "(text|image|video|audio|application|message)";
    if (preg_match("/\"alternative\"/i", $struct['remainder'])) {
        $test = hm_parse_toplevel($struct['remainder'], true, 1, 0);
        if (isset($test[1]) && count($test[1]) > 5) {
            $struct['subs'][2] = hm_parse_single($test[1], $part_number);
        }
    }
    elseif ($struct['subtype'] == 'rfc822') {
        $struct = hm_parse_multi($parts, $part_number); 
    }
    elseif (preg_match("/\"$top_level\"/i", $struct['remainder'])) {
        $left_overs = hm_parse_toplevel($struct['remainder'], true, 1, 0);
        $l = 2;
        foreach($left_overs as $array) {
            if (preg_match("/\"$top_level\"/i", $array[1])) {
                $struct['subs']["$l"] = hm_parse_single($array); 
                $l++;
            }
        }
    }
    return $struct;
}

/**
 *  split an rfc part into parts
 *
 *  @param   $parts         array   array of one message part bodystructure values
 *  @param   $part_number   float   current part for recursive tracking
 *  @return                 array   structure array portion for an rfc message part
 *
 */
function hm_parse_multi($parts, $part_number=1) {
    $struct = array();
    $top_level = "(text|image|video|audio|application|message)";
    while ($parts[0] == '(') {
        array_shift($parts);
    }
    while (strtolower($parts[count($parts)-2]) == 'nil') {
        array_splice($parts, (count($parts)-2), 1);
    }
    switch (strtolower($parts[count($parts)-6])) {
        case '"digest"':
            $test = hm_parse_toplevel('('.implode(' ', $parts), true, 1, 1);
            $l = 1;
            $struct['type'] = 'message';
            $struct['subtype'] = 'digest';
            $struct['encoding'] = '7bit';
            $struct['name'] = 'rfc822_digest.eml';
            $struct['rawsize'] = '';
            foreach($test as $array) {
                if (strtolower($array[2]) == '"rfc822"') {
                    $struct['subs']["$part_number.$l"] = 
                                    hm_parse_multi($array, ("$part_number.$l"));
                    $l++;
                }
            }
            break;
        case 'nil':
        default:
            $struct['type'] = strtolower(str_replace('"', '', $parts[0]));
            $struct['subtype'] = strtolower(str_replace('"', '', $parts[1]));
            $temp_value = '';
            if ($parts[2] == '(') {
                $n = 3;
                while ($parts[$n] != ')') {
                    $temp_value .= ' '.$parts[$n];
                    $n++;
                }
                $struct['parameters'] = ltrim($temp_value);
                array_splice($parts, 2, ($n-2));
            }
            else {
                $struct['parameters'] = $temp_value;
            }
            $struct['id'] = $parts[3];
            $struct['description'] = $parts[4];
            $struct['encoding'] = strtolower(str_replace('"', '', $parts[5]));
            $struct['rawsize'] = $parts[6];
            $struct['size'] = intval($parts[6]/1024)." Kb";
            $struct['date'] = trim($parts[8], '"');
            $subject_tmp = '';
            while ($parts[10] != '(') {
                $subject_tmp .= ' '.$parts[10];
                array_splice($parts, 10, 1);
            }
            $struct['name'] = $struct['type'].'_'.$struct['subtype'].'.eml';
            $subject = $parts[9].$subject_tmp;
            $struct['subject'] = hm_decode_field(preg_replace("/(^\"{1}|\"{1}$)/",
                                                 '', $subject));
            $struct['subject'] = stripslashes($struct['subject']);
            $struct['from'] = trim($parts[14], '"').'@'.trim($parts[15], '"');
            $sub_struct = hm_parse_toplevel(implode(' ', array_slice($parts, 7)));
            $sub_part = $sub_struct[1];
            if (count($sub_part) > 25) {
                $part = hm_parse_toplevel(implode(' ', $sub_part), true, 0, 1);
                $sub = array_slice($part, 0, (count($part) - 2));
            }
            else {
                if ($sub_part[0] == '(' && $sub_part[1] == '(') {
                    array_shift($sub_part);
                }
                $sub[0] = $sub_part;
            }
            if (count($sub) == 1 && count($sub[0]) < 25) {
                $struct['subs']["$part_number.1"] = hm_parse_single($sub[0], 
                                                    $part_number);
            }
            else {
                $max_part = count($sub);
                $n = 1;
                for ($l=0;$l<$max_part;$l++) {
                    if ($sub[$l][0] == '(' && $sub[$l][1] == '(') {
                        array_shift($sub[$l]);
                    }
                    if (strtolower($sub[$l][2]) == '"rfc822"') {
                        $struct['subs']["$part_number.$n"] = hm_parse_multi($sub[$l], 
                                                                ("$part_number.$n"));
                    }
                    else {
                        if (preg_match("/$top_level/i", $sub[$l][0].$sub[$l][1].
                                                                    $sub[$l][2])) {
                            $struct['subs']["$part_number.$n"] = hm_parse_single($sub[$l],
                                                                 $part_number);
                            if (isset($struct['subs']["$part_number.$n"]['subs'])) {
                                $struct['subs']["$part_number.$n.1"] = 
                                                     $struct['subs']["$part_number.$n"];
                                foreach ($struct['subs']["$part_number.$n"]['subs'] as 
                                                                      $index => $array) {
                                    $struct['subs']["$part_number.$n.$index"] = $array;
                                }
                                unset($struct['subs']["$part_number.$n.1"]['subs']);
                                unset($struct['subs']["$part_number.$n"]);
                            }
                        }
                    }
                    $n++;
                }
            }
            break;
    }
    return $struct;
}

?>
