<?php

/* constant.php: some constants used in many hastymail pages.
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: constant.php,v 1.36.2.3 2004/05/11 04:48:54 sailfrog Exp $
*/

/* absolute path to the configuration file */
$config_file = '/etc/hastymail.conf';

/* hastymail version */
$version = '1.0';

/* key for hastymail's encryption */
$hasty_key = 'You should be using the more secure version!';

/* default user settings. Notice that booleans and strings
   are single quoted, but numbers are not */
$defaults = array(
    'lang'             => 'en_US',       /* interface language */
    'page_count'       => 20,            /* messages per page */
    'read_wrap'        => 80,            /* wrap length for incoming text */
    'refresh_new'      => 5,             /* new page refresh rate (minutes)*/ 
    'start_page'       => 'mailbox.php', /* first displayed page */
    'filter_level'     => 1,             /* HTML filter level */
    'simple'           => 'false',       /* simle mode */
    'click_links'      => 'false',       /* clickable links in text parts */
    'click_email'      => 'false',       /* clickable emails in text parts */
    'wrap_clean'       => 'false',       /* show '\' on wrapped lines */
    'html_only'        => 'false',       /* display html parts if no text part exists */
    'font_type'        => 'monospace',   /* text part font family */
    'folder_detail'    => 'new',         /* detail level on folder list */
    'date_format'      => 'm/d/y',       /* date format string */
    'time_format'      => 'g:i:s a',     /* time format string */
    'folder_style'     => 'nested',      /* folder list style (nested or flat) */
    'html_default'     => 'false',       /* show html parts by default (blech!) */
    'folder_preview'   => 'none',        /* folder preview option */
    'preview_position' => 0,             /* folder preview position (0=top, 1=bottom)*/
            );
?>
