<?php

/*  general.php:  Some various helper functions
 *
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

 *$Id: general.php,v 1.191 2004/04/30 04:33:59 sailfrog Exp $
*/


/**
 *  Determine the web browser capabilities for simple or normal mode.
 *
 *  @param  $string     string      the HTTP_USER_AGENT string from the browser
 *  @return             boolean     true for simple mode and false for normal mode 
 *
 */
function hm_browser_type($string) {
    $simple = false;
    $simple_types = '(Links|Lynx|Blazer|Nokia7250|UPG1|Elinks|PalmSource|PalmOS|WebPro)';
    if (preg_match("/$simple_types/i", $string)) {
        $simple = true;
    }
    elseif (preg_match("/^Mozilla\/(\d)/", $string, $matches)) {
        if (isset($matches[1]) && is_numeric($matches[1])) {
            if ($matches[1] < 3) {
                $simple = true;
            }
        }
    }
    return $simple;
}

/**
 *
 *  Our own htmlspecialchars function that does not care about charset
 *
 *  @param $string              string      the string to html-ize
 *  @return                     string      transformed text
 */
function hm_htmlize ($string) {
    $find    = array('&', '>', '<', "'");
    $replace = array('&amp;', '&gt;', '&lt;', '&#039;');
    return str_replace($find, $replace, $string);
}
 
/**
 *  clean and prepare text for display
 *
 *  @param  $text               string      the string to convert
 *  @param  $charset            string      the charset hastymail is using
 *  @param  $charset_convert    boolean     if the charset should be converted to utf-8
 *  @param  $code_page          array       the charset convertion table
 *  @param  $utf8               boolean     if the string is already utf-8
 *  @return                     string      cleaned text             
 *
 */
function hm_special_chars($text, $charset, $charset_convert, $code_page, $utf8=false) {
    $result = '';
    if ($charset_convert) {
        $result = hm_htmlize($text);
        $result = hm_utf8_convert($result, $code_page);
    }
    elseif ($charset == 'UTF-8') {
        if ($utf8) {
            $result = hm_htmlize($text);
        }
        else {
            $text = utf8_encode($text);
            $result = hm_htmlize($text);
        }
   }
   else {
        $result = hm_htmlize($text);
    }
    return $result;
}    

/**
 *  convert text to utf8
 *
 *  @param      $text       string  text to convert
 *  @param      $code_page  array   conversion table for the text charset 
 *  @return                 string  converted text
 *
 */ 
function hm_utf8_convert($text, $code_page) {
    $utf8='';
    while($text) {
        if (ord(substr($text,0,1))>127) {
            $char = substr($text,0,1);
            $text = substr($text,1);
            $index = '0x'.strtoupper(dechex(ord($char)));
            $utf8 .= '&#x'.substr($code_page[$index], 3).';';
        }
        else {
            $utf8 .= substr($text,0,1);
            $text = substr($text,1);
        }
    }
    return $utf8;
}

/**
 *  split lines on word boudries
 *
 *  @param    $line       string      the string to be split
 *  @param    $limit      int         the strlen to split at
 *  @param    $hardbreak  boolean     true means split regardless of word boundries
 *  @param    $clean      boolean     false means don't mark split lines with "\"
 *  @return                array      each line is one array element
 *
 */
function hm_split_line($line, $limit, $hardbreak=false, $clean=false) {
    if ($clean || (isset($_SESSION['settings']['wrap_clean']) && 
        $_SESSION['settings']['wrap_clean'] == 'true')) {
        $marker = '';
    }
    else {
        $marker = "     \\";
    }
    $string = $line;
    while (strlen($string) > $limit) {
        if (!$hardbreak) {
            $chunk1 = substr($string, 0, ($limit-20));
            $chunk2 = substr($string, ($limit-20), 20);
            $split = strlen($chunk1) + (strlen($chunk2) - strlen(strrchr($chunk2, " ")));
            if ($split < $limit) {
                $parts[] = substr($string, 0, $split).$marker; 
                $string = substr($string, $split+1);
            }
            else {
                break;
            }
        }
        else {
            $parts[] = substr($string, 0, $limit).$marker;
            $string = substr($string, $limit);  
        }
    }
        
    $parts[] = $string;
    return $parts; 
}

/**
 *  search struture array for a key, returning it's value
 *
 *  @param      $key        float       the key to search for 
 *  @param      $array      array       the structure array to search
 *  @param      $key_path   float       the parent if we know it 
 *  @param      $parent     boolean     return the parent value instead
 *  @return                 array       each element is a message part attribute
 *
 */
function &hm_in_multi_array ($key, $array, $key_path=array(), $parent=false) {
    $return = false;
    foreach ($array as $akey => $value) {
        if ($key == $akey) {
            if ($parent) {
                if (count($key_path) > 0) {
                    $return = array($key_path[count($key_path)-1][0], 
                                   $key_path[count($key_path)-1][1]);
                    break;
                }
                else {
                    $return = false;
                    break;
                }
            }
            else {
                $return = array($key, $value);
                break;
            }
        }
        if (isset($value['subs'])) {
            if (isset($value['subtype']) && $value['subtype'] == 'rfc822') {
                $key_path[] = array($akey, $value);
            }
            if($return = &hm_in_multi_array($key, $value['subs'], $key_path, $parent)) {
                break;
            }
        }
    }
    return $return;
}

/**
 *  decode specially encoded headers
 *
 *  @param  $string     string      value to decode
 *  @return             string      value converted to decoded text
 *
 */
function hm_decode_field($string) {
    $str = $_SESSION['str'];
    if (strlen($string) <= 1) {
        return $string;
    }
    elseif (strpos($string, ' ') === false ) {
        $parts[] = $string;
    }
    else {
        /* real encoded address from lkml. This violates the mime rfc afaict because
           there are no spaces or CRLFs after the encoded "words". nevertheless
           adding this preg_replace makes it work with the parser */

        //=?koi8-r?Q?=22?=Bansh=?koi8-r?Q?=22=20?= <bansh21@mail.ru>
        $string = preg_replace("/(=\?[^\?]+\?(q|b)\?[^\?]+\?=)/i", " \\1 ", $string);
        $parts = explode(' ', $string);
    }
    $return_string = '';
    foreach ($parts as $chunk) {
        $chunk = trim($chunk);
        if (strlen($chunk) < 5) {
            $return_string .= ' '.$chunk;
        }
        else {
            $qq_start = '';
            $qq_stop = '';
            switch ($chunk{0}) {
                case '"':
                    $qq_start = '"';
                    $chunk    = substr($chunk, 1);
                    break;
                case "'":
                    $qq_start = "'";
                    $chunk    = substr($chunk, 1);
                    break;
                case '(':
                    $qq_start = '(';
                    $chunk    = substr($chunk, 1);
                    break;
                default:
                    break;
            }
            switch (substr($chunk, -1)) {
                case '"':
                    $qq_stop  = '"';
                    $chunk    = substr($chunk, 0, -1);
                    break;
                case "'":
                    $qq_stop  = "'";
                    $chunk    = substr($chunk, 0, -1);
                    break;
                case ')':
                    $qq_stop = ')';
                    $chunk    = substr($chunk, 0, -1);
                    break;
                default:
                    break;
            }
            $charset_convert = false;
            $code_page = false;
            $utf8 = false;
            if (substr($chunk, 0, 2) == '=?' && substr($chunk, -2) == '?=') {
                $chunk        = substr($chunk, 2);
                $charset      = strtolower(substr($chunk, 0, strcspn($chunk, '?')));
                $offset       = strlen($charset);
                $encoding     = substr($chunk, ($offset + 1), 1);
                $encoded_text = substr($chunk, ($offset + 3), -2);
                if (strtolower($encoding) == 'b') {
                    $chunk = base64_decode($encoded_text);
                }
                elseif (strtolower($encoding) == 'q') {
                    $chunk = &hm_quoted_decode($encoded_text);
                }
                else {
                    $chunk = $encoded_text;
                }
                if ($charset == 'utf-8') {
                    $utf8 = true;
                }
                if ($str['charset'] == 'UTF-8') {
                    if (isset($_SESSION['charsets'][$charset])) {
                        $code_page = $_SESSION['charsets'][$charset];
                        $charset_convert = true;
                    }
                }
            }
            $return_string .= ' '.$qq_start.hm_special_chars($chunk, $str['charset'], 
                              $charset_convert, $code_page, $utf8).$qq_stop;
        }
    }
    $return_string = trim($return_string);
    if (substr($return_string, 0, 2) == '=?' && substr($return_string, -2) == '?=') {
        $return_string = substr($return_string, 2, -2);
        $mark = strpos($return_string, '?');
        if ($mark !== false) {
            $return_string = substr($return_string, ($mark + 3));
        }
    }
    return $return_string; 
}

/**
 *  clean mailbox name
 *
 *  @param      $folders    array   the folders array
 *  @return                 array   each key is the folder, each value is the name
 *
 */
function hm_folder_dsp ($folders) {
    $folders_dsp = array();
    foreach($folders as $folder) {
        if ($folder != 'INBOX') {
            if (isset($_SESSION['config']['prefix']) &&
                $_SESSION['config']['prefix'] != '' && 
                $_SESSION['config']['prefix'] != 'none')
                $folder_dsp = substr(urldecode($folder), 
                                     strlen($_SESSION['config']['prefix']));
            elseif (preg_match("/^INBOX/", $folder)) {
                $folder_dsp = substr(urldecode($folder), 6);
            }
            else {
                $folder_dsp = $folder;
            }
        }
        else {
            $folder_dsp = $folder;
        }
        $folders_dsp[$folder] = $folder_dsp;
    }
    return $folders_dsp;
}

/**
 *  clean address name for display
 *
 *  @param      $string     string      address value to clean up
 *  @return                 string
 *
 */
function hm_address_dsp ($string, $empty=false) {
    if (trim($string) == '' && $empty) {
        return $empty;
    }
    if (strpos(trim($string), ' ') !== false) {
        $return_string = '';
        $string_parts = explode(' ', $string);
        foreach ($string_parts as $part) {
            switch (true) {
                case substr($part, 0, 1) == '"':
                    $return_string .= ' '.$part;
                    break;
                case strpos($part, '@'):
                case substr($part, 0, 1) == '<':
                    break;
                default:
                    $return_string .= ' '.$part;
                    break;
            }
        }
    }
    else {
        $return_string = $string;
    }
    $return_string = stripslashes(str_replace(array('(', ')', '&lt;', '&gt;', '"',
                     '&quot;'), '', $return_string));
    if (trim($string) == '' && $empty) {
        return $empty;
    }
    elseif (trim($return_string) == '') {
        $string = stripslashes(str_replace(array('(', ')', '&lt;', '&gt;', '"',
                         '&quot;'), '', $string));
        return $string;
    }
    else {
        return trim($return_string);
    }
}

/**
 *  clean up text/plain parts
 *
 *  @param  $text_part      string      the message text to format for display
 *  @param  $reply          boolean     when true format the text as a reply
 *  @param  $clean          boolean     don't add line break char (\)
 *  @return                 string      formatted text
 *
 */
function &hm_text_cleanup ($text_part, $reply=false, $clean=false) {
    $link_check = false;
    if (isset($_SESSION['settings']['click_links']) && 
        $_SESSION['settings']['click_links'] == 'true') {
        $link_check = true;
    }
    $result = array();
    if ($reply) {
        $clean = true;
        $def_divider = "\n> ";
        $prefix = "> ";
        $cutoff = 72;
    }
    else {
        $def_divider = "\n";
        $prefix = '';
        if (isset($_SESSION['settings']['read_wrap'])) {
            $cutoff = $_SESSION['settings']['read_wrap'];
        }
        else {
            $cutoff = 90;
        }
    }
    $text_part = preg_replace("/\t/", '    ', $text_part);
    $lines = preg_split("/\n/", $text_part);
    $carry_over = '';
    foreach ($lines as $index => $line) {
        if ($reply) {
            if (preg_match("/^((\s*>\s*){1,})(.*)/", $line, $regs)) {
                $line = rtrim($regs[1], "\r\n").' '.ltrim($carry_over, ' ').$regs[3];
            }
            else {
                $line = ltrim($carry_over, ' ').$line;
            }
        }
        $line = $prefix.$line;
        if (preg_match("/^(\s*>\s*){1,}/", $line, $regs) && $reply) {
            $divider = "\n".rtrim($regs[0], ' ')." ";
        }
        else {
            $divider = $def_divider;
        }
        if (strlen($line) > $cutoff) {
            $link = false;
            if ($link_check && preg_match("/((http|ftp)s?:\/\/(%[[:digit:]A-Fa-f][[:digit:]A-Fa-f]|[-_\.!~\*';\/\?#:@&=\+$,[:alnum:]])+)$/", $line, $matches) && !$reply) {
                $link = $matches[1]."\n";
                $line = substr($line, 0, (0 - strlen($matches[1])));
            }
                $temp = hm_split_line($line, $cutoff, false, $clean);
                if (count($temp) == 1) {
                    $result[] = rtrim(implode($divider, 
                                hm_split_line($line, $cutoff, true, $clean)))."\n";
                    $carry_over = '';
                }
                elseif(strlen($temp[(count($temp) - 1)]) > $cutoff) {
                    $result[] = rtrim(implode($divider, 
                                array_slice($temp, 0, (count($temp)-1))))."\n";
                    $result[] = rtrim(implode($divider, hm_split_line(
                                $temp[(count($temp)-1)], $cutoff, true, $clean)))."\n";
                    $carry_over = '';
                }
                else {
                    if ($reply) {
                        $carry_over = ' '.rtrim($temp[(count($temp)-1)]).' ';
                        array_pop($temp);
                    }
                    else {
                        $carry_over = '';
                    }
                    $result[] = rtrim(implode($divider, $temp))."\n";
                }
            if ($link) {
                $result[] = $link;
            }
        }
        else {
            $result[] = rtrim($line)."\n";
            $carry_over = '';
        }
    }
    $result[] = rtrim($carry_over)."\n";
    if ($reply) {
        while (isset($result[(count($result)-2)]) && 
               preg_match("/^>\s*\n$/", $result[(count($result)-2)])) {
            array_pop($result);
        }
    }
    else {
        while (isset($result[(count($result)-1)]) && 
               preg_match("/^\s*\n$/", $result[(count($result)-1)])) {
            array_pop($result);
        }
    }
    $body = "\n".implode("", $result)."\n";
    return $body;
}

/**
 *  decode quoted printable values
 *
 *  @param      $string     string      string to decode
 *  @return                 string      decoded text
 *
 */
function &hm_quoted_decode($string) {
    $string = preg_replace("/(\=[0-9A-Za-z]{2})\n/", "\\1 \n", $string);
    $result = preg_replace("/\=([0-9A-Za-z]{2})/e", 
              "''.chr(hexdec('\\1')).''", $string);
    $result = preg_replace("/\=\n/m", '', $result);
    return $result;
}

/**
 *  find and return parts of a message
 *
 *  @param      $imap_stream    resource    connection to imap
 *  @param      $structure      array       message mime structure
 *  @param      $uid            int         message uid
 *  @param      $part           float       part to return
 *  @param      $reply          boolean     format as a reply
 *  @param      $clean          boolean     don't add line break char (\)
 *  @param      $cutoff         boolean     flag to break LARGE messages
 *  @returns                    string      formatted message part
 *
 */
function &hm_find_display_part ($imap_stream, $structure, $uid, $part=false, 
                               $reply=false, $clean=false, $cutoff=false) {
    $str = $_SESSION['str'];
    if (!$part) {
        /* here we don't know the text part we want so find the first one */
        if (is_array($structure)) {
            foreach($structure as $index => $array) {
                if ($array['type'].$array['subtype'] == 'textplain' ||
                    $array['type'].$array['subtype'] == 'textenriched') {
                    $text_part = &hm_get_message_part($imap_stream, $uid, $index, $cutoff);
                    if (isset($array['charset'])) {
                        $chr = $array['charset'];
                    }
                    else {
                        $chr = false;
                    }
                    if ($array['encoding'] == 'quoted-printable') {
                        $text_part = &hm_quoted_decode($text_part);
                    }
                    elseif ($array['encoding'] == 'base64') {
                        $text_part = base64_decode($text_part);
                    }
                    $text_part = &hm_text_cleanup($text_part, $reply, $clean);
                    if ($array['type'].$array['subtype'] == 'textenriched') {
                        if ($reply) {
                            $text_part = str_replace("\n>\n>", "\n>", $text_part);
                        }
                        else {
                            $text_part = str_replace("\n\n", "\n", $text_part);
                        }
                    }
                    $result = array($index, $text_part, array($array['encoding'], 
                                    'text', 'plain', 'textplain', $chr));
                    return $result;
                }
                if (isset($array['subs'])) {
                    $result = &hm_find_display_part ($imap_stream, $array['subs'], $uid, 
                                                    false, $reply, $clean, $cutoff);
                    return $result;
                }
            }
        }
    }
    else {
        /* this is for parts selected from the message parts links in message.php */
        $dsp_type = false;
        $types = array(
        'text:plain'  => array ('textplain', 'messagedisposition-notification',
                                'messagedelivery-status', 'textenriched', 
                                'textrfc822-headers', 'messagerfc822-headers'),
        'image:jpeg'  => array('imagejpeg', 'imagepjpeg', 'imagejpg'),
        'image:png'   => array('imagepng'),
        'image:gif'   => array('imagegif'),
        'text:html'   => array('texthtml'));

        $attributes = &hm_in_multi_array ($part, $structure);
        if (isset($attributes[1]['type'])) {
            $type = $attributes[1]['type'];
        }
        else {
            $type = false;
        }
        if (isset($attributes[1]['name'])) {
            $name = $attributes[1]['name'];
        }
        else {
            $name = false;
        }
        if (isset($attributes[1]['subtype'])) {
            $subtype = $attributes[1]['subtype'];
        }
        else {
            $subtype = false;
        }
        if (isset($attributes[1]['encoding'])) {
            $decode = $attributes[1]['encoding'];
        }
        else {
            $decode = false;
        }
        if (isset($attributes[1]['charset'])) {
           $chr = $attributes[1]['charset'];
        }
        else {
            $chr = false;
        }
        $dsp_type = $type.$subtype;
        $dsp_flag = false;
        foreach ($types as $key => $array) {
            if (in_array($dsp_type, $array)) {
                $dsp_type = str_replace(':', '', $key);
                $dsp_flag = true;
                break;
            }
        }
        if (!$dsp_flag && $type == 'text') {
            $dsp_type = 'textplain';
        }
        $message_part = &hm_get_message_part($imap_stream, $uid, $part, $cutoff);
        if ($decode == 'quoted-printable') {
            $message_part = &hm_quoted_decode($message_part); 
        }
        elseif ($decode == 'base64') {
            $message_part = base64_decode($message_part);
        }
        if ($dsp_type == 'textplain') {
            $message_part = str_replace("\0", '', $message_part);
            if (!$clean) {
                $message_part = &hm_text_cleanup($message_part);
            }
            if ($type.$subtype == 'textenriched') {
                $message_part = str_replace("\n\n", "\n", $message_part);
            }
        }
        $result = array($part, $message_part, 
                        array( $decode, $type, $subtype, $dsp_type, $chr, $name));
        return $result;
    }
    /* if we could not find a text part return a message */
    $text_part = "\n\n     ".$str[194]."\n\n";
    $result = array('0', $text_part, array('none', 'text', 'plain', 'textplain'));
    return $result;
} 

/**
 *  check the cahce and decide on sort update 
 *
 *  @param  $mailbox    string      folder to check cahce status on
 *  @return             boolean     if the cache can be re-used
 *
 */
function hm_check_cache($mailbox) {
    $cache = false;
    if (isset($_SESSION['sort_data'][$mailbox])) {
        if (!isset($_SESSION['changed'][$mailbox])) {
            $cache = true;
        }
        else {
            unset($_SESSION['changed'][$mailbox]);
        }
    }
    return $cache;
} 

/**
 *  parse one set of message headers
 *
 *  @param  $header_array   array   the message headers
 *  @return                 array   keys are field names
 *  
 */
function hm_parse_header($header_array) {
    $result = array();
    $n = 1;
    $count = count($header_array);
    for ($i=0;$i<$count;$i++) {
        if (preg_match("/^(\S+:)(.*)/i", $header_array[$i], $regs)) {
            $field = $regs[1];
            $value = trim($regs[2]);
            if (isset($header_array[$i+1]) && 
                      preg_match("/^(\s|\t)/", $header_array[$i+1])) {
                $k = $i+1;
                while (preg_match("/^(\s|\t)/", $header_array[$k])) {
                    $value .= " ".trim($header_array[$k]);
                    if (isset($header_array[$k+1])) {
                        $k++;
                    }
                    else {
                        break;
                    }
                }
            }
            if (isset($result[strtolower(rtrim($field, ":"))])) {
                $key = strtolower(rtrim($field, ":")).'_'.$n;
                if ($key == 'subject' || $key == 'from' || 
                    $key == 'to' || $key == 'cc' || $key == 'reply-to') {
                    $value = hm_decode_field($value);
                }
                else {
                    $value = hm_htmlize($value);
                }
                $result[$key] = $value;
                $n++;
            }
            else {
                $key = strtolower(rtrim($field, ":"));
                if ($key == 'subject' || $key == 'from' || 
                    $key == 'to' || $key == 'cc' || $key == 'reply-to') {
                    $value = hm_decode_field($value);
                }
                else {
                    $value = hm_htmlize($value);
                }
                $result[$key] = $value;
            }
        }
    }
    return $result;
}

/**
 *  simple error check for IMAP responses
 *
 *  @param  $string     string  imap response to check
 *  @param  $prefix     string  the imap command prefix (like A00001)
 *  @param  $command    string  the command that was sent to the imap server
 *  @param  $inline     boolean produce errors with inline HTML 
 *  @return             void    exits calling script for a read error
 */
function hm_check_errors($string, $prefix, $command, $inline=false){
    $str = $_SESSION['str'];
    if (!strstr($string, $prefix)) {
        $settings = $_SESSION['settings'];
        if (!$inline) {
            echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>
      Hastymail
  </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">
  <link rel="stylesheet" type="text/css" href="../themes/',$settings['css_file'],'">
</head>
<body>',"\n";
        }
        echo '<br><br><br><br>
<table align="center" class="tables2" cellpadding="8" cellspacing="1">
   <tr>
      <td colspan="2" class="tables1" align="center">
      <b><font class="font2">',$str[193],':</font> &nbsp;&nbsp;
      ',$str[189],'</b>
      </td>
   </tr>
   <tr class="tables3">
      <td>
      ',$str[190],':
      </td>
      <td>
      ',hm_htmlize($command),'
      </td>
   </tr>
   <tr class="tables3">
      <td>
      ',$str[191],':
      </td>
      <td>
      ',hm_htmlize($string),'
      </td>
   </tr>
   <tr class="tables5">
      <td align="center" colspan="2">
      <a class="font2" href="../html/mailbox.php?id=',session_id(),'">
      ',$str[192],'</a>
      </td>
   </tr>
</table>
</body>
</html>',"\n";
        exit;
    }
}
/**
 *  takes the result of a message action and issue the correct imap
 *  commands, then returns the error/success information 
 *
 *  @param      $action         string      the imap action to perform
 *  @param      $imap_stream    resource    the connection to imap
 *  @param      $uid_string     string      message uids to operate on
 *  @param      $destination    string      if move or copy then this is target folder
 *  @param      $large          boolean     flag for really large message counts
 *  @param      $sort_type      string      sort method 
 *  @param      $mailbox        string      the currently selected mailbox
 *  @param      $dsp_count      int         # of messages we are dealing with
 *  @param      $dsp_end        string      end of the response string we send back
 *  @return                     string      sort type
 *
 */
function hm_message_controls ($action, $imap_stream, $uid_string, $destination,
                              $large, $sort_type, $mailbox, $dsp_count, $dsp_end) {
    $sort = false;
    $str = $_SESSION['str'];
    $dsp_end2 = $dsp_end;
    if (isset($_SESSION['config']['utf7_decode'])) {
        $dsp_end .= 'meuh <small>&nbsp;&nbsp;&nbsp;['.
                     hm_htmlize(utf8_encode(imap_utf7_decode(urldecode($mailbox)))).
                     ']</small>';
        $dsp_end2 .= '<small>&nbsp;&nbsp;&nbsp;['.
                     hm_htmlize(utf8_encode(imap_utf7_decode(urldecode($mailbox)))).
                     ' -> '.hm_htmlize(utf8_encode(imap_utf7_decode(urldecode(
                     $destination)))).']</small>';
    } 
    else {
        $dsp_end .= '<small>&nbsp;&nbsp;&nbsp;['.
                    hm_htmlize(urldecode($mailbox)).']</small>';
        $dsp_end2 .= '<small>&nbsp;&nbsp;&nbsp;['.hm_htmlize(urldecode($mailbox)).
                     ' -> '.hm_htmlize(urldecode($destination)).']</small>';
    }
    switch($action) {
        case 'move':
            if ($err = hm_imap_action($imap_stream, $uid_string, 'COPY', 
                                    $destination, $large)) {
                $_SESSION['notices'][] = $err;
            }
            elseif ($err = hm_imap_action($imap_stream, $uid_string, 'DELETE', 
                                          false, $large)) {
                $_SESSION['notices'][] = $err;
            }
            elseif ($err = hm_imap_action($imap_stream, $uid_string, 'EXPUNGE',
                                          false, $large)) {
                $_SESSION['notices'][] = $err;
            }
            else {
                $_SESSION['notices'][] = $str[186]." $dsp_count $dsp_end2";
            }
            break;
        case 'copy':
            if ($err = hm_imap_action($imap_stream, $uid_string, 'COPY', 
                                      $destination, $large)) {
                $_SESSION['notices'][] = $err;
            }
            else {
                $_SESSION['notices'][] = $str[187]." $dsp_count $dsp_end2";
            }
            break;
        case 'delete':
            $action_dsp = '';
            if (isset($_SESSION['settings']['trash_folder']) &&
                $_SESSION['settings']['trash_folder'] != $mailbox) {
                if ($err = hm_imap_action($imap_stream, $uid_string, 
                                                       'READ', false, $large)) {
                    $action_dsp = $err;
                }
                elseif ($err = hm_imap_action ($imap_stream, $uid_string, 'COPY',
                                           $_SESSION['settings']['trash_folder'],
                                           $large)) {
                    $action_dsp = $str[27];
                    unset($_SESSION['settings']['trash_folder']);
                    hm_write_settings($_SESSION['user'], $config['settings_dir']); 
                }
            }
            if ($action_dsp == '') {
                if ($err = hm_imap_action($imap_stream, $uid_string, 'DELETE', 
                                          false, $large)) {
                    $_SESSION['notices'][] = $err;
                }
                elseif ($err = hm_imap_action ($imap_stream, $uid_string, 'EXPUNGE',
                                               false, $large)) {
                    $_SESSION['notices'][] = $err;
                }
                else {
                    $_SESSION['notices'][] = $str[89]." $dsp_count $dsp_end";
                }
            }
            else {
                $_SESSION['notices'][] = $action_dsp;
            }
            break;
        case 'read':
            if ($err = hm_imap_action($imap_stream, $uid_string, 'READ', false, $large)) {
                $_SESSION['notices'][] = $err;
            }
            else {
                $_SESSION['notices'][] = $str[2]." $dsp_count $dsp_end";
            }
            break;
        case 'unread':
            if ($err = hm_imap_action($imap_stream, $uid_string, 'UNREAD',
                                      false, $large)) {
                $_SESSION['notices'][] = $err;
            }
            else {
                $_SESSION['notices'][] = $str[3]." $dsp_count $dsp_end";
            }
            break;
        case 'sort';
            $sort = $sort_type;
            $_SESSION['notices'][] = $str[188];
            break;
        default:
            break;
    }
    return $sort;
}

/**
 *  looks for message attachments and writes the entire message
 *  to the supplied stream. Used for both IMAP and SMTP
 *
 *  @param  $stream     resource    the connection to the server
 *  @param  $body       string      the first part of the message (headers and body)
 *  @param  $bndry      string      mime boundary
 *  @return             boolean     true on success, false on failure
 *
 */
function hm_write_data($stream, $body, $bndry) {
    $size = 0;
    if (is_resource($stream)) {
        fputs($stream, $body);
        $size = strlen($body);
        foreach ($_SESSION['attachments'] as $name => $vals) {
            clearstatcache();
            if (file_exists($_SESSION['config']['settings_dir'].'attachments/'.$name)
                && is_resource($stream)) {
                fputs($stream, "\r\n$bndry\r\n");
                fputs($stream, $vals['header']);
                $size += strlen("\r\n$bndry\r\n".$vals['header']);
                $fh = fopen($_SESSION['config']['settings_dir'].'attachments/'.$name,'r');
                if (is_resource($fh)) {
                    while (!feof($fh)) {
                        $tmp = fread($fh, 1024);
                        fputs($stream, $tmp);
                        $size += strlen($tmp);
                    }
                    fclose($fh);
                }
                //fputs($stream, "\r\n");
                //$size += 2;
            }
            else {
                return false;
            }
        }
    }
    else {
        return false;
    }
    fputs($stream, "\r\n$bndry--");
    $size += strlen("\r\n$bndry--");
    return $size; 
}

/**
 *
 * convert raw sizes into human readable form
 *
 *  @param      $rawsize    int     size in bytes
 *  @return     $size       string  human readable size
 *
 */
function hm_size_format ($rawsize) {
    $size = 'unkown';
    if ($rawsize > 1024 && $rawsize < 1048576) {
        $size = round(($rawsize/1024), 1).' Kb';
    }
    elseif ($rawsize > 1048576) {
        $size = round(($rawsize/1048576), 1).' Mb';
    }
    elseif ($rawsize < 1024) {
        $size = $rawsize.' b';
    }
    return $size;
}

/**
 *
 * Simple sort function for the search and new pages 
 *
 *  @param      $a          array     size in bytes
 *  @param      $b          array     size in bytes
 *  @return                 boolean   
 *
 */
function hm_date_cmp($a, $b) {
    if ($a[8] == $b[8]) {
        return 1;
    }
    elseif ($a[8] < $b[8]) {
        return 1;
    }
    else {
        return -1;
    }
}

?>
