<?php

/* html_functions.php: Some functions for html generation 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: html_functions.php,v 1.274.2.1 2004/05/06 15:39:56 sailfrog Exp $
*/


/**
 *  function to print out folder option elements for select boxes
 *
 *  @param      $mailbox    string|array    currently selected mailbox(s)
 *  @param      $unseen     array|boolean   unseen data array, or false
 *  @param      $simple     boolean         simple display mode flag
 *  @param      $enc        boolean         if true option values are urlencoded
 *  @param      $style      string          css style to use for the option elements
 *  @return                 void
 *
 */ 
function hm_folder_options($mailbox, $unseen=false, $simple=false, $enc=false, 
                           $css_style='') {
    $delim = $_SESSION['delimiter'];
    $folders = $_SESSION['folders'];
    $dsp_folders = $_SESSION['dsp_folders'];
    $no_sel = $_SESSION['nosel_folders'];
    $new_mail_folders = array();
    if (isset($_SESSION['settings']['new_mail_folders'])) {
        $new_mail_folders = $_SESSION['settings']['new_mail_folders'];
    }
    $detail = 'new';
    if (isset($_SESSION['settings']['folder_detail'])) {
        $detail = $_SESSION['settings']['folder_detail'];
    }
    $style = 'nested';
    if (isset($_SESSION['settings']['folder_style'])) {
        $style = $_SESSION['settings']['folder_style'];
    } 
    foreach($folders as $folder) {
        echo '                  <option ',$css_style,' value="';
        if ($enc) {
            echo urlencode($folder);
        }
        else {
            echo $folder;
        }
        if (in_array($folder, $no_sel)) {
            echo ' " DISABLED >';
        }
        elseif (!is_array($mailbox) && 
                (urlencode($folder) == $mailbox || $folder == $mailbox)) {
            echo '" SELECTED >';
        }
        elseif (is_array($mailbox) && in_array($folder, $mailbox)) {
            echo '" SELECTED >';
        }
        else {
            echo '">';
        }
        if (!$simple && substr_count($dsp_folders[$folder], $delim) > 0 &&
            $style == 'nested') {
            $pos = strrpos($dsp_folders[$folder], $delim);
            echo str_repeat('&nbsp;', intval($pos/2)),'|_ ';
            if (isset($_SESSION['config']['utf7_decode'])) {
                echo utf8_encode(imap_utf7_decode(substr($dsp_folders[$folder],
                     ($pos + 1))));
            }
            else {
                echo substr($dsp_folders[$folder], ($pos + 1));
            }
        }
        else {
            if (isset($_SESSION['config']['utf7_decode'])) {
                echo utf8_encode(imap_utf7_decode($dsp_folders[$folder]));
            }
            else {
                echo $dsp_folders[$folder];
            }
        }
        if ($unseen && $detail != 'none') {
            if (!isset($unseen[$folder])) {
                $unseen[$folder] = 0;
            }
            if (in_array($folder, $new_mail_folders)) {
                if ($detail == 'total') {
                    echo '&nbsp;&nbsp;('.$unseen[$folder].
                         '/'.$_SESSION['message_totals'][$folder].')';
                }
                else {
                    echo '&nbsp;&nbsp;('.$unseen[$folder].')';
                }
            }
        }
        echo "</option>\n";
    }
}

/**
 *  function to output the top of each page, html title etc. and the toolbar
 *
 *  @param      $imap_stream    resource    conneciton to imap
 *  @param      $mailbox        string      currently selected folder
 *  @param      $unseen         array       unseen array
 *  @param      $refresh        boolean     add refresh meta tag
 *  @param      $page_name      string      name of the calling script
 *  @param      $warning        string      a warning/notice for hm_print_error()
 *  @return                     void
 *
 */
function hm_toolbar($imap_stream, $mailbox, $unseen, $refresh=false, $page_name=false,
                    $warning=false, $uid=false) {
    $config = $_SESSION['config'];
    $settings = $_SESSION['settings'];
    $str = $_SESSION['str'];
    if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 
        'true') || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 
        'true')) {
        $simple = true;
    }
    else {
        $simple = false;
    }
    if (!isset($settings['css_file'])) {
        if (!isset($config['default_theme']) || $config['default_theme'] == '') {
            $settings['css_file'] = 'default.css';
        }
        else {
            $settings['css_file'] = $config['default_theme'];
        }
    }
    if (isset($settings['refresh_new'])) {
        $refresh_new = $settings['refresh_new'] * 60;
    }
    else { 
        $refresh_new = 60;
    }
    if (isset($config['page_title'])) {
        $title = $config['page_title'];
    }
    else {
        $title = 'Hastymail';
    }
    if ($page_name) {
        $title = $page_name.' | '.$title;
    }
    if ($uid) {
        if (!isset($_SESSION['current_uid'])) {
            $_SESSION['current_uid'] = array();
        }
        $_SESSION['current_uid'][$mailbox] = $uid;
    }
    $total = 0;
    foreach ($unseen as $index => $value) {
        $total += $value;
    }
    if (isset($settings['date_string'])) {
        $date_string = $settings['date_string'];
    }
    else {
        $date_string = 'g:i:s a m/d/y';
    }
    header("Expires: Mon, 26 Jul 1997 05:00:00 GMT");
    header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT"); 
    header("Cache-Control: no-store, no-cache, must-revalidate");
    header("Cache-Control: post-check=0, pre-check=0", false);
    header("Pragma: no-cache");             
    header("Content-Type: text/html; charset=".$str['charset']);

    echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>
      ',
        $str[10],' (',$total,') | ',$title,'
  </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">',"\n";
    if ($refresh && ($refresh_new != 0)) {
        echo '  <meta HTTP-EQUIV="refresh" content="',$refresh_new,';url=',
            $config['hostname'],$config['install_path'],
            'new.php?mailbox=',urlencode($mailbox),'&amp;id=',session_id(),"\">\n";
    }
    if (!$simple) {
        echo '  <link rel="stylesheet" type="text/css" href="../themes/',
             $settings['css_file'],"\" >\n";
    }
    echo '<link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>',"\n";
    if (!$simple) {
        echo '<table width="100%" align="center">
   <tr>
      <td class="tables2" width="1%">
      <table align="center" width="100%" cellpadding="2" cellspacing="2" class="tables1">
         <tr>
            <td align="center" ';
        if (isset($settings['wide_bar']) && $settings['wide_bar'] == 'true') {
            echo 'rowspan="2" valign="top" width="29">',"\n";
        }
        else {
            echo 'valign="middle" width="29">',"\n";
        }
echo '            <a href="about.php?id=',session_id(),'&amp;mailbox=',$mailbox,'">
            <img src="../images/hastymail.png" width="28" height="23" border="0" alt="H">
            </a>
            </td>',"\n";
        if (isset($settings['show_clock']) && $settings['show_clock'] == 'true') {
            echo '            <td align="center" nowrap valign="middle">
            <table class="tables2" cellpadding="2" cellspacing="0">
               <tr>
                  <td class="tables1" nowrap>
                  <small>&nbsp;',date($date_string),'&nbsp;</small>
                  </td>
               </tr>
            </table>
            </td>',"\n";
        }
        echo '            <td nowrap valign="middle">',"\n";
    }
    echo '             <form action="mailbox.php" method="post">
            <select name=mailbox>',"\n";
    hm_folder_options($mailbox, $unseen, $simple, true);
    echo '            </select>
            &nbsp;&nbsp;
            <input type="submit" name="',$str[5],'" value="',$str[5],'" class="button1">
            <input type="hidden" name="id" value="',session_id(),'">
            </form>',"\n";
    if (!$simple) {
    echo '            </td>',"\n";
    if (isset($settings['wide_bar']) && $settings['wide_bar'] == 'true') {
        echo '<td width="75%"></td></tr><tr><td></td>';
    }
    echo '            <td colspan="2" align="right" nowrap>',"\n";
        $search = '<input type="submit" name="search" value="'.$str[11].
                  '" class="button1">';
    }
    else {
        $search = '';
    }
    echo '            <form method="post" action="redirect.php">
            <input type="submit" name="new" value="',$str[10],' (',$total,')',
            '" class="button1">
            ',$search,'
            <input type="submit" name="options" value="',$str[12],'" class="button1">
            <input type="submit" name="folders" value="',$str[13],'" class="button1">
            <input type="submit" name="contacts" value="',$str[14],'" class="button1">
            <input type="submit" name="compose" value="',$str[15],'" class="button1">
            <input type="submit" name="logout" value="',$str[16],'" class="button1">
            <input type="hidden" name="id" value="',session_id(),'">
            <input type="hidden" name="mailbox" value="',$mailbox,'">
            <input type="hidden" name="hostname" value="',$config['hostname'],'">
            <input type="hidden" name="install_path" value="',
            $config['install_path'],'">
            </form>',"\n";
    if (!$simple) {
echo '            </td>
        </tr>';
    hm_print_error($simple, $warning);
echo '    </table>
    </td>
</tr>
</table>',"\n";
        if (isset($config['iframe']) && $config['iframe'] == 'true' && 
           (!$refresh || $refresh_new == 0)) {
            echo '<iframe src="iframe.php?id=',session_id(),
         '" width="0" height="0" frameborder="0" style="{display: none}">
</iframe>',"\n";
        }
    }
    else {
        hm_print_error($simple, $warning);
    }
    
}

/**
 *  check for errors and print them out
 *
 *  @param      $simple     boolean     status of simple mode display
 *  @param      $warning    string      warning/notice from the calling script
 *  @return                 void        prints errors under the toolbar
 *
 */
function hm_print_error($simple, $warning) {
    $str = $_SESSION['str'];
    if ($simple) {
        $start = '<br>';
        $stop = '<br>';
    }
    else {
        $start = '<tr><td colspan="4" align="center">';
        $stop = '</td></tr>'."\n";
    }
    if (empty($_SESSION['notices'])) {
        return;
    }
    else {
        echo $start;
        foreach($_SESSION['notices'] as $index => $val) {
            echo '<b><small>'.preg_replace("/<br>$/", '', $val),'</small></b><br>';
        }
        echo $stop;
        $_SESSION['notices'] = array();
    }
    if ($warning && $warning != '') {
        echo $start,$warning,$stop;
    }
}

/**
 *  function to print out the attachments part of the message page
 *
 *  @param  $structure  array   the message structure array
 *  @param  $part       float   message part number
 *  @param  $atag       string  the begining of a really long link tag
 *  @param  $level      int     keeps track of recursive calling for part indentation
 *  @return
 *
 */
function hm_print_attachments ($structure, $part, $atag, $level=0) {
    $simple = false;
    $str = $_SESSION['str'];
    if ((isset($_SESSION['settings']['simple']) && $_SESSION['settings']['simple'] == 
        'true') || (isset($_SESSION['auto_simplify']) && $_SESSION['auto_simplify'] == 
        'true')) {
        $simple = true;
    }
    $types = array( 'textplain', 'messagedisposition-notification', 'textrfc822-headers', 
                    'messagedelivery-status', 'imagejpeg', 'imagepjpeg', 'imagejpg',
                    'imagepng', 'imagegif', 'texthtml', 'textenriched', 
                    'messagerfc822-headers');

    foreach ($structure as $index => $array) {
        $double_link = false;
        if (!isset($array['type'])) {
            $type = 'unknown';
        }
        else {
            $type = $array['type'];
        }
        if (!isset($array['subtype'])) {
            $subtype = 'unknown';
        }
        else {
            $subtype = $array['subtype'];
        }

        /* normal attachments */
        if ($type != 'mixed' && $type != 'unknown' && $subtype != 'rfc822') {
            if (!$simple) {
            echo "         <tr class=\"tables3\">\n";
                if ($index == $part) {
                    echo '<td class="tables3" nowrap>-&gt;</td>';
                }
                else {
                    echo '<td class="tables3">&nbsp;</td>';
                }
                echo '            <td class="tables3" align="center" nowrap>
            <small>&nbsp;',"\n";
            }
            else {
                echo '<br><small>';
            }

            /* view links for supported types */
            if ((in_array($type.$subtype, $types) || $type == 'text') 
                && $index != $part) {
                echo $atag,"part=$index\">",$str[39],"</a></small>\n";
                $double_link = true;
            }

            /* download links for supported types */
            if ($type != 'message' || $type.$subtype == 'messagedelivery-status' ||
                $type.$subtype == 'messagerfc822-headers') {
                if ($double_link) {
                    echo ' / <small>';
                }
                echo '            ',
                     preg_replace("/message.php/", 'download.php', $atag),
                     "part=$index";
                if ($double_link || $index == $part) {
                    echo '&amp;subtype=octet-stream&amp;type=application';
                }
                else {
                    echo '&amp;subtype=',$subtype,'&amp;type=',$type;
                }
                if ($type.$subtype == 'textplain' || $type.$subtype == 'textenriched') {
                    echo "&amp;name=message.txt";
                }
                elseif ($type.$subtype == 'texthtml') {
                    echo '&amp;name=message.html';
                }
                elseif (preg_match("/\"filename\" \"([^\"]+)\"/i", $array['remainder'],
                                   $matches)) {
                   echo '&amp;name=',urlencode($matches[1]);
                }
                elseif (isset($array['name']) && trim($array['name']) != '') {
                    echo "&amp;name=", urlencode($array['name']);
                }
                else {
                    echo '&amp;name=unknown.',$subtype;
                }
                if (isset($array['encoding']) && isset($array['encoding'])) {
                    echo '&amp;decode=',strtolower($array['encoding']);
                }
                echo '">',$str[38],'</a>
            </small>',"\n";
                if (!$simple) {
                    echo '            </td>',"\n";
                }
            }

            /* indent and type section */
            if (!$simple) {
                echo '            <td class="tables3" nowrap>',"\n";
            }
            echo '            <small>&nbsp;', str_repeat('&nbsp;', ($level*8));
            if ($level > 0) {
                echo '|_&nbsp;';
            }
            echo $type,' - ',$subtype,' </small>',"\n";
            if (!$simple) {
                echo '             </td>',"\n";

            /* description */
            echo '            <td class="tables3" nowrap>',"\n";
            }
            echo '            <small>',"\n";
            if (isset($array['description']) && 
                strtolower($array['description']) != 'nil' &&
                trim($array['description']) != '') {
                echo '            ',str_replace('"', '', $array['description']),"\n";
            }
            elseif (isset($array['subject']) && 
                strtolower($array['subject']) != 'nil' &&
                trim($array['subject']) != '') {
                echo '            ', $array['subject'],"\n";
            }
            elseif (preg_match("/\"filename\" \"([^\"]+)\"/i", $array['remainder'],
                               $matches)) {
                echo '            ',$matches[1],"\n";
            }
            elseif (isset($array['name']) && trim($array['name']) != '') {
                echo '            ', $array['name'],"\n";
            }

            /* size */
            echo '            </small>',"\n";
            if (!$simple) {
                echo '            </td>
            <td class="tables3" nowrap>',"\n";
            }
            echo "            <small>\n";
            if (isset($array['size'])) {
                echo '            ',$array['size'],"\n";
            }
            else {
                echo "            Unknown\n";
            }
            echo "            </small>\n";
            if (!$simple) {
                echo "            </td>
         </tr>\n";
            }
        }

        /* rfc822 messages */
        if ($type == 'message' && $subtype == 'rfc822') {
            if (!$simple) {
                echo '         <tr class="tables3">
            <td colspan="2">
            </td>
            <td>
            <small>
            ',str_repeat('&nbsp;', ($level*8)),'&nbsp;Rfc-message:&nbsp;&nbsp;&nbsp;
            </small>
            </td>
            <td colspan="2">
            <table width="100%">
               <tr>
                 <td width="60%">
                 <small>',"\n";
            }
            else {
                echo "<small>\n";
            }
            if (isset($array['description']) && 
                strtolower($array['description']) != 'nil') {
                echo '                 ',str_replace('"', '', $array['description']),"\n";
            }
            elseif (isset($array['subject']) && 
                strtolower($array['subject']) != 'nil') {
                echo '                 ',$array['subject'],"\n";
            }
            echo '                   </small>',"\n";
            if (!$simple) {
                echo '                   </td>
                  <td width="40%">',"\n";
            }
            echo '                   <small>',"\n";
            if (isset($array['from']) && 
                strtolower($array['from']) != 'nil') {
                echo '                 ',str_replace('"', '', $array['from']),"\n";
            }
            echo '                   </small>',"\n";
            if (!$simple) {
                echo '                   </td>
                </tr>
             </table>
             </td>
          </tr>',"\n";
            }
        }
                 
        if (isset($array['subs'])) {
            if (isset($level)) {
                $level += 1;
            }
            hm_print_attachments ($array['subs'], $part, $atag, $level);
            $level -= 1;
        }
    }
}
/**
 *  function to build the first 2/3 of the top and bottom of the message page
 *
 *  @param  $sort_info      array       the sort information for this mailbox
 *  @param  $mailbox        string      the currently selected folder
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $page_num       int         he current page number if known
 *  @param  $id             string      session id
 *  @param  $uid            int         message uid
 *  @param  $dsp_folders    array       folder array formatted for display
 *  @param  $simple         boolean     flag indicating simple mode
 *  @return                 array       (html, prev/next toggle, current message flags)
 *
 */
function hm_message_header ($sort_info, $mailbox, $imap_stream, 
                            $page_num, $id, $uid, $dsp_folders, $simple=false) {
    $pre = false;
    $nex = false;
    $string = false;
    $pre_new = false;
    $nex_new = false;
    $key = array_keys($sort_info[2], $uid);
    $key = $key[0];
    $result = '';
    $str = $_SESSION['str'];

    if (!in_array($uid, $sort_info[1][$page_num][2])) {
        if (isset($sort_info[1][$page_num + 1][2]) &&
            in_array($uid, $sort_info[1][$page_num + 1][2])) {
            $page_num = $page_num + 1;
        }
        elseif (isset($sort_info[1][$page_num - 1][2]) &&
                in_array($uid, $sort_info[1][$page_num - 1][2])) {
            $page_num = $page_num - 1;
        }
        else {
            foreach ($sort_info[1] as $index => $array) {
                if (in_array($uid, $array[2])) {
                    $page_num = $index;
                    break;
                }
            }
        }
    }
    $result = '';

    $result .=  hm_create_next_previous ($imap_stream, $sort_info[2], urlencode($mailbox),
                                         array ('&lt;&lt;&lt;', '', '&gt;&gt;&gt;', '',
                                         ''), $uid, $id, false, '', false, '', false,
                                         true, 'width="10%"', false, $simple); 

    /* link back to the mailbox page, with page number */
    if (!$simple) {
        $result .= '            <td class="tables2">'."\n";
    }
    $result .= '            <a class="font2" href="mailbox.php?mailbox='.
            urlencode($mailbox).'&amp;id='.$id.'&amp;page_num='.$page_num.'&amp;uid='.
            $uid.'">&nbsp;&nbsp;&nbsp;';
    if (isset($_SESSION['config']['utf7_decode'])) {
        $result .= utf8_encode(imap_utf7_decode($dsp_folders[urldecode($mailbox)]));
    }
    else {
        $result .= $dsp_folders[urldecode($mailbox)];
    }
    $result .= '&nbsp;&nbsp;(&nbsp;'.$str[9].'&nbsp;'.($page_num + 1).',&nbsp;&nbsp;'.
            $str[26].'&nbsp;'.($key+1).'&nbsp;/&nbsp;'.count($sort_info[2]).
            '&nbsp;)</a>'."\n";

   
    return array($page_num, $result);
}

/**
 * Prints out the column headers for a message listing
 *
 *  @param      $mailbox        string      current folder
 *  @return                     void
 *
 */
function hm_start_message_listing ($mailbox) {
    $str = $_SESSION['str'];
    /* checkbox */
    $col_1 = '            <td>
            &nbsp;
            </td>'."\n";
    /* subject */
    $col_2 = '            <td colspan="2" width="50%">
            &nbsp;&nbsp;&nbsp;<small><b>'.$str[21].'</b></small>
            </td>'."\n";
    /* from or to */
    $col_3 = '            <td width="25%">'."\n";
    if (isset($_SESSION['settings']['sent_folder']) && 
        ($_SESSION['settings']['sent_folder'] == urldecode($mailbox))) {
        $col_3 .= "            &nbsp;&nbsp;<b><small>".$str[25]."</small></b>\n";
    }
    else {
        $col_3 .= "            &nbsp;&nbsp;<b><small>".$str[22]."</small></b>\n";
    }
    $col_3 .= '            </td>'."\n";
    /* date */
    $col_4 = '            <td width="19%">
            &nbsp;&nbsp;<b><small>'.$str[23].'</small></b>
            </td>'."\n";
    /* size */
    $col_5 = '            <td width="5%">
            &nbsp;&nbsp;<b><small>'.$str[24].'</small></b>
            </td>'."\n";
    /* flags */
    $col_6 = '            <td width="1%">
            &nbsp;&nbsp;
            </td>'."\n";
    echo $col_1,$col_2,$col_3,$col_4,$col_5,$col_6;
}

/**
 *  Print out one row of message details
 *
 *  @param      $headers        array       message header data
 *  @param      $simple         boolean     simple mode flag
 *  @param      $t_all          boolean     toggle all flag
 *  @param      $mailbox        string      current mailbox
 *  @param      $id             string      session id
 *  @param      $uid            int         message id
 *  @param      $sort_info      array       sort information for thread view
 *  @param      $current        boolean     true if this message is the last one viewed
 *  @param      $ref            array       thread sorting reference array
 *  @param      $row            int         current row for thread sorting
 *  @param      $message_page   boolean     message page flag
 *  @param      $up             string      uid for the up arrow link (false for none)
 *  @param      $down           string      uid for the down arrow link (false for none)
 *  @param      $cur_uid        string      real uid used when called with message_page
 *  @return                     void
 *
 */
function hm_print_row($headers, $simple, $t_all, $mailbox, $id, $uid, $sort_info=array(),
                      $hilite=true, $chk_folder=false, $search=false, $thread=false, 
                      $current=false, $ref=array(), $row=false, $message_page=false) {
    $str = $_SESSION['str'];
    $col_1 = '';
    $col_2 = '';
    $col_3 = '';
    $col_4 = '';
    $col_5 = '';
    $col_6 = '';
    list ($subject, $from, $date, $priority, $content, 
         $flags, $to, $size, $int_date) = $headers;
    if (!$current && !$message_page) {
        if (isset($_SESSION['current_uid'][$mailbox]) &&
            $uid == $_SESSION['current_uid'][$mailbox]) {
            $current=true;
        }
    }
    if ($message_page) {
        $start = '<small>';
        $stop  = '</small>';
    }
    else {
        $start = '';
        $stop  = '';
    }
    if ($subject == '') {
        $subject = $str[229];
    }
    $priority = ltrim($priority);
    $from = hm_address_dsp($from, $str[230]);
    $to = hm_address_dsp($to, $str[232]);
    if (!strstr($subject, ' ') && strlen($subject) > 100) {
        $subject = substr($subject, 0, 100).' '.substr($subject, 100);
    }
    if (!stristr($flags, 'seen')) {
        $new = 1;
        if ($hilite) {
            $class = 'tables6';
            $font = 'font2';
        }
        else {
            $class = 'tables3';
            $font = 'font1';
        }
    }
    else {
        $new = 0;
        $class = 'tables3';
        $font = 'font1';
    }
    if (!stristr($flags, 'answered')) {
        $ans = false;
    }
    else {
        $ans = true;
    }
    echo '         <tr>',"\n";
    /* print out a table row */
    if (!$simple && !$thread) {
        $col_1 .= '            <td valign="top" width="1%" class="'.$class.
                 '" nowrap>'."\n";
    }
    elseif (!$simple) {
        $col_1 .= '            <td class="'.$class.'" nowrap>'."\n";
    }
    else {
        $col_1 .= "            <td>\n";
    }
    /* checkbox */
    if (!$thread && !$message_page) {
        if (!$chk_folder) {
            $col_1 .= '            <input type="checkbox" name="'.$uid.
                 '" value="mark" class="'.$class.'" ';
            if ($t_all) {
                if (!isset($_POST[$uid])) {
                    $col_1 .= 'CHECKED ';
                }
            }
        }
        else {
            $col_1 .= '            <input type="checkbox" name="'.$chk_folder.
                 '[]" value="'.$uid.'" class="'.$class.'" ';
            if ($t_all) {
                if (!isset($_POST[$chk_folder])) {
                    $col_1 .= 'CHECKED ';
                }
                else {
                    if (!in_array($uid, $_POST[$chk_folder])) {
                        $col_1 .= 'CHECKED ';
                    }
                }
            }
        }
        $col_1 .= ">\n";
    }
    else {
        $col_1 .= '&nbsp;';
    }
    $tag = 'mailbox='.urlencode($mailbox).'&amp;id='.urlencode($id).
           '&amp;new='.$new.'&amp;uid='.$uid;
    if ($search) {
        $tag .= '&amp;search=1';
    }
    if ($thread) {
        $tag .= '&amp;thread=1';
    }
    /* current message arrow */
    if (!$simple) {
        $col_1 .= '</td>'."\n";
        $col_2 .= '            <td width="1%" class="'.$class.
                  '" nowrap valign="top">'."\n";
        if ($current) {
            $col_2 .= '            -&gt;';
        }
        else {
            $col_2 .= '            &nbsp;&nbsp;&nbsp;';
        }
        $col_2 .= '            </td><td class="'.$class.'" valign="top">'."\n";
    }
    /* thread lines */
    if (isset($sort_info[3]) && isset($sort_info[3][$uid])) {
        if ($sort_info[3][$uid] > 1) {
            $range = array_slice($ref, $row); 
            $remaining = $range;
            $place = array();
            foreach ($range as $index => $val) {
                if ($val < $sort_info[3][$uid]) {
                    $add = true;
                    foreach ($remaining as $v) {
                        if ($v == $val) {
                            $add = true;
                            break;
                        }
                        if ($v < $val) {
                            $add = false;
                            break;
                        }
                    }
                    if ($add) {
                        $place[] = $val;
                    }
                }
            }
            $string = str_repeat("_", $sort_info[3][$uid]);
            foreach ($place as $value) {
                $string{$value} = '|';
            }
            $string = str_replace('_', '&nbsp;&nbsp;&nbsp;', $string);
            $string = str_replace('|', '|&nbsp;&nbsp;&nbsp;', $string);
            $col_2 .= "            <font class=\"font1\">$string|_</font>&nbsp;\n";
        }
    }
    if ($simple) {
        /*$col_2 .= '</td>';
        $col_2 .= '<td>';
        if ($new == 1) {
            $col_2 .= '<b>[U] ';
        }*/
    }
    /* subject */
    $col_2 .= '            <a class="'.$font.'" href="message.php?'.$tag.'">
        '.$start.'    '.$subject.$stop.' </a>'."\n";
    /* from (or to for sent folder) */
    if (!$simple) {
        $col_2 .= '            </td>'."\n";
        $col_3 .= '            <td class="'.$class.'" valign="top">'."\n";
    }
    else {
        /*$col_2 .= "            </b></td>";
        $col_3 .= "            <td>\n";*/
        $col_2 .= "            <br>\n";
    }
    if (!$simple) {
        $col_3 .= '            <a class="'.$font.'" href="message.php?'.$tag."\">\n";
    }
    if (isset($_SESSION['settings']['sent_folder']) &&
             ($_SESSION['settings']['sent_folder'] == urldecode($mailbox))) {
        $col_3 .= '           '.$start.$to.$stop;
    }
    else {
        $col_3 .= '            &nbsp;&nbsp;'.$start.$from.$stop;
    }
    /* date */
    if ($simple) {
        /*$col_3 .= '</td>';
        $col_4 .= '<td>';*/
        $col_3 .= "<br>\n";
    }
    else {
        $col_3 .= '</a>
            </td>'."\n";
        $col_4 .= '            <td valign="top" nowrap class="'.$class.'">'."\n";
    }
    $col_4 .= '            &nbsp;'."\n";
    if (!$simple) {
        $col_4 .= '            <font class="'.$font.'">';
    }
    $col_4 .= '            '.$start.hm_htmlize($date).$stop."\n";;
    if (!$simple) { 
        $col_4 .= '</font>
            </td>'."\n";
        $col_5 .= '            <td valign="top" class="'.$class.
                 '" nowrap><font class="'.$font."\">\n";
    }
    /* size */
    if ($simple) {
        $col_5 .= "            <br>\n            &nbsp;&nbsp;";
    }
    else {
        $col_5 .= "&nbsp;\n            ";
    }
    if ($size != '') {
        $col_5 .= $start.hm_size_format($size).$stop;
    }
    $col_5 .= "         &nbsp;</font>\n";
    if (!$simple) {
        $icons = '';
        if (stristr($content, 'multipart') || stristr($content, 'mixed')) {
            $icons .= '<b><small>+&nbsp;</small></b>';
        }
        if ($ans) {
            $icons .= '<b><small>r&nbsp;</small></b>';
        }
        if (strlen($priority) > 0 && $priority{0} < 3) {
            $icons .= '<b><font color="red"><small>!&nbsp;</small></font></b>';
        }
        $col_5 .= '            </td>'."\n";
        $col_6 .= '            <td class="'.$class.
                  '">
            '.$icons.'&nbsp;
            </td>
         </tr>'."\n";
    }
    else {
        $col_6 .= "            </td>
         </tr>\n";
    }
    if ($message_page) {
        echo '<td></td>';
    }
    echo $col_1,$col_2,$col_3,$col_4,$col_5,$col_6;
}

/**
 *  Create previous and next links for message ranges
 *
 *  @param      $imap_stream    resource    connection to imap
 *  @param      $range          array       uid array
 *  @param      $mailbox        string      current mailbox
 *  @param      $style          array       the link text and style
 *  @param      $uid            int         current message id
 *  @param      $id             string      session id
 *  @param      $multi_folder   boolean     true if the range spans multiple folders
 *  @param      $tag_extra      string      some url args for the prev and next links
 *  @param      $center         string      center url (flase for no center link)
 *  @param      $center_extra   string      url args for the center link
 *  @param      $thread         boolean     if this is prev/next in thread
 *  @param      $set_flag       boolean     cache read/unread flags for re-use
 *  @param      $width          string      table width
 *  @param      $use_flag       boolean     use cached flags
 *  @return                     string      html links in a small html table
 *
 */
function hm_create_next_previous ($imap_stream, $range, $mailbox, $style, $uid, $id,
                                  $multi_folder=false, $tag_extra='', $center=false, 
                                  $center_extra='', $thread=false, $set_flag=false,
                                  $width='', $use_flag=false, $simple=false) {
    $class = 'font2';
    $pos = 0;
    $max = 0;
    if ($use_flag) {
        if (isset($_SESSION['prev_flag'])) {
            $prev_uid = $_SESSION['prev_flag'];
            $pos = 1;
            $prev_box = $mailbox;
        }
        if (isset($_SESSION['next_flag'])) {
            $next_uid = $_SESSION['next_flag'];
            $max = 2;
            $next_box = $mailbox;
        }
    }
    elseif (!$multi_folder) {
        if ($thread) {
            foreach($range[$mailbox] as $index => $array) {
                if (in_array($uid, $array[1])) {
                    $current_range = $array[1];
                    break;
                }
            }
        }
        else {
            $current_range = $range;
        }
        $current_index_array = array_keys($current_range, $uid);
        $pos = $current_index_array[0];
        $max = (count($current_range) - 1);
        if ($pos > 0) {
            $prev_uid = $current_range[($pos - 1)];
            $prev_box = $mailbox;
        }
        if ($pos < $max) {
            $next_uid = $current_range[($pos + 1)];
            $next_box = $mailbox;
        }
    }
    else {
        $range_index_array = array_keys($range);
        list($fold_pos) = array_keys($range_index_array, $mailbox);
        $fold_max = count($range_index_array) - 1;
        $current_index_array = array_keys($range[$mailbox]);
        $max = count($current_index_array) - 1;
        list($pos) = array_keys($current_index_array, $uid);
        if ($pos > 0) {
            $prev_uid = $current_index_array[($pos - 1)];
            $prev_box = $mailbox;
        }
        elseif ($fold_pos > 0) {
            $prev_box = $range_index_array[($fold_pos - 1)];
            $prev_index_array = array_keys($range[$prev_box]);
            $prev_uid = $prev_index_array[(count($prev_index_array) - 1)];
        }
        if ($pos < $max) {
            $next_uid = $current_index_array[($pos + 1)];
            $next_box = $mailbox;
        }
        elseif ($fold_pos < $fold_max) {
            $next_box = $range_index_array[($fold_pos + 1)];
            $next_index_array = array_keys($range[$next_box]);
            $next_uid = $next_index_array[0];
        }
    }
    if (!$simple) {
        $return_string = '            <td class="tables2" '.$width.
                         ' align="center" nowrap>'."\n";
    }
    else {
        $return_string = '';
    }
    if ($pos > 0 || (isset($fold_pos) && $fold_pos > 0)) {
        if ($use_flag) {
            if (isset($_SESSION['prev_new']) && $_SESSION['prev_new'] == 1) {
                $class = 'font3';
                $new = 1;
            }
            else {
                $class = 'font2';
                $new = 0;
            }
        }
        else {
            if ($prev_box != $mailbox) {
                hm_select_mailbox($imap_stream, $prev_box);
            }
            $prev_flags = hm_get_flags($imap_stream, $prev_uid);
            if ($prev_box != $mailbox) {
                hm_select_mailbox($imap_stream, $mailbox);
            }
            if (stristr($prev_flags, '\Seen')) {
                $class = 'font2';
                $new = 0;
            }
            else {
                $class = 'font3';
                $new = 1;
            }
        }
        if ($set_flag) {
            $_SESSION['prev_flag'] = $prev_uid;
            $_SESSION['prev_new'] = $new;
        }
        $return_string .= '            '.$style[3].'<a class="'.$class.
                          '" href="message.php?id='.$id.'&amp;uid='.$prev_uid.
                          '&amp;mailbox='.$prev_box.'&amp;new='.$new. $tag_extra.'">'.
                          $style[0].'</a>'.$style[4]."\n";
    }
    if ($center) {
        $_SESSION['current_flags'] = hm_get_flags($imap_stream, $uid);
        $return_string .= '            '.$style[3].'<a class="font2" href="'.$center.
                          '?id='.$id.'&amp;uid='.$uid.'&amp;mailbox='.$mailbox.
                          $center_extra.'">'.$style[1].'</a>'.$style[4]."\n";
    }
    else {
        $return_string .= "            &nbsp;\n";
    }
    if ($pos < $max || (isset($fold_pos) && isset($fold_max) && $fold_pos < $fold_max)) {
        if ($use_flag) {
            if (isset($_SESSION['next_new']) && $_SESSION['next_new'] == 1) {
                $class = 'font3';
                $new = 1;
            }
            else {
                $class = 'font2';
                $new = 0;
            }
        }
        else {
            if ($next_box != $mailbox) {
                hm_select_mailbox($imap_stream, $next_box);
            }
            $next_flags = hm_get_flags($imap_stream, $next_uid);
            if ($next_box != $mailbox) {
                hm_select_mailbox($imap_stream, $mailbox);
            }
            if (stristr($next_flags, '\Seen')) {
                $class='font2';
                $new = 0;
            }
            else {
                $class = 'font3';
                $new = 1;
            }
        }
        if ($set_flag) {
            $_SESSION['next_flag'] = $next_uid;
            $_SESSION['next_new'] = $new;
        }
        $return_string .=  '            '.$style[3].'<a class="'.$class.
                           '" href="message.php?id='.$id.'&amp;uid='.$next_uid.
                           '&amp;mailbox='.$next_box.'&amp;new='.$new.$tag_extra.'">'.
                           $style[2].'</a>'.$style[4]."\n";
    }
    if (!$simple) {
        $return_string .= '            </td>'."\n";
    }
    return $return_string;    
}

/**
 *  Folder preview on the message page
 *
 *  @param      $imap_stream    resource    connection to imap
 *  @param      $cur_uid        int         message uid for the center of the list
 *  @param      $sort_info      array       sort information for thread view
 *  @param      $id             string      session id
 *  @param      $mailbox        string      current mailbox
 *  @param      $real_uid       int         the currently displayed message
 *  @return                     void
 */
function hm_folder_preview ($imap_stream, $cur_uid, $sort_info, $id, $mailbox,
                            $real_uid) {
    $str            = $_SESSION['str'];
    $amount         = $_SESSION['settings']['folder_preview'];
    $check          = ($amount - 1)/2;
    $scroll_down    = false;
    $scroll_up      = false;
    if (in_array($cur_uid, $sort_info[2])) {
        list($index) = array_keys($sort_info[2], $cur_uid);
        if ($index !== false) {
            $total = count($sort_info[2]);
            if ($total <= $amount) {
                $start_pos = 0;
            }
            elseif ($index < $check) {
                $start_pos = 0;
            }
            else {
                $start_pos = $index - $check;
            }
            if (($start_pos + $amount) >= $total) {
                $start_pos = $total - $amount;
            }
            if ($index > $check) {
                $scroll_up = $start_pos;
            }
            if (($start_pos + $amount - 1) < ($total - 1)) {
                $scroll_down = $start_pos + $amount - 1;
            }
            $uid_slice   = array_slice($sort_info[2], $start_pos, $amount);
            $uid_string  = implode(',', $uid_slice);
            $uid_headers = &hm_get_messages ($uid_string, $imap_stream);
            echo '
      <table class="tables2" cellpadding="1" cellspacing="0" align="center" width="100%">
      <tr>',"\n";
            if ($scroll_up) {
                echo '      <td align="center" width="1%">
                     <a class="font2" href="message.php?id=',urlencode($id),
                     '&amp;mailbox=',$mailbox,'&amp;scroll_uid=',
                     $sort_info[2][$scroll_up],'&amp;uid=',$real_uid,
                     '">&uarr;</a>';
            }
            else {
                echo "      <td>\n";
            }
            echo '      </td>',"\n";
            hm_start_message_listing($mailbox);
            echo '   </tr>',"\n";
            foreach ($uid_slice as $uid) {
                $uid_current = false;
                if ($real_uid == $uid) {
                    $uid_current = true;
                }
                hm_print_row($uid_headers[$uid], false, false, $mailbox, 
                             $id, $uid, $sort_info, true, false, false, 
                             false, $uid_current, array(), false, true);
            }
            echo '
      <tr>',"\n";
            if ($scroll_down) {
                echo '      <td align="center">
                     <a class="font2" href="message.php?id=',urlencode($id),
                     '&amp;mailbox=',$mailbox,'&amp;scroll_uid=',
                     $sort_info[2][$scroll_down],'&amp;uid=',$real_uid,
                     '">&darr;</a>';
            }
            else {
                echo "       <td>\n";
            }
            echo '      </td>
      <td align="center" colspan="5">
      <small>
      <b>&nbsp;&nbsp; ',$str[19],' ',$str[18],' ',($start_pos + 1),'-',
      ($start_pos + $amount),' (',$sort_info[0],')</b>
      &nbsp;&nbsp;&nbsp;<a class="font2" href="message.php?mailbox=',$mailbox,
      '&amp;id=',urlencode($id),'&amp;uid=',$real_uid,'&amp;hide_folder_preview=1">
      (',$str[130],')</a>
      </small>
      </td>
      </tr>
      </table>';
        }
    }
}
?>
