<?php

/* imap.php: core IMAP functions :) 
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: imap.php,v 1.253.2.1 2004/05/06 15:39:56 sailfrog Exp $
*/

/**
 *  get IMAP capability response
 *
 *  @param  $imap_stream    resource    connection to the imap server
 *  @return                 string      the imap CAPABILITY response or an error string
 *
 */
function hm_get_caps($imap_stream) {
    $str = $_SESSION['str'];
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $result = array();
    $command = "$pre CAPABILITY\r\n";
    $n = -1;
    $caps_string = $str[200];
    fputs($imap_stream, $command);
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        if (stristr($result[$n], '* CAPABILITY')) {
            $caps_string = $result[$n];
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    return $caps_string;
}

/**
 *  login to imap
 *
 *  @param  $user       string          imap username
 *  @param  $encpass    string          encrypted password
 *  @param  $config     array           configuration values
 *  @param  $hasty_key  string          The encryption key
 *  @param  $response   boolean         if true, puts the login string in the session
 *  @return             resource|false  the imap connection on success 
 *
 */    
function hm_imap_login ($user, $encpass, $config, $hasty_key, $response=false, 
                        $debug=false) {

    // add some debug and checks for these config options
    $server = $config['imap_server'];
    $port = $config['imap_port'];
    $ssl = $config['imap_ssl'];

    $result = array();
    $pass = hmw_crypt($encpass, $config, 'decrypt', $hasty_key);
    if (!$pass && $debug) {
        echo '<font color="blue">Could not get the encrypted password.</font><br>',
             'Make sure the encryption key is setup as described in',
             'the INSTALL file<br>';
    }
    if ($ssl == 'ssl') {
        $server = 'ssl://'.$server;
    }
    if ($ssl == 'tls') {
        $server = 'tls://'.$server;
    }
    if ($debug) {
        echo 'trying to connect to the IMAP server at this address:<font color="blue"> ',
              $server,'</font><br>';
        if ($ssl == 'ssl' || $ssl == 'tls') {
            echo 'connecting over ',$ssl,' to port # <font color="blue">',$port,
                 '</font><br>';
        }
        else {
            echo 'connection on a normal socket on port # <font color="blue">',$port,
                 '</font><br>';
        } 
    }
    if ($is = @fsockopen($server, $port, $errorno, $errorstr, 30)) {
        if (is_resource($is)) {
            if ($debug) {
                echo '<b>successfully opened socket to imap server</b><br>';
            }
            $result[0] = fgets($is, 1024);
            fputs($is, 'A0001 LOGIN "'.$user.'" "'.$pass."\"\r\n");
            $n = 0;
            do {
                $n++;
                $result[$n] = fgets($is, 1024);
            } while (substr($result[$n], 0, 5) != 'A0001');
            if (stristr($result[$n], 'A0001 OK')) {
                if ($response) {
                    $_SESSION['login_string'] = $result[0];
                }
                $_SESSION['counter'] = 1;
                if ($debug) {
                    echo '<br><br><br><center>',
                         '<br>You have successfully logged into the IMAP server!<br>
                          <b>You can now disable the login_debug in hastymail.conf</b>',
                         '</center>';
                    exit;
                }
                return $is;
            }
            else {
                if ($debug) {
                    echo 'The imap server did not like us, it said: <font color="blue">',
                         $result[$n],'</font><br>';
                    exit;
                }
                return false;
            }
        }
        else {
            if ($debug) {
                echo 'could not connect to the imap server: <font color="blue">',
                      '<br>Error number:',$errorno,
                      '<br>Error name:',$errorstr,'</font><br>';
                exit;
            }
            return false;
        }
    }
    else {
        if ($debug) {
            echo 'could not connect to the imap server: <font color="blue">',
                  $errorno, $errorstr,'</font><br>';
            exit;
        }
        return false;
    }
}

/**
 *  select a mailbox
 *
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $mailbox        string      the mailbox to select
 *  @return                 void
 *
 */
function hm_select_mailbox ($imap_stream, $mailbox, $die=false) {
    $_SESSION['counter']++;
    $str = $_SESSION['str'];
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $command = "$pre SELECT \"".urldecode($mailbox)."\"\r\n";
    fputs($imap_stream, $command);
    $n = -1;
    $total = false;
    $uidv  = false;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        $parts = hm_line_parse($result[$n]);
        $count = count($parts);
        for ($i=0;$i<$count;$i++) {
            if (stristr($parts[$i], 'EXISTS') && isset($parts[$i - 1]) &&
                is_numeric($parts[$i - 1])) {
                $total = $parts[$i - 1];
            }
            if (stristr($parts[$i], 'UIDVALIDITY') && isset($parts[$i + 1]) &&
                is_numeric($parts[$i] + 1)) {
                $uidv = $parts[$i + 1];
            }
        }
    }
    while (substr($result[$n], 0, $pre_len) != $pre);
    if (!stristr($result[$n], "$pre OK")) {
        if ($die) {
            hm_check_errors($result[$n], "$pre OK", $command);
        }        
        $_SESSION['missing_folders_flag'] = 1;
        $_SESSION['missing_folders'][] = urldecode($mailbox);
        $mailbox = 'INBOX';
        hm_select_mailbox ($imap_stream, $mailbox, true);
    }
    if (isset($_SESSION['message_count'][$mailbox]) && $total &&
        $_SESSION['message_count'][$mailbox] != $total) {
        $_SESSION['changed'][$mailbox] = 1;
    }
    if (isset($_SESSION['valid'][$mailbox]) && $uidv &&
        $_SESSION['valid'][$mailbox] != $uidv) {
        $_SESSION['changed'][$mailbox] = 1;
    }
    $_SESSION['message_count'][$mailbox] = $total;
    $_SESSION['message_totals'][$mailbox] = $total;
    $_SESSION['valid'][$mailbox] = $uidv;
    return $mailbox;
}

/**
 *  get the unseen status for all selected mailboxes
 *
 *  @param  $imap_stream    resource    conneciton to imap
 *  @param  $folders        array       array of folder names
 *  @return                 array       keys are folders, values are unseen count
 *
 */
function hm_unseen_status ($imap_stream, $folders) {
    $n = 100;
    $k = 0;
    $unseen = array();
    $uidnext = array();
    $valid = array();
    $count = array();
    $ans = false;
    if (isset($_SESSION['settings']['new_mail_folders'])) {
        $folders = $_SESSION['settings']['new_mail_folders'];
    }
    else {
        $folders = array_diff($_SESSION['folders'], $_SESSION['nosel_folders']);
    }
    if (!in_array('INBOX', $folders)) {
        array_unshift($folders, 'INBOX');
    }
    foreach ($folders as $folder) {
        $_SESSION['counter']++;
        $pre = 'A000'.$_SESSION['counter'];
        $pre_len = strlen($pre);
        $command = "$pre STATUS \"".trim($folder).
                   "\" (UNSEEN MESSAGES UIDVALIDITY UIDNEXT)\r\n";
        fputs($imap_stream, $command);
        $l = -1;
        do {
            $l++;
            $result[$l] = fgets($imap_stream, 1024);
            if (strtolower(substr($result[$l], 0, 8)) == '* status' ||
                substr($result[$l], 0, strlen($folder)) == $folder) {
                $line = rtrim(ltrim(strstr($result[$l], '('), '('), ")\r\n");
                while (strlen($line) > 0) {
                    $token = strtolower(substr($line, 0, 4));
                    switch ($token) {
                        case 'mess':
                            $line = substr($line, 9);
                            $count[$folder] = 
                                substr($line, 0, strspn($line, "0123456789"));
                            $line = ltrim(substr($line, strlen($count[$folder])));
                            break;
                        case 'uidn':
                             $line = substr($line, 8);
                             $uidnext[$folder] =
                                 substr($line, 0, strspn($line, "0123456789"));
                             $line = ltrim(substr($line, strlen($uidnext[$folder])));
                             break;
                         case 'uidv':
                             $line = substr($line, 12);
                             $valid[$folder] =
                                 substr($line, 0, strspn($line, "0123456789"));
                             $line = ltrim(substr($line, strlen($valid[$folder])));
                             break;
                        case 'unse':
                            $line = substr($line, 7);
                            $unseen[$folder] = 
                                substr($line, 0, strspn($line, "0123456789"));
                            $line = ltrim(substr($line, strlen($unseen[$folder])));
                            break;
                        default:
                            $line = ltrim(strstr(ltrim($line), ' '));
                            break;
                    }
                }
            }
        } while (substr($result[$l], 0, $pre_len) != $pre);
        if (!stristr($result[$l], "$pre OK")) {
            if (!isset($_SESSION['missing_folders'])) {
                $_SESSION['missing_folders'] = array();
            }
            if (!in_array($folder, $_SESSION['missing_folders'])) {
                $keys = array_keys($_SESSION['folders'], $folder);
                if (isset($keys[0])) {
                    $key = $keys[0];
                    unset($_SESSION['folders'][$key]);
                    unset($_SESSION['dsp_folders'][$folder]);
                    $_SESSION['missing_folders'][] = $folder;
                    $_SESSION['missing_folders_flag'] = 1;
                }
            }
            if (isset($unseen[$folder]) && isset($_SESSION['unseen'][$folder]) &&
                $unseen[$folder] != $_SESSION['unseen'][$folder]) {
                $_SESSION['changed'][$folder] = 1;
            }
            if (isset($count[$folder]) && isset($_SESSION['message_count'][$folder]) &&
                $count[$folder] != $_SESSION['message_count'][$folder]) {
                $_SESSION['changed'][$folder] = 1;
            }
            if (isset($_SESSION['uidnext'][$folder]) && isset($uidnext[$folder]) &&
                $_SESSION['uidnext'][$folder] !== $uidnext[$folder]) {
                $_SESSION['changed'][$folder] = 1;
            }
            if (isset($_SESSION['valid'][$folder]) && isset($valid[$folder]) &&
                $_SESSION['valid'][$folder] !== $valid[$folder]) {
                $_SESSION['changed'][$folder] = 1;
           }
        }
        $n++;
        $k++;
    }
    $_SESSION['valid'] = $valid;
    $_SESSION['uidnext'] = $uidnext;
    $_SESSION['unseen'] = $unseen;
    $_SESSION['message_totals'] = $count;
    return $unseen;
}

/**
 *  terminates the imap connection
 *
 *  @param      $imap_stream    resource    conneciton to imap
 *  @return                     void
 *
 */
function hm_imap_logout ($imap_stream) {
    $command = "A1000 LOGOUT\r\n";
    fputs($imap_stream, $command);
    $result = fgets($imap_stream, 1024);
}

/**
 *  parse one line returned from imap (incomplete, does not handle literals)
 *  
 *  @param      $line               string      response from imap
 *  @param      $index              int         current response number
 *  @param      $full_response      array       the entire imap response
 *  @return                         array       line broken up into parts
 *
 */
function hm_line_parse($line, $index=false, $full_response=false) {
    $result = array();
    $quoted_string = "\"[^\"\\\]*(?:\\\.[^\"\\\]*)*\""; 
    $word          = "\S+";
    $int           = "\d+";
    $i = 0;
    while (strlen($line) > 0) {
        if (preg_match("/^($quoted_string|$int|$word|\*)/", $line, $matches)) {
            if (substr($matches[1], 0, 1) == '"' && substr($matches[1], -1) == '"') {
                $matches[1] = substr($matches[1], 1, -1);
            }
            $result[] = $matches[1];
            $line = substr($line, strlen($matches[0]));    
        }
        else {
            $line = substr($line, 1);
        }
    }
    return $result;
}
?>
