<?php

/* imap_2.php: More IMAP functions
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: imap_2.php,v 1.53 2004/04/05 23:13:46 sailfrog Exp $
*/

/**
 *  Get requested folder lists
 *
 *  @param  $imap_stream    resource    connection to the imap server
 *  @param  $hidden         boolean     if true returns hastymails hidden folders
 *  @param  $type           string      folder type: selectable, all, or can_have_kids
 *  @return                 array       where each element is one folder
 *
*/
function hm_boxlist ($imap_stream, $hidden=true, $type='all') {
    $_SESSION['counter']++;
    $_SESSION['nosel_folders'] = array(); 
    $list = array();
    $hidden_list = array();
    if (isset($_SESSION['settings']['hidden'])) {
        $hidden_list = $_SESSION['settings']['hidden'];
    }
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $config = $_SESSION['config'];
    if (isset($config['prefix']) && $config['prefix'] == 'none') {
        $prefix = '';
    }
    elseif (isset($config['prefix'])) {
        $prefix = trim($config['prefix']);
    }
    else {
        $prefix = '';
    } 
    $command = "$pre LIST \"\" \"$prefix*\"\r\n";
    $delim = false;
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
    } while (substr($result[$n], 0, $pre_len) != $pre);
    hm_check_errors($result[$n], "$pre OK", $command);
    array_pop($result);
    for ($i=0;$i<$n;$i++) {
        $flags = '';
        if (strtoupper(substr($result[$i], 0, 6)) != '* LIST') {
           continue;
        }
        $parts  = hm_line_parse($result[$i], false, false);
        $count  = count($parts);
        $folder = $parts[$count - 1];
        if (preg_match("/^\{(\d+)\}/", $folder, $matches)) {
            $size = $matches[1];
            $i++;
            $folder = substr($result[$i], 0, $size);
        }
        
        $delim  = $parts[$count - 2];
        $flags  = join(' ', array_slice($parts, 2, -2));
        $hide   = false;
        if (in_array($folder, $hidden_list) && $hidden) {
            $hide = true;
        }
        if (!in_array($folder, $list) && $folder != $prefix && strtoupper($folder) != 'INBOX' &&
            !$hide) {
            if ($type == 'all') {
                $list[] = $folder;
            }
            elseif ($type == 'can_have_kids' && !stristr($flags, 'noinferiors')) {
                $list[] = $folder;
            }
            elseif ($type == 'selectable' && !stristr($flags, 'noselect')) {
                $list[] = $folder;
            }
        }
        if (stristr($flags, 'noselect')) {
            $_SESSION['nosel_folders'][] = $folder;
        }
    }
    sort($list);
    array_unshift($list, 'INBOX');
    $_SESSION['delimiter'] = $delim;
    return $list;
}

/**
 *  client side sorting fallback in case server side sort is unavailable.
 *
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $mailbox        string      the folder we are sorting
 *  @param  $sort_type      string      sort method
 *  @return                 array       sort information array
 *
*/
function &hm_client_side_sort($imap_stream, $mailbox, $sort_type) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $reverse = false;
    $sort_keys = array();
    $value = '';
    $cont = false;
    $command = "$pre UID FETCH 1:* ";
    switch ($sort_type) {
        case 'DATE':
            $command .= "BODY.PEEK[HEADER.FIELDS (DATE)]\r\n";
            $reverse = true;
            break;
        case 'R_DATE':
            $command .= "BODY.PEEK[HEADER.FIELDS (DATE)]\r\n";
            break;
        case 'SIZE':
            $command .= "RFC822.SIZE\r\n";
            break;
        case 'R_SIZE':
            $command .= "RFC822.SIZE\r\n";
            $reverse = true;
            break;
        case 'ARRIVAL':
            $command .= "INTERNALDATE\r\n";
            $reverse = true;
            break;
        case 'R_ARRIVAL':
            $command .= "INTERNALDATE\r\n";
            break;
        case 'FROM':
            $command .= "BODY.PEEK[HEADER.FIELDS (FROM)]\r\n";
            break;
        case 'R_FROM':
            $command .= "BODY.PEEK[HEADER.FIELDS (FROM)]\r\n";
            $reverse = true;
            break;
        case 'SUBJECT':
            $command .= "BODY.PEEK[HEADER.FIELDS (SUBJECT)]\r\n";
            break;
        case 'R_SUBJECT':
            $command .= "BODY.PEEK[HEADER.FIELDS (SUBJECT)]\r\n";
            $reverse = true;
            break;
        default:
            $command .= "INTERNALDATE\r\n";
            $reverse = true;
            break;
    }
    fputs($imap_stream, $command);
    $n = -1;
    do {
        if (!$cont) {
            $uid = false;
        }
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        if (substr($result[$n], 0, 1) == '*' || $cont) {
            if ($cont) {
                $cont = false;
                $line = trim($result[$n], " \r\n)");
            }
            else {
                $line = ltrim(strstr($result[$n], '('), '(');
            }
            while (strlen($line) > 0) {
                switch (strtoupper(substr($line, 0, 4))) {
                    case 'UID ':
                        $line = substr($line, 4);
                        $uid = substr($line, 0, strspn($line, "0123456789"));
                        $line = ltrim(substr($line, strlen($uid)));
                        break;
                    case 'RFC8':
                        $line = substr($line, 12);
                        $value = substr($line, 0, strspn($line, "0123456789"));
                        $line = ltrim(substr($line, strlen($value)));
                        break;
                    case 'INTE':
                        $line = substr($line, 13);
                        $line = ltrim($line, '" ');
                        $value = strtotime(substr($line, 0, strcspn($line, '"')));
                        $line = ltrim(substr($line, (strlen($value) + 1)));
                        break;
                    case 'BODY':
                        $len = trim(strstr($line, '{'),"{}\r\n");
                        $len_count = 0;
                        $line = '';
                        do {
                            $n++;
                            $result[$n] = fgets($imap_stream, 1024);
                            $len_count += strlen($result[$n]);
                            if (strtoupper(substr($result[$n], 0, 1)) == 'D') {
                                $value = strtotime(substr($result[$n], 5));
                            }
                            if (strtoupper(substr($result[$n], 0, 1)) == 'S') {
                                $value = strtolower(substr($result[$n], 8));
                            }
                            if (strtoupper(substr($result[$n], 0, 1)) == 'F') {
                                $value = strtolower(str_replace(array('<', '"', ' '), '',
                                         substr($result[$n], 5)));
                                
                            }
                            if ($len) {
                                if ($len == $len_count) {
                                    $cont = true;
                                    break;
                                }
                            } 
                        } while (trim($result[$n]) != ')');
                       break; 
                    default:
                        $line = ltrim(strstr(ltrim($line), ' '));
                        break;
                }
            }
        }
        if (!$cont) {
            if ($uid) {
                $sort_keys[$uid] = $value;
            }
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    asort($sort_keys);
    hm_check_errors($result[$n], "$pre OK", $command);
    $sorted_array = array();
    foreach ($sort_keys as $key => $value) {
        $sorted_array[] = $key;
    }
    if ($reverse) {
        $sorted_array = array_reverse($sorted_array);
    }
    if (isset($_SESSION['settings']['page_count']) && 
        $_SESSION['settings']['page_count'] > 0) {
        $page_count = $_SESSION['settings']['page_count'];
    }
    else {
        $page_count = 20;
    }
    if (!empty($sorted_array)) {
        $sorted_array[0] = trim($sorted_array[0]);
        $total = count($sorted_array);
        $sorted_array[$total-1] = trim($sorted_array[$total-1]);
        for ($i=0;$i<=$total;) {
            $sorted_page = array_slice($sorted_array, $i, $page_count);
            if (!empty($sorted_page)) {
                $last = count($sorted_page) -1;
                $sorted_page[$last] = trim($sorted_page[$last]);
                $page_arrays[] = array(($i+1), ($i + (count($sorted_page))), 
                                                              $sorted_page);
            }
            $i += $page_count;
        }
        $response[0] = $total;
        $response[1] = $page_arrays;
        $response[2] = $sorted_array;
        $response[3] = array();
        $_SESSION['sort_data'][$mailbox] = $response;
        return $response;
    }
    else {
        $_SESSION['sort_data'][$mailbox] = '';
        return '';
    }
}

/**
 *  get sort order information for currently selected mailbox 
 *
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $sort_type      string      the selected sort method
 *  @param  $mailbox        string      the mailbox to get sort information for
 *  @param  $quick          boolean     shortcut to speed up the thread view page
 *  @return                 array       sort information array
 *
 */
function &hm_get_sort_info($imap_stream, $sort_type, $mailbox, $quick=false) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $parents = array();
    if (substr($sort_type, 0, 2) == 'R_') {
        $sort = substr($sort_type, 2);
        $reverse = true;
    }
    else {
        $sort = $sort_type;
        $reverse = false;
    }
    if ($sort_type == 'THREAD_R' || $sort_type == 'THREAD_O') {
        if (substr($sort_type, 7) == 'R') {
            $method = 'REFERENCES';
        }
        else {
            $method = 'ORDEREDSUBJECT';
        }
        $command = "$pre UID THREAD $method US-ASCII ALL\r\n";
    }
    else {
        $command = "$pre UID SORT ($sort) US-ASCII ALL\r\n";
    }
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 4096);
        while (!strpos($result[$n], "\n", (strlen($result[$n])-1))) {
            $result[$n] .= fgets($imap_stream, 4096);
        }
        if (stristr($result[0], '[PARSE]')) {
            $n--;
            $result[$n] = '';
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);

    if (!strstr($result[$n], "$pre OK")) {
        $sort_info = hm_client_side_sort($imap_stream, $mailbox, $sort_type);
        $_SESSION['config']['client_sort'] = 'true';
        return $sort_info;
    }

    if ($n >= 3) {
        array_pop($result);
        $result = implode('', $result);
    }
    else {
        $result = $result[0];
    }
    if (trim($result) == '* SORT' || trim($result) == '* THREAD') {
        $result = '';
        $_SESSION['sort_data'][$mailbox] = $result;
        return $result;
    }
    else {
        if (substr($sort_type, 0, 6) == 'THREAD') {
            $string = trim(str_replace(' (', '(', substr($result, 9)));
            $len = strlen($string);
            $uids = array();
            $thread = array();
            $base = array();
            $thread_data = array();
            $level = 1;
            $z = 0;
            $start = true;
            for ($i=0;$i<$len;$i++) {
                switch($string{$i}) {
                    case '(':
                        $z++;
                        $base[$z] = $level;
                        if ($i > 0) {
                            if ($string{$i-1} != '(') {
                                $level++;
                            }
                        }
                        else {
                            $level++;   
                        }
                        break;
                    case ')':
                        $level = $base[$z];
                        $z--;
                        break;
                    case ' ':
                        $level++;
                        break;
                    default:
                        $k = 0;
                        $uid = '';
                        if ($start) {
                            $break_point = $level - 1;
                            $start = false;
                        }
                        while (is_numeric($string{$i+$k})) {
                            $uid .= $string{$i+$k};
                            $k++;
                        }
                        $thread[] = $uid;
                        $parents[$uid] = $level - ($break_point);
                        $i += ($k - 1);
                        break;
                }
                if (isset($break_point) && $level == $break_point) {
                    if ($quick && in_array($quick, $thread)) {
                        $thread_data = $thread;
                        break;
                    }
                    $uids = array_merge($uids, array_reverse($thread));
                    $thread = array();
                }
            }
            $sorted_array = array_reverse($uids);
        }
        else {
            $sorted_array = preg_split('/ /', $result);
            array_shift($sorted_array);
            array_shift($sorted_array);
        }
        if (!$quick) {
            switch ($sort) {
                case 'ARRIVAL':
                    if (!$reverse) { 
                        $sorted_array = array_reverse($sorted_array);
                    }
                    break;
                case 'DATE':
                    if (!$reverse) {
                        $sorted_array = array_reverse($sorted_array);
                    }
                    break;
                default:
                    if ($reverse) {
                        $sorted_array = array_reverse($sorted_array);
                    }
                    break;
            }
            if (isset($_SESSION['settings']['page_count']) && 
                $_SESSION['settings']['page_count'] > 0) {
                $page_count = $_SESSION['settings']['page_count'];
            }
            else {
                $page_count = 20;
            }
            $sorted_array[0] = trim($sorted_array[0]);
            $total = count($sorted_array);
            $sorted_array[$total-1] = trim($sorted_array[$total-1]);
            for ($i=0;$i<=$total;) {
                $sorted_page = array_slice($sorted_array, $i, $page_count);
                if (!empty($sorted_page)) {
                    $last = count($sorted_page) -1;
                    $sorted_page[$last] = trim($sorted_page[$last]);
                    $page_arrays[] = array(($i+1), ($i + (count($sorted_page))), 
                                                                  $sorted_page);
                }
                $i += $page_count;
            }
            $response[0] = $total;
            $response[1] = $page_arrays;
            $response[2] = $sorted_array;
            $response[3] = $parents;
            $_SESSION['sort_data'][$mailbox] = $response;
        }
        else {
            $response[0] = $parents;
            $response[1] = $thread_data;
            $_SESSION['thread_data'][$mailbox][$response[1][0]] = $response;
        }
        return $response;
    }
}

/**
 *  get the structure of a message
 *
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $uid            int         message uid
 *  @return                 array       an array that represents the mime structure
 *
 */
function hm_get_struct ($imap_stream, $uid) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $command = "$pre UID FETCH $uid BODYSTRUCTURE\r\n";
    $line = '';
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        while (!strpos($result[$n], "\n", (strlen($result[$n])-1))) {
            $result[$n] .= fgets($imap_stream, 1024);
        }
        if (substr($result[$n], 0, 1) == '*') {
            $line = ltrim(substr(stristr($result[$n], 'bodystructure'), 13));
        }
        elseif (substr(rtrim($line), -1) == '}') {
            $line = rtrim($line, "\n\r{}0123456789");
            $line .= $result[$n];
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    hm_check_errors($result[$n], "$pre OK", $command, true);
    $struct = hm_parse_bodystructure($line);
    return $struct;
}

/**
 *  return any part of a message
 *
 *  @param  $imap_stream    resource        connection to imap
 *  @param  $uid            int             message uid
 *  @param  $part           float           message part number, false for all parts
 *  @param  $cutoff         boolean         flag to cutoff reading LARGE messages
 *  @return                 string          the message part contents
 *
 */
function &hm_get_message_part ($imap_stream, $uid, $part=false, $cutoff=false) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $body = '';
    if ($part) {
        if ($part == 'raw') {
            $command = "$pre UID FETCH $uid BODY[]\r\n";
            $rpart = '';
        }
        else {          
            $command = "$pre UID FETCH $uid BODY[$part]\r\n";
            $rpart = $part;
        }
        fputs($imap_stream, $command);
        $total_size = 0;
        do {
            $result_line = fgets($imap_stream, 1024);
            while (!strpos($result_line, "\n", (strlen($result_line)-1))) {
                $result_line .= fgets($imap_stream, 1024);
            }
            if (substr($result_line, 0, 1) == '*') {
                if ($line = stristr($result_line, "BODY[$rpart]")) {
                    $last = substr(rtrim($line), (strlen(rtrim($line)) - 1));
                    if ($last == '}') {
                        $len = trim(strstr($line, '{'),"{}\r\n");
                        if ($len == 0) {
                            $body = '';
                        }
                        else {
                            $len_count = 0;
                            do {
                                $body_tmp = fgets($imap_stream, 1024);
                                while (!strpos($body_tmp, "\n", (strlen($body_tmp)-1))) {
                                    $body_tmp .= fgets($imap_stream, 1024);
                                }
                                $total_size += strlen($body_tmp);
                                $result_line = $body_tmp;
                                $body .= rtrim($body_tmp, "\r\n")."\n";
                                $len_count += strlen($body_tmp);
                                if ($len == $len_count || $len_count > $len) {
                                    if ($len_count > $len) {
                                        $diff = (($len_count - $len) - 1);
                                        $body = substr($body, 0, -$diff);
                                    }
                                    break;
                                }
                                if ($cutoff && $total_size > 101000) {
                                    $_SESSION['cutoff'] = 1;
                                    break;
                                }                                
                            } while (substr($body_tmp, 0, $pre_len) != $pre);
                        }
                    }
                    elseif ($last = '"') {
                        $line = rtrim($line);
                        $body = ltrim(strstr(preg_replace('/"\)$/', '', $line), '"'), '"').
                                "\n";
                    }
                    else {
                        $body = rtrim(ltrim(strstr($line, ']'), ']'))."\n";
                    }
                }
            } 
        } while (substr($result_line, 0, $pre_len) != $pre);
        hm_check_errors($result_line, "$pre OK", $command, true);
        unset($result_line);
        return $body;
    }
}

/**
 *  perform the requested action on the messages
 *
 *  @param  $imap_stream    resource        connection to imap
 *  @param  $uid            string|array    uid(s) to perform actions on
 *  @param  $action         string          the type of action to perform.
 *  @param  $mailbox        string          destination mailbox if required
 *  @param  $large          boolean         flag indicating more than 1k messages
 *  @return                 boolean|string  false on success or the imap error on failure
 *
*/
function hm_imap_action ($imap_stream, $uid, $action, $mailbox=false, $large=false) {
    $return = false;
    $imap_string = '';
    $uid_array = array();
    if ($large) {
        $page_count = count($_SESSION['sort_data'][$large][1][0][2]);
        $m = intval(1000/$page_count);
        $l = 0;
        $n = 0;
        foreach($_SESSION['sort_data'][$large][1] as $array) {
            if ($n == 0) {
                $uid_array[$l] = trim(implode(',', $array[2]), ',');
                $n++;
            }
            elseif ($n < $m) {
                $uid_array[$l] .= ','.trim(implode(',', $array[2]), ',');
                $n++;
            }
            else {
                $l++;
                $uid_array[$l] = trim(implode(',', $array[2]), ',');
                $n = 1;
            }
        }
    }
    else {
        $uid_array[] = rtrim($uid, ',');
    }
    $i = 0;
    foreach ($uid_array as $uid_string) {
        switch ($action) {
            case 'COPY':
                $imap_string = " UID COPY $uid_string \"".
                               stripslashes(urldecode($mailbox))."\"\r\n";
                break;
            case 'READ':
                $imap_string = " UID STORE $uid_string +FLAGS (\Seen)\r\n";
                break;
            case 'ANSWERED':
                $imap_string = " UID STORE $uid_string +FLAGS (\Answered)\r\n";
                break;
            case 'UNREAD':
                $imap_string = " UID STORE $uid_string -FLAGS (\Seen)\r\n";
                break;
            case 'DELETE':
                $imap_string = " UID STORE $uid_string +FLAGS (\Deleted)\r\n";
                break;
            case 'MOVE':
                break;
            case 'EXPUNGE':
                $imap_string = " EXPUNGE\r\n";
                break;
            default:
                break;
        }
        $result = array();
        $_SESSION['counter']++;
        $pre = 'A000'.$_SESSION['counter'];
        $pre_len = strlen($pre);
        if ($uid_string != '' && $imap_string != '') {
            fputs($imap_stream, $pre.$imap_string);
            $result[0] = fgets($imap_stream, 1024);
            $n = 1;
            while (!strstr($result[$n-1], $pre)) {
                $result[$n] = fgets($imap_stream, 1024);
                $n++;
            }
            if (!preg_match("/^$pre OK/i", $result[$n-1])) {
                $return = preg_replace("/^(NO|BAD)/i", '', 
                substr($result[$n-1], ($pre_len + 1)));
                break;
            }    
        }
        $i++;
    }
    return $return;
}

/**
 *  get full message headers
 *
 *  @param  $imap_stream    resource        connection to imap
 *  @param  $uid            int             the message uid
 *  @param  $part           float           false for default headers, float for rfc part
 *  @return                 array
 *
 */
function hm_get_full_header($imap_stream, $uid, $part=false, $raw=false) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    if (!$part) {
        $command = "$pre UID FETCH $uid BODY[HEADER]\r\n";
    }
    else {
        $command = "$pre UID FETCH $uid BODY[$part.HEADER]\r\n";
    }
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $line = fgets($imap_stream, 1024);
        if (preg_match("/^(\s\t)/", $line)) {
            $result[$n-1] .= $line;
        }
        else {
            $n++;
            $result[$n] = $line;
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    hm_check_errors($result[$n], "$pre OK", $command, true);
    $raw_headers = array_slice($result, 1, (count($result)-3));
    if ($raw) {
        return implode("", $raw_headers);
    }
    else {
        $headers = hm_parse_header($raw_headers);
        return $headers;
    }
}

/**
 *  get the headers for the current page
 *
 *  @param  $sorted_string  string      comma seperated list of uids
 *  @param  $imap_stream    resource    conneciton to imap
 *  @return                 array       header values in a complex array
 *
 */
function &hm_get_messages ($sorted_string, $imap_stream) {
    $_SESSION['counter']++;
    $str = $_SESSION['str'];
    if (isset($_SESSION['settings']['date_string'])) {
        $date_string = $_SESSION['settings']['date_string'];
    }
    else {
        $date_string = 'g:i a, M j, y';
    }
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $cont = false;
    $headers = array();
    $result = array();
    $return = array();
    $command = "$pre UID FETCH ".$sorted_string.
               " (FLAGS INTERNALDATE RFC822.SIZE BODY.PEEK[HEADER.FIELDS (SUBJECT FROM ".
               "DATE CONTENT-TYPE X-PRIORITY TO)])\r\n";
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        if (substr($result[$n], 0, 1) == '*' || $cont) {
            if ($cont) {
                $cont = false;
                $line = trim($result[$n], " \r\n)");
            }
            else {
                $line = ltrim(strstr($result[$n], '('), '(');
                $headers = array (
                    0 =>  $str[229],     /* subject       */
                    1 =>  $str[230],     /* from          */
                    2 =>  $str[231],     /* date          */
                    3 =>  3,             /* priority      */
                    4 =>  '',            /* content-type  */
                    5 =>  '',            /* flags         */
                    6 =>  $str[232],     /* to            */
                    7 =>  0,             /* size          */
                    8 => 0);             /* internal date */
            }
            while (strlen($line) > 0) {
                switch (strtoupper(substr($line, 0, 4))) {
                    case 'UID ':
                        $line = substr($line, 4);
                        $uid = substr($line, 0, strspn($line, "0123456789"));
                        $line = ltrim(substr($line, strlen($uid)));
                        break;
                    case 'FLAG':
                        $line = substr($line, 6);
                        $flag = substr($line, 0, (strcspn($line, ")") + 1));
                        $line = ltrim(substr($line, strlen($flag)));
                        $headers[5] = $flag;
                        break;
                    case 'RFC8':
                        $line = substr($line, 12);
                        $size = substr($line, 0, strspn($line, "0123456789"));
                        $line = ltrim(substr($line, strlen($size)));
                        $headers[7] = $size;
                        break;
                    case 'INTE':
                        $line = substr($line, 13);
                        $line = ltrim($line, '" ');
                        $idate = strtotime(substr($line, 0, strcspn($line, '"')));
                        $line = ltrim(substr($line, (strcspn($line, '"') + 1)));
                        $headers[8] = $idate;
                        break;
                    case 'BODY':
                        $len = trim(strstr($line, '{'),"{}\r\n");
                        $len_count = 0;
                        $line = '';
                        $pos = '';
                        do {
                            $n++;
                            $result[$n] = fgets($imap_stream, 1024);
                            $len_count += strlen($result[$n]);
                            switch (strtoupper(substr($result[$n], 0, 1))) {
                                case 'T':
                                    $headers[6] = hm_decode_field(
                                                    substr($result[$n], 3));
                                    $pos = 'T';
                                    break;
                                case 'S':
                                    $headers[0] = hm_decode_field(
                                                    substr($result[$n], 8));
                                    $pos = 'S';
                                    break;
                                case 'F':
                                    $headers[1] = hm_decode_field(
                                                    substr($result[$n], 5));
                                    $pos = 'F';
                                    break;
                                case 'D':
                                    $headers[2] = 
                                    @date($date_string,
                                    strtotime(substr($result[$n], 5)));
                                    break;
                                    $pos = '';
                                case 'X':
                                    $headers[3] = substr($result[$n], 11);
                                    $pos = '';
                                    break;
                                case 'C':
                                    $headers[4] = substr($result[$n], 13);
                                    $pos = 'C';
                                    break;
                                case "\t":
                                case ' ':
                                    switch ($pos) {
                                        case 'T':
                                            $headers[6] .= hm_decode_field($result[$n]);
                                            break;
                                        case 'S':
                                            $headers[0] .= hm_decode_field($result[$n]);
                                            break;
                                        case 'F':
                                            $headers[1] .= hm_decode_field($result[$n]);
                                            break;
                                        case 'C':
                                            $headers[4] .= $result[$n];
                                            break;
                                        default:
                                            break;
                                    } 
                                    break;
                                default:
                                    break;
                            }
                            if ($len) {
                                if ($len == $len_count) {
                                    $cont = true;
                                    break;
                                }
                            } 
                        } while (trim($result[$n]) != ')');
                       break; 
                    default:
                        echo $result[$n];
                        exit;
                }
            }
        }
        if (!$cont) {
            if (!empty($headers)) {
                $return[$uid] = $headers;
            }
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    return $return; 
}

/**
 *  search function for the mailbox
 *
 *  @param  $imap_stream    resource    the connection to IMAP
 *  @param  $command        string      the search command to send to IMAP
 *  @param  $search_terms   string      the string to search for
 *  @return                 string      a string of uids that match
 *
 */
function hm_search_mailbox($imap_stream, $command, $search_terms=false) {
    $uids = '';
    $config=$_SESSION['config'];
    $_SESSION['counter']++;
    $str = $_SESSION['str'];
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    if ($search_terms) {
        $len = strlen($search_terms);
        if (isset($config['simple_search']) && $config['simple_search'] == 'true') {
            $search_terms = addslashes($search_terms);
            $command = "$pre UID ".$command.' "'.$search_terms."\"\r\n";
        }
        else {
            $command = "$pre UID ".$command.' {'.$len.'}'."\r\n";
        }
        $uids = '';
        fputs($imap_stream, $command);
        if (!isset($config['simple_search']) || $config['simple_search'] != 'true') {
            $result[0] = fgets($imap_stream, 1024);
            if (preg_match("/^$pre (NO|BAD)/", $result[0])) {
                $_SESSION['notices'][] = $str[199].":<br>\n".$result[0];
                return;
            }
            fputs($imap_stream, $search_terms."\r\n");
        }
    }
    else {
        $command = "$pre UID ".rtrim($command)."\r\n";
        fputs($imap_stream, $command);
    }
    $n = -1;
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
        if (preg_match("/\^* SEARCH ([\d\s]+)/", $result[$n], $regs)) {
            $uids .= $regs[1];
        }
        elseif (strspn($result[$n], '0123456789 ') == strlen(trim($result[$n]))) {
            $uids .= $result[$n];
        }
    } while (substr($result[$n], 0, $pre_len) != $pre);
    hm_check_errors($result[$n], "$pre OK", $command);
    return $uids;
}

/**
 *  Get the message flags for one message
 *
 *  @param      $imap_stream    resource    connection to the imap server
 *  @param      $uid            int         message uid to get flags for
 *  @return                     string      imap message flags
 *
 */
function hm_get_flags($imap_stream, $uid) {
    $str = $_SESSION['str'];
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $result = array();
    $command = "$pre UID FETCH $uid FLAGS\r\n";
    $n = -1;
    $caps_string = $str[200];
    fputs($imap_stream, $command);
    do {
        $n++;
        $result[$n] = fgets($imap_stream, 1024);
    } while (substr($result[$n], 0, $pre_len) != $pre);
    if (isset($result[$n - 1])) {
        return ($result[$n - 1]);
    }
    else {
        return '';
    }
}

?>
