<?php

/* imap_3.php: More IMAP functions
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: imap_3.php,v 1.41 2004/04/21 21:18:56 sailfrog Exp $
*/

/**
 *  delete an imap folder
 *
 *  @param  $folder         string      folder to delete
 *  @param  $imap_stream    resource    conneciton to imap
 *  @param  $settings_dir   string      the location of the users settings file
 *  @return                 string      indicates if the operation was successful
 *
 */
function hm_delete_folder ($folder, $imap_stream, $settings_dir) {
    $str = $_SESSION['str'];
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $command = "$pre DELETE \"$folder\"\r\n";
    fputs($imap_stream, $command);
    $result = fgets($imap_stream, 1024);
    if (preg_match("/^$pre (NO|BAD)/", $result)) {
        $return = $str[201].":<br>".
                    $result."\n";
    }
    elseif (preg_match("/^$pre OK/", $result)) {
        $update_settings = false;
        if (isset($_SESSION['settings']['sort'][urlencode($folder)])) {
            unset($_SESSION['settings']['sort'][urlencode($folder)]);
            $update_settings = true;
        }
        if (isset($_SESSION['settings']['hidden']) && 
            is_array($_SESSION['settings']['hidden'])) {
            foreach($_SESSION['settings']['hidden'] as $index => $mailbox) {
                if ($mailbox == $folder) {
                    unset($_SESSION['settings']['hidden'][$index]); 
                    $update_settings = true;
                    break;
                }
            }
        }
        if ($update_settings) {
            hm_write_settings($_SESSION['user'], $settings_dir);
        }
        $return = $str[202];
    }
    else {
        $return = $str[203].":<br>".$result;
    }
    return $return;
}

/**
 *  rename an imap folder
 *
 *  @param  $old_folder     string      folder to rename
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $new_folder     string      new folder name
 *  @param  $settings_dir   string      location of the users settings file
 *  @return                 string      indicates if the operation was successful
 *
 */
function hm_rename_folder ($old_folder, $imap_stream, $new_folder, $settings_dir) {
    $str = $_SESSION['str'];
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $delim = $_SESSION['delimiter'];
    $prefix = strrev(strstr(strrev($old_folder), $delim));
    if ($delim == 'nil') {
        return $str[204]."<br>".$str[205];
    }
    else { 
        if ($prefix != '' && substr($prefix, -1) != $delim) {
            $prefix .= $delim;
        }
    }
    if (isset($_SESSION['config']['prefix']) &&
        $_SESSION['config']['prefix'] == 'none') {
        $command = "$pre RENAME \"$old_folder\" \"$new_folder\"\r\n";
    }
    else {
        $command = "$pre RENAME \"$old_folder\" \"$prefix$new_folder\"\r\n";
    }
    fputs($imap_stream, $command);
    $result = fgets($imap_stream, 1024);
    if (preg_match("/^$pre (NO|BAD)/", $result)) {
        $return = $str[242].":<br>".$result."\n";
    }
    elseif (preg_match("/^$pre OK/", $result)) {
        $update_settings = false;
        if (isset($_SESSION['settings']['sort'][urlencode($old_folder)])) {
            $_SESSION['settings']['sort'][urlencode($prefix.$new_folder)] =
            $_SESSION['settings']['sort'][urlencode($old_folder)];
            unset($_SESSION['settings']['sort'][urlencode($old_folder)]);
            $update_settings = true;
        }
        if (isset($_SESSION['settings']['hidden']) && 
            is_array($_SESSION['settings']['hidden'])) {
            foreach($_SESSION['settings']['hidden'] as $index => $mailbox) {
                if ($mailbox == $old_folder) {
                    unset($_SESSION['settings']['hidden'][$index]); 
                    $_SESSION['settings']['hidden'][$index] = $prefix.$new_folder;
                    $update_settings = true;
                    break;
                }
            }
        }
        if ($update_settings) {
            hm_write_settings($_SESSION['user'], $settings_dir);
        }
        $return = $str[241];
    }
    else {
        $return = $str[203].":<br>".$result."\n";
    }
    return $return;
}
    
    
/**
 *  create an imap folder
 *
 *  @param  $folder         string      folder name to create
 *  @param  $imap_stream    resource    conneciton to imap
 *  @param  $parent         string      the parent folder, otherwise false 
 *  @param  $allow_subs     boolean     true for folders that can have subfolders 
 *  @return                 string      indicating the result of the operation
 *
 */
function hm_create_folder ($folder, $imap_stream, $parent=false, $allow_subs=false) {
    $str = $_SESSION['str'];
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $delim = $_SESSION['delimiter'];
    $bail = false;
    if (isset($_SESSION['config']['prefix'])) {
        $prefix = $_SESSION['config']['prefix'];
    }
    if (!isset($prefix) || $prefix == '')  {
        $prefix = 'INBOX';
    }
    if ($parent && $parent != 'INBOX') {
        $prefix = $parent; 
    }
    if ($delim == 'nil') {
        $return = $str[204]."<br>".$str[205];
        $bail = true;
    }
    else { 
        if (substr($prefix, -1) != $delim) {
            $prefix .= $delim;
        }
    }
    if (stristr($folder, "$delim") || $folder == 'INBOX' || $folder == 'inbox') {
        $return = $str[206];
        $bail = true;
    }
    if ($allow_subs == 'yes') {
        $folder .= $delim;
    }
    if ($bail) {
        return $return;
    }
    else {
        if (isset($_SESSION['config']['prefix']) &&
            $_SESSION['config']['prefix'] == 'none') {
            $command = "$pre CREATE \"$folder\"\r\n";
        }
        else {
            $command = "$pre CREATE \"$prefix$folder\"\r\n";
        }
        fputs($imap_stream, $command);
        $result = fgets($imap_stream, 1024);
        if (preg_match("/^$pre (NO|BAD)/", $result)) {
            $return = $str[207].":<br>".$result."\n";
        }
        elseif (preg_match("/^$pre OK/", $result)) {
            $return = $str[208];
        }
        else {
            $return = $str[203].":<br>".$result."\n";
        }
        return $return;
    }
}

/**
 *  create special folders on first login
 *
 *  @param  $imap_stream    resource    connection to IMAP
 *  @param  $config         array       config vars from the hastymail.conf file
 *  @return                 void
 *
 */
function hm_autocreate_folders($imap_stream, $config) {
    if (isset($_SESSION['delimiter']) && $_SESSION['delimiter'] != 'nil') {
        $delim = $_SESSION['delimiter'];
        if (isset($config['prefix'])) {
            $prefix = $config['prefix'];
        }
        if (!isset($prefix) || $prefix == '')  {
            $prefix = 'INBOX';
        }
        if (substr($prefix, -1) != $delim) {
            $prefix .= $delim;
        }
        $special_folders = array ('sent', 'trash', 'drafts');
        foreach ($special_folders as $t) {
            $exists = false;
            $r = '';
            $nosel = false;
            if (isset($config['autocreate_'.$t]) && 
                $config['autocreate_'.$t] != '') {
                if (strtoupper($config['autocreate_'.$t]) == 'INBOX') {
                    $pre = '';
                }
                else {
                    $pre = $prefix;
                }
                if ($config['prefix'] == 'none') {
                    $pre = '';
                }
                if (in_array($pre.$config['autocreate_'.$t], $_SESSION['folders'])) {
                    $exists = true;
                }
                if (in_array($pre.$config['autocreate_'.$t],
                    $_SESSION['nosel_folders'])) {
                    $nosel = true;
                }
                if (!$exists && !$nosel) {
                    $r = hm_create_folder($config['autocreate_'.$t],$imap_stream);
                }
                if (strstr($r, $_SESSION['str'][208]) || ($exists && !$nosel)) {
                    $_SESSION['settings'][$t.'_folder'] = 
                        $pre.$config['autocreate_'.$t];
                }
            }
        }
        $_SESSION['folders'] = hm_boxlist($imap_stream, true, 'all');
    }
}


/**
 *  save sent or draft mail to folder
 *
 *  @param  $message        string      message text to save (including headers)
 *  @param  $imap_stream    resource    conneciton to imap
 *  @param  $type           string      draft or sent
 *  @param  $multi          boolean     flag indicating attachments
 *  @param  $bndry          string      mime boundary string
 *  @size   $size           int         string length for multipart messages
 *  @return                 void        
 *
 */
function hm_save_message ($message, $imap_stream, $type, $multi=false, 
                          $bndry=false, $size=false) {
    $str = $_SESSION['str'];
    if ($type == 'sent') {
        $folder = 'sent_folder';
    }
    elseif ($type == 'draft') {
        $folder = 'drafts_folder';
    }
    else {
        return;
    }
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    if (isset($_SESSION['settings'][$folder])) {
        if (!in_array(urldecode($_SESSION['settings'][$folder]), 
            $_SESSION['folders'])) {
            if ($type == 'sent') {
                $_SESSION['notices'][] = $str[28];
            }
            elseif ($type == 'draft') {
                $_SESSION['notices'][] = $str[209];
            }
                unset($_SESSION['settings'][$folder]);
                hm_write_settings($_SESSION['user'], $_SESSION['config']['settings_dir']);                      
                return;
        }
        if (!isset($_SESSION['settings'][$folder])) {
            return;
        }
        else {
            $message = trim($message);
            if ($type == 'sent') {
                $flags = '(\Seen)';
            }
            elseif ($type == 'draft') {
                $flags = '(\Draft \Seen)';
            }
            if ($multi) {
                $imap_size = $size;
            }
            else {
                $imap_size = strlen($message);
            }
            $command = "$pre APPEND \"".
                        urldecode($_SESSION['settings'][$folder]).'" '.$flags.' {'.
                       $imap_size."}\r\n";
            fputs($imap_stream, $command);
            $result[0] = fgets($imap_stream, 1024);
            
            if (preg_match("/^$pre (NO|BAD)/", $result[0])) {
                    $_SESSION['notices'][] = $str[210].":<br>\n".$result[0]."\n";
                    return;
            }
            if ($multi) {
                $size_result = hm_write_data($imap_stream, $message, $bndry);
                    if ($size != $size_result) {
                        /*$_SESSION['notices'][] = 'Could not save Sent message, we '.
                                'thought The message was<br>'.$size.' bytes but it '.
                                'ended up being '.$size_result;*/
                        return;
                    }
                fputs($imap_stream, "\r\n");
            }
            else { 
                fputs($imap_stream, $message."\r\n");
            }
            $result[1] = fgets($imap_stream, 1024);
            $i = 2;
            while (!strstr($result[$i-1], $pre)) {
                $result[$i] = fgets($imap_stream, 1024);
            }
            hm_check_errors($result[$i-1], "$pre OK", $command, true);
            if ($type == 'draft') {
                $_SESSION['notices'][] = $str[211];
            }
        }
    }
}

/**
 *  outputs a message part directly to the browser. ONLY called 
 *  from download.php for images display and message part downloading
 *
 *  @param  $imap_stream    resource        connection to imap
 *  @param  $uid            int             message uid
 *  @param  $part           float           message part number
 *  @param  $decode         string          type of decoding to perform
 *  @return                 void
 *
 */
function hm_output_message_part ($imap_stream, $uid, $part, $decode) {
    $_SESSION['counter']++;
    $pre = 'A000'.$_SESSION['counter'];
    $pre_len = strlen($pre);
    $command = "$pre UID FETCH $uid BODY[$part]\r\n";
    fputs($imap_stream, $command);
    $n = -1;
    do {
        $n++;
        $read_line = fgets($imap_stream, 1024);
        while (!strpos($read_line, "\n", (strlen($read_line) - 1))) {
            $read_line .= fgets($imap_stream, 1024);
        }
        if (substr($read_line, 0, 1) == '*') {
            if ($line = stristr($read_line, "BODY[$part]")) {
                $last = substr(rtrim($line), (strlen(rtrim($line)) - 1));
                if ($last == '}') {
                    $len = trim(strstr($line, '{'),"{}\r\n");
                    if ($len != 0) {
                        $len_count = 0;
                        $i = -1;
                        do {
                            $i++;
                            $n++;
                            $body_tmp = fgets($imap_stream, 1024);
                            while (!strpos($body_tmp, "\n", (strlen($body_tmp)-1))) {
                                $body_tmp .= fgets($imap_stream, 1024);
                            }
                            $read_line = $body_tmp;
                            if ($decode && $decode == 'base64') {
                                echo base64_decode(rtrim($body_tmp, "\r\n")."\n");
                            }
                            elseif ($decode && $decode == 'quoted-printable') {
                                $body_tmp = &hm_quoted_decode(rtrim($body_tmp, "\r\n")
                                            ."\n");
                                echo $body_tmp;
                            }
                            else {
                                echo rtrim($body_tmp, "\r\n")."\n";
                            }
                            $len_count += strlen($read_line);
                            if ($len == $len_count || $len_count > $len) {
                                if ($len_count > $len) {
                                    $diff = (($len_count - $len) - 1);
                                    $body_tmp = substr($body_tmp, 0, -$diff);
                                }
                                break;
                            }
                        } while (substr($body_tmp, 0, $pre_len) != $pre);
                    }
                }
                elseif ($last = '"') {
                    $line = rtrim($line);
                    if ($decode && $decode == 'base64') {
                        echo  base64_decode(ltrim(strstr(
                              preg_replace('/"\)$/', '', $line), '"'), '"')."\n");
                    }
                    elseif ($decode && $decode == 'quoted-printable') {
                        $line = &hm_quoted_decode(ltrim(strstr(
                              preg_replace('/"\)$/', '', $line), '"'), '"')."\n");
                        echo $line;
                    }
                    else {
                        echo  ltrim(strstr(preg_replace('/"\)$/', '', $line), '"'), '"').
                              "\n";
                    }
                }
                else {
                    if ($decode && $decode == 'base64') {
                        echo base64_decode(rtrim(ltrim(strstr($line, ']'), ']'))."\n");
                    }
                    elseif ($decode && $decode == 'quoted-printable') {
                        $line = &hm_quoted_decode(rtrim(ltrim(strstr($line, ']'), ']'))."\n");
                        echo $line;
                    }
                    else {
                        echo rtrim(ltrim(strstr($line, ']'), ']'))."\n";
                    }
                }
            }
        } 
    } while (substr($read_line, 0, $pre_len) != $pre);
}

?>
