<?php

/* session.php: Functions to maintain the session.
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: session.php,v 1.196.2.1 2004/05/06 15:39:56 sailfrog Exp $
*/

/**
 *  validates vars by type
 *
 *  @param      $_POST      array       the post array values
 *  @param      $_GET       array       the get array values
 *  @param      $page       string      the current page
 *  @return                 array       validated array values
 *
 */
function hm_validate_input($_POST, $_GET, $page) {
    $v_types = array (
    'mailbox' =>
                array ( 'submit_page' => 'string',  'next'            => 'int',
                        'prev'        => 'int',     'mailbox'         => 'folder', 
                        'page_num'    => 'int',     'selection_type'  => 'string',
                        'sort'        => 'string',  'destination'     => 'string', 
                        'page2'       => 'int',     'selection_type2' => 'string',
                        'sort2'       => 'string',  'destination2'    => 'string', 
                        'page_string' => 'string',  'uid_string'      => 'int',
                        'new'         => 'int',     'id'              => 'id',
                        'sort_type'   => 'string',  'Go'              => 'string',
                        'uid_delete'  => 'int',     'page'            => 'int',
                        'submit2'     => 'string',  'sort_type2'      => 'string',
                        'pass'        => 'string',  'user'            => 'string',
                        'uid_move'    => 'int',     'alt_server'      => 'int',
                        'login'       => 'string',  'toggle_all'      => 'string',
                        'uid'         => 'int',     'psubmit'         => 'string',
                        'nsubmit'     => 'string',  'copy'            => 'string',
                        'move'        => 'string',  'read'            => 'string',
                        'delete'      => 'string',  'unread'          => 'string',
                        'sort2'       => 'string',  'move2'           => 'string',
                        'copy2'       => 'string',  'read2'           => 'string',
                        'unread2'     => 'string',  'delete2'         => 'string',
                        'purge'       => 'string',  'submit_page2'    => 'string',),
    'print_view' =>
                array ( 'id'              => 'id',     'uid'        => 'int', 
                        'mailbox'         => 'folder', 'page_num'   => 'int',
                        'part'            => 'float',  'print_full' => 'string',
                        'print_part_full' => 'string', 'big_text'   => 'int'),
    'message' =>
                array ( 'full'          => 'string',  'mailbox'       => 'folder',
                        'new'           => 'int',     'page_num'      => 'int',
                        'uid'           => 'int',     'part'          => 'float',
                        'subject'       => 'string',  'from'          => 'string',
                        'date'          => 'string',  'to'            => 'string',
                        'part_full'     => 'string',  'top_level'     => 'float',
                        'id'            => 'id',      'name'          => 'string',
                        'reply_notice'  => 'string',  'raw'           => 'int',
                        'move'        => 'string',  'uid_delete'    => 'int',
                        'search'        => 'int',     'thread'        => 'int',
                        'uid_move'      => 'int',     'destination'   => 'folder',
                        'draft'         => 'int',     'bounce_notice' => 'string',
                        'find_response' => 'string',  'big_text'      => 'string',
                        'scroll_uid'    => 'int',     'hide_folder_preview' => 'int',
                        'delete'        => 'string'),
    'new' =>
                array ( 'id'             => 'id',     'mailbox'     => 'folder',
                        'move'           => 'string', 'destination' => 'string',
                        'selection_type' => 'string', 'toggle_all'  => 'string',
                        'read'           => 'string', 'copy'        => 'string',
                        'delete'         => 'string'),
    'search' =>
                array ( 'id'             => 'id',     'mailbox'         => 'folder',
                        'range_type'     => 'string', 'month'           => 'string',
                        'day'            => 'int',    'year'            => 'int',
                        'size_type'      => 'string', 'size'            => 'int',
                        'size_unit'      => 'string', 'search_part'     => 'string',
                        'sstring'        => 'string', 'update'          => 'string',
                        'FLAG_FLAGGED'   => 'string', 'FLAG_UNFLAGGED'  => 'string',
                        'FLAG_SEEN'      => 'string', 'FLAG_UNSEEN'     => 'string',
                        'FLAG_DELETED'   => 'string', 'FLAG_UNDELETED' => 'string',
                        'FLAG_ANSWERED'  => 'string', 'FLAG_UNANSWERED' => 'string',
                        'FLAG_DRAFT'     => 'string', 'FLAG_UNDRAFT'    => 'string',
                        'FLAG_RECENT'    => 'string', 'FLAG_OLD'        => 'string',
                        'search_folders' => 'array',  'uid'             => 'int',
                        'move'           => 'string', 'destination'     => 'string',
                        'selection_type' => 'string', 'toggle_all'      => 'string',
                        'search'         => 'string', 'reset'           => 'string',
                        'read'           => 'string', 'unread'      => 'string',
                        'copy'           => 'string', 'delete'      => 'string'),
    'iframe' =>
                array ( 'id' => 'id'),
    'options' =>
                array ( 'id'             => 'id',     'mailbox'        => 'folder',
                        'css_selection'  => 'string', 'sent_on'        => 'int',
                        'update'         => 'string', 'sent_folder'    => 'folder',
                        'page_count'     => 'int',    'refresh_new'    => 'int',
                        'trash_folder'   => 'folder', 'trash_on'       => 'int',
                        'filter_links'   => 'int',    'wrap_clean'     => 'int',
                        'font_type'      => 'string', 'simple'         => 'int',
                        'read_wrap'      => 'int',    'filter_images'  => 'int',
                        'drafts_folder'  => 'folder', 'drafts_on'      => 'int',
                        'lang_selection' => 'string', 'start_page'     => 'string',
                        'html_only'      => 'int',    'click_links'    => 'int',
                        'click_email'    => 'int',    'add_profile'    => 'string',
                        'date_selection' => 'string', 'time_selection' => 'string',
                        'folder_style'   => 'string', 'folder_detail'  => 'string',
                        'html_default'   => 'int',    'folder_preview' => 'string',
                        'pos_1'          => 'string', 'pos_2'          => 'string',
                        'pos_3'          => 'string', 'pos_4'          => 'string',
                        'pos_5'          => 'string', 'pos_6'          => 'string',
                        'preview_position' => 'int',  'font_size'      => 'int',
                        'show_clock'     => 'int', 'wide_bar' => 'int'),
    'compose' =>
                array ( 'reply'      => 'int',    'uid'          => 'int', 
                        'part'       => 'float',  'id'           => 'id',
                        'refs'       => 'string', 'messid'       => 'string',
                        'inreplyto'  => 'string', 'to'           => 'string',
                        'from'       => 'int',    'subject'      => 'string',
                        'message'    => 'string', 'cc'           => 'string',
                        'bcc'        => 'string', 'send'         => 'string',
                        'forward'    => 'int',    'list_reply'   => 'string',
                        'mailbox'    => 'folder', 'reply_send'   => 'int',
                        'to_add'     => 'string', 'match'        => 'string',
                        'addresses'  => 'array',  'all'          => 'int',
                        'sig'        => 'string', 'attach'       => 'string',
                        'new'        => 'int',    'delete'       => 'string',
                        'attachment' => 'string', 'save'         => 'string',
                        'draft'      => 'int',    'bounce'       => 'int',
                        'search'     => 'string', 'search_terms' => 'string',
                        'list'       => 'string', 'html_part'    => 'string',
                        'cc_add'     => 'string', 'bcc_add'      => 'string'),
    'folders' =>
                array ( 'id'            => 'id',    'mailbox'     => 'folder',
                        'Update'        => 'string', 'create'     => 'string',
                        'newfolder'     => 'folder', 'parent'     => 'folder',
                        'allow_subs'    => 'string', 'delfolder'  => 'folder',
                        'rename_folder' => 'folder', 'rename_new' => 'folder',
                        'delete'        => 'string', 'confirm_del' => 'string',
                        'rename'        => 'string', 'update'     => 'string'),
    'contacts' =>
                array ( 'id'        => 'id',     'mailbox'      => 'folder',
                        'addresses' => 'string', 'name'         => 'string',
                        'info'      => 'string', 'add'          => 'string',
                        'index'     => 'int',    'update_index' => 'int',
                        'prep'      => 'string', 'prep_addy'    => 'string',
                        'update'    => 'string', 'edit'         => 'string',
                        'delete'    => 'string'),
    'about' =>
                array ( 'id' => 'id', 'mailbox' => 'folder'),
    'download' =>
                array ( 'id'      => 'id',     'mailbox' => 'folder',
                        'uid'     => 'int',    'part'    => 'float',
                        'decode'  => 'string', 'type'    => 'string',
                        'subtype' => 'string', 'name'    => 'string'),
    'logout' =>
                array ( 'id' => 'id'),
    'thread_view' =>
                array ( 'id'  => 'id', 'mailbox'  => 'folder',
                        'uid' => 'int', 'update' => 'string'),
    'redirect' =>
                array ( 'id'       => 'id',     'options'      => 'string', 
                        'hostname' => 'string', 'install_path' => 'string',
                        'mailbox'  => 'folder', 'folders'      => 'string',
                        'contacts' => 'string', 'compose'      => 'string',
                        'logout'   => 'string', 'search'       => 'string',
                        'new'      => 'string'));

    $checked = array();
    $input = array();
    if (!empty($_POST)) {
        $input = $_POST;
    }
    elseif (!empty($_GET)) {
        $input = $_GET;
    }
    if (!empty($input)) {
        foreach ($input as $key => $value) {
            if (isset($v_types[$page][$key])) {
                switch ($v_types[$page][$key]) {
                    case 'string':
                        if (ini_get('magic_quotes_gpc') == 1) {
                            $checked[$key] = stripslashes((string) $value);
                        }
                        else {
                            $checked[$key] = (string) $value;
                        }
                        break;
                    case 'id':
                        if (strlen($value) == 32 && preg_match("/[a-zA-Z0-9]/", $value)) {
                            $checked[$key] = $value;
                        }
                        else {
                            $checked[$key] = false;
                        }
                        break;
                    case 'folder':
                            $checked[$key] = $value;
                        break;
                    case 'int':
                            $checked[$key] = intval($value);
                        break;
                    case 'float':
                        $checked[$key] =  preg_replace( "/[^0-9\.]*/", "", $value );
                        break;
                    case 'array':
                        if (is_array($value)) {
                            $checked[$key] = $value;
                        }
                        break;
                    default:
                        break;
                }
            }
        }
    }
    if (!isset($checked['mailbox'])) {
        $checked['mailbox'] = 'INBOX';
    }
    if (!isset($checked['id'])) {
        $checked['id'] = false;
    }
    return $checked;
}

/**
 *  init function for hastymail login
 *
 *  @param  $hm_input       array       the POST vars passed to this page
 *  @param  $config_file    string      the path+name of the site config file
 *  @param  $hasty_key      string      encryption key
 *  @return                 resource    a connection to the IMAP server
 *
 */
function hm_hastymail_login ($hm_input, $config_file, $hasty_key) {
    $alt_index = false;
    if (isset($hm_input['alt_server']) && $hm_input['alt_server'] > 0) {
        $alt_index = $hm_input['alt_server'];
    }
    set_magic_quotes_runtime(0);
    /* open config file */
    $config = hm_get_config($config_file, $alt_index);
    if ($hm_input['pass'] != '' && $hm_input['user'] != '') {
        $pass = hmw_crypt($hm_input['pass'], $config, 'encrypt', $hasty_key);
        $debug = false;

        /* setup username */
        if (isset($config['append_name']) && $config['append_name'] != '') {
            if (!strstr($hm_input['user'], '@')) {

                /* virtual host logic */
                if (strtolower($config['append_name']) == 'virtual_host' &&
                    isset($_SERVER['HTTP_HOST'])) {
                    $shost = $_SERVER['HTTP_HOST'];
                
                    /* use the defined list */
                    if (isset($config['virtual_list']) && $config['virtual_list'] != '') {
                        if (strstr($config['virtual_list'], ',')) {
                            $hostpart = '('. 
                            str_replace(',', '|', $config['virtual_list']).')';
                            $domain = preg_replace("/^$hostpart\./", '', $shost);
                        }
                        else {
                            $hostpart = $config['virtual_list'];
                            $domain = preg_replace("/^$hostpart\./", '', $shost);
                        }
                    }
                    
                    /* use our own logic */
                    else {
                        if (!preg_match("/^(\d){1,3}\.(\d){1,3}\.(\d){1,3}\.(\d){1,3}$/",
                            $shost) && count(explode('.', $shost)) > 2) {
                            $domain = substr(strstr($shost, '.'), 1);
                        }
                        else {
                            $domain = $shost;
                        }
                    }
                    $hm_input['user'] .= '@'.$domain;
                }

                /* static append name option */
                else {
                    $hm_input['user'] .= '@'.$config['append_name'];
                }
            }
        }
        if (isset($config['login_debug']) && $config['login_debug'] == 'true') {
            $debug = true;
        }

        /* check username/password with imap server */
        if ($imap_stream = hm_imap_login($hm_input['user'], $pass, $config, $hasty_key, 
                                         false, $debug)) {
            ob_start();
            ini_set('url_rewriter.tags', '');
            if (ini_get('session.use_cookies') == 1) {
                ini_set('session.use_cookies', '0');
            }

            /* setup session vars */
            $session_id = md5(uniqid(rand(),1));
            session_id($session_id);
            session_start();
            $_SESSION['notices'] = array();
            $hm_input['id'] = $session_id;
            if (isset($config['log_users']) && $config['log_users'] == 'true') {
                hm_log_users($config['log_path'], $hm_input['user'], 'login');
            }
            $_SESSION['counter'] = 1;
            $_SESSION['config'] = $config;
            $_SESSION['user'] = $hm_input['user'];
            $_SESSION['pass'] = $pass;
            $_SESSION['ip_addy'] = $_SERVER['REMOTE_ADDR'];
            $_SESSION['user_agent'] = $_SERVER['HTTP_USER_AGENT'];
            $_SESSION['user_id'] = $_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT'];
            $_SESSION['settings'] = hm_get_settings($hm_input['user'],
                                                 $config['settings_dir']);

            $_SESSION['charsets'] = array();
            /* get i18n strings */
            if (isset($config['default_lang'])) {
                if (isset($_SESSION['settings']['lang'])) {
                    $str = hm_translate($_SESSION['settings']['lang']);
                }
                else {
                    $str = hm_translate($config['default_lang']);
                }
            }
            elseif (isset($_SESSION['settings']['lang'])) {
                $str = hm_translate($_SESSION['settings']['lang']);
            }
            else {
                $str = hm_translate('en_US');
            }
            if (isset($config['disable_utf8'])) {
                if ($config['disable_utf8'] != 'true') {
                    if (isset($config['utf7_decode_folder']) &&
                        $config['utf7_decode_folder'] == 'true' &&
                        function_exists('imap_utf7_decode')) {
                        $_SESSION['config']['utf7_decode'] = 'true';
                    }
                    $_SESSION['charsets'] = include('../lang/charsets.php');
                    foreach ($str as $key => $value) {
                        if (is_array($value)) {
                            foreach ($value as $k => $v) {
                                if ($str['charset'] != 'iso-8859-1') {
                                    $_SESSION['str'][$key][$k] =
                                        hm_special_chars($v, $str['charset'], true, 
                                        $_SESSION['charsets'][$str['charset']], false);
                                }
                                else {
                                    $_SESSION['str'][$key][$k] = utf8_encode($v);
                                }
                            }
                        }
                        else {
                            if ($str['charset'] != 'iso-8859-1') {
                                $_SESSION['str'][$key] =
                                    hm_special_chars($value, $str['charset'], true, 
                                    $_SESSION['charsets'][$str['charset']], false);
                            }
                            else {
                                $_SESSION['str'][$key] = utf8_encode($value);
                            }
                        }
                    }
                    $_SESSION['str']['charset'] = 'UTF-8';
                }
                else {
                    $_SESSION['str'] = $str;
                }
            }
            else {
                $_SESSION['charsets'] = include('../lang/charsets.php');
                foreach ($str as $key => $value) {
                    if (is_array($value)) {
                        foreach ($value as $k => $v) {
                            if ($str['charset'] != 'iso-8859-1') {
                                $_SESSION['str'][$key][$k] =
                                    hm_special_chars($v, $str['charset'], true, 
                                    $_SESSION['charsets'][$str['charset']], false);
                            }
                            else {
                                $_SESSION['str'][$key][$k] = utf8_encode($v);
                            }
                        }
                    }
                    else {
                        if ($str['charset'] != 'iso-8859-1') {
                            $_SESSION['str'][$key] =
                                hm_special_chars($value, $str['charset'], true, 
                                $_SESSION['charsets'][$str['charset']], false);
                        }
                        else {
                            $_SESSION['str'][$key] = utf8_encode($value);
                        }
                    }
                }
                $_SESSION['str']['charset'] = 'UTF-8';
            }
            $_SESSION['caps'] = hm_get_caps($imap_stream);
        }

        /* bail on bad login */
        else {
            header("Location: ".$config['hostname'].$config['install_path'].
                   "logout.php");
            exit;
        }
    }
    else {
        header("Location: ".$config['hostname'].$config['install_path'].
               "logout.php");
        exit;
    }
    return $imap_stream;
}

/**
 *  reads in the site config file 
 *
 *  @param  $config_file    string      the config file name with absolute path
 *  @param  $alt            boolean     alternate imap server flag
 *  @return                 array       configuration file values
 *
*/
function hm_get_config($config_file, $alt=false) {
    if (!is_readable($config_file)) {
        echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>
      Hastymail configuration error
  </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=ISO-8859-1">
  <link rel="stylesheet" type="text/css" href="themes/default.css">
  <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>
<br><br><center>
<h3>Configuration Read Error</h3>
<br>
Configuration file not found or unreadable.
<br>Please contact your system administrator to investigate the issue.
</body>
</html>',"\n";
         exit;
    }
    $config = array();
    $config_fh = fopen ($config_file, 'r');
    while (!feof ($config_fh)) {
        $line = fgets($config_fh, 1024);
        if ($line{0} != '#') {
            $value = substr(trim(strstr($line, '=')), 1);
            $offset = (strlen(trim($line)) - strlen($value)) - 1;
            $name = substr($line, 0, $offset);
            if ($name) {
                $config[$name] = $value; 
            }
        }
    }
    fclose($config_fh);
    if ($alt) {
        foreach($config as $name => $value) {
            if (substr($name, 0, 6) == 'alt_'.$alt.'_') {
                $config[substr($name, 6)] = $value;
            }
        }
    }
    if (isset($_SERVER['SERVER_PORT'])) {
        if ($_SERVER['SERVER_PORT'] == '443') {
            $config['hostname'] = 'https://';
        }
        elseif ($_SERVER['SERVER_PORT'] == '80') {
            $config['hostname'] = 'http://';
        }
        else {
            if (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] == 'on') {
                $config['hostname'] = 'https://';
            }
            else {
                $config['hostname'] = 'http://';
            }
        }
    }
    $config['install_path'] = rtrim(dirname($_SERVER['PHP_SELF']), '/').'/';
    $config['hostname'] .= $_SERVER['HTTP_HOST']; 
    return $config;
}

/**
 *  clean up session on logout
 *
 *  @param      $id             string      session id
 *  @param      $config_file    string      absolute path to the hastymail config file
 *  @return                     void
 *
 */
function hm_session_logout ($id, $config_file) {
    if (!$id) {
        hm_logged_out($config_file);
    }
    ob_start();
    if (ini_get('session.use_cookies') == 1) {
        ini_set('session.use_cookies', '0');
    }
    set_magic_quotes_runtime(0);
    ini_set('url_rewriter.tags', '');
    session_id($id);
    session_start($id);
    $config = hm_get_config($config_file);
    if (isset($config['log_users']) && $config['log_users'] == 'true') {
        hm_log_users($config['log_path'], $_SESSION['user'], 'logout');
    }
    $_SESSION = array();
    session_destroy();
}

/**
 *  continue the session
 *
 *  @param  $id             string      session id
 *  @param  $config_file    string      absolute path to the hastymail config file
 *  @param  $clear          boolean     remove attachments from session if they exist
 *  @param  $skip           boolean     flag to skip dynamic session_id
 *  @return                 boolean     redirects to logout on failure
 *
*/
function hm_session_continue ($id, $config_file, $clear=true, $skip=false) {
    if (!$id) {
        hm_logged_out($config_file);
    }
    ob_start();
    if (ini_get('session.use_cookies') == 1) {
        ini_set('session.use_cookies', '0');
    }
    set_magic_quotes_runtime(0);
    ini_set('url_rewriter.tags', '');
    session_id($id);
    session_start($id);
    if (!isset($_SESSION['user_id']) ||
        $_SESSION['user_id'] != $_SERVER['REMOTE_ADDR'].$_SERVER['HTTP_USER_AGENT']) {
        hm_logged_out($config_file);
    }
    if ($clear && isset($_SESSION['attachments'])) {
        foreach ($_SESSION['attachments'] as $name => $vals) {
            if (file_exists($_SESSION['config']['settings_dir']."attachments/".$name)) {
                unlink($_SESSION['config']['settings_dir']."attachments/".$name);
                clearstatcache();
            }
        }
        $_SESSION['attachments'] = array();
        unset($_SESSION['attachments']);
    }
    if (!$skip && (isset($_SESSION['config']['dynamic_sessionid']) &&
        $_SESSION['config']['dynamic_sessionid'] == 'true')) {
        $session_values = $_SESSION;
        $_SESSION = array();
        session_unset();
        session_destroy();
        $session_id = md5(uniqid(rand(),1));
        session_id($session_id);
        session_start($session_id);
        $_SESSION = $session_values;
    }
    return true;
}

/**
 *  encrypt/decrypt user password with PHP mycrypt lib
 *
 *  @param      $input      string      password to encrypt/decrypt
 *  @param      $type       string      encrypt or decrypt flag
 *  @param      $cipher     string      encryption cipher to use
 *  @param      $key        string      encryption key
 *  @return                 string      encrypted/decrypted string
 */    
function hm_mcrypt($input, $type, $cipher, $key) {
    if (isset($_SERVER['HASTY_KEY'])) {
        $key = $_SERVER['HASTY_KEY'];
    }
    else {
        if ($key == 'You should be using the more secure version!') {
            return false; 
        }
    }
    $result = false;
    $td = mcrypt_module_open ($cipher, '', 'ecb', '');
    $key = substr ($key, 0, mcrypt_enc_get_key_size ($td));
    $iv_size = mcrypt_enc_get_iv_size ($td);
    $iv = mcrypt_create_iv ($iv_size, MCRYPT_RAND);
    if (mcrypt_generic_init ($td, $key, $iv) != -1) {
        if ($type == 'encrypt') {
            $result = mcrypt_generic ($td, $input);
            mcrypt_generic_deinit ($td);
            mcrypt_module_close ($td);
        }
        elseif ($type == 'decrypt') {
            $result = mdecrypt_generic ($td, $input);
            mcrypt_generic_deinit ($td);
            mcrypt_module_close ($td);
        }
    }
    else {
        return false;
    }
    if ($type == 'decrypt') {
        $result = rtrim($result, "\0");
    }
    return $result;
}

/**
 *  RC4 based encrypt/decrypt function
 *
 *  @param      $input      string  the string to encrypt or decrypt
 *  @param      $key        encryption key
 *  @return                 string  encrypted/decrypted string
 *
*/
function hm_crypt($input, $key) {
    if (isset($_SERVER['HASTY_KEY'])) {
        $key = $_SERVER['HASTY_KEY'];
    }
    else {
        if ($key == 'You should be using the more secure version!') {
            return false; 
        }
    }
    $k_tmp = preg_split('//', $key, -1, PREG_SPLIT_NO_EMPTY);
    foreach($k_tmp as $char) {
        $k[] = ord($char);
    }
    unset($k_tmp); 
    $message = preg_split('//', $input, -1, PREG_SPLIT_NO_EMPTY);
    $rep = count($k);
    for ($n=0;$n<$rep;$n++) {
        $s[] = $n;
    }
    $i = 0;
    $f = 0;
    for ($i = 0;$i<$rep;$i++) {
        $f = (($f + $s[$i] + $k[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
    }
    $i = 0;
    $f = 0;
    foreach($message as $letter) {
        $i = (($i + 1) % $rep);
        $f = (($f + $s[$i]) % $rep);
        $tmp = $s[$i];
        $s[$i] = $s[$f];
        $s[$f] = $tmp;
        $t = $s[$i] + $s[$f];
        $done = ($t^(ord($letter)));
        $i++;
        $f++;
        $enc_array[] = chr($done);
    }
    $coded = implode('', $enc_array);
    return $coded;
}

/**
 *  log the user out
 *
 *  @param  $config_file    string      hastymail configuration file with absolute path
 *  @param  $id             string      session id
 *  @return                 void        prints logout message and exits the calling script
 *
 */
function hm_logged_out ($config_file, $id=false) {
    $config = hm_get_config($config_file);
    if (isset($config['default_lang'])) {
        $str = hm_translate($config['default_lang']);
    }
    else {
        $str = hm_translate('en_US');
    }
    if (isset($config['default_theme']) && $config['default_theme'] != '') {
        $style = $config['default_theme'];
    }
    else {
        $style = 'default.css';
    }
    echo '<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN">
<html>
<head>
  <title>
     ',$str[97],'
  </title>
  <meta HTTP-EQUIV="content-type" CONTENT="text/html; charset=',$str['charset'],'">
  <link rel="stylesheet" type="text/css" href="../themes/',$style,'">
  <link rel="SHORTCUT ICON" href="../images/hastymail.ico">
</head>
<body>
<br><br>
<center>
<b>',$str[195],'</b>
<br><a href="',$config['hostname'],$config['install_path'],'login.php">
<b>',$str[196],'</b></a>
</center>
</body>
</html>',"\n"; 
    exit; 
}

/**
 *  logs user login/outs to specified file
 *
 *  @param      $path       string      the full path and filename to the log file
 *  @param      $username   string      the users login name
 *  @param      $type       string      login or logout
 *  @return                 void        fails silently if there is a problem
 *
 */
function hm_log_users($path, $username, $type) {
    clearstatcache();
    if (is_writable($path) && file_exists($path) && $log_fh = @fopen($path, 'a+')) {
        $string = "$type\t$username\t".$_SERVER['REMOTE_ADDR'].
            "\t".date("F j, Y, g:i a");
        if (isset($_SERVER['HTTP_USER_AGENT'])) {
            $string .= "\t".$_SERVER['HTTP_USER_AGENT'];
        }
        $string .= "\n";
        @fputs($log_fh, $string);
        @fclose($log_fh);
    }
    else {
        if ($type == 'login') {
            $_SESSION['notices'][] = 'Could not write log file. Please check your'.
                                     ' Hastymail settings';
        }
    }
}

/**
 *  translation function to get the interface strings.
 *
 *  @param  $lang           string      the selected language
 *  @param  $lang_options   boolean     indicates language selection 
 *  @return                 array       translated strings array
 *
 */
function hm_translate($lang, $lang_options=false) {
    $strings = array();
    if (!$lang_options) {
        require_once('../lang/lang_index.php');
    }
    if (isset($lang_options[$lang]) && is_readable('../lang/'.$lang.'.php')) {
        $strings = require_once('../lang/'.$lang.'.php');
    }
    else {
        $strings = require_once('../lang/en_US.php');
    }
    return $strings; 
}

?>
