<?php

/* session_2.php: Additional functions for settings, contacts, etc.
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: session_2.php,v 1.30.2.1 2004/05/06 15:41:20 sailfrog Exp $
*/

/**
 *  read in the contacts list from LDAP book defined in hastymail.conf
 *  @param      $config     array       configuration settings
 *  @param      $key        string      encrypted user password
 *  @return     array       any LDAP contacts we could find
 *
 */
function hm_get_ldap_contacts($config, $key, $filter) {
    $contacts = array();
    if (!function_exists('ldap_connect')) {
        return $contacts;
    }
    if (isset($config['ldap_ssl']) && $config['ldap_ssl'] == 'true') {
        $ldap_server = 'ldaps://'.$config['ldap_server'];
    }
    else {
        $ldap_server = 'ldap://'.$config['ldap_server'];
    }
    $str = $_SESSION['str'];
    if ($ldapp= @ldap_connect($ldap_server, $config['ldap_port'])) {
        if (isset($config['ldap_auth']) &&
            $config['ldap_auth'] == 'true') {
            $ldap_rdn = $_SESSION['user'];
            $ldap_pass = hmw_crypt($_SESSION['pass'], $config, 'decrypt', $key);
            $bind = @ldap_bind($ldapp, $ldap_rdn, $ldap_pass);
        }
        else {
            $bind = @ldap_bind($ldapp);
        }
        if ($bind) {
            if ($filter) {
                $filter = str_replace(array('*', '(', ')', "\\", "\0"),
                          array('\0x2a', '\0x28', '\0x29', '\0x5c', '\0x00'), $filter);
                $search = '(|(|(cn=*'.$filter.'*) (mail=*'.$filter.
                          '*))(sn=*'.$filter.'*))';
            }
            elseif (isset($config['ldap_search_term']) &&
                $config['ldap_search_term'] != '') {
                $search = $config['ldap_search_term'];
            }
            else {
                $search = 'cn=*';
            }
            $ldap_attr = @ldap_search($ldapp, $config['ldap_base_dn'], 
                         $search);
            $info = ldap_get_entries($ldapp, $ldap_attr);
            ldap_close($ldapp);
            array_shift($info);
            $i = 0;
            foreach ($info as $array) {
                if (isset($array['mail'][0]) && strstr($array['mail'][0], '@')) {
                    $contacts[$i] = array( $i, trim($array['mail'][0]), 
                                    trim($array['cn'][0], ''));
                    $i++;
                }
            }
        }
        else {
            ldap_close($ldapp);
            $_SESSION['notices'][] = $str[197];
        }
    }
    else {
        $_SESSION['notices'][] = $str[198];
    }

    return $contacts;
}

/**
 *  read in the contacts list
 *
 *  @param      $user   string      username
 *  @param      $dir    string      settings dir
 *  @return             array       array of personal contacts
 *
 */
function hm_get_contacts($user, $dir, $filter=false) {
    $contacts = array();
    if ($contacts_file = @fopen ($dir.strtolower($user).'.contacts', 'r')) {
        while (!feof ($contacts_file)) {
            $line = fgets($contacts_file, 1024);
            $parts = preg_split("/\|/", $line, 4);
            if (count($parts) == 4) {
                if ($filter) {
                   if (stristr($parts[2], $filter) || stristr($parts[1], $filter)) { 
                        $contacts[$parts[0]] = $parts;
                    }
                }
                else {
                    $contacts[$parts[0]] = $parts;
                }
            }
        }
    }
    return $contacts;
}

/**
 *  sort the contact list
 *
 *  @param      $contacts       array   the contacts array
 *  @return                     array   alpha sorted contacts
 *
 */
function hm_sort_contacts($contacts) {
    $i = 0;
    $new_contacts = array();
    if (!function_exists('cmpsort')) {
        function cmpsort ($a, $b) {
            return strcmp(strtolower($a[2]), strtolower($b[2]));
        }
    }
    usort($contacts, "cmpsort");
    foreach ($contacts as $index => $array) {
        $new_contacts[$i] = $array;
        $new_contacts[$i][0] = $i;
        $i++;
    }
    return $new_contacts;
}

/**
 *  get the users settings
 *
 *  @param      $user   string      username
 *  @param      $dir    string      settings directory
 *  @return             array       
 *
 */
function hm_get_settings($user, $dir) {
    $settings = array();
    if (!is_readable($dir.strtolower($user).'.settings')) {
        $_SESSION['first_login'] = true;
    }
    if ($settings_file = @fopen ($dir.strtolower($user).'.settings', 'r')) {
        while (!feof ($settings_file)) {
            $line = fgets($settings_file, 1024);
            if (!preg_match("/^#/", $line)) {
                $pair = preg_split("/=/", $line);
                if (isset($pair[0]) && isset($pair[1])) {
                    switch ($pair[0]) {
                        case 'hidden':
                            $settings['hidden'][] = trim($pair[1]);
                            break;
                        case 'new_mail_folders':
                            $settings['new_mail_folders'][] = trim($pair[1]);
                            break;
                        case 'sort':
                            $parts = preg_split("/\|/", $pair[1], 2);
                            if (isset($parts[0]) && $parts[1]) {
                                $settings['sort'][$parts[0]] = trim($parts[1]);
                            }
                            break;
                        default:
                            $settings[$pair[0]] = trim($pair[1]);
                            break;
                    }
                }
            }
        }
        fclose($settings_file);
    }
    $data = array();
    if (isset($settings['profile_count'])) {
        $profile_count = $settings['profile_count'];
    }
    else {
        $profile_count = 1;
        $settings['profile_count'] = 1;
    }
    $data = @file($dir.strtolower($user). '.profile');
    for ($i=0;$i<$profile_count;$i++) {
        $_SESSION['profiles'][$i]['from_name'] = '';
        $_SESSION['profiles'][$i]['from_address'] = '';
        $_SESSION['profiles'][$i]['sig'] = '';
        /* bail if no data */
        if (!isset($data[0])) {
            continue;
        }
        else {
            /* get profile from name */
            $_SESSION['profiles'][$i]['from_name'] = trim($data[0]);
            array_shift($data);
            if (!isset($data[0])) {
                continue;
            }
            else {
                /* get profile from address */
                $_SESSION['profiles'][$i]['from_address'] = trim($data[0]);
                array_shift($data);
            }
        }
        /* get profile signature */
        if (isset($data[0]) && preg_match("/^\{(\d+)\}/", $data[0], $matches)) {
            if (isset($matches[1])) {
                $len = $matches[1];
                $data[0] = substr($data[0], (strlen($len) + 2));
                $sig = '';
                if ($len > 0) {
                    while ($len > 0) {
                        $sig .= $data[0];
                        $len -= strlen($data[0]);
                        array_shift($data);
                    }
                    $_SESSION['profiles'][$i]['sig'] = $sig;
                }
                else {
                    array_shift($data);
                }
            }
        }
        else {
            continue;
        }
    }
    return $settings;
}

/**
 *  write the contacts to file
 *
 *  @param      $user       string      username
 *  @param      $dir        string      settings directory
 *  @param      $contacts   array       the contacts array
 *  @return                 boolean     true on success false on failure
 *
 */
function hm_write_contacts($user, $dir, $contacts) {
    $result = false;
    $contacts = hm_sort_contacts($contacts);
    if ($contacts_file = @fopen ($dir.strtolower($user).'.contacts', 'w')) {
        $i = 0;
        foreach ($contacts as $array) {
            $line = $i.'|'.trim($array[1]).'|'.trim($array[2]).'|'.trim($array[3]);
            str_replace("\n", '', $line);
            fputs($contacts_file, trim($line)."\n");
            $i++;
        }
        fclose($contacts_file);
        $result = true;
    }
    return $result;
}

/**
 *  write the users settings to file
 *
 *  @param      $user       string      username
 *  @param      $dir        string      settings dir
 *  @return                 void
 * 
 */  
function hm_write_settings($user, $dir) {
    $settings = $_SESSION['settings'];
    $str = $_SESSION['str'];
    $profile_count = $settings['profile_count'];
    if (isset($settings['sort'])) {
        $sorts = $settings['sort'];
        $settings['sort'] = array();
        foreach($sorts as $index => $value) {
            $settings['sort'][] = $index.'|'.$value;
        }
    }
    $settings_file = @fopen ($dir.strtolower($user).'.settings', 'w');
    if (is_resource($settings_file)) {
        foreach ($settings as $index => $value) {
            if (is_array($value)) {
                foreach ($value as $element) {
                    fputs($settings_file, $index."=".$element."\n");
                }
            }
            else { 
                fputs($settings_file, $index."=".$value."\n");
            }
        }
        fclose($settings_file);
    }
    else {
        $_SESSION['notices'][] = $str[272];
    }
    $profile_file = @fopen ($dir.strtolower($user).'.profile', 'w');
    if (is_resource($profile_file)) {
        for ($i=0;$i<$profile_count;$i++) {
            if ($profile_file) {
               fputs($profile_file, trim($_SESSION['profiles'][$i]['from_name'])."\n");
               fputs($profile_file, trim($_SESSION['profiles'][$i]['from_address'])."\n");
               fputs($profile_file, '{'.
                    strlen(rtrim($_SESSION['profiles'][$i]['sig'])).'}'.
                    rtrim($_SESSION['profiles'][$i]['sig'])."\n");
            }
        }
    fclose($profile_file);
    }
    else {
        $_SESSION['notices'][] = $str[273];
    }
}

/**
 * check for missing special folders
 *
 *  @return             void
 */
function hm_check_folders($imap_stream) {
    $write = false;
    $str = $_SESSION['str'];
    $specials = array(27 => 'trash_folder', 28 => 'sent_folder', 209 => 'drafts_folder');
    foreach ($specials as $index => $val) {
        if (isset($_SESSION['settings'][$val]) &&
            !in_array(urldecode($_SESSION['settings'][$val]), $_SESSION['folders'])) {
            unset($_SESSION['settings'][$val]);
            $write = true;
            $_SESSION['notices'][] = $str[$index];
        }
    }
    if ($write) {
        hm_write_settings($_SESSION['user'], $_SESSION['config']['settings_dir']);
    }
    if (isset($_SESSION['missing_folders_flag']) && 
        $_SESSION['missing_folders_flag'] == 1 && 
        is_array($_SESSION['missing_folders'])) {
        $tmp = $str[47].'<br>';
        foreach ($_SESSION['missing_folders'] as $missing) {
            $tmp .= "<b>$missing</b><br>";
        }
        $tmp .= $str[49];
        $_SESSION['notices'][] = $tmp;
        $_SESSION['missing_folders_flag'] = 0;
        unset($_SESSION['missing_folders_flag']);
        $_SESSION['folders'] = hm_boxlist($imap_stream, true, 'all');
    }
    return;
}    
?>
