<?php

/*  wrapper_functions.php: wrappers for various functions in lib/
*
    Copyright (C) 2002  Hastymail Development group

    This program is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; Version 2
    See the COPYING file for complete information.

* $Id: wrapper_functions.php,v 1.24 2004/02/18 05:42:36 sailfrog Exp $
*/

/* Include the needed files for the calling script */
require_once('constant.php');
require_once('session.php');
switch (basename($_SERVER['PHP_SELF'])) {
    case 'thread_view.php':
    case 'new.php':
    case 'mailbox.php':
        require_once('session_2.php');
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_2.php');
        require_once('html_functions.php');
        break;
    case 'print_view.php':
    case 'message.php':
        require_once('session_2.php');
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_2.php');
        require_once('bodystructure.php');
        require_once('html_functions.php');
        break;
    case 'search.php':
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_2.php');
        require_once('session_2.php');
        require_once('html_functions.php');
        break;
    case 'redirect.php':
        break;
    case 'logout.php':
        require_once('session_2.php');
        require_once('session_2.php');
        break;
    case 'folders.php':
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_2.php');
        require_once('imap_3.php');
        require_once('session_2.php');
        require_once('html_functions.php');
        break;
    case 'contacts.php':
    case 'options.php':
        require_once('../lang/lang_index.php');
        require_once('general.php');
        require_once('imap.php');
        require_once('session_2.php');
        require_once('html_functions.php');
        break;
    case 'about.php':
        require_once('general.php');
        require_once('imap.php');
        require_once('html_functions.php');
        break;
    case 'iframe.php':
        break; 
    case 'compose.php':
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_2.php');
        require_once('imap_3.php');
        require_once('session_2.php');
        require_once('smtp.php');
        require_once('html_functions.php');
        require_once('bodystructure.php');
        break;
    case 'download.php':
        require_once('general.php');
        require_once('imap.php');
        require_once('imap_3.php');
        require_once('bodystructure.php');
        break;
    default:
        hm_logged_out($hm_input['id']);
        break;
}

/**
 *  wrapper function to pull in contact lists from different sources.
 *  @param      $user       string      username
 *  @param      $dir        string      user settings directory
 *  @param      $key        string      encryption key
 *  @param      $config     array       configuration settings
 *  @return                 array       array of user contacts
 *
 */
function hmw_get_contacts($user, $dir, $key, $config, $search=false) {
    $contacts = array();
    if (isset($config['ldap_server']) && $config['ldap_server'] != '') {
        if (!isset($config['ldap_search_only']) ||
            $config['ldap_search_only'] == 'false' || $search) {
            $contacts = array_merge($contacts, 
                        hm_get_ldap_contacts($config, $key, $search));
        }
    }
    $contacts = array_merge($contacts, hm_get_contacts($user, $dir, $search));
    $contacts = hm_sort_contacts($contacts);
    return $contacts;
}

/**
 *  wrapper around get_sort_info().
 *
 *  @param  $imap_stream    resource    connection to imap
 *  @param  $sort_type      string      sort method
 *  @param  $mailbox        string      folder to sort
 *  @param  $quick          boolean     quick flag for thread view
 *  @return                 array       sort information array
 *
 */
function &hmw_get_sort_info ($imap_stream, $sort_type, $mailbox, $quick=false) {
    $sort_info = '';
    if (isset($_SESSION['config']['client_sort']) && 
              $_SESSION['config']['client_sort'] == 'true') {
        $sort_info = &hm_client_side_sort($imap_stream, $mailbox, $sort_type);
    }
    else {
        $sort_info = &hm_get_sort_info($imap_stream, $sort_type, $mailbox, $quick);
    }
    return $sort_info;
}

/**
 *  wrapper around hm_crypt()
 *
 *  @param  $string     string      string to encrypt/decrypt
 *  @param  $config     array       configuration values
 *  @param  $type       string      flag to decrypt or encrypt string
 *  @param  $key        string      encryption key
 *  @return             string      encrypted/decrypted string
 *
 */
function hmw_crypt($string, $config, $type, $key) {
    if (isset($config['use_mcrypt']) && $config['use_mcrypt'] == 'true') {
        if (isset($config['mcrypt_cipher'])) {
            $cipher = strtolower($config['mcrypt_cipher']);
        }
        else {
            $cipher = 'des';
        }
        return hm_mcrypt($string, $type, $cipher, $key);
    }
    return hm_crypt($string, $key);
}

?>
