#!/usr/bin/perl

###
##	Original package IRCCS version 1, Copyright (c) 1995
##	Daniel J. Wightman.  Rewritten from Nov to Dec 2000.
##	Packaged Dec 19 and published as IRCCS (fruitbrick) version 2.
##
##	FruitBrick (IRCCS) - Internet Relay Chat Control System version 2
##	Copyright (C) 2000  Daniel J. Wightman <dent@abonica.net>
##
##	See the copyright or COPYRIGHT in the main directory for
##	details.  See the LICENSE in the main program directory.
##
##	My suggestion is that you get the newest version
##	of this program.  One way to locate the newest
##	version is to point your web browser at:
##
##	http://www.abonica.net/ircserv
###

use Socket;

# we need to know what parameter we ran with because we can do
# a fake fork and go daemon using a dupliate process and handles (pipe).
$myprocess = shift;

# Setup some variables to use in signal handling.  Can't, or shouldn't,
# use variables that allocate memory inside a handler.  Use variables
# that are already allocated some.

$sigpid = "aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa";
$sigsub = "bbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbbb";
$sigsig = "ccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccccc";
$exit = 0;

# auto flush STDIN in case we were started as spoon
select(STDIN); $|=1; select(STDOUT); $|=1;

$nolog = 1; # don't send to chan until $msgnick is in there

# our variables, flags and some data etc.
	require "service.conf"; # Configuration File to setup our variables

# if they used the Configur(ator) then options.conf exists
# with their desired settings, load this one now, which will
# override the service.conf settings.
	if(-f "options.conf") { require "options.conf"; }
	else
		{
		print STDERR "ERROR: You need to run Configure first !\n";
		exit;
		}
# I put the 'use' here just because the other OS check is here
##
# It's probably out there but a rudimentary search didn't
# reveal the secret to loading modules dependant on runtime
# data.  So here's my version of that control entity.
use win32use; # This is made by running Configure

# if windows, do they have win32 process?
if($flags{os} =~ /windows/i)
	{
	eval('use Win32::Process;');
	if(!$@) { $getwin32 = 1; }
	else
		{
		print "No win32 on this platform, I'll try main write instead\n";
		print "Win32 Process Error: $@\n";
		}
	}

# Generate the password list for the admin access feature
open PASSFILE, ">password.lst" or die "can't create password.lst : $!\n";
$cnt = 0;
foreach $i (@adminpass)
	{
	print PASSFILE "$i $cnt\n";	
	$cnt++;
	}
close(PASSFILE);

# for loging
#	require "ctime.pl";

# setup for writing databases
	$writetime = 15 if !$writetime;
	$synctime = $writetime;
	$syncnow = time() + ($synctime * 60);

# setup for nicktimer kill/change
	$nicktimer = 2 if !$nicktimer;

# setup server restrictions for modes ( nicks, users, chans)
foreach $i (keys %{$server{modes}})
	{
	(@modes) = split //, $server{modes}{$i};
	foreach $mode (@modes)
		{
		$server{modes}{$i}{$mode} = {}; # define it
		}
	undef(@modes); # for next pass
	}
# -------------------------------------------------------------------------
# MAIN
# -------------------------------------------------------------------------
# The main routine
{
# ----------------
# log, dump and database directories need to exist
my($path, $dir, @dirs);
(@dirs) = split/\//, $dumpdir;
foreach $dir (@dirs)
	{
	if($path) { $path .= "/".$dir; }
	else { $path = $dir; }
	if(!-d "$path")
		{
		mkdir ("$path", 0777) or die "I'm sorry, I can't work under these conditions. Create the directory structure $dumpdir and try again. I died with the following error: $!\n";
		}
	}
undef($path); undef(@dirs); undef($dir);
(@dirs) = split/\//, $datadir;
foreach $dir (@dirs)
	{
	if($path) { $path .= "/".$dir; }
	else { $path = $dir; }
	if(!-d "$path")
		{
		mkdir ("$path", 0777) or die "I'm sorry, I can't work under these conditions. Create the directory structure $datadir and try again. I died with the following error: $!\n";
		}
	}
undef($path); undef(@dirs); undef($dir);
# now the log dir
(@dirs) = split/\//, $logdir;
foreach $dir (@dirs)
	{
	if($path) { $path .= "/".$dir; }
	else { $path = $dir; }
	if(!-d "$path")
		{
		mkdir ("$path", 0777) or die "I'm sorry, I can't work under these conditions. Create the directory structure $logdir and try again. I died with the following error: $!\n";
		}
	}
undef($path); undef(@dirs); undef($dir);

# Start the log right away... so we can see any errors in daemon
if($flags{log} =~ /on/i)
	{
	unless(open LOG, ">>$logdir/service.log")
		{
		print STDOUT "COULD NOT OPEN LOGFILE... ABORTING!!! : $!\n";
	#	close($mysock); # ??? socket already, nah, prolly not eh?
		exit;
		}
	select(LOG); $|=1; # un bufffered loging
	select(STDOUT); $|=1; # always switch back
	# if this is true, we're spawned by ourself and our other
	# process exited, we hope.  now we're main.
	if($myprocess =~ /win32.daemon/i)
		{
		&writelog("LOG OPENED -");
		&writelog("Win32d run by PID : $$ - Switched", 1);
		}
	# this is the other process we can run, a duplicate of ourself
	# so that windows can emulate a sort of fork, we call it spoon.
	elsif($myprocess =~ /Win32.spoon/i)
		{
		select(STDIN);	$|=1; # auto flush
		select(STDOUT);	$|=1; # switch back to default print
		# set my output rights
		$myrights{log} = 1;
		$myrights{display} = 1;
		&writelog("Win32.spoon, aka fakefork, running on PID : $$ : good...", 1);
		delete($myrights{log});
		delete($myrights{display});
		}
	else
		{
		&writelog("LOG OPENED -");
		}
	}
# ----------------
# Go daemon, if they flaged this, before we load databases
# and create command structure. We don't want a duplicate
# database even if we're dumping it if we don't have to.
	&daemon if !$myprocess; # either way we're done using daemon

# Create the service databases and commands before we connect or
# the information we get from the server will be recieved out of
# sync.  If we load the database AFTER, we won't have any information
# to check against registered nicks/channels etc.
	&makedata;

# Catch signals term, hup, int unless we're running under windows,
# I'll need SIGCHLD for return value on fork later for database writes.
# If fork fails we'll just be pausing the main routine while writting
# databases.  No biggie, just not nice.

if($flags{os} !~ /windows/i)
	{
	$SIG{CHLD} = \&SIGDONE;
	# child will change these to return so it can finish data write
	# before exit.
	$SIG{INT} = \&cleanup; $SIG{TERM} = \&cleanup; $SIG{HUP} = \&cleanup;
	$SIG{QUIT} = \&cleanup; $SIG{KILL} = \&cleanup; $SIG{STOP} = \&cleanup;
	}
else
	{
	# windows don't like sigs, the only assurance we can provide, if that,
	# is we'll try to wait for children that are writting databases
	# and set an exit value so that the main routine can exit later.
# UPDATE: Because we're running fake fork we don't care about
# return child.  there can only be one write at a time, unlike linux
# where we can continue to fork.  So we don't really need to sig here.
#	$SIG{CHLD} = 'IGNORE';
#	$SIG{INT} = \&cleanup;
	}

# loops, if we get disconnected we wait awhile and reconnect.
while(1)
	{
	# Are we running as Win32.spoon (fakefork) ?
	if($myprocess =~ /Win32.spoon/i)
		{
		# if we ever get pipe to work I'd prolly wanna use
		# that instead.  This call should take care of any
		# needed settings.  Currently, it creates a socket,
		# waits for the parent to connect, and then closes
		# the server socket so no more connections can be
		# attempted.
		$mysock = &socketpipe;
		}
	else
		{
		$mysock = "S";
		&openport;

		# now we spawn another one of me, in the backgrownd, if
		# fakefork is enabled. we do this before we transfer any data
		# across the socket because we want our spawned process to
		# recieve a duplicate copy.  if $SPOON_S is defined then we
		# already have a forked copy and we somehow got a close() on
		# the socket but the spoon is still running.
		if($flags{fakefork} =~ /yes/i)
			{
			# a special condition is if the socket closed and
			# we have a spooned version.  We have to 'die' cos
			# we can't close $SPOON_S and get it back later.
			# I'll have to fix this at some point, I know.
			if($SPOON_S)
				{
				&writelog("PARENT - $$ - must exit, got socket close and can't dup this effect on spoon");
				# print $SPOON_S "SQUIT - Main process must exit, socket closed and can't dup pipe\n";
				close($SPOON_S);
				$SpoonObj->Kill(); # win32 kill process
				exit;
				}
			&spoon;
			}
		}

	# Send connect information to server
	&connect;

	# join and lock all services channels. at the time of this writting
	# there was only one service channel but the plan is to install
	# a facility where the admin or specified ranked opers can change
	# what types of detail are displyed in which service channels.
	&lockchans;

	# At the start of the program we set $nolog to 1 so that we
	# didn't try to send messages to the service channel before
	# our nick arrived...we can do it now.
	undef($nolog);

	# listen to the open connection for server messages
	&listen;

	# did we return from an interrupt if we're windows?
	if($exit) { exit; } # logs are already closed, can't say anything

	# ok they closed the socket on us but maybe it's a temporary
	# issue. We'll keep trying every 5 seconds
	# we'll try to connect to the socket in a few seconds

	&writelog("cleaning up hashes for loop/reconnect", 1);
	undef(%chans); undef(%nicks); undef(%opers);

	&writelog("sleeping for 5 then loop to reconnect", 1);

	sleep 5;
	}

# eh, idano, just being safe, i don't get all this sig stuff,
# it's nothing like assembly :/

exit;

}
# -------------------------------------------------------------------------
# MAKEDATA
# -------------------------------------------------------------------------
# Load command list.  Then, if the flag is set, open each command file
# and load the contents into a command hash lookup table, where we
# use the command/filename as the key and the the value is actualy
# the contents of the perl file.  We eval it when we need to run
# the command, if the flag's set.

sub makedata
{

# now load the commands and data
&runcom("admin","COMLIST");

# and the nick, chan, memo and game serv databases
# &runcom("admin","DATABASE.CONVERTER");
# &writedatabase;
# exit;
# return;

&writelog("Loading databases", 1);
if(-f "./$datadir/$chansdb") { require "./$datadir/$chansdb"; }
else { &writelog("Missing database file ./$datadir/$chansdb but that's ok I'll build one for you", 1); }
if(-f "./$datadir/$nicksdb") { require "./$datadir/$nicksdb"; }
else { &writelog("Missing database file ./$datadir/$nicksdb but that's ok I'll build one for you", 1); }
if(-f "./$datadir/$gamesdb") { require "./$datadir/$gamesdb"; }
else { &writelog("Missing database file ./$datadir/$gamesdb but that's ok I'll build one for you", 1); }
if(-f "./$datadir/$opersdb") { require "./$datadir/$opersdb"; }
else { &writelog("Missing database file ./$datadir/$opersdb but that's ok I'll build one for you", 1); }
&writelog("Database load completed", 1);

# If this was a new configuration or a new opercoms database
# we have to setup their first password for them.
if(!$opcoms{pass})
	{
	&writelog("sub makedata reports missing administrative password", 1);
	&writelog("but that's ok, I'll initialize it for you", 1);
	$opcoms{pass} = $adminpass[0];
	$opcoms{pass}{number} = 0;
	}

return;
}
# -------------------------------------------------------------------------
# DAEMON
# -------------------------------------------------------------------------
# Now go daemon if we can.  Some people might not setup the config file
# properly, or miss some things, so we check a couple flags to make
# things easier for them.  If they're under window we use the fake
# fork we created, all we do is spawn this same program in a different
# process with a parameter.. -Win32.daemon.

sub daemon
{
if( ($flags{daemon} =~ /yes/i) && ($flags{os} !~ /windows/i) )
	{
	print STDERR "$0 Going daemon...\n\n";
	&writelog("Going daemon...");

	$0 = $processname; # defined in config file

	if ($pid = fork)
		{
		exit 0;	# Parent.
		}
	elsif (defined($pid))
		{
		$pid = getpid;	# Child.
		}
	else
		{
		die "Can't fork: $!\n";
		}
	# Detach from terminal, etc.
	setpgrp(0, 0);
	close(STDIN); close(STDOUT); close(STDERR);
	# chdir("/"); # no changing dir or we won't find stuff :\
	return;
	}
elsif( ($flags{daemon} =~ /yes/i) && ($flags{os} =~ /windows/i) )
	{
	return if !$getwin32; # we checked at the top of the program

	# daemon for windows, all our data is lost but the process
	# that runs just reloads it, it's us afterall, and knows that
	# it's already daemon, it has the parameter -Win32.daemon
	&writelog("Going daemon... Win32");

	# *sigh* this is a long one
	# Fork off...heh...er..spoon off..that's more like it.
	if(!$perlpath) { die "comon...edit the config file huh?, died at perlpath variable.\n"; }

	# We need to fix the path, we've got way too many backwacks (\);
	$perlpath =~ s/\\+/\\/g;
	if(!-f $perlpath) { die "can't find your perl executable..sorry, change the variable perlpath.\n"; }

	# we'll close the logfile first
	&writelog("LOG CLOSED by PID : $$ - Switching processes", 1);
	close(LOG);

	Win32::Process::Create($SpoonObj,
	"$perlpath",
	"IRCCS $0 -Win32.daemon",	# $0 is the command line we used to
	0,				# run this, without the perl prefix
	DETACHED_PROCESS,		# That's the point, no console.
	".") || Win32DaemonError();	# They need to change some flags
	Win32::MsgBox(" IRCCS running in backgrownd,\n ctrl+alt+del to kill it or\n issue the DIE command from a server",0+0,'Win32 Daemon Mode');
	exit; # we exit this entire process, we have daemon running now.
	}
}
# -------------------------------------------------------------------------
# WIN32DAEMONERROR
# -------------------------------------------------------------------------
# Error trying to create win32 process, we'll die from here.
sub Win32DaemonError
{
print Win32::FormatMessage( Win32::GetLastError() );
print STDERR
"
- DAEMON -
You need to change your daemon or os flags cos something
weird happened when I tried to launch a sub process.  I suggest
you disable daemon mode and the fakefork flag, if it's set, unless
the error returned by that failure makes any sense to you (see above).
";
die;
}
# -------------------------------------------------------------------------
# SPOON
# -------------------------------------------------------------------------
# Fake fork.  Windows does't have a stable fork yet and we only need the
# name space duplicated, not even the socket(s), so we can write the
# databases without a pause.  I've learned quite a few things in discovering
# a solution for windows busted fork and should probably implement one or
# two of them to resolve this issue rather than a 'fake fork' but I'll look
# into that later.

sub spoon
{
if(!$getwin32)
	{
	&writelog("1: Couldn't Win32.spoon, no Win32 modules for this process");
	&writelog("2: but that's ok, I'll save databases under main process instead");
	return;
	}

&writelog("1: Spoon initiated by PID : $$ : for Win32", 1);
&writelog("2: Attempting to open a socket as a pipe to child", 1);

# ok, I've tried all sorts of pipes, ipc, even using files to set
# state on various things, reopening stdin and stdout to pass handles
# across to my child process, all of it worked, except when the parent
# goes daemon windows closes it's IN and OUT permanently and the
# file descriptors don't even work.  So, what I've decided to do is
# use a socket instead... *sigh* this just HAS to work.

# spoon a process
if(!$perlpath) { die "comeon...edit the config file huh?, died at sub spoon looking for perlpath variable.\n"; }
$perlpath =~ s/\\+/\\/g; # got too many backwacks (\)
if(!-f $perlpath) { die "can't find your perl executable..sorry, change the variable perlpath, died at sub spoon\n"; }

	Win32::Process::Create($SpoonObj,
	"$perlpath",
	"IRCCS_spoon $0 -Win32.spoon",	# $0 is the name of this program
	0,				# Pass our filehandles or not?(0)
	DETACHED_PROCESS,		# That's the point, no console.
	".") || Win32SpoonError();	# They need to change some flags

	&writelog("Win32.spoon started to mimic fork", 1);

# This is the socket to the spoon we'll talk to. We'll be the client
# because then we won't deadlock if the child process never creates
# the server side socket.  We'll loop about 10 times and then exit.
# We'll pause 1 second between connect attempts.

$SPOON_S = "SPOON_S";

&writelog("PARENT - Attempting to set socket protocal");
# setup the socket protocal
local($socket, $this, $that, $whadjewsay, $protcl) = ("Snc4x8");
$that = pack($socket, 2, $spoonport, &getaddress($spoonip));
socket($SPOON_S, AF_INET, $stream, 6) or die &writelog("PARENT - Can't socket $SPOON_S, that's strange : $!");
setsockopt($SPOON_S, SOL_SOCKET, SO_REUSEADDR, 1) or die &writelog("PARENT - setsockopt failed, do you even HAVE sockets ? : $!");

&writelog("PARENT - Client side socket looks good, trying to connect...");
$cnt = 0;
while(!connect($SPOON_S, $that))
	{
	&writelog("Server not ready, looping to try again...");
	sleep 1;
	$cnt++;
	if($cnt >= 11)
		{
		# Just to make sure everything goes down with the
		# main process use the win32 kill feature.
		$SpoonObj->Kill(0);
		Win32::MsgBox(" IRCCS PARENT\n can't connect to spooned process,\n shutting down!",48+0,"Win32.spoon Error");
		&writelog("PARENT - Tried $cnt times to connect but couldn't, maybe try again later?");
		&writelog("LOG CLOSED -");
		close(LOG);
		exit;
		}
	}
select($SPOON_S); $|=1;
select(STDOUT);	$|=1;
&writelog("PARENT - Connected to spooned process! Good.");
&writelog("PARENT - Hand Shake [sending password]");
# a little bit of security because we're using an inet socket :\
# this is just the link password, why not use it here too? Our
# client has it, we have it and it's um...already made.
print $SPOON_S "$linkpass\n";

# expect OK or close
my $line = <$SPOON_S>;
if($line !~ /OK/i)
	{
	$SpoonObj->Kill(0);
	Win32::MsgBox(" IRCCS PARENT\n Spooned process rejected our connection,\n shutting down!",48+0,"Win32.spoon Error");
	&writelog("PARENT - Spooned process rejected our connection");
	&writelog("LOG CLOSED -");
	close(LOG);
	exit;
	}
&writelog("PARENT - Child said OK, we be jammin\`");

return;
}
# -------------------------------------------------------------------------
# WIN32SPOONERROR
# -------------------------------------------------------------------------
# Error trying to create win32 process, we'll die from here.
sub Win32SpoonError
{
print Win32::FormatMessage( Win32::GetLastError() );
print STDERR
"
- SPOON -
You need to change your daemon or os flags cos something
weird happened when I tried to launch a sub process.  I suggest
you disable daemon mode and the fakefork flag, if it's set, unless
the error returned by that failure makes any sense to you (see above).
";
die;
}
# -------------------------------------------------------------------------
# SOCKETPIPE
# -------------------------------------------------------------------------
# This will create a server side socket, wait for a connetion, check the
# password sent, send OK for good password and close the server socket so
# no more connections can be attempted.  If the password is bad we'll close
# the accepted socket and continue listening for a new connection.
sub socketpipe
{
# we want to keep $SPOON_C globaly scoped but if we keep
# $SPOON_S defined we'll try to write to it during &listen,
# we can't have that.
my($uaddr, $remoteaddr, $protocol, $line, $SPOON_S);
$SPOON_S = "SPOON_S"; # server handle
$SPOON_C = "SPOON_C"; # client handle

# $spoonport and $stream are already set in
# the config file, it's here only for example.
# $spoonport = "8123";
# $stream = 1;

# set rights so we, as child, can write to log etc.
$myrights{log} = 1; $myrights{display} = 1;

&writelog("CHILD - $$ - attempting to open port for listen");
$uaddr = sockaddr_in($spoonport, INADDR_ANY);
$protocol = getprotobyname('tcp');
socket($SPOON_S, PF_INET, SOCK_STREAM, $protocol)
	or die &writelog("socket : $!");
setsockopt($SPOON_S, SOL_SOCKET, SO_REUSEADDR, pack("l", 1))
	or die &writelog("can't setsockopt: $!\n");
bind($SPOON_S, $uaddr)
	or die &writelog("bind: $!");
listen($SPOON_S, SOMAXCONN)
	or die &writelog("listen: $!");
&writelog("CHILD - $$ - Great! The socket's good, listening...");
select($SPOON_S); $|=1; select(STDOUT); $|=1;

while($line ne $linkpass)
	{
	# block until we get a connection
	$remoteaddr = accept($SPOON_C, $SPOON_S);

	## JUNK
	# Just some junk to see who connected, we realy don't need it
	# except for the accept, but we don't need to assign the result
	# of accept to anything. We just wanna know who's talking to us.
	my($port,$iaddr) = sockaddr_in($remoteaddr);
	my $name = gethostbyaddr($iaddr,AF_INET);
	my $logline  = "connection from $name [";
	   $logline .= inet_ntoa($iaddr);
	   $logline .= "] at port $port";
	&writelog($logline, 1);
	undef($logline);
	##!JUNK

	select($SPOON_C); $|=1; select(STDOUT); $|=1;
	$line = <$SPOON_C>;
	$line =~ s/\n|\r//g; # get rid of all the nonsense
	if($line ne $linkpass)
		{
		&writelog("CHILD - $$ - Bad password [$line], connection closed!");
		close($SPOON_C); # don't close before or parent will kill us
		}
	}

print $SPOON_C "OK\n"; # send OK, so parent can move on
&writelog("CHILD - $$ - Got good password, we're linked!");
&writelog("CHILD - $$ - Closing listen socket, no more connections");
close($SPOON_S); # close the server socket, no more connections.

# don't want duplicate info in log and/or on console
delete($myrights{log}); delete($myrights{display});

return $SPOON_C; # caller expects handle to put into $mysock
}
# -------------------------------------------------------------------------
# WRITELOG
# -------------------------------------------------------------------------
# This just checks the flags for log and if it's set, we'll log everything
# to the log file.  There are several levals of loging indicated using
# numbers.  There's full, 0 for none or null, 1 for basic reports like
# system errors, services linkup failure, attempted hacks..etc..
# it's explained in the config file. Loging must be engaged first
# before we can check the level.
#
# OPTIONS: 0 / 1 / 2 / 3
# Variables already set and required:
#	$_[0]		-	Text for logging
#	$_[1]		-	Log level
#
# NOTE: We now call display from writelog.. it makes it easier
# and we only need to check level once.  We'll also sendtochan
# here when we're ready to install that. We do this because all
# loging, display and channel activity has the same loglevel.

sub writelog
{
# if set to 0 then loging is off

if($flags{loglevel} == 0) { return; }

if( ($_[1]) && ($flags{loglevel} >= $_[1]) )
	{
	if($flags{log} =~ /on/i)
		{
		# Don't write to anything if you're a forked copy
		# and access rights disabled.
		if( ($myprocess =~ /Win32.spoon/i)
			&& (!$myrights{log}) ) { return; }

		chop($date = localtime(time));
		print LOG "$date - $_[0]\n"; # we stripped the \n earlier
		}
	if($flags{display} =~ /on/i)
		{
		# Don't write to anything if you're a forked copy
		# and access rights disabled.
		if( ($myprocess =~ /Win32.spoon/i)
			&& (!$myrights{display}) ) { return; }

		&display($_[0]);
		}
	if($flags{watch} =~ /on/i)
		{
		# it won't send to chan if Win32.spoon, we can't
		&sendtochan($_[0]);
		}
	}
# if we got logs enabled and no level sent to us,
# we assume high priority.
elsif(!$_[1])
	{
	if($flags{log} =~ /on/i)
		{
		# Don't write to anything if you're a forked copy
		# and access rights disabled.
		if( ($myprocess =~ /Win32.spoon/i)
			&& (!$myrights{log}) ) { return; }

		chop($date = localtime(time));
		print LOG "$date - $_[0]\n"; # we stripped the \n earlier
		}
	if($flags{display} =~ /on/i)
		{
		# Don't write to anything if you're a forked copy
		# and access rights disabled.
		if( ($myprocess =~ /Win32.spoon/i)
			&& (!$myrights{display}) ) { return; }

		&display($_[0]);
		}
	if($flags{watch} =~ /on/i)
		{
		# it won't send to chan if Win32.spoon, we cant
		&sendtochan($_[0]);
		}
	}
}
# -------------------------------------------------------------------------
# DISPLAY
# -------------------------------------------------------------------------
# Just so we don't have to keep typing this 'if' thingie, if the flag
# is set we send this to console, but not if we went daemon.
# Also, if the 'watch' flag is set we send to the watch channel.
#
# OPTIONS: (none)
#
# Variables already set and required:
#	$_[0]		-	The text to send
#
# NOTE: We've alredy done the level checking and the display flag.
# This routine should only be called by &writelog, which also calls
# &sendtochan .  Special cases are ping/pong where loging this
# would be silly, as well as other trivial data and special case
# in-line debugging.

sub display
{
if($flags{display} !~ /on/i)
	{
	return; # silently
	}
if(!$_[0])
	{
	return;
	} # nothing to do

# if we're daemon we can't display to console
if($flags{daemon} !~ /yes/i)
	{
	# daemon means we set the daemon flag and we cant display
	print STDOUT "$_[0]\n"; # we stripped the \n earlier
	}
}
# -------------------------------------------------------------------------
# SENDTOCHAN
# -------------------------------------------------------------------------
# This just sends the text that's in $_[0] to the watch channel, usualy
# #services . We've already done all of the checking.  This routine should
# only be called by &writelog, which also calls &display
#
sub sendtochan
{
# Don't try to write to non-existant socket if you're a spooned copy
if($myprocess =~ /Win32.spoon/i) { return; }

# $nolog was set when someone messaged $opernick with the AUTH command.
# we don't send this to the channel but we did log it and/or display
# it if that was enabled...we were, after all, called by &writelog.
if($nolog) { return; }
# this variable set means we have an open socket. if we didn't
# we couln't use the 'send' sub routine.
if(!$connect) { return; }

# for now, we'll just use the 0 element channel. I'm not sure how I'm
# going to distribute the tasks across channels yet.

&send(":$watch{$watch[0]}{nick} PRIVMSG $watch[0] :$_[0]\n");
}
# -------------------------------------------------------------------------
# CLEANUP
# -------------------------------------------------------------------------
sub cleanup
{
# we save files here and stuff so we don't forget what people said and
# we log why we died.
&writelog("got exit signal, shutting down...", 1);

# are there any pending children? We don't want a corrupt database
while(%pidlist)
	{
	&writelog("Child pending, waiting for zombie, sleeping for 5...", 1);
	sleep 5; # exits before 5 if child returns, unless windows?
	}
# reset interrupt on windows
if($flags{os} =~ /windows/i)
	{
	$SIG{INT} = 'DEFAULT';
	# indicate to any routine that checks this that we're ready for exit.
	$exit = 1;
	&writelog("Windows: this may take a minute... Control+C again to SHUTDOWN NOW but data may be corrupted if you do", 1);
	&writelog("LOG CLOSED -\n", 1);
	close(LOG);
	return; # don't exit, windows don't like it.
	}
&writelog("LOG CLOSED -\n", 1);
close(LOG);

# if not windows we can probably get out now.
exit 0; # must exit or zombie
}
# -------------------------------------------------------------------------
# LOCKCHANS
# -------------------------------------------------------------------------
# This sub routine will make DeckLeader join and lock all
# Services channels so people can't join and see delicate info.
sub lockchans
{
my($keychan, $i);

# first lowercase all the channel names and return them back to
# the hash in lowercase keys.

%temphash = %watch;
undef(%watch);
foreach $keychan (keys %temphash)
	{
	$i = &dcase($keychan);
	$watch{$i} = $temphash{$keychan}; # transfer it over
	}
undef(%temphash);

# now join, lock, mode all the channels in our hash

my($time) = time;
my($tempnick, $modes, $topic);
foreach $keychan (keys %watch)
	{
	# make the nick
	# ok, this looks weird but here's what's going on, we need to save
	# the entire block in our hash so if the nick get's killed off the
	# server we can just eval the key to bring it back and place it on
	# it's channel's etc.
	$tempnick = lc($watch{$keychan}{nick});
	$modes = $watch{$keychan}{modes};
	$topic = $watch{$keychan}{topic};
	$server{nicks}{$tempnick} = qq(
	&send("NICK $tempnick 0 0 $servuser $servhost $services  :Service Administration\n");
	&send(":$tempnick JOIN $keychan\n");
	&send(":$tempnick MODE $keychan $modes\n");
	&send(":$tempnick TOPIC $keychan :$topic\n");
	);
	# the actual code that does it
	eval($server{nicks}{$tempnick});
	}

}
# -------------------------------------------------------------------------
# RUNCOM
# -------------------------------------------------------------------------
# Just open, read and eval a perl file, i.e. run it.
sub runcom
{
unless (open THISCOM, "<./$_[0]/$_[1]")
	{
	&writelog("ERROR: &runcom reports error opening $_[1]");
	return;
	}
undef $/; $someperl = <THISCOM>; close(THISCOM);
$/ = "\n"; eval($someperl); undef($someperl);

if($@)
	{
	# show any errors during interpretation
	&writelog("RUNCOM reports error in $_[0]/$_[1] : $@");
	}
}
# -------------------------------------------------------------------------
# LOADCOM
# -------------------------------------------------------------------------
# Command loader.  After a command line, message, has been parsed and the
# appropriate command determined, the line/path is passed to this routine
# so that it can be opened, eval'd and then released.  The alternative
# is to set the appropriate flag in the config file.  You may also
# issue an administrative command on a running system to dump the commands
# and revert to disk based running, for debuging and creation of commands,
# or load the commands to make the system run faster and more efficient.

# Now, for a peculiarity... if there's a directory like SET under
# chanserv and they type /msg chanserv SET
# what's gonna happen?  Well, we'd check to see if that command existed
# in our hash and it would exist, but when we tried to execute it we'd
# fail.  So how do we fix this?  Under each sub directory there's a
# file/command by the name DIR.DIR with brief instructions on what to do
# next, i.e. <Nickserv> /msg NickServ HELP SET for more info.
#
# OPTIONS: (none)
# Variables already set and required:
#	$goodcom	-	Command line dir structure

sub loadcom
{
my($lines);

# TEST
# print STDOUT "PARM:$goodcom:\n";
#!TEST

if(!(open COMS, "<$comdir/$keydir/$goodcom"))
	{
	&send(":$servnick NOTICE $nick :Whoops, something weird	happened.\n");
	&send(":$servnick NOTICE $nick :Please contact an irc Operator\n");
	&send(":$servnick NOTICE $nick :and tell them that loadcom failed.\n");
	&send(":$servnick NOTICE $nick :Tell them what command you attemped to use.\n");
	return;
	}
undef $/;
$lines = <COMS>;
close(COMS);
$/ = "\n";
eval($lines);
undef($lines);
# if we got errors on eval, the file we loaded, say something.
if($@)
	{
	&writelog("eval error while loadcom tried to process $goodcom : $@");
	} # if errors in loaded eval, say so.
}

# -------------------------------------------------------------------------
# LOADCTCP
# -------------------------------------------------------------------------
# Like LOADCOM
#
# OPTIONS: (none)
# Variables already set and required:
#	$goodcom	-	Command line dir structure
sub loadctcp
{
my($lines);

if(!(open COMS, "<ctcp/$goodcom"))
	{
	&send(":$servnick NOTICE $nick :Whoops, something weird	happened.\n");
	&send(":$servnick NOTICE $nick :Please contact an irc Operator\n");
	&send(":$servnick NOTICE $nick :and tell them that loadctcp failed.\n");
	&send(":$servnick NOTICE $nick :Tell them what command you attemped to use.\n");
	return;
	}
undef $/;
$lines = <COMS>;
close(COMS);
$/ = "\n";
eval($lines);
undef($lines);
# if we got errors on eval, the file we loaded, say something.
if($@)
	{
	&writelog("eval error while loadctcp tried to process $goodcom : $@");
	} # if errors in loaded eval, say so.
}
# -------------------------------------------------------------------------
# LOADDEFAULT
# -------------------------------------------------------------------------
# We get here as a result of them having typed just a directory name.
# It's seamless because the code is contained in the hash itself to come
# here.  But from here we'll open the default file for that directory, if
# they have commands dumped, or we never got here in the first place.
# If that command doesn't exist we load a default default *sigh*.
sub loaddefault
{
my($lines);
if(!(open COMS, "<$comdir/$keydir/$goodcom/DIR.DIR"))
	{
	# try the default default, if it didn't exist at runtime
	# we wouldn't have loaded anyways.
	if(!(open COMS, "< $comdir/DIR.DIR"))
		{
		# if that failed someone deleted the file during runtime or
		# deleted an original command. Just get out.
		&send(":$servnick NOTICE $nick :Whoops, something weird happened.\n");
		&send(":$servnick NOTICE $nick :Please contact an irc Operator\n");
		&send(":$servnick NOTICE $nick :and tell them that loaddefault failed.\n");
		&send(":$servnick NOTICE $nick :Tell them what command you attemped to use.\n");
		return;
		}
	}
undef $/;
$lines = <COMS>;
close(COMS);
$/ = "\n";
eval($lines);
undef($lines);
# if we got errors on eval, the file we loaded, say something.
if($@)
	{
	&writelog("eval error while loadcom tried to process $goodcom\/DIR.DIR : $@");
	} # if errors in loaded eval, say so.
}
# -------------------------------------------------------------------------
# LOADHELP - *DISABLED* This doesn't function yet, it's here for future work
# -------------------------------------------------------------------------
# We get here as a result of them having typed the $helpcom along with
# the command structure.  It's used by the command hash and installed into
# that hash using the COMLIST file under ./admin
# If that command doesn't exist we load a default help file.
sub loadhelp
{
my($lines);
if(!(open COMS, "<$comdir/$keydir/$goodcom/DIR.HELP"))
	{
	# try the default help, if it didn't exist at runtime
	# we wouldn't have loaded anyways.
	if(!(open COMS, "< $comdir/DIR.HELP"))
		{
		# if that failed someone deleted the file during runtime or
		# deleted an original command. Just get out.
		&send(":$servnick NOTICE $nick :Whoops, something weird happened.\n");
		&send(":$servnick NOTICE $nick :Please contact an irc Operator\n");
		&send(":$servnick NOTICE $nick :and tell them that loadhelp failed.\n");
		&send(":$servnick NOTICE $nick :Tell them what command you attemped to use.\n");
		return;
		}
	}
undef $/;
$lines = <COMS>;
close(COMS);
$/ = "\n";
eval($lines);
undef($lines);
# if we got errors on eval, the file we loaded, say something.
if($@)
	{
	&writelog("eval error while loadhelp tried to process $goodcom\/DIR.HELP : $@");
	} # if errors in loaded eval, say so.
}
# -------------------------------------------------------------------------
# UCASE
# -------------------------------------------------------------------------
# Just convert the passed parameter to uppercase and pass it back
# This won't effect the original paramater passed so you have to use
# $something = &ucase($somethingelse);
sub ucase
{
my($i);
$i = uc($_[0]);
return $i;
}
# -------------------------------------------------------------------------
# DCASE
# -------------------------------------------------------------------------
# same as above, only reversed
sub dcase
{
my($i);
$i = lc($_[0]);
return $i;
}
# --------------------------------------------------------------------------
# CHECKMASK
# --------------------------------------------------------------------------
# Perfectly checks one string against another, using * as global character.
# *!*@*.aol.com against bobie!~user1@AAAFAAD434.ipt.aol.com would match.
#
# Apparently you can use a ? for a single character in a ban.  hmm..
# I have no clue what will happen then.  I may chose to fix this later
# if it shows up with bugs.
# 
# OPTIONS: (none)
# Variables already set and required:
#	$_[0]		-	original text ( nick!user@host )
#	$_[1]		-	mask ( *!*@*.aol.com )
#
sub checkmask
{
my($mask);

# so it's readable
$orig = $_[0]; $mask = $_[1];

# Find global character and replace it with expression that means
# the same in perl.
$mask =~ s/\*/\.\*\?/g;

# Tell perl that, last match matches end, and, first match matches first,
# NOT, first match matches 'first match', or 'aol.com' will match
# 'ANYTHING.AT.ALL.aol.com' and user1 will match user1.ANYTHING.AT.ALL.COM
$mask = "^".$mask."\$";

# now see if it's a match
if($orig =~ /$mask/i)
	{
	# It matched! Return true.
	return 1;
	}
return; # return false
}
# --------------------------------------------------------------------------
# ISAUTHCHAN
# --------------------------------------------------------------------------
# Checks to see if the number matches or is greater than access rank.
# A rank number is sent as a parameter and compared with the
# channel access list ranks for the nick.
##
# OPTIONS: (none)
#
# Variables already set and required:
#	$_[0]		-	access number they need to be, or above
#	$_[1]		-	the lowercase nickname as key
#	$_[2]		-	the lowercase channel name as key
#
sub isauthchan
{
my($keynick, $keychan) = ($_[1], $_[2]);
my($ident, $ranknick, $rank1, $rank2);
$rank2 = 50; # so it don't match anything

# check owner first, that's the highest level, we don't want to check lower
# or we may never get high access if we added both for some strange
# reason. We return true and 2 for owner, only true for others or 1,
# and 0 or not, for no access.

return undef, 2 if $nicks{$keynick}{ident}{chans}{$keychan};

# the owner of the channel has the right to suspend authentication
# for the channel commands for a time. This is so that the owner can
# deal with an abuse issue, if ranks are being deligated and reassigned
# faster then he can deal with it, he simply suspends, changes ranks,
# access and action and then resumes the channel again. Here's where
# we test for that since all commands need to come here for auth if
# their not owner, and even then for most.

if(defined($rchans{$keychan}{suspend}))
	{
	$text = qq~
	[ SUSPENDED ] The channel $rchans{$keychan}{chan} is currently 
	in suspend mode and is not authenticating nicks for 
	restricted command access. This is a temporary setting 
	and is used to deal with abuse issues. The owner of the 
	channel	had the following words to add [$rchans{$keychan}{suspend}]~;
	&sendtext($text, "\n", "\t");
	return;
	}

return undef, 1 if ($_[0] == $lowrank); # all get access on low rank

# Is the channel registered? most, if not all, of the commands that
# require access also check registered, this is here in case we forgot
# some commands.

if(!$rchans{$keychan})
	{
	# not registered;
	return undef, 0; # return no access
	}
# the $keynick may not be registered but they'll have an ident list.
# we'll recurse through that and see if any of those nicks have access
# on this channel.

foreach $ident (keys %{$nicks{$keynick}{ident}{nicks}})
	{
	# iterate through all their ident nicks, we want to find
	# the best rank if they have two nicks with differing ranks
	# on the same channel access.

	# DAN, you think it would be quicker to just set a rank on the
	# $nicks hash? It's kinda late to change this.

	if($rchans{$keychan}{access}{nicks}{$ident})
		{
		# check timestamp to see if they droped nick before
		if($rnicks{$ident}{timestamp} ne $rchans{$keychan}{access}{nicks}{$ident}{timestamp})
			{
			# clean it up..we'll never use it again.
			delete($rchans{$keychan}{access}{nicks}{$ident});
			next;
			}
		$rank1 = $rchans{$keychan}{access}{nicks}{$ident}{rank};
		# if this is a better rank, save it.
		if($rank1 < $rank2)
			{
			# save this rank
			$rank2 = $rank1;
			# remember the keynick
			$ranknick = $ident;
			}
		}
	}
# now, if $rank1 is still 50 we never found anything or maybe
# never entered the loop, either way we return false

if($rank1 == 50)
	{
	# never matched
	return undef, 0;
	}
# must use compare operator so no null match can be made
if( ($rank2 <=> $_[0]) =~ /-1|0/)
	{
	# send yes, rank number and keynick
	# always put return code last
	return $rank2, 1;
	# return 1;
	}
# got this far, entered loop but no match, return false.
return undef, 0;
}
# --------------------------------------------------------------------------
# ISAUTHGAME
# --------------------------------------------------------------------------
# Checks to see if this nick has access to the basic game list for
# the indicated channel.  It will recurse through their identified
# list for a nick that matches the game or simply return true if
# they've identified as the channel owner.

##
# OPTIONS: (none)
#
# Variables already set and required:
#	$_[0]		-	the lowercase nickname as key
#	$_[1]		-	the lowercase channel name as key
#
sub isauthgame
{
my($keynick, $keychan) = ($_[0], $_[1]);
my($ident);

return 2 if $nicks{$keynick}{ident}{chans}{$keychan};

# if there's ever a reason to pass a nick that might not be
# on the system we don't want to create the key accidently.
return 0 if !$nicks{$keynick};

# paranoid but hey, you never know
return 0 if !$rchans{$keychan};

foreach $ident (keys %{$nicks{$keynick}{ident}{nicks}})
	{
	# itterate through all their ident nicks, we want to see
	# if any of their registered nicks are in this channels
	# gamelist.
	if($rchans{$keychan}{game}{nicks}{$ident})
		{
		return 1;
		}
	}
return 0; # no go

}
# --------------------------------------------------------------------------
# ISAUTHOPER
# --------------------------------------------------------------------------
# This tests to see if a particular user has access, or partial access, to
# a particular command in the operator service. When they move their nick
# the access follows them in $opers so we only need to check the rank
#  key on that.
##
# OPTIONS: (none)
#
# Variables already set and required:
#	$_[0]		-	access number they need to be, or above
#	$_[1]		-	the lowercase nickname as key
#
sub isauthoper
{
my($rank, $keynick) = ($_[0], $_[1]);

# not op, this shouldn't be able to happen because we only call this
# routine from a command and they can only run commands if they're
# oper.  Flag this is a bug.
if(!$opers{$keynick})
	{
	&writelog("HACK: sub isauthoper reports commands access by $keynick but not oper");
	return;
	}

$rank = $opers{$keynick}{rank};

# check for administrator
return 2 if $opers{$keynick}{rank} eq "admin";

# the system admin can suspend access to operserv.
# is it suspended right now?

if(defined($opcoms{suspend}))
	{
	$text = qq~
	[ SUSPENDED ] $opernick is currently 
	in suspend mode and is not authenticating nicks for 
	restricted command access. This is a temporary setting 
	and is used to deal with abuse issues.~;
	&sendtext($text, "\n", "\t");
	return;
	}

# must use compare operator so no null match can be made
if( ($rank <=> $_[0]) =~ /-1|0/)
	{
	# send yes and rank number
	# ** that didn't work, return only true or false
	# return $rank, 1;
	return 1;
	}
# got this far, entered loop but no match, return false.
return 0;
}
# --------------------------------------------------------------------------
# REGCHAN
# --------------------------------------------------------------------------
# This just tests to see if the channel is registered,...oh but there's 
# much much more...actually it's here because I'm tired of typing out
# the command each time and the text telling them it's not registered.
# Now that it's here we can just change the text if we like and it will
# change all the replies to "not registered"
sub regchan
{
if(!$rchans{$_[0]})
	{
	$text = qq~
	Channel $_[0] is not registered. You can register it, 
	if you want, using the following command, /msg $servnick 
	REGISTER $_[0] <password> [ where password is anything you 
	like for your security code which protects your channel against 
	unauthorised changes ].~;
	&sendtext($text, "\n", "\t");
	return;
	}
return 1; # say it's registered.
}
# --------------------------------------------------------------------------
# OPENPORT
# --------------------------------------------------------------------------
sub openport
{
local($socket, $this, $that, $whadjewsay, $protcl) = ("Snc4x8");

$that = pack($socket, 2,$port, &getaddress($mainlink));
socket($mysock,AF_INET,$stream, 6) or die "Can't open socket S: $!\n";
setsockopt($mysock, SOL_SOCKET, SO_REUSEADDR, 1) or die "setsock failed: $!\n";
connect($mysock, $that) or die "Can't connect: $!\n";
select($mysock); $|=1;
select(STDOUT);	$|=1;
}
# --------------------------------------------------------------------------
# GET ADDRESS
# --------------------------------------------------------------------------
sub getaddress
{
local($hostname) = @_; local(@returned); @returned = gethostbyname($hostname);
return(unpack("C4",$returned[4]));
}
# --------------------------------------------------------------------------
# CONNECT
# --------------------------------------------------------------------------
# Send server connect information for server and nicks
sub connect
{
$servnote = "Copyright (c) 1995 - 2000 Daniel J. Wightman";
$starttime = time();
$timestamp = $starttime;
&send("PASS $linkpass\n");
&send("SERVER $services 1 :$servnote\n");

# now send all our nicknames
# we need to save each line in a hash so that we can just eval it later
# in the event that someone kills one of our nicks off the server, we
# can get it back. After we save each line we'll eval it from the hash
# to activate it.

$tempnick = lc($opernick); $server{nicks}{$tempnick} = '
&send("NICK $opernick 0 0 $servuser $servhost $services :IRCop SilverWare\n");
'; eval ($server{nicks}{$tempnick});

$tempnick = lc($channick); $server{nicks}{$tempnick} = '
&send("NICK $channick 0 0 $servuser $servhost $services :Channel Registration Service\n");
'; eval ($server{nicks}{$tempnick});

$tempnick = lc($nicknick); $server{nicks}{$tempnick} = '
&send("NICK $nicknick 0 0 $servuser $servhost $services :Nickname Registration Service\n");
'; eval ($server{nicks}{$tempnick});

$tempnick = lc($memonick); $server{nicks}{$tempnick} = '
&send("NICK $memonick 0 0 $servuser $servhost $services :Memo Delivery Service\n");
'; eval ($server{nicks}{$tempnick});

$tempnick = lc($gamenick); $server{nicks}{$tempnick} = '
&send("NICK $gamenick 0 0 $servuser $servhost $services :Channel Game Utensils\n");
'; eval ($server{nicks}{$tempnick});

# say we're connected now, when the socket closes we undef this which
# prevented &sendtochan from trying to...well..send to chan.
$connect = 1;
}
# --------------------------------------------------------------------------
# LISTEN
# --------------------------------------------------------------------------
# Listen to messages from the server or, if we're spoon, from parent.
#
sub listen
{
 while(<$mysock>)
	{
	# Only set this if we spooned a copy
	if($SPOON_S) { print $SPOON_S $_; } # spoon has duplicate info now

	$sockets{$mysock}{buffer} = $_; # save it

	# DAN !
	# we might want to put in a timer, how often
	# do we check timers, since we can't rely on ping
	# because there's no ping if there's constant
	# activity, apparently, and we'll just keep
	# runing sub timers on each message.  That's
	# a little sloppy.

	# check timers (nickserv kill, database write)
	&timers;

	# did our uplink ping us?
	if(($_ =~ /^PING/i) && ($_ !~ /TIMEOUT/i))
		{
		&send("PONG :$uline\n");
		$sockets{$mysock}{buffer} = ""; # clean it out
		}

	# if this were a different socket routine we might use
	# parse $handle, after having recursed over a list of
	# handles that may have said something.  Then, we'd pass
	# the handle to this routine and the routine would read
	# the buffer associated with that particular handle.
	else
		{
		&parse($mysock);
		}
	}
# If we're a spooned copy we have to exit, we can't dup
# this effect on a fake fork... well... we can but I'm not
# going to today.  I'll leave that for maintainance release,
# if anyyone ever finds a use for this service in the first place.
if($myprocess =~ /Win32.spoon/i)
	{
	$myrights{log} = 1;
	$myrights{display} = 1; # because one day we'll have a window for it
	&writelog("CHILD - $$ - parent closed our connection, exiting.");
	&writelog("LOG CLOSED -");
	exit;
	}
 
# if we got this far the socket closed.
undef($connect); # so sendtochan doesn't try to send
&writelog("Socket closed $_");
close($mysock); # idano, just being neat

# let's write the database before we exit
# &writedatabase; # no, this kills our sleep before loop, don't like that

# return to caller and we'll loop.  caller cleans up
# hashes and re-establishes connection.


}
# -------------------------------------------------------------------------
# PARSE
# -------------------------------------------------------------------------
# This routine parses the data we've stored in the sockets buffer.
##

sub parse
{
my(@buffer, $line);
# split at \n and save the rest in the same buffer for later processing

# hmm.. it doesn't work, it puts all, even the last line without a \n,
# into the @buffer.  but we don't use the sysread anymore so we'll just
# kludge something in here.
##(@buffer, $sockets{$_[0]}{buffer}) = split(/\n/, $sockets{$_[0]}{buffer});

# NEW
# This is functional..do not remove it.. we just don't want to
# lose the old idea, even though the implementation didn't work.
$line = $sockets{$_[0]}{buffer};
$sockets{$_[0]}{buffer} = "";
$line =~ s/\r//g;
&engine($line);
return;
#!NEW


# for each \n we had a line we need to process for this trip
foreach $line (@buffer)
	{
	# Get rid of the \r, dos does this to us if the server is
	# running under dos
	$line =~ s/\r//g;

	# This is where it all happens.  We examine the line to see who
	# they where talking to, who spoke and what they wanted.  This
	# will also handle ctcp requests and hand off control to various
	# subroutines depending on the source, action and/or command.
	&engine($line); # go see if we need to say anything and save and learn

	}

}

# -------------------------------------------------------------------------
# ENGINE
# -------------------------------------------------------------------------
# This is where we parse and pass off.
sub engine
{

# get the message passed to us.
$msg = $_[0];
$msg =~ s/\n$//; # get rid of the trailing NewLine

$rawmsg = $msg; # save it for later, we might need it again after a split

# Split this into segents, ignore multiple spaces untill piece 4,
# were there might be parmaters that require spaces.
($who, $action, $target, $msg) = split(/\s+/, $msg, 4);

# setup keys that we'll use later
$nick = $who;
$nick =~ s/^://;
$keynick = &dcase($nick);
$keychan = &dcase($target); # not always target but for most stuff yes.
$keychan =~ s/^://; # Nick sent joins make :#somechan ( a colon )

# let's check first for the most abundant of commands, PRIVMSG.  This
# will be more efficient.  We'll check for messages/commands in order
# of frequency.  Well, we'll give it a shot.

# Check for client message in second segment of message.
# If the command was the FIRST segment we check that later.
# A "NICK somenick someother stuff here" is an example where
# a user is introduced to the server and NOT a nick change.

$action = &ucase($action);

# high priority write, I don't want to cluter my code up with
# writes...one for high and one for privmsg.  I think that'll
# do it.
# &writelog($rawmsg); # CAN'T DO THIS HERE OR sendtochan WILL SEE AUTH PASS

if($action eq "PRIVMSG") { &privmsg; } # parse commands
elsif($action eq "NICK")
	{ # move nick, check nickserv
	# $nick isn't set if it was a nick change, do it here
	# since we use it in other routines like &sendtext
	$nick = $target;
	# if we came here $keychan is actually the lowercase nick
	$destnick = $keychan; # it's just that way, make it readable
	&nick($keynick, $destnick ); # this indicates a nick change
	}
# squit before quit or flase reading? if it's squit we can't write to
# the socket again or we'll get a pipe error and die so unset $connect
# or &sendtochan will try to write to the socket.
elsif($msg =~ /^SQUIT\s+$services/)
	{
	undef($connect);
	&writelog("GOT SQUIT !");
# ###############################
=head
	# if we get squited and return, we'll show our link password
	# in the services admin channel on level 3.
	if($flags{loglevel} > 2)
		{
		$temp1 = $flags{loglevel};
		$flags{loglevel} = 2; # set lower level before recon
		# save a backup copy so we can restore it later
		$flags{loglevel}{backup} = $temp1;
		}
=cut
# I X out the password now
# ################################
	return;
	}
elsif($who =~ /^PASS/)
	{
	# hide the remote link password
	$rawmsg =~ s/(^pass :).*/$1xxxxxxxxxx/gi;
	}
elsif($action eq "QUIT") { &quit($keynick); } # remove nick/user
elsif($action eq "KILL")
	{
	# it's usualy :$keynick QUIT : reason
	# but this nick was killed so it's
	# :keynick KILL $keychan : reason
	# so $keychan was $target, it's really the nick in this case
	# in lowercase format.
	##
	# did they kill one of us?
	if($server{nicks}{$keychan})
		{
		# tell everyone
		$nolog = 1; # don't send to chan or loop results
		&writelog("abuse recovery: $nick killed service nick [$keychan], recovering...");
		&send("WALLOPS :$nick killed a service nick [$keychan]\n");
		&send("GNOTICE :$nick killed a service nick [$keychan]\n");

		# reconnect our nick before we quit the oper, cos only oper
		# can 'kill' and that means the $msgnick will try to wallop.
		# if that happens the server sends a ghost kill and $msgnick
		# dies the first time it speaks, that happens if the nick
		# they killed was $msgnick. The best thing to do is to kill
		# the offender first but we just can't do that here.
		# get our service nick back
		eval($server{nicks}{$keychan}); # this is actualy a nick here

		# remove the offender
		# was the offender a service nick itself? We don't want
		# to kill OperServ do we?
		if(!$server{nicks}{$keynick})
			{
			&send("KILL $nick :Trampoline Hexified!\n");
			&quit($keynick); # remove the nick we just killed
			}
		undef($nolog);
		return; # no need to quit ourselvs right?
		}
	&quit($keychan);
	} # remote link shows KILL not QUIT
elsif($action eq "JOIN") { &join($keynick, $keychan); } # add nick to chan hash and check chanserv
elsif($action eq "PART") { &part($keynick, $keychan); } # remove user from channel
elsif($action eq "KICK")
	{
	# get the kicked nick, we don't need $keynick or kicker nick
	($keynick) = split/\s+/, $msg;
	$keynick = &dcase($keynick);
	&part($keynick, $keychan);
	} # remove user from channel
elsif($action eq "MODE") { &mode; } # go do lots of mode stuff
elsif($action eq "TOPIC"){ &topic($keynick, $keychan); } # set channel topic, check chanserv
elsif($rawmsg =~ /^NICK/){ &user; } # nick joins server, check nickserv

# it all falls through so I can display the message after the fact and
# just remove the password one.

# we'll check $nolog in sendtochan only, it was set by using AUTH command
&writelog("$rawmsg", 3);

# we're done when we get back, we need to unset it to continue loging
undef($nolog);

}
# --------------------------------------------------------------------------
# PRIVMSG
# --------------------------------------------------------------------------
# Recieved a PRIVMSG formated line.  The commands are in $msg along with parms
# $who, $action, $target, $msg
sub privmsg
{

# we don't want duplicate lines in our log so check that we didn't already
# write using the caller, and if there's no 3 then we DIDN'T, so let's
# do it here, otherwise we already logged this info.
if($flags{loglevel} < 3)
	{
	&writelog($rawmsg, 2);
	}
# since we know it's a private message we expect the : delimiter in
# the message itself, let's get rid of it.
$msg =~ s/^://;

# $keynick = &dcase($nick); # for hashes # WE DID IT ALREADY!

# Test to see what service they're talking to.
# We don't respond to messages destined for anything else.
   if($target =~ /$nicknick/i) { $servnick = $nicknick; }
elsif($target =~ /$channick/i) { $servnick = $channick; }
elsif($target =~ /$memonick/i) { $servnick = $memonick; }
elsif($target =~ /$gamenick/i) { $servnick = $gamenick; }
#elsif($target =~ /$killnick/i) { $servnick = $killnick; }
elsif($target =~ /$opernick/i)
	{ # $opernick special case, check for access.
	$servnick = $opernick;

	# check for 'auth' command and password first
	($temp1, $temp2) = split /\s+/, $msg, 2;
# ====================================================
# Windows "fork()" bug, see below
# ====================================================
	if(&dcase($temp1) eq "auth")
		{
		# set a variable so that when we return our caller won't
		# log this command line or all nicks will see it in the
		# service channel
		$nolog = 1;
		if($temp2 ne $opcoms{pass})
			{
			# bad password, tell all current ops so someone
			# comes to the rescue if they're trying to hack
			foreach $temp1 (keys %opers)
				{
				&send("NOTICE $temp1 :$nicks{$keynick}{nick} attempted to authenticate but failed\n");
				}
			&send(":$servnick NOTICE $nick :Nope, try again.\n");
			return;
			}
		else
			{
			&send(":$servnick NOTICE $nick :Password accepted! You now have\n");
			&send(":$servnick NOTICE $nick :administrative access to services.\n");
			&send(":$servnick NOTICE $nick :The password has been changed.\n");
			&writelog("SERVICES ADMINISTRATIVE ACCESS ENGAGED FOR $nick", 1);
			$opers{$keynick}{rank} = "admin";

			# is there another password in this list to rotate to?
			if($adminpass[$opcoms{pass}{number}+1])
				{
				# reuse variables
				$temp2 = $opcoms{pass}{number}+1;
				}
			else
				{
				$temp2 = 0;
				}
			$opcoms{pass} = $adminpass[$temp2];
			$opcoms{pass}{number} = $temp2;
# ====================================================
# Windows fork() bug
# [ Application : ActiveState Perl v5.6.0.620 binary dist. for win95/32 ]
# [ Archive name: ActivePerl-5.6.0.620-MSWin32-x86-multi-thread.msi ]
# ====================================================
# Also see below, ACTIVEPERL BUG, where I've actualy changed code to fix this.
# ====================================================
# Bizarre SvTYPE [205]
##
# I can prevent this bug by running another command before
# the DUMP command or simply removing this "foreach".  So far
# I haven't found a sane solution to this.  So the kudge doesn't
# make any immediate sense but it does fix it.  What I'll do
# is treads instead.  The poblem lies with use socket; and
# initiating a fork();.  I can fork() in certain instances
# even with socket but only outside of a block, where state
# doesn't have to be maintained.  Just ignore this, I'm using
# threads on windows and recompiled activperl to include it.
# ====================================================
			# now tell all opers what happened and the new index to pass
			foreach $temp1 (keys %opers)
				{
				&send("NOTICE $temp1 :$nicks{$keynick}{nick} admin authenticated, new auth index ($opcoms{pass}{number})\n");
				}
			return;
			}
		}
	if(!$opers{$keynick})
		{
		&send(":$servnick NOTICE $nick :Access to $opernick is restricted to\n");
		&send(":$servnick NOTICE $nick :select personnel. You do not appear to\n");
		&send(":$servnick NOTICE $nick :be in that list. If you believe this to be\n");
		&send(":$servnick NOTICE $nick :a bug please contact an online IRC Operator\n");
		&send(":$servnick NOTICE $nick :and explain the error. Thank you.\n");
		return; # must return, no if else
		}
	}
else
	{
	# if we get this far then they spoke to one of us that isn't
	# willing to talk back.  Either that or something's wrong
	# with my parser OR the remote server had gas.

	# might want to disable this action later, it could be a nick
	# that's in prison and this could happen too many times and
	# would reduce server response time.

	&writelog("ERROR: Service nick not able to speak [ $target ] in sub PRIVMSG with content: $msg", 1);
	return; # nothing else to do

	# I just discovered this, if a nick has been locked/recover(ed)
	# people can msg that nick and get this 'else' but they won't
	# see anything since the recent addition of the return;, all this
	# apparent redundant checking is paying off.

	# ok, person talking in service channel gets this too.
	# OK, THIS IS NOT A PROBLEM... it just means that we have
	# a service nick that this routine didn't check. Give this
	# writelog a low priority.
	}
# -----------------------------------------------
# check for ctcp, this is an easy check and only comes first because
# anything ELSE is a REAL privmgs.
if($msg =~ /^/)
	{
	# got ctcp something
	if($flags{ctcp} =~ /off/i)
		{
		# if it's off we warn in the log and return

		# just for statistics, you might want to remove this later
		&writelog("WARNING: CTCP was requested but is set to OFF", 1);
		return; # just get out
		}
	else
		{
		&ctcp;
		return; # Nothing left to do
		}
	}
# -----------------------------------------------

# Now check to see if they typed a command in our database.
# Essentialy we're going to generate a pathname which is the key into
# the hash element we want.  Each successfull match will be met by
# another attempt.  Once it fails we back off one, and that's the key.
# We eval the contents of the hash element that the key matches and
# that's our command.  The actual perl code to load and run the command
# is contained inside the hash element.  Either that or the actual
# command code itself is there.  Kewl huh? :P

# don't my($goodcom) we need to pass it to loadcom
my(@msg, $lastcom);

# If the first command don't exist it's not a match.  After we
# match the first command a NON match is the end of our command
# string.
$tmpmsg = &ucase($msg); # for processing and discard, commands are uppercase

# now we need to retrive the dir name to work with
# lowercase the service nick for the key into the command hash
$keyserv = &dcase($servnick);
$keydir = $servdir{$keyserv};

# TEST
# print STDOUT "KEYDIR: $keydir $comdir/$keydir/$msg[0]\n";
# foreach $thisone (keys %{$commands{$keyserv}}) { print "$thisone\n"; }
#!TEST

##
# DO NOT IMPLEMENT THIS YET - I added some of it but it should
# be cleaned up eventualy.  I don't know if this is a good move
# as the code becomes difficult to understand. I think as soon
# as I've removed all the references to this I'll remove this
# piece of code aswell.
## So the following should be ignored and is here for reference/compat. only
# I'm using a variable to store the valid command line so that we can
# return it to the nick that used it if they need assistance.
# Example:
# To change your password /msg $servnick $comline <password>
# would really look like /msg NickServ SET PASSWORD <password>
# unless they changed the command to PASS then you'll see
# what I mean, or even if they changed the sub directory SET.

$comline = "";
(@msg) = split (/\s+/, $tmpmsg);
if(!($commands{$keyserv}{"$comdir/$keydir/$msg[0]"}))
	{
	# if first command don't match we're outta here
	&send(":$servnick NOTICE $nick :No such command $msg[0]\n");
	&send(":$servnick NOTICE $nick :/msg $servnick HELP for more info\n");
	# release the array
	undef(@msg);
	return;
	}
foreach $i (@msg)
	{
# TEST
# print STDOUT "FIRST COM OK! :$i:\n";
# print $commands{$keyserv}{"$comdir/$keydir/$msg[0]"}, "\n";
#!TEST
	$lastcom .= &ucase($i);

	if($commands{$keyserv}{"$comdir/$keydir/$lastcom"})
		{
		# when it matches we split at this to put the parameters into
		# parms.  if we split at $i when it matches we'll lose one parm.
		$splitcom = $i;

		# it was acting up on dup commands, ACCESS ACCESS
		# now we remove the entire front section and pass what's left as parms
		# by popping off each command that works.
		# THAT WORKED!

		($junk, $msg) = split ((/$splitcom\s+/i), $msg, 2);
		$comline .= " ".$i; # see above for info
		$goodcom = $lastcom;

		# a unique state we'd be in is if there was only one
		# command and it's a good one, we'd never get back here
		# to run the eval or to undef the array.  Then we WOULD
		# get back on a second command.  Let's check for
		# second element existance and, if not, we'll go with
		# this one and undef the array.
		if(!($msg[1]))
			{
			$comline = &ucase($comline); # see above for info
			$comline =~ s/^\s//; # there's a space in front
			undef(@msg);
			undef($parms); # so command don't try to parse it
			eval($commands{$keyserv}{"$comdir/$keydir/$goodcom"});
			undef($parms); # security measure
			undef($splitcom);
			# any errors?
			if ($@)
				{
				&writelog("privmsg SINGLE COM returns error from $goodcom $@");
				}

			return; # Just get out, we're done here.
			}
		$lastcom .= "/" ; # for next check
		}
	else
		{
		# release the array
		undef(@msg);

		# we found the end, no command, so eval the last match found
		# and pass it the parameters.  We have to first split
		# the original at the last matched command to get the
		# parameters.
		
		# what this says is, split the original line up with
		# the LAST good command, give me the parms in $parms
		# and we don't care about case just as long as it's
		# a word and not $i ( the last command ) embeded in
		# in a previouse word.
# TEST
# print STDOUT "FOUND COMMAND ! $goodcom\n";
# print $commands{$keyserv}{"$comdir/$keydir/$goodcom"}, "\n";
#!TEST

		$comline = &ucase($comline); # see above for info
		$comline =~ s/^\s//; # there's a space in front
##
#		($junk, $parms) = split ((/$splitcom\s+/i), $msg, 2);
# THAT WORKED!
		$parms = $msg;
		eval($commands{$keyserv}{"$comdir/$keydir/$goodcom"});
		undef($parms); # security measure
		undef($splitcom);
		if ($@)
			{
			&writelog("privmsg returns error from $goodcom $@");
			}
		return;
		}
	}
# If we're done processing commands and all commands matched then we're
# in a special condition were we exited the loop without processing.
# The only way we exit this loop is if the command is good but without
# parameters so go ahead and eval the line and return.  No splitting needed.
eval($commands{$keyserv}{"$comdir/$keydir/$goodcom"});
if ($@)
	{
	&writelog("privmsg returns error, at fall through, from $goodcom $@");
	}
return;
}
# --------------------------------------------------------------------------
# CTCP
# --------------------------------------------------------------------------
# Respond to ctcp requests
sub ctcp
{
# Get rid of the strange characters.
$msg =~ s///g; # get rid of these, there's 2
# $msg =~ s/^://; #get rid of the first one of these, should be 1

# Must split the message into main and parms in case
# it's a ping or special ctcp command
($msg, $parms) = split (/ /, $msg, 2);
$goodcom = &ucase($msg); # uppercase to match command names

# unlike the commands hash this is ONE level.  If it's
# any MORE than that we don't want it anyways.  So just
# check to see if it's in there.  No conactonation is
# required.
if ($ctcp{commands}{"ctcp/$goodcom"})
	{
	# run it
	eval($ctcp{commands}{"ctcp/$goodcom"});
	undef($parms); # security measure

	# if error
	if ($@)
		{
		&writelog("ctcp returns $@");
		}
	}
else
	{
	&writelog("SYSTEM: ctcp command $msg not found", 1);
	}
}
# --------------------------------------------------------------------------
# SEND
# --------------------------------------------------------------------------
# Just send what's in the parameter to the socket, untouched.  We have a
# simple routine like this because we never know if we're going to need
# to change this one day to meed different standards.
##
# whoops, looks like we've run into an eventual bug.  we can't send
# text over a certain size.  i've fixed this in sub sendtext but we
# need to do more checking here.  I think that we'll use a different
# send utility instead of this when the possibility of them getting
# too much text is there.  We'll start doing that now in &sendq();
sub send
{
# DON'T PUT A &writelog() IN HERE, you have been warned!

# Don't write to anything if you're a forked copy
if($myprocess =~ /Win32.spoon/i) { return; }

print $mysock "$_[0]";

# UNCOMMENT THIS ONLY FOR TESTING, we use this sub routine far too
# much to go checking flags when we don't need to.
# print "SENDING: $_[0]";
}
# --------------------------------------------------------------------------
# SENDQ
# --------------------------------------------------------------------------
# This routine calls others, probably &send(), to deliver text in a split
# form.  We've not done this yet because we don't know if we'll just alter
# &send() to make check length but the purpose is to prevent our system
# from sending too much text, spliting it up into $sendsize lengths on
# a dictionary word boundary, before the size, and send it in multiple
# lines.
#
# --------------------------------------------------------------------------
# SENDTEXT
# --------------------------------------------------------------------------
# Just a small routine to make sending multiple lines of text easier.
# In the source we're called with 1 or more variables. Additional variables
# contain elements we want removed from our text. Now why would they do that?
# Because it's easier to read formated.  Then we just take out the stuff
# we don't want before we send the array. All parameters are recursed over
# until there are none. So you could say &sentext($text, "\n", "\t", "\r");
# To remove newlines, tabs and returns.
#
# We also check $sendsize against the size of the string and report an
# error if the string size is larger. We'll still attempt to send
# the text, for debuging purposes, and call &writelog.
#
# OPTIONS: T / (none)
# Variables already set and required:
#	$_[0]		-	the text we're formating and sending
#	$_[1]..		-	additonal parameters contain that which
#				we want removed from our text before
#				delivery.
##

sub sendtext
{

# Don't write to anything if you're a forked copy
# if($myprocess =~ /Win32.spoon/i) { return; }
# actually, this calls &send() so we can just rely
# on that routine to check this, and then we don't have
# to worry about 'state' for each line, if there is any
# state and I'm just too tired to even look at the next
# 11 lines, or however many there are, to find out.

my($i, @text, $cnt);
$_[0] =~ s/^\n//; # take off the first \n, just a convenience
$_[0] =~ s/^\r//g; # take out dos junk # WHY DID I DO THIS?
$cnt = 1; # need to point to things to remove
while($_[$cnt])
	{ 
	$_[0] =~ s/$_[$cnt]//g; # take out this match
	$cnt++;
	}
(@text) = split /\n/,$_[0];
foreach $i (@text)
	{
	&send(":$servnick NOTICE $nick :$i\n"); # no \n in this one
	# if this last line was bigger than our send size, complain.
	# the the +1 is for \n that we need to send.
	if( (length($i)+1) > $sendsize )
		{
		&writelog("ERROR: sub sendtext reports sendsize error - sendsize: $sendsize - array: $cnt - TEXT: $i");
		}
	}
}
# --------------------------------------------------------------------------
# NICK
# --------------------------------------------------------------------------
# Nick change, we have to move their data thats in ONE hash key to another
# key in the SAME hash, check nickserv and move the nicks on the channel hash
##
##
# Options: MOVE
##
# Variables already set and required:
#	$_[0]		-	lowercase nick, key
#	$_[1]		-	lowercase target nick for nick change
# -------------------------------------------------------------
# used in this sub routine
#	$keynick	-	lower case nickname
#	$destnick	-	lower case target nickname
##
#:UrbanFizBoz NICK boo :972727792
##
sub nick
{
my($keynick, $destnick) = ($_[0], $_[1]);

# all these other calls rely on the nicks database so call THEM before
# you call the nicks or the information will be deleted and unavailable
# for you to finish the job.

&chanlist("MOVE", $keynick, $destnick, undef); # move nick in channel data
&operlist("MOVE", $keynick, $destnick, undef); # change the database structures
&userlist("MOVE", $keynick, $destnick); # move core user info
&nickserv($destnick); # go see if the new nick is registered

}
# --------------------------------------------------------------------------
# QUIT
# --------------------------------------------------------------------------
# Delete user from lists
##
# :Skoo QUIT :Layter people
# or we're called by another routine to cleanup a user.
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	lowercase nick that quit
##
sub quit
{
# Just use passed variables, it's pretty straight forward.

# if they don't exist we may have removed them using a
# command. that means we might generate bogus keys bye
# checking them...we don't want that.

if(!$nicks{$_[0]})
	{
	&writelog("sub quit reports quit request for $_[0] but nick doesn't exist");
	return;
	}

# remove from all channels FIRST or testing would put them
# back into the nicks hash because the nicks hash holds their
# channel list that we parse into the chan keys for chans hash *sigh*
&chanlist("ALL", $_[0], undef, undef);

# remove from oper hash before nicks hash so we can grab their
# real case nickname for the OFF DUTY notice, if they're oper.
if($opers{$_[0]})
	{
	&send(":$msgnick WALLOPS :IRCop $ranks{$opers{$_[0]}{rank}} $nicks{$_[0]}{nick} has gone off duty\n");
	&send(":$msgnick GNOTICE :IRCop $ranks{$opers{$_[0]}{rank}} $nicks{$_[0]}{nick} has gone off duty\n");
	&operlist("DEL", $_[0], undef, undef); # routine takes care of checking
	}
# remove from normal user hash
&userlist("DEL", $_[0]);

}
# --------------------------------------------------------------------------
# JOIN
# --------------------------------------------------------------------------
# Nick joins a channel
# we already have $target (chan) and lowercase key $keychan
# I dont' know why i wrote $target up there...we use $keychan.
# $keychan is either 1 channel or a list seperated by commas.
# Either way this routine will work fine, it'll send each name
# to the &chanlist routine to perform certain checking and/or add
# them to the channel.
##
# :dent JOIN #boo
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	lowercase nick
#	$_[1]		-	lowercase channel(s)
##
sub join
{

my($keynick, $keychan) = ($_[0], $_[1]);

# now, the calling routine expected that there's no spaces in the
# list of channels...only commas ',' seperating the channels.
# if there were spaces we'll have to add the contents of $msg
# to this list so we can get all the channels. just remember
# this if there's problems later.

# This one's for multiple nicks on a channel
if($keychan =~ /,/)
	{
	my (@chans) = split /,/, $keychan;
	foreach $keychan (@chans)
		{
		&chanlist("ADD", $keynick, undef, $keychan);
		&chanserv("JOIN", $keynick, $keychan);
		}
	}
# This one's for a single join
else
	{
	&chanlist("ADD", $keynick, undef, $keychan);
	&chanserv("JOIN", $keynick, $keychan);
	}
}
# --------------------------------------------------------------------------
# PART
# --------------------------------------------------------------------------
# Nick leaves a channel.  There can actually be a  fourth element, the
# part message, but we don't need it.
##
#:dent PART #boo :layter people
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	lowercase nick
#	$_[1]		-	lowercase channel
sub part
{
# pretty simple, just use passed variables
&chanlist("DEL", $_[0], undef, $_[1]);
}
# --------------------------------------------------------------------------
# MODE
# --------------------------------------------------------------------------
# Channel modes, carefull here, a channel with no modes issues a
# + TIMESTAMP instead of a positive o 
# :admin.abonica.net MODE #Sho +  972767283
# chan/nick mode here
# :admin.abonica.net MODE #Sho +o  By56z3r4 972837006
# channel mode
# :By56z3r4 MODE #Sho +nt
# user mode
# :dent MODE dent :+oghw
#
##
#
# I might change this later but the channel hash built this way:
# %chans{#channel}{users}{nicks on channel}{their modes}
# %chans{#channel}{modes}{channel modes} <- {key if +k}
# %chans{#channel}{topic} <- {contents of topic}
# %chans{#channel}{bans}{masks, hosts, ips of banned people}
#
##
sub mode
{

# hashes %pos and %neg are defined here and then released after
# we call &chanserv. these hashes hold the + and - modes for
# this pass. &chanserv needs to know what changes we made on
# this pass only.

# The server issues a line like this:
# :admin.abonica.net MODE #Sho +tnoo  UrbanFizBoz By56z3r4 972837006
# see? channel modes mixed with nick modes
#
# 3 diff types of modes here. nickmodes, chanmodes, usermodes.
(undef, undef, $target, $msg) = split(/\s+/, $rawmsg, 4);

# save keynick before we overwrite or we'll lose it. we need to
# remember WHO changed these modes for possible authentication later.
my($sourcenick) = $keynick;

$keynick = &dcase($target); # different here, we're GETTING not SETTING
$keychan = $keynick; # in case we get channel modes, we can use $keychan

# The easy one first
# :UrbanFizBoz MODE UrbanFizBoz :+oghw

# don't enter this loop at all if it's not usermodes.
# reduces strain.

# let's express ourselfs in a way that will allow us to test
# the 'sign' later.
# if($msg =~ /^:(\+)|^:(\-)/)


# do we enter?
if($msg =~ /^:/)
	{
	$rank1 = 50;
	$rank2 = 50; # prevent false reading (low number)

	(@modes) = split//, $msg;
	foreach $mode (@modes)
		{
		if($mode eq "+") { $sign = "+"; }
		if($mode eq "-") { $sign = "-"; }
		# do we support this usermode?
		if(defined($server{modes}{users}{$mode}))
			{
			# is this usermode an op/globop/admin
			if(defined($opermode{$mode}))
				{
				if($sign eq "+")
					{
					# get the rank
					$rank1 = $opermode{$mode};
					# higher rank?
					if($rank1 < $rank2)
						{
						# yes, save it, save best rank
						$rank2 = $rank1;
						}
					}
				elsif($sign eq "-")
					{
					# get the rank name, delete from
					# opers hash and show action
					$rank = $opers{$keynick}{rank};
					&operlist("DEL", $keynick, undef, undef);
					&send("WALLOPS :IRCop $ranks{$rank} $nicks{$keynick}{nick} has gone off duty\n");
					&send("GNOTICE :IRCop $ranks{$rank} $nicks{$keynick}{nick} has gone off duty\n");
					}
				}
			# else ( put your own mode routines here if not o,O|a
			# REMEMBER ! We already processed the user modes we want.
			# If you want more put the checks BEFORE this last check
			# for ':'.  For any user mode we expect to see this.
			# &writelog("sub mode - Not processing USERMODE $mode", "1");
			}
		}
	# did we get a match?
	if($rank1 != 50)
		{
		# show oper notice and define
		# $rank2 will always be lower than $rank1 because
		# we started with 50. (lower = higher rank)
		&operlist("ADD", $keynick, undef, $rank2); # tell operlist to add oper and give rank 1
		&send("WALLOPS :IRCop $ranks{1} $nicks{$keynick}{nick} is now on duty\n");
		&send("GNOTICE :IRCop $ranks{1} $nicks{$keynick}{nick} is now on duty\n");
		}
	# get rid of our mess
	undef(@modes);
	undef($mode);
	undef($sign);
	undef($rank);
	undef($rank1);
	undef($rank2);
	# if we entered this loop we got usermodes and we're done with them,
	# just get out
	return;
	}


# Now for this strangeness, channel creation time
# This only happens if there's NO ops, NO topic and NO modes on the chan...
# I think.
# :admin.abonica.net MODE #Sho +  972767283

# get at the modes
($modes, $msg) = split(/\s+/, $msg, 2);

# Now, are there any modes at all or just a + ?
if($modes eq "+")
	{
	return; # only channel creation time
	}

# If we got this far then modes are formated like so...
# :irc.abonica.net MODE #Sho +vv UrbanFizBoz Bob TIEMSTAMP
# :irc.abonica.net MODE #Sho +ntoo UrbanFizBoz Bob TIMESTAMP
# :By56z3r4 MODE #Sho +oo UrbanFizBoz Bob
# :irc.abonica.net #Sho +bb *!*@*.aol.com *!*@*.mindspring.com

# So we got channel modes, we can test source after we set
# to see if they have authority to do this. We don't want
# to test during the loop, it's actually less efficient that way.

# If the channel has modes, nt or whatever or they're removed
# during run time, we use the $target and we don't update
# the pointer to the next nick.  We treat + or - k as a nick
# because the location of the k is in the same location as
# the nick in the following array. so here's an example if the
# key is zzbohee
# :irc.abonica.net MODE #Sho +ntkoo zzbohee UrbanFizboz Bob
# zzbohee can be treated as a nick because it's lined up
# properly with the previouse array, @modes array.

# if the channel is keyed we treat it like any other user mode.
# we just strip off one of the pieces, booboo, and apply the
# k to it. so (keyed) = booboo
# :admin.abonica.net MODE #Sho +minko booboo By56z3r4 972849605

# Now we gotta split the modes up into pieces along with the nicks.
# When we run out of modes we're done.  The only thing left would
# be the timestamp.

(@modes) = split//, $modes;

# Lower case nicks, if you need uppercase modes you better
# look through this code a bit cos I already tried it it's
# not configured for it. You'll have to change it a bit.
# This also means that the keys are lowercase. So far that
# hasn't been a problem.
$msg = &dcase($msg);

(@msg) = split /\s+/, $msg;

$cnt = 0; # index from modes into nicks, when we run outta modes we're done

foreach $mode (@modes)
	{
	if($mode eq "+")
		{
		$sign = "+";
		# don't go processing this, it'll get added to the hash
		next;
		}
	if($mode eq "-")
		{
		$sign = "-";
		# don't go processing this, it'll get added to the hash
		next;
		}
	# get the type of mode, we know about nick to chan modes
	# but the channel modes are less stable among versions
	if($mode !~ /o|b|v/)
		{
		# it's a channel mode
		# IF K EVER BECOMES CASE SENSATIVE YOU'LL HAVE TO
		# PROCESS THE KEY BEFORE WE GET HERE
		if( (($mode eq "k") || ($mode eq "l")) && ($sign eq "+"))
			{
			# save the key and bump the pointer
			$chans{$keychan}{modes}{$mode} = $msg[$cnt];
			$pos{$mode} = $msg[$cnt]; # save for reversal
			$cnt++;
			}
		elsif( (($mode eq "k") || ($mode eq "l")) && ($sign eq "-"))
			{
			# delete key and bump the pointer
			delete($chans{$keychan}{modes}{$mode});
			$neg{$mode} = $msg[$cnt]; # save for reversal
			# only ++ if not l cos -l don't have a parameter
			# only +l does
			if($mode ne "l")
				{
				$cnt++;
				}
			}
		else
			{
			# save or delete mode as indicated
			if($sign eq "+")
				{
				$chans{$keychan}{modes}{$mode} = {};
				$pos{$mode} = {}; # save for reversal
				}
			elsif($sign eq "-")
				{
				delete($chans{$keychan}{modes}{$mode});
				$neg{$mode} = {}; # save for reversal
				}
			}
		}
	else
		{
		if($sign eq "+")
			{
			# is it a ban?
			if($mode eq "b")
				{
				$chans{$keychan}{bans}{$msg[$cnt]} = {};
				$pos{$mode}{$msg[$cnt]} = {}; # save for reversal
				}
			# only other modes are users
			else
				{
				$chans{$keychan}{users}{$msg[$cnt]}{$mode} = {};
				$pos{$mode}{$msg[$cnt]} = {}; # save for reversal
				}
			}
		elsif($sign eq "-")
			{
			# removing a ban?
			if($mode eq "b")
				{
				delete($chans{$keychan}{bans}{$msg[$cnt]});
				$neg{$mode}{$msg[$cnt]} = {}; # save for reversal
				}
			# only other modes are users
			else
				{
				delete($chans{$keychan}{users}{$msg[$cnt]}{$mode});
				$neg{$mode}{$msg[$cnt]} = {}; # save for reversal
				}
			}
		$cnt++;
		}
	}
# &chanserv is responsible for checking reg chan.
&chanserv("MODE", $sourcenick, $keychan); # go say who and what channel
undef(%pos);
undef(%neg);
}
# --------------------------------------------------------------------------
# DOMODE
# --------------------------------------------------------------------------
# This will cleanely apply modes, or remove the, from or to a channel
# or a nick on a channel without corrupting the transient database.
# This routine should be called from any OP, DEOP, MDEOP, BAN..etc.
# command from the services command structure. It returns a message
# in the second parameter and 0 or 1 in the first indicating
# success or failure. We need this sub routine when services changes
# a mode because the remote server doesn't echo it back to us, hence,
# our "sub modes" doesn't run. This routine will make sure we're
# trying to apply modes that exist, configured in the service.conf
# file and overlayed using options.conf.
#
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	ADD or DEL, applies or removes the mode
#	$_[1]		-	keyword NICK or CHAN
#	$_[2]		-	lowercase channel as key
#	$_[3]		-	mode letter o/b/v/i..whatever
#	$_[4]		-	lowercase nick as key or mode parameter
#      -------------------------------------
# options: ADD / DEL
sub domode
{
my($keychan, $mode, $keynick) = ($_[2], $_[3], $_[4]);
$keychan = &dcase($keychan); $keynick = &dcase($keynick);

# basic checking here, 3% apr..whatever..*sigh*
# can't mode anything on a non existant channel
if(!$chans{$keychan})
	{
	return 0, "No such channel [$_[2]]";
	}
# can't mode non existant nick and can't mode nick that's not on channel
if($_[1] =~ /NICK/)
	{
	# no nick if b, no mode if not b and not on chan
	if( (!$nicks{$keynick}) && ($mode !~ /b/) )
		{
		return 0, "No such nick [$_[4]]";
		}
	# check for b mode on nick and if it's not, check if nick on chan
	if( ($mode !~ /b/) && (!$chans{$keychan}{users}{$keynick}) )
		{
		return 0, "They're not on that channel $keynick, $keychan";
		}
	}
if($server{modes}{nicks} =~ /$mode/)
	{
	if($_[0] =~ /ADD/)
		{
		# we could run a check to see if the mode exists but
		# I don't see it being a problem, except that it will
		# return true on a 'b' even if the mask isn't there and
		# that's not a problem so far.
		#
		&send(":$servnick MODE $keychan +$mode $keynick\n");
		if($mode =~ /b/) { $chans{$keychan}{bans}{$keynick} = {}; }
		else{ $chans{$keychan}{users}{$keynick}{$mode} = {}; }
		return 1, "Success!";
		}
	elsif($_[0] =~ /DEL/)
		{
		&send(":$servnick MODE $keychan -$mode $keynick\n");
		if($mode =~ /b/) { delete($chans{$keychan}{bans}{$keynick}); }
		else{ delete($chans{$keychan}{users}{$keynick}{$mode}); }
		return 1, "Success!";
		}
	}
elsif($server{modes}{chans} =~ /$mode/)
	{
	if($_[0] =~ /ADD/)
		{
		&send(":$servnick MODE $keychan +$mode $keynick\n");
		if($mode =~ /l|k/) { $chans{$keychan}{modes}{$mode} = $keynick; }
		else{ $chans{$keychan}{modes}{$mode} = {}; }
		return 1, "Success!";
		}
	elsif($_[0] =~ /DEL/)
		{
		&send(":$servnick MODE $keychan -$mode $keynick\n");
		delete($chans{$keychan}{modes}{$mode});
		return 1, "Success!";
		}

	}
&writelog("sub domode reports inconsistancy, called but fell through, that can't happen, I was called with the following :$_[0]:$_[1]:$_[2]:$_[3]:$_[4]:");
return 0, "severe error";
}
# --------------------------------------------------------------------------
# TOPIC
# --------------------------------------------------------------------------
#
# Here's the topic sent by server
# :admin.abonica.net TOPIC #Sho By56z3r4 972837486 :this is a topic

# here's a topic sent by user setting it.
# :UrbanFizBoz TOPIC #Sho UrbanFizBoz 972838210 :Distant topic here

# Parsed the same I guess. The problem is, when two servers link
# and services sees a topic for the first time, sent by server
# setting the topic, it'll attempt to change it.  that's because
# no server has auth to change the topic.  then, the same thing
# happens on a first joiner..topic gets set if topic item is ON.
# what I have to do is check to see if the topic matches that being
# set and do nothing if so.
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	lowercase nick as key
#	$_[1]		-	lowercase chan as key
#	$msg		-	the topic message, needs parsing
#      -------------------------------------
#

sub topic
{
# Let's make this easy, we only need to parse $msg because we have
# the nick, target and topic in msg somewhere after the ":".

(undef, $topic) = split(/:/, $msg, 2);

# save it in channel has
$chans{$_[1]}{topic} = $topic;

# go see if registered, if topic setter is ranked, etc.
&chanserv("TOPIC", $_[0], $_[1]);

}
# --------------------------------------------------------------------------
# USER
# --------------------------------------------------------------------------
# A user/nick has joined the server.  Add them to the userlist and check
# for registered nick.
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$rawmsg		-	unaltered server message
#      -------------------------------------
#	$keynick	-	lowercase nick, set it here, different proto
#      -------------------------------------
#	variables used here, global
#	$nick		-	their prefered case nickname
#	$user		-	username
#	$host		-	hostname
#	$name		-	what they put for real name

sub user
{
# we did this split before but now the nick is in a different place
# *sigh* don't let the expression scare you, it's only a little one...

########## hmm...
# open TESTING, ">>blarn"; print TESTING "$rawmsg\n"; close(TESTING);
#(undef, $nick, undef, undef, $user, $host, undef, $name) =
#split/\s+(.*?)\s+(.*?)(\d+\d+\d+\s+)(.*?)\s+(.*?)\s+.*?:(.*?)/, $rawmsg;
#$keynick = &dcase($nick);
##########
########## oh well
(undef, $nick, undef, undef, $user, $host, undef, $name) = split(/\s+/, $rawmsg, 8);
$keynick = &dcase($nick);
## get rid of the : before the name
## $name =~ s/^:+//; # oops..some servers have hop count before name
## use this instead
$name =~ s/.*?://; # take only that which is after the first colon
##########

# *sigh* maybe that will work for everything... I keep having to change
# this parse line so that's why I used the crazy expression above.

# Now save their data, uses the items in the line we just split above
# we don't use $keynick as parm for userlist yet but we might convert later,

# DAN, we've been converting the sub routines so that we can just pass
# parameters.  Don't convert this pass here since we parse into the original
# message to get these parameters for $nick/$keynick, geez, I always say
# 'we' and address myself by name 'DAN'... yeah, I'm a programmer }:)

&userlist("ADD", $keynick); # call a routine to add them so future changes are easier
&nickserv($keynick); # see if nick is registered and take necessary action if it is
}
# --------------------------------------------------------------------------
# NICKSERV
# --------------------------------------------------------------------------
# Check to see if this nick is registered and if it is see if we need to
# warn them.
#
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	lowercase key for rnicks of current user
#	$nicktimer	-	amount of seconds before we kill/change
#	$nick		-	real case nick was set special for this sub
sub nickserv
{
my($access, $mask, $text, $subtext);

return if !$nicknick; # just leave if they don't want a nickserv
return if !$rnicks{$_[0]}; # if not registered we don't need anything
return if $nicks{$_[0]}{kill}{$_[0]}; # already marked for death

# we're assuming the calling routine moved the user hash (ident) so
# we can check it here. if not then we have things in the wrong order
# and sub nick needs to be changed
return if $nicks{$_[0]}{ident}{nicks}{$_[0]}; # if identified return

# so we've established that they're using a registered nick and that
# they've not identified.

# run through they're nick access list to see if we should bother them.
# generate the user line to match against masks
$access = "$nicks{$_[0]}{user}\@$nicks{$_[0]}{host}";

foreach $mask (keys %{$rnicks{$_[0]}{access}})
	{
	if(&checkmask($access, $mask)) { return; } # nothing to do, they match
	}
# no matches, let's bug them

# is secure enabled? generate text and kill time if so
if($rnicks{$_[0]}{secure} =~ /on/i)
	{
	# generate future kill time stamp
	# $nicks{$_[0]}{kill}{$_[0]}{timestamp} = (time() + ($nicktimer * 60));
	$nicks{$_[0]}{kill}{$_[0]}{timestamp} = time() + $nicktimer;
	$kill{$_[0]} = {};
	$subtext = "I'll give you at least 1 to 2 minutes to ";
	$subtext .= "change it before I take action.";
	}
else
	{
	$subtext = "The owner has the option to remove you from ";
	$subtext .= "the server if they find you're using their nick.";
	}

# set the servnick, that's what the called routine uses
$servnick = $nicknick;

$text = "This nick is registered with $nicknick. $subtext";
$text .= " If it's yours simply identify yourself as the owner ";
$text .= "using the $nicknick IDENTIFY command: /msg $nicknick ";
$text .= "IDENTIFY <password>";
&sendtext($text);

}
# --------------------------------------------------------------------------
# CHANSERV
# --------------------------------------------------------------------------
##
# Options: JOIN / MODE / TOPIC
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	option, MODE / TOPIC / JOIN .. blah
#	$_[1]		-	this is the keynick that did action/option
#	$_[2]		-	the channel the action is on
#	---			: If we're called by &mode; these are defined
#	%pos		-	positive modes that were applied to chan
#	%neg		-	negative modes that were applied to chan
#	----			pos and neg are for this pass only and are
#				released by the calling routine when it's
#				done.
#
sub chanserv
{
# Used for MODE
my($i, $values1, $values2, $mode, $modes, $values);
my($modes1, $modes1v, $modes2, $modes2v, $isauth, $yes, $time); undef($yes);

# Used for JOIN (akick) $nuh is Nick User Host,
# used for mask mathing in akick list
my($rank, $nuh, $mask, $reason);

# General use, probably use this everywhere in this routine
my($keynick, $keychan) = ($_[1], $_[2]);

# Chanserv only effects registered channels so check that first
# and if it's not, just get out. we also don't want to define
# a registered channel just by checking one of it's keys,
# so this plays a dual role even though the first is sufficient
# enough to get out of this routine.

return if !$rchans{$keychan};

if($_[0] eq "MODE")
	{
	# channel must be registered but is it created?
	return if !$chans{$keychan};

	# if it's not on don't even bother
	if($rchans{$keychan}{modes}{state} eq "on")
		{
		# we're gonna change this check later to
		# $keychan}{actions}{modes/join/kick} that stuff
		# are they authorised to make this change?
		if(!&isauthchan($rchans{$keychan}{action}{mode}{rank}, $keynick, $keychan))
			{
			# Looks like they didn't have auth, let's see what
			# positive modes need placing by checking neg.
			foreach $mode (keys %neg)
				{
				if($rchans{$keychan}{modes}{hash}{$mode})
					{
					$yes = "1"; # say we were here
					# if this was a k, o or b we have to
					# get the value. Don't forget a space.
					if($mode =~ /o|b|v/)
						{
						foreach $i (keys %{$neg{$mode}})
							{
							# no matter what it is it's stored in here
							# but we have to add it to the channel
							# hash too, so check after. we won't get
							# (k) (l) here cos we refused to record it, we
							# get it on pos modes though. I might do some
							# more work on this later but this functions fine
							# and is room for expansion since we don't check k/l
							$modes1v .= $mode;
							$values1 .= $i." "; # value / mask
							if($mode eq "b")
								{ # reverse it
								$chans{$keychan}{bans}{$i} = {};
								}
							else
								{ # reverse it
								$chans{$keychan}{users}{$i}{$mode} = {};
								}
							}
						}
					else
						{
						# when I wrote this section I hadn't enabled
						# +kl for the MODES feature, but I figured
						# I'd add the ability just in case we tweek
						# the SET MODES command later.

						# only mode letter
						# I can't get an 'l' back because the parm
						# is missing.  oh well. no big deal, we saw this
						# comming before.
						if($mode eq "l")
							{
							# no cure for this yet but shouldn't
							# interfere, just make a log so we don't
							# forget about it later
							&writelog("sub chanserv reports lack of code for (l) mode", 1);
							}
						elsif($mode eq "k")
							{ # theres's a key
							$modes1v .= $mode; # front end, parm
							$values1 .= $neg{$mode}." "; # the key
							$chans{$keychan}{modes}{$mode} = $neg{$mode}; # the key
							}
						else
							{
							$modes1 .= $mode;
							$chans{$keychan}{modes}{$mode} = {}; # no parms, just define it
							# that should be it, there shouldn't be a fall through for other
							# modes if they're good.
							}
						} # end else, channel mode
					} # end if mode hash
				} # end foreach $mode
			} # end if isauth
		} # end if state on

	## Comming into this next section with a full set of properly
	## aligned $modes along with their $tempvalues so don't mix
	## it up. Well, that's if there were any of those mode, of course.

	# if $yes didn't get defined then there were no modes, so just
	# undef just to be safe, why? cos I can't remember everything I did.

	if(!$yes) { undef($modes1); undef($modes1v); }
	undef($yes);

	# now check the other side for modes we can't have on the channel
	if($rchans{$keychan}{secure}{state} eq "on")
		{
		# are they authorised to make this change?
		if(!&isauthchan($rchans{$keychan}{action}{mode}{rank}, $keynick, $keychan))
			{
			# guess not, here's where we would reverse modes
			# even if we don't understand them but we'll pay
			# special attention to obkl because the hashes
			# are different for each one of those. For b, o and
			# v we must itterate over the keys because there
			# could be many items assocciated with that letter,
			# for k we get the value and for any others
			# we just get the mode. l is an exception, we add
			# that to the "just get the mode" for now.
			
			foreach $mode (keys %pos)
				{
				if($rchans{$keychan}{secure}{hash}{$mode})
					{
					# if this was a k, o or b we have to
					# get the value. Don't forget a space.
					if($mode =~ /o|b|v/)
						{
						foreach $i (keys %{$pos{$mode}})
							{
							# no matter what it is it's stored in here
							# but we have to delete it from the channel
							# hash too, so check after
							$modes2v .= $mode;
							$values2 .= $i." "; # value / mask
							if($mode eq "b")
								{
								delete($chans{$keychan}{bans}{$i});
								}
							else
								{
								delete($chans{$keychan}{users}{$i}{$mode});
								}
							}
						}
					else
						{
						if($mode eq "k")
							{ # theres's a key
							$modes2v .= $mode; # front end, parm
							$values2 .= $pos{$mode}." "; # the key
							delete($chans{$keychan}{modes}{$mode});
							}
						else
							{
							$modes2 .= $mode;
							delete($chans{$keychan}{modes}{$mode});
							# that should be it, there shouldn't be a fall through for other
							# modes if they're good.
							}
						} # end else, channel mode
					} # end if mode hash
				} # end foreach $mode
			} # end if isauth
		} # end if state on

	# if $yes didn't get defined then there were no modes here.
	# if there were no modes here or before then there's nothing
	# to do. let's see.

	# we gotta piece this together
	$modes  = $modes1.$modes1v;

	# if it exists there's a reason to put a + sign,
	# if not we'd corrupt the modes line, don't want THAT.

	if($modes) { $modes = "+".$modes; }

	undef($modes1); # reuse this

	$modes1 = $modes2.$modes2v;

	if($modes1) { $modes1 = "-".$modes1; }

	$modes .= $modes1; # combine it, even if null it works.

	if(!$modes) { return; } # nothing to do
	# if there were modes then there were values too.

	$values = $values1.$values2;

	$time = time;
	&send(":$channick MODE $keychan $modes $values\n");
	return;
	}
if($_[0] eq "JOIN")
	{
	# ------------------------------------------------
	# ACTION JOIN
	# ------------------------------------------------
	# we don't set TOPIC here, &chanlist is responsible for that
	# because it knows about the first joiner.  if we get a TOPIC
	# command then chanserv TOPIC is run, that's not here.
	#
	# the channel is registered, drop the url first, see
	# if we can join it and if we need to kick ban

	if($rchans{$keychan}{url}{item} ne "")
		{
		# only if it's not empty
		&send(":$services 328 $nick $rchans{$keychan}{chan} :$rchans{$keychan}{url}{item}\n");
		}

	# we first check the ACTION element because owners
	# get to choose who joins, even if their op.

	if(!&isauthchan($rchans{$keychan}{action}{join}{rank}, $keynick, $keychan))
		{
		$mask = "$keynick!*@*";
		$rank = $rchans{$keychan}{action}{join}{rank};
		&send(":$channick MODE $keychan +b $mask\n");
		$chans{$keychan}{bans}{$mask} = {};

		# set a default reason, it gets set properly if
		# the channel is supsended.

		$reason = "Sorry, Rank ($rank) [$chanops{$rank}] and higher access only, try again later";

		# special case, if were were denied because the channel
		# is suspended we have to say that.
		if(defined($rchans{$keychan}{suspend}))
			{
			$reason = "Channel suspended to perform administrative tasks, try again in a few minutes";
			}
		&send(":$channick KICK $keychan $keynick :$reason\n");
		# remove them from the channel hash
	# server sends PART wich triggers DEL
	#	&chanlist("DEL", $keynick, undef, $keychan);
		return;
		}
	# ------------------------------------------------
	# ACTION OPER
	# ------------------------------------------------
	# Before we go through the akick list let's see if they
	# have a rank on the channel. If they do, we let them
	# slide and give them ops.
	if(&isauthchan($rchans{$keychan}{action}{oper}{rank}, $keynick, $keychan))
		{
		# op them
		&send(":$channick MODE $keychan +o $keynick\n");

		# don't forget, we have to do all this work, no feed back
		# from server if WE set modes.
		$chans{$keychan}{users}{$keynick}{o} = {};

		# our works done here because if they got oper
		# we don't VOICE or AKICK them.
		return;
		}
	# ------------------------------------------------
	# ACTION VOICE
	# ------------------------------------------------
	# Do we give them voice? This works exactly the same
	# way that OPER does accept we voice them. If they
	# get a voice we're done here too, cos it's easy to
	# just delete this nick from the list if you wanted
	# to kick them, and allow the akick mask to take effect.

	if(&isauthchan($rchans{$keychan}{action}{voice}{rank}, $keynick, $keychan))
		{
		# voice them
		&send(":$channick MODE $keychan +v $keynick\n");

		# don't forget, we have to do all this work, no feed back
		# from server if WE set modes.
		$chans{$keychan}{users}{$keynick}{v} = {};

		# our works done here because if they got oper
		# we don't AKICK them or VOICE them.
		return;
		}
	# ------------------------------------------------
	# AKICK
	# ------------------------------------------------
	# let's see if their $nuh matches anything in the
	# akick list.

	# first get their info
	$nuh = "$keynick!$nicks{$keynick}{user}\@$nicks{$keynick}{host}";

	# itterate through the akick list and send the items, one at a time,
	# to &checkmask
	foreach $mask (keys %{$rchans{$keychan}{akick}{item}})
		{
		if(&checkmask($nuh, $mask))
			{
			# found one, get them out and clean up hashes
			&send(":$channick MODE $keychan +b $mask\n");
			&send(":$channick KICK $keychan $keynick :$rchans{$keychan}{akick}{item}{$mask}{reason}\n");

			# remove them from the channel hash
		# server sends PART wich triggers DEL
		#	&chanlist("DEL", $keynick, undef, $keychan);
			}
		}
	}
if($_[0] eq "TOPIC")
	{
	# The topic has already been set, phisicaly, on the channel,
	# has been recorded in the transient channels hash and
	# sub join called upon us to see what needs doing.
	# -
	# Here we check to see if the source that changed the
	# topic was authorised, that the topic's state is on
	# and that there's even a topic recorded for setting.
	# ------------------------------------------------
	# 
	# ------------------------------------------------
	# is the state ON?

#	if( ($rchans{$keychan}{topic}{state} eq "on")
#		&& ($rchans{$keychan}{topic}{item} ne "") )
# Hmm... never set topic on new channels
	if($rchans{$keychan}{topic}{state} eq "on")
		{
		# authorized to make the change?
		if(&isauthchan($rchans{$keychan}{action}{topic}{rank}, $keynick, $keychan))
			{
			# Authenticated, save the current topic in the registered
			# channels hash, we don't care if it matches or not,
			# it's just easier to save it, quicker, and it won't
			# hurt anything.
			$rchans{$keychan}{topic}{item} = $chans{$keychan}{topic};
			}
		else
			{
			# Not authenticated, change it back if it's not
			# the same. Dan, you'll have to fix this later so
			# that the original topic setter is recorded, for
			# now we'll use chanserv's nick.

			# see if the topic differs or we'll be setting it
			# twice, once for first joiner and once for server
			# to service topic.  that happens on a rejoin after
			# split or when services first comes on line, get's
			# reg chans and those chans have nicks.

			# only change back if topic is different
			if($rchans{$keychan}{topic}{item} ne $chans{$keychan}{topic})
				{
				$time = time();
				&send(":$channick TOPIC $keychan :$rchans{$keychan}{topic}{item}\n");
				# gotta set it in the hash too since we changed it
				$chans{$keychan}{topic} = $rchans{$keychan}{topic}{item};
				}
			}
		}
	}
}
# --------------------------------------------------------------------------
# USERLIST
# --------------------------------------------------------------------------
# This will add or del a user from the $nicks hash
##
# Options: ADD / DEL / MOVE
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$nick		-	real case nick
#	$user		-	username, may contain ~ , we'll remove it
#	$host		-	hostname, host.sub-domain.toplev
#	$name		-	what they put in as 'real name'
#	$_[0]		-	ADD / DEL / MOVE
#	$_[1]		-	Source nick
#	$_[2]		-	Dest nick for MOVE
#
##
sub userlist
{
if($_[0] =~ /ADD/i)
	{
	# special case for ADD, these vars are already set.
	# maybe we should change that huh? pass them?
	$user =~ s/~//; # remove the first squiggly
	$nicks{$_[1]}{nick} = $nick;
	$nicks{$_[1]}{user} = $user;
	$nicks{$_[1]}{host} = $host;
	$nicks{$_[1]}{name} = $name;
	}
elsif($_[0] =~ /DEL/i)
	{
	delete($nicks{$_[1]});
	}
elsif($_[0] =~ /MOVE/i)
	{
	# on a move we need to change their {nick}, but that's it.
	# if the source and destination are the same it just means
	# they changed the case sTyle - > Style, no matter what they
	# did we do the same thing  here. it should work fine.
	# also, you might be inlined to think $nick isn't the NEW nick,
	# but it is, the engine switch it with $target before the call
	# because it knew it was a nick change.
	$nicks{$_[2]} = $nicks{$_[1]}; # move source to dest
	$nicks{$_[2]}{nick} = $nick; # the new nick or case
	delete($nicks{$_[1]});
	}
else
	{
	&writelog("sanity check: sub userlist reports being called without appropriate parameters, parm1: $_[0], parm2: $_[1], expected one of the following ADD/DEL/MOVE");
	}
}
# --------------------------------------------------------------------------
# NICKLIST - why did I make a nicklist?
# --------------------------------------------------------------------------
# This will add or del a user from the $rnicks hash
##
# Options: ADD / DEL / MOVE
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$keynick	-	lowercase key
#	$_[0]		-	ADD / DEL / MOVE
#	$_[1]		-	if MOVE this is the new lowercase nick
##
#
sub nicklist
{
# wait a minute, im getting confused here, doesn't &nickserv take care of this?
# DELETE THIS SUB LATER WHEN  YOU DISCOVER IT'S NOT BEING USED
}
# --------------------------------------------------------------------------
# CHANLIST
# --------------------------------------------------------------------------
# This will add, move or del a user from the $chans hash.
# For MOVE it will move their nick in all their channels to the new nick.
# For add and del we expect the channel to be in the last parm.
#
##
# Options: ADD / DEL / ALL / MOVE
##
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	Action ADD / DEL / ALL / MOVE
#	$_[1]		-	Lowercase key of THIS nick
#	$_[2]		-	if MOVE this is the new lowercase nick
#	$_[3]		-	Lowercase key of THIS channel
##
#      --------------------------------------
#	used in this routine
#      --------------------------------------
#	$keynick	-	lowercase nickname for key
#	$destnick	-	lowercase destination nick
#	$chan		-	real case channel name ( for ADD )
#
#
sub chanlist
{

my($i); # for recursion, we might be using this somewhere else

# make it readable, to make it easier for the caller and
# to cut down on code, there could be undef variables depending
# on what they selected.  regardless, the appropriate variables
# will be set so the rest of the routine can function properly.

my($keynick, $destnick, $keychan) = ($_[1], $_[2], $_[3]);
my($time);

# add to a channel?
if($_[0] =~ /ADD/i)
	{
	# don't create bogus keys, if we kicked them and the
	# uplink says PART then we generate a bogus key.
	if(!$nicks{$keynick})
		{
		&writelog("sub chanlist reports ADD request for $keynick to $keychan but nick doesn't exist");
		return;
		}
	$nicks{$keynick}{chans}{$keychan} = {};
	$chans{$keychan}{users}{$keynick} = {};

	# number of people on channel
	# if this element doesn't exist then create it
	# or if it's 0 make it one, either way it's the
	# first nick on the channel. "!" returns false
	# if it's 0 so it serves a dual purpose, that's
	# why we don't use "if !defined" here.

	# new creation means first join, set topic?
	# &chanserv is responsible for testin AKICK and everything
	# but because we're the authority in FIRST join we do TOPIC.
	if(!$chans{$keychan}{count})
		{
		$chans{$keychan}{count} = 1; # not exist then 1 is correct

		# Do this ONLY if the channel is registered!
		if($rchans{$keychan})
			{
			# first set the topic if needed, only if the topic isn't
			# blank and the state is ON and this is the first join.
			# On a topic change we don't come here, we go to
			# &chanserv("TOPIC"..) so we deal with that then.

			if( ($rchans{$keychan}{topic}{state} eq "on")
				&& ($rchans{$keychan}{topic}{item} ne ""))
				{
				# Dan, you'll have to fix this later so that the
				# original topic setter is recorded, for now we'll
				# use chanserv.

				# set it.
				$time = time();

			# i commented this line out because it shows that
			# chanserv set the topic, I don't know about that.
			#	&send(":$channick TOPIC $keychan $channick $time :$rchans{$keychan}{topic}{item}\n");
			# I use this line instead, if we keep this line we
			# don't need $time, so get rid of it above and in 'my'

				&send(":$channick TOPIC $keychan :$rchans{$keychan}{topic}{item}\n");
				# gotta set it in the hash too,
				$chans{$keychan}{topic} = $rchans{$keychan}{topic}{item};
				}
			}
		}
	else
		{
		$chans{$keychan}{count}++; #
		}
	}
# remove from just one channel?
elsif($_[0] =~ /DEL/i)
	{
	# we would never call this unless the channel actually
	# existed and even then, if it didn't, this code is
	# self cleaning and will delete the base key if the
	# channel doesn't have a count..so if we generate a bogus
	# key by testing a remote key we'll delete it anyway.
	# the only provision we need to make here is that the nick
	# exists on the channel or we'll delete and decrement on
	# a bogus key.  We must always use this routine to remove
	# nicks that we manualy deleted from the hash because remote
	# links don't issue PART when services kicks them.

	if(!$chans{$keychan}{users}{$keynick})
		{
		return; # someone got to them before we did
		}
	delete($nicks{$keynick}{chans}{$keychan});
	delete($chans{$keychan}{users}{$keynick});
	$chans{$keychan}{count}--; #

	# if they were the last person then destroy the channel.
	# it will clear all the modes, bans etc.

	# we say less than or = because it will help keep the bugs
	# down when a new command is being testing.
	if($chans{$keychan}{count} <= 0)
		{
		delete($chans{$keychan});
		}
	}
# remove a nick from ALL channels?
elsif($_[0] =~ /ALL/i)
	{
	foreach $i (keys %{$nicks{$keynick}{chans}})
		{
		delete($chans{$i}{users}{$keynick});
		delete($nicks{$keynick}{chans}{$i});
		$chans{$i}{count}--; #

		# if they were the last person then destroy the channel.
		# it will clear all the modes, bans etc.

		if($chans{$i}{count} == 0)
			{
			delete($chans{$i});
			}
		}
	}
elsif($_[0] =~ /MOVE/i)
	{
	# This is channels, don't delete user info, just the chans.
	# other routines do other stuff, nicklist will do the userinfo
	# and is called by the routine that called US, if it was necessary.

	foreach $i (keys %{$nicks{$keynick}{chans}})
		{
		$chans{$i}{users}{$destnick} = $chans{$i}{users}{$keynick};
		delete($chans{$i}{users}{$keynick});

		#
		# You might feel inclined to do ...
		# delete($nicks{$keynick}{chans}{$i});
		# but the calling routine takes care of this
		# because there's data behind that which we're not
		# allowed to touch, we're chanlist not userlist
		}
	}
}
# --------------------------------------------------------------------------
# CHANMODE
# --------------------------------------------------------------------------
# This routine will take a channel mode leter and remove or add it to
# a channel hash or take a mode letter and nick and add or remove it
# from the channel hash. This is much different than &chanlist in that
# it desn't move nicks or remove them, it changes the internal mode
# for a channel or user on that channel.  We also do bans.
#
# Variables already set and required:
#	variable		description
#      -------------------------------------
#	$_[0]		-	ADD / DEL a mode
#	$_[1]		-	there's always a chan so let this be it,
#				it's the lowercase key.
#	$_[2]		-	The mode letter
#	$_[3]		-	This is a nick or mask if b or user mode
##
#      --------------------------------------
#	used in this routine
#      --------------------------------------
#	$keychan	-	lowercase channel name
#	$mode		-	the mode letter
#	$mask		-	this is nick or mask
sub chanmode
{
my($keychan, $mode, $mask) = ($_[1], $_[2], $_[3]);
# some may not be defined, depending on why we were called, but so what.

if($_[0] eq /ADD/i)
	{
	if($mode =~ /o|v/i)
		{
		$chans{$keychan}{users}{$mask}{$mode} = {};
		}
	elsif($mode =~ /b/i)
		{
		$chans{$keychan}{bans}{$mask} = {};
		}
	else
		{
		# must be a channel mode, there shouldn't be any problem
		# attempted to assign a null value to a key, so we'll just
		# assume there's a mask.
		$chans{$keychan}{modes}{$mode} = $mask;
		}
	}
elsif($_[0] eq /DEL/i)
	{
	if($mode =~ /o|v/i)
		{
		delete($chans{$keychan}{users}{$mask}{$mode});
		}
	elsif($mode =~ /b/i)
		{
		delete($chans{$keychan}{bans}{$mask});
		}
	else
		{
		# must be a channel mode
		delete($chans{$keychan}{modes}{$mode});
		}

	}
}
# --------------------------------------------------------------------------
# OPERLIST
# --------------------------------------------------------------------------
# This will add or del a user to/from the $opers hash
##
# Options: ADD / DEL / MOVE
##
# Variables already set and required:
#	variable	-	description
#	$_[0]		-	ADD / DEL / MOVE
#	$_[1]		-	This is the keynick to apply oper
#				the move.
#	$_[2]		-	this is the new nick if MOVE
#	$_[3]		-	this is the rank if needed
##
#
sub operlist
{

my($keynick, $destnick, $rank) = ($_[1], $_[2], $_[3]);

if($_[0] =~ /ADD/i)
	{
	$opers{$keynick}{rank} = $rank;
	}
elsif($_[0] =~ /DEL/i)
	{
	delete($opers{$keynick});
	}
elsif($_[0] =~ /MOVE/i)
	{
	# don't want to create bogus keys
	if(!$opers{$keynick}) { return; }

	$opers{$destnick} = $opers{$keynick};

	# if $keynick and $destnick are the same we don't want
	# do delete them, get it?
	if($keynick eq $destnick) { return; }
	delete($opers{$keynick});
	}
}
# --------------------------------------------------------------------------
# TIMERS
# --------------------------------------------------------------------------
# We check if it's time to do a variety of tasks, kill nicks, write the
# databases and later we'll even run special commands that were loaded
# into a different hash using the COMLIST command installer.  Maybe
# send notices at timed intervals etc.
sub timers
{

my ($event, $timenow, $newnick);
# time to kill/change any nicks that haven't identified?

foreach $event (keys %kill)
	{
# TEST
# $timenow = time();
# print STDOUT "Entering event and listed: $event $nicks{$event}{kill}{$event}{timestamp} : $timenow\n";
#!TEST

	# if there's a kill event and past kill time, do.
	if( ($nicks{$event}{kill}{$event})
		&& ($nicks{$event}{kill}{$event}{timestamp} <= time()) )
		{
		# if identified, remove kill event
		if($nicks{$event}{ident}{nicks}{$event})
			{
			delete($kill{$event});
			delete($nicks{$event}{kill}{$event});
			next;
			}
		# whoops, they're fit for kill/change
		# we checked flag for kill/change/none or null
		if( ($flags{nick} =~ /none/i) || (!$flags{nick}) )
			{ # none or null, $nonenotice set in config file
			$servnick = $nicknick; # &sendtext needs this
			$nick = $event ; # &sendtext needs this set
			&sendtext($nonenotice, "\n"); # remove \n ( see config )
			}
		# change it?
		elsif($flags{nick} =~ /change/i)
			{

			# generate the random number
		        $newnick = int(rand($guestnumber));
		        $newnick = $guestnick.$newnick;
			$timenow = time(); # timestamp
			&send("SVSNICK $event $newnick :$timenow\n");
			&send(":$nicknick NOTICE $newnick :$changenotice\n");
		# DAN, check nick change to see if we need to use
		# MOVE on it here. REMOVE THIS NOTICE WHEN YOU FIND OUT
			}
		# kill it?
		elsif($flags{nick} =~ /kill/i)
			{
 			&send("KILL $event :$nicknick enforcement, $killnotice\n");
			# must remove them from database
			&quit($event); # just remove user from hashes
			}
		# now delete the event
		delete($kill{$event});
		delete($nicks{$event}{kill}{$event});
		}

	}

# time for database write?
# check to see if a child process is already
# writing the databases
if($flags{database} eq "disabled")
	{
# hmm... I could use a mutex object for this can't I?
	# don't even log it cos we'd have to do this on every message.
	# &writedatabase was responsible for loging it's write and
	# disabling access earlier.  SIGDONE will remove this flag
	# later, when chld returns from write.
	return;
	}

$synctime = int (($syncnow - time()) / 60);
if($syncnow <= time())
	{
	&writedatabase;
	# &writedatabase is responsible for resetting the timers
	# because we setup the timer for a shorter period into the
	# future if a fork failed for a process reason or we setup
	# timers after a fork when child exists or we reset the
	# timers after a main process data write as a result of
	# unsupported fork function or second attempt at bad
	# process fork.
##
#	# now reset the interval
#	# countdown database write
#	$synctime = $writetime;
#	# turn into seconds
#	$syncnow = time() + ($synctime * 60);
##
	}
# now for special commands that run at certain times.
# NOT WORKING YET - We need to install a timestamp and checker first
# and have COMLIST look in the appropriate directory, maybe admin/COMMANDS
#foreach $event (keys %events)
#	{
#	eval($events{$event});
#	}
###

}
# --------------------------------------------------------------------------
# WRITEDATABASE
# --------------------------------------------------------------------------
# write all services databases and re-index if needed.
# We reindex first because, even if we have a spooned process,
# we still need BOTH processes to know the real values, index numbers etc.
# The non-spooned/forked version responds to socket input and sends. The
# spooned/forked version of us doesn't, we only handle data state, write
# the databases and do 'dump' when requested.

sub writedatabase
{
# Both processes do this

my($index, $total, $sender, $memo, $value, $element);

undef($keynick); undef(%temphash); # paranoid

&writelog("WRITTING DATABASES !", 1);

# Let's start with nicks first, get these memos out of the way *sigh*

# Delete their list flag, this means they'll have to LIST again before
# they can delete one.  This ensures that they don't unintentionaly
# delete a good memo.  The index numbers will resequence here.

# while( ($keynick) = each %rnicks )
# CHANGE THIS BACK WHEN YOU'RE DONE - TAGG

while( ($keynick) = each %rnicks )
	{
	# resequence the memos

	$cnt = 1; # for indexing the new hash

	# delete LIST indicator
	delete($rnicks{$keynick}{memos}{list});

	# now we have to delete D flaged memos and decrement the
	# total counter each delete but we have to start counting the
	# good memos and reindex them as we go
	# foreach nick that sent us memo(s)
	foreach $sender (keys %{$rnicks{$keynick}{memos}{nicks}})
		{
		foreach $index (keys %{$rnicks{$keynick}{memos}{nicks}{$sender}})
			{
			# foreach memo this nick sent us
			# is this one deleted?
			if($rnicks{$keynick}{memos}{nicks}{$sender}{$index}{flag} =~ /D/i)
				{
				# yeah, delete it
				# delete($rnicks{$keynick}{memos}{nicks}{$sender}{$index});
				# We don't have to now, we're moving the hash
				# and deleting this whole section.

				# and decrement their sent memo count
				$rnicks{$keynick}{memos}{count}{$sender}--;

				# reduce the total amount of memos
				$rnicks{$keynick}{memos}{total}--;
				}
			else
				{
#&writelog("ENTERING NON DELETED ITEM FOR $sender with index $index\n");
				# use the temphash as a temp storage, it's only
				# a few items and we destroy and reuse it later.
				$temphash{$keynick}{memos}{nicks}{$sender}{$cnt} =
					$rnicks{$keynick}{memos}{nicks}{$sender}{$index};

				# The nickname is under the index number, we need
				# that for later, it's a quick key into the
				# memos index by nick.
				$temphash{$keynick}{memos}{index}{$cnt} = $sender;

				$cnt++; # bump the pointer, we got a good one.

				# now delete the old index, we don't need it
				# and the lookup index key
				delete($rnicks{$keynick}{memos}{nicks}{$sender}{$index});
				delete($rnicks{$keynick}{memos}{index}{$index});
				}
			} # end each index
		# It's not keyed by index, it's keyed by sender, so we can
		# have duplicate numbers and it's ok, we just have to make
		# sure all THESE are unique in the sender hash, we can NOW
		# move the new ones over to our original hash.

		delete($rnicks{$keynick}{memos}{nicks}{$sender});

		# if this sender's memos are at 0 then we delete them
		# from the recipients memo base
		if($rnicks{$keynick}{memos}{count}{$sender} == 0)
			{
			# delete the count, it's 0, we don't want to
			# accumilate nicks in a dead count key.
			delete($rnicks{$keynick}{memos}{count}{$sender});
			# if we had all deleted memos we don't even need
			# to delete us in the temp hash cos we're not there
			# so just get next key..
			next;
			}

		# if there werw memos they'll be in the temphash,
		# copy them over
		$rnicks{$keynick}{memos}{nicks}{$sender} =
			$temphash{$keynick}{memos}{nicks}{$sender};

		# we're done with this part of the temp hash, when we're done
		# with the recipient nick we'll then delete the old index
		# base key and put the new one in.

		delete($temphash{$keynick}{memos}{nicks}{$sender});
		} # end each sender

	# Did we get to 0 for memos on this nick? If so, delete the
	# total key, so we can tell them their empty later.  Actualy,
	# we check for non-null and 0 so we're really just cleaning up
	# here.
	if($rnicks{$keynick}{memos}{total} == 0)
		{
		delete($rnicks{$keynick}{memos}{total});
		}
	# we're moving to the next recipient nick, remove the old index
	# base key and put in the new one.
	delete($rnicks{$kenick}{memos}{index});
	$rnicks{$keynick}{memos}{index} = $temphash{$keynick}{memos}{index};

	# and at last, just undefine the entire temphash
	undef(%temphash);
	} # end each registered nick

# *sigh* what a mess that was, I just didn't
# want to go changing the memoserv commands.

# Well, here's where we traverse all the database hashes.
# This is a long process so we tried our best to do some sort
# of fork for windows so it'll work on that platform as well.
# If it worked, we have two processes running right now, one
# with either NO value for $myprocess or valued as -Win32.daemon
# and the forked copy would have -Win32.spoon which will be the
# one to run this task.  Win32.daemon, or undef, will be responsible
# for sending info to logs, setting error values and checking
# that we actually have a spoon process running.  Whichever way it
# is we can still write the databases.  If spoon failed but we're still
# alive then we can go ahead and write them under main, which is slow
# but it's nice to have it working anyway.  I wonder what I can do
# about mac fork....hmm... I gotta get me a mac I think :)

# Ok, here we go, if fork doesn't work we'll still run through
# these routines and we've kludged some 'pong(s)' to appease
# the server.

# TODO . add the open2() command for those system that don't
# support win32::Process
# TODO . find a fix for the 'out of sync' we'll eventualy get
# with messages from main about writedata and the actual spoon
# writting the data.  Somehow we have to set the timers on main
# to co-inside with the timers on spoon.  Maybe a file? Maybe just
# return from the process without messages?

# are we main process, are we windows os? do we have spoon flaged??
# Then we assume spoon is running and will handle the task.
if( ($myprocess !~ /Win32.spoon/i)
	&& ($flags{fakefork} =~ /yes/i)
	&& ($flags{os} =~ /windows/i) )
	{
	&writelog("Main detects Win32.spoon running, ret to normal processing");

	# reset the countdown, we have to fix this, we don't really need to
	# come back here but until we figure out all the complexities we really
	# should keep everything as unchanged as it was before the advent of
	# spoon/fakefork.
	$synctime = $writetime;
	# turn into seconds
	$syncnow = time() + ($synctime * 60);
	return;
	}
# are we the spoon?
if($myprocess =~ /Win32.spoon/i)
	{
	# we don't have to worry about ping, even if we could dup S, which
	# we couldn't under windows, the main process would be responding
	# for that open connection.  But, as it happens, we're listening
	# to the main process for our messages and THAT will never ping out.
	# In any event, all of that really has nothing to do with this
	# except to explain that we dont' need to PONG...here we go...
	# write the databases under Win32

	# gain &writelog rights
	$myrights{log} = 1;
	$myrights{display} = 1;

	&writelog("Win32.spoon writting databases, this could take a while...", 1);
	&writelog("Win32.spoon writing $chansdb...", 1);
	&save('%rchans', "$datadir/$chansdb");
	&writelog("Win32.spoon writing $nicksdb...", 1);
	&save('%rnicks', "$datadir/$nicksdb");
	&writelog("Win32.spoon writing $gamesdb...", 1);
	&save('%rgames', "$datadir/$gamesdb");
	&writelog("Win32.spoon writing $opersdb...", 1);
	&save('%opcoms', "$datadir/$opersdb");
	&writelog("Win32.spoon done writing databases, returning", 1);

	# disable access rights.
	delete($myrights{log});
	delete($myrights{display});

	# now reset the interval
	# countdown database write
	$synctime = $writetime;
	# turn into seconds
	$syncnow = time() + ($synctime * 60);

	return;
	}
# well, we determined that:
# We're not spoon
# We're not main with fake fork enabled
# We must be main with fakefork disabled
##
# That means we check os flag and if it's windows we
# don't even try to fork.  if it's anything else we'll
# try to fork but on second failure we'll run under main.
## 

$pid = eval('fork') if ($flags{os} !~ /windows/i);

# if it's defined and not 0
if($pid)
	{
	# pid was defined and not 0, I'm the parent.
	&writelog("1: writedatabase spawned process $pid ... good.", 1);
	&writelog("2: disabled database flag and ret to normal processing", 1);

	# cannot set flags and variables in child or we won't
	# see the changes, it's a totaly seperate environment now.
	$flags{database} = "disabled";

	# save the pid for this task in our list so we know what's
	# finished when this child returns.
	$pidlist{$pid} = {};
	undef($pid); # paranoia
	return;
	}
elsif($pid eq "0")
	{
	# I'm the child
	# reset the signals so we don't exit here until we're done
	# writting databases or we'll get a corrupt datafile.
	if($flags{os} !~ /windows/i)
		{
		$SIG{INT} = sub { return; }; $SIG{TERM} = sub { return; }; $SIG{HUP} = sub { return; };
		$SIG{QUIT} = sub { return; }; $SIG{KILL} = sub { return; }; $SIG{STOP} = sub { return; };
		}
	# ok, before we go allocating more memory, let's just clean up some
	# stuff we'll never use. We might miss things here but at least
	# we clean up the biggies.
	undef(%nicks); undef(%chans); undef(%opers); undef(%commands);
	undef(%ctcp);
	# now close file handles we don't need.
	close(STDIN); close($mysock); # need stdout for &display

	&writelog("child writting databases, this could take a while...", 1);
	&writelog("child writing $chansdb...", 1);
	&save('%rchans', "$datadir/$chansdb");
	&writelog("child writing $nicksdb...", 1);
	&save('%rnicks', "$datadir/$nicksdb");
	&writelog("child writing $gamesdb...", 1);
	&save('%rgames', "$datadir/$gamesdb");
	&writelog("child writing $opersdb...", 1);
	&save('%opcoms', "$datadir/$opersdb");
	&writelog("child done writing databases, exiting", 1);
	exit(1);
	}

# if we got this far we got the undefined value in $pid,
# this means the fork failed, let's find out why, or we're
# windows.

# test for non existing fork function
if($@ =~ /unsupported|function|unimplemented/i)
	{
	&writelog("1: writedatabase reports error, fork not implemented", 1);
	&writelog("2: pre 5.6 win32 perl does not support fork", 1);
	&writelog("3: upgrade to remove the pause associated with database write", 1);
	&writelog("4: or fork not supported at all on this platform, mac?", 1);
	}
elsif($flags{os} =~ /windows/i)
	{
	&writelog("1: writedata reports no fork, no spoon", 1);
	&writelog("2: running save under main instead. if your service pings", 1);
	&writelog("3: out during this write you'll need to fix it manualy", 1);
	&writelog("4: If your perl supports Win32 Process then enable the fakefork flag", 1);
	&save('%rchans', "$datadir/$chansdb");
	&send("PONG :$uline\n");
	&save('%rnicks', "$datadir/$nicksdb");
	&send("PONG :$uline\n");
	&save('%rgames', "$datadir/$gamesdb");
	&send("PONG :$uline\n");
	&save('%opcoms', "$datadir/$opersdb");
	&writelog("Main database write finished", 1);
	# now reset the interval
	# countdown database write
	$synctime = $writetime;
	# turn into seconds
	$syncnow = time() + ($synctime * 60);
	return;
	}
# fork's ok, we just couldn't create a process, we'll
# try twice before using main to write with
# have we tried already?
elsif(!$forkfull)
	{
	$forkfull = 1;
	&writelog("1: writedatabase reports error: Couldn't fork,", 1);
	&writelog("2: I'll try again at half the write interval, or", 1);
	&writelog("3: 2 minutes if your data write is 0", 1);

	# reset the write interval to a few minutes into
	# the future. we don't want to wait an entire period
	# before attempting another write, unless of course
	# the period is really short, hey, let them mis-configure
	# it if they wanna.

	# countdown database write
	# test for zero, no dividing zeros here
	if($writetime) { $synctime = ($writetime / 2); }
	else { $synctime = 2; } # seems like a good number

	# turn into seconds
	$syncnow = time() + ($synctime * 60);
	return; # or we'll fall through and use main process for save
	}
else
	{
	undef($forkfull); # for next try
	&writelog("writedatabase reports error: Couldn't fork on second try, using main instead", 1);
	}
&writelog("1: writedata reports error, fork failed,", 1);
&writelog("2: running save under main instead. if your service pings", 1);
&writelog("3: out during this write you'll need to fix it manualy", 1);
&save('%rchans', "$datadir/$chansdb");
&send("PONG :$uline\n");
&save('%rnicks', "$datadir/$nicksdb");
&send("PONG :$uline\n");
&save('%rgames', "$datadir/$gamesdb");
&send("PONG :$uline\n");
&save('%opcoms', "$datadir/$opersdb");
&writelog("Main database write finished", 1);

# now reset the interval
# countdown database write
$synctime = $writetime;
# turn into seconds
$syncnow = time() + ($synctime * 60);

}
# --------------------------------------------------------------------------
# SAVE
# --------------------------------------------------------------------------
# Saves an entire hash database to a file
sub save
{
# Call with '%hashname' and $filename
# Dont' pass a hash to this, I'm not even sure that works, and
# not a reference either, just the name via $variable = '%rchans';
# or easier yet, save('%rchans', "$dirname/$filename");

my($base, $key, $value);

$bHash = $_[0]; # hash name

if (! open HASHBASE, ">$_[1]")
	{
	&writelog("sub save reports can't open $_[1]: $!");
	return; # don't do anything else
	}

# Turn name %name into $name for element lookups / walking
$bHash =~ s/^%/\$/; # for later use

$base = eval("\\"."$_[0]"); # turn $base into reference to %{name}

while( ($key, $value) = each %{$base})
	{
	# excape the channel name junk so we can eval this
	# first base key line without error.

	# first pass assigns value here, all recursive passes get
	# their values assiged by walk

	# don't save HASH mem location as key, it'll cause database
	# corruption later because having a key of HASH(0xsomething)
	# will not prevent perl from allocating a REAL HASH reference
	# with that same name.
	if(ref($$base{$key}) eq "HASH")
		{
		# replace backwack with double backwack, first,
		# or we'll backwack the wacks we backwacked the
		# single quotes with.  oh, we do this because even
		# in single quotes the backwack is interpreted as
		# an escape character.
		$key =~ s/\\/\\\\/g;
		$key =~ s/\'/\\'/g;
		print HASHBASE ("$bHash"."\{'$key'\}".' = '."\{\};\n");
		}
	else
		{
		$key =~ s/\\/\\\\/g;
		$key =~ s/\'/\\'/g;
		$value =~ s/\\/\\\\/g;
		$value =~ s/\'/\\'/g;
		print HASHBASE ("$bHash"."\{'$key'\}".' = '."'$value';\n");
		}
	&walk($key);

	# kill base name so first call saves new key
	# or we'll be here forever if next loop is foreach,
	# not to mention the fact that we won't get the job done.
	# Oh, I guess I mentioned it huh?
	undef($bSave);
	undef($bKey);
	}

print HASHBASE "1;"; # so it returns true on require
close(HASHBASE);

# We're done, kill gloals or you'll get an interesting surprise next call
undef($bSave);
undef($bHash);
undef($base); undef($key); undef($value);
}
# ------------------
# WALK
# ------------------
sub walk
{
# $bHash already defined, it's the hash name
# $bKey is defined if we've been here before, it's the base, first key

my($hash, $base, $save, $key, $value);

# are we in a walk() loop traversing a hash or on the
# first key setting up?
if(!defined($bKey))
	{
	$bKey = $_[0];
	}
else
	{
	$save = $_[0];
	}

#print "bKey: $bKey\n";

# no matter what we do we eval the same way using the same vars
$hash = "$bHash\{'$bKey'\}".$save;
$base = eval($hash); # it's a copy but we'll change it

#print "$hash\n";
# print "key: $base\n";

while( ($key, $value) = each %{$base})
	{
	if(ref($$base{$key}) eq "HASH")
		{
		# Backwack the backwacks cos they get interpreted as
		# escape characters even in single quotes.
		$key =~ s/\\/\\\\/g;
		$key =~ s/\'/\\'/g;
		print HASHBASE ("$bHash"."\{'$bKey'\}".$save."\{'$key'\}".' = '."\{\};\n");
		}
	else
		{
		$key =~ s/\\/\\\\/g;
		$key =~ s/\'/\\'/g;
		$value =~ s/\\/\\\\/g;
		$value =~ s/\'/\\'/g;
		print HASHBASE ("$bHash"."\{'$bKey'\}".$save."\{'$key'\}".' = '."'$value';\n");
		}
	$hash = $save."\{'$key'\}";
	&walk($hash);
	}

}
# --------------------------------------------------------------------------
# DUMP
# --------------------------------------------------------------------------
# Dump the selected database hash to disk.  We use Win32.spoon if we don't
# have fork, just like in writedatabase
sub dump
{
my($hashname, $dumpfile);
# first setup globals so child has these
$hashname = $_[0]; $dumpfile = $_[1];

# Trap error on system without fork, like win32
# perl pre 5.6 - then we'll run normal processing
# and wait, since we can't spawn on those systems.

# are we main process, are we windows os? do we have spoon flaged??
# Then we assume spoon is running and will handle the task.
if( ($myprocess !~ /Win32.spoon/i)
	&& ($flags{fakefork} =~ /yes/i)
	&& ($flags{os} =~ /windows/i) )
	{
	&writelog("Main detects Win32.spoon running, ret to normal processing");
	return;
	}
# are we the spoon?
if($myprocess =~ /Win32.spoon/i)
	{
	# gain &writelog rights
	$myrights{log} = 1;
	$myrights{display} = 1;

	&writelog("Win32.spoon dumpfile, this could take a while...", 1);
	&writelog("Win32.spoon writing $dumpdir/$dumpfile ...", 1);
	&save($_[0], "$dumpdir/$dumpfile");
	&writelog("Win32.spoon done writing $dumpdir/$dumpfile, returning", 1);

	# disable access rights.
	delete($myrights{log});
	delete($myrights{display});
	return;
	}
# We're not spoon
# We're not main with fake fork enabled
# We must be main with fakefork disabled
##
# That means we check os flag and if it's windows we
# don't even try to fork.  if it's anything else we 
# write under main.
## 

$pid = eval('fork') if ($flags{os} !~ /windows/i);

# if it's defined and not 0
if($pid)
	{
	# pid was defined and not 0, I'm the parent.
	&writelog("1: dumping hash $hashname spawned process $pid ... good.", 1);
	&writelog("2: returning to normal processing", 1);
	# so SIGDONE knows to delete database flag, idano if i realy need this
	# anymore, I have to check this entire main now because of all the
	# canges I've made to accomodate windows.
	$pidlist{$pid} = {};
	$flags{database} = "disabled"; # so we don't access during write
	return;
	}
elsif($pid eq "0")
	{
	# I'm the child
	# reset the signals so we don't exit here until we're done
	# writting databases or we'll get a corrupt datafile.

## I don't think we need to set sigs here now, I've done a lot of work
## since this block, um... we need SIG CHLD to point to sub SIGDONE
## so it removes the {database} flag.
#
#	if($flags{os} =~ /windows/i)
#		{
#	# windows don't like to lose control over signals
#	#	$SIGH{INT} = sub { return; };
#		}
#	else
#		{
#		# These get reset on exit, we don't have to put them back.
#		$SIG{INT} = sub { return; }; $SIG{TERM} = sub { return; }; $SIG{HUP} = sub { return; };
#		$SIG{QUIT} = sub { return; }; $SIG{KILL} = sub { return; }; $SIG{STOP} = sub { return; };
#		}
##
	# release some memory, we're only dumping one hash, if it's not
	# the one we're dumping we release it.

	undef(%ctcp)		if "%ctcp"	ne $_[0];
	undef(%nicks)		if "%nicks"	ne $_[0];
	undef(%chans)		if "%chans"	ne $_[0];
	undef(%opers)		if "%opers"	ne $_[0];
	undef(%rnicks)		if "%rnicks"	ne $_[0];
	undef(%rchans)		if "%rchans"	ne $_[0];
	undef(%rgames)		if "%rgames"	ne $_[0];
	undef(%commands)	if "%commands"	ne $_[0];

	# Close file handles we won't use
	close(STDIN); close($mysock); # need stdout for &display

	&writelog("child dumpfile, this could take a while...", 1);
	&writelog("child writing $dumpdir/$dumpfile ...", 1);
	&save($_[0], "$dumpdir/$dumpfile");
	&writelog("child done writing $dumpdir/$dumpfile, exiting", 1);
	exit(1);
	}
# if we got this far we got the undefined value in $pid,
# this means the fork failed, let's find out why.

# test for non existing fork function
if($@ =~ /unsupported|function|unimplemented/i)
	{
	&writelog("1: dump reports error, fork not implemented", 1);
	&writelog("2: pre 5.6 win32 perl does not support fork", 1);
	&writelog("3: upgrade to remove the pause associated with dump", 1);
	&writelog("4: or fork not supported at all on this platform, mac?", 1);
	}
elsif($flags{os} =~ /windows/i)
	{
	&writelog("1: sub dump reports no fork, no spoon", 1);
	&writelog("2: running save under main instead. if your service pings", 1);
	&writelog("3: out during this write you'll need to fix it manualy", 1);
	&writelog("4: If your perl supports Win32 Process then enable the fakefork flag", 1);
	&save($hashname, "$dumpdir/$dumpfile");
	&writelog("Main dump write finished", 1);
	return;
	}
&writelog("1: sub dump reports error: Fork failed $@", 1);
&writelog("2: dumping file under main instead", 1);
&save($hashname, "$dumpdir/$dumpfile");
&writelog("main done writing $dumpdir/$dumpfile, returning to duties", 1);

}
# --------------------------------------------------------------------------
# SIGDONE
# --------------------------------------------------------------------------
# child signals that it's done. currently we only use fork to spawn the
# database saving processes so when a child returns we set the timers
# again for the next data write.  we won't ask for another write until
# the child returns since it can take quite a while.

sub SIGDONE
{
$childpid = wait; # get the pid of this child after dead
&writelog("SIGDONE returns dead child with pid $childpid on signal:$?", 1);

# we saved the pid of the child process that's responsible for
# writting the databases.  if we get this one back we'll set the
# database write timer back to normal, otherwise it's disabled
# until we get a return on chld.

# we won't enter here if we're a dump because our pid
# isn't in this list.
if($pidlist{$childpid})
	{
	# now reset the interval
	# countdown database write
	$synctime = $writetime;
	# turn into seconds
	$syncnow = time() + ($synctime * 60);

	# now delete the disabled flag, this will tell sub timers
	# to go ahead and call writedatabase again, cos we're
	# not already doing it.
	delete($flags{database});

	# and delete this pid from the hash
	delete($pidlist{$childpid});
	&writelog("SIGDONE reset writedatabase timers and flags", 1);
	return;
	}

# was this a dump and we're only holding off on
# a write until done? we don't want to scramble the
# hashes so can only traverse them of noone else is
# so we fill the flag with a special indicator.
# when we use the DUMP command this flag is set with
# value 'dump' so we don't reset the timers. a write
# may be ready.
if($flags{database} eq "dump")
	{
	delete($flags{database});
	# nothing else to do, we only dumped
	}

}
# --------------------------------------------------------------------------
# --------------------------------------------------------------------------

# --------------------------------------------------------------------------
# --------------------------------------------------------------------------

# --------------------------------------------------------------------------
# --------------------------------------------------------------------------

# --------------------------------------------------------------------------





