/*************************************************/
/* Treiber fr die Expert Mouse Clock            */
/*                                               */
/* angefangen am 02.10.99                        */
/* Helmut Fahrion                                */
/* hefa@gmx.de                                   */
/*************************************************/


#include "dcf.h"

void signal_handler_kill (int status);	/* nach killen Schnittstelle zurck */
void initseriell ();		/* Schnittstelle definieren 50Bbp ... */
void readdcf ();		/* liest die Daten von der Schnittstelle */
int gettimefromdcf ();		/* zeit bilden */
int zum_daemon (); /* echten Daemon erzeugen */


BIT59 time1, time2;
volatile int STOP = FALSE;

int fd;
struct termios oldtio, newtio;

int sz_umsch = 0;		/* Sommerzeitumschaltung */

int rts = 1;
int dtr = 0;

/* Verbose Level */
int verbose = 0;
#define VALLES verbose>=3
#define VMELD  verbose>=2
#define VERROR verbose>=1
/*
   v = 0  nichts
   v = 1  errors
   v = 2  meldungen
   v = 3  alles
 */


#define DEV_LEN 60
char modemdevice[60] = "/dev/ttyS0";	/* correct port */

int printtime = 0;
int setsystime = 1;

long max_systime_diff = 10800L; /* Zeitmaximum welcher gesetzt wird */
int  drift=5*60;  /* Wieviel Minuten auf einmal gesetzt werden drfen */

int
main (int argc, char **argv)
{
  int x;

  /* Signal umbiegen */

  signal (SIGTERM, signal_handler_kill);	// killall
  signal (SIGINT, signal_handler_kill);		// ^C 

  printf ("dcf: starte..., ");
  while ((x = getopt (argc, argv, "D:m:d:v:hrspy")) != -1)
    {
      switch (x)
	{
	case 'D':
	  sscanf (optarg, "%d", &drift);
	  if (VMELD)
	    {
	      printf ("Drift auf %d Minuten gesetzt\n", drift);
	    }
          drift *= 60;
	  break;
	case 'm':
	  sscanf (optarg, "%ld", &max_systime_diff);
	  if (VMELD)
	    {
	      printf ("Systemdiff auf %ld gesetzt\n", max_systime_diff);
	    }
	  break;
	case 'p':
	  printtime = 1;
	  if (VMELD)
	    {
	      printf ("printtime=1, gebe Zeit aus\n");
	    }
	  break;
	case 'y':
	  setsystime = 0;
	  if (VMELD)
	    {
	      printf ("setze Systemzeit nicht!\n");
	    }
	  break;
	case 'r':
	  dtr = 1;
	  if (VMELD)
	    {
	      printf ("dtr=1\n");
	    }
	  break;
	case 's':
	  rts = 0;
	  if (VMELD)
	    {
	      printf ("rts=0\n");
	    }
	  break;
	case 'd':
	  strncpy (modemdevice, optarg, TESTLEN (optarg, DEV_LEN));
	  if (VMELD)
	    {
	      printf ("Modemdevice=%s\n", modemdevice);
	    }
	  break;
	case 'v':
	  /* if (!strcmp(optarg, "1")) */
	  verbose = 1;

	  if (!strcmp (optarg, "2"))
	    verbose = 2;

	  if (!strcmp (optarg, "3"))
	    verbose = 3;

	  if (VMELD)
	    {
	      printf ("Verbose Level=%d\n", verbose);
	    }

	  break;
	default:
	  fprintf (stderr, "Die Parameterbeschreibung kommt mit: dcf_srv -h \n\n");
	case 'h':
	  printf ("Parameter:\n");
	  printf ("dcf_srv[-v1 | -v2 | -v3][-d /dev/ttyS1][-r][-s][-y][-p][-m 2400]\n\n");
	  printf ("v1: Verbose, Errors\n");
	  printf ("v2: Verbose, Error und Meldungen\n");
	  printf ("v3: Verbose, Alles\n");
	  printf ("default sind keinerlei Ausgaben. Auer der Startmeldung.\n\n");
	  printf ("d: /dev/ttyS0 das Device fr die Funkuhr\n");
	  printf ("D: Drift in Minuten, Zeit wird schrittweise gesetzt.\n");
	  printf ("r: dtr = 1\n");
	  printf ("s: rts = 0\n");
	  printf ("Mit r und s sollten Sie nur arbeiten wenn die Funkuhr sonst nicht geht.\n\n");
	  printf ("y: setzt die Systemzeit nicht\n");
	  printf ("p: gibt die Zeit als String aus\n");
	  printf ("m 1800: falls die Funkzeit mehr als 1800 sek, von der\n");
	  printf ("Systemzeit abweicht, wird die Systemzeit nicht gesetzt.\n");
	  exit (0);
	  break;
	}
    }

  printf("\n");

  initseriell ();		/* Schnittstelle */

  zum_daemon (); /* Deamon */

  /* Endlos schleife */
  while (1)
    {				/* loop for input */
      readdcf ();
      gettimefromdcf ();
    }

  /* zurcksetzen,  unerreichbarer Code !!! */
  tcsetattr (fd, TCSANOW, &oldtio);

  return 0;
}


int zum_daemon(void)
{
	pid_t pid;

	if ( ( pid = fork()) < 0 ) {
		return -1;
	} else if ( pid != 0 ) {
		exit(0); // Elternprozess beendet sich
	}

	// Kind
	setsid(); // Kind wird Sessionfhrer
	chdir("/"); // Wechseln zum Rootdir
	umask(0); // Dateikreirungsmaske loeschen
	
	return 0;
}

void 
initseriell (void)
{
  int res;

  /* 
     Open modem device for reading and writing and not as controlling tty
     because we don't want to get killed if linenoise sends CTRL-C.
   */
  fd = open (modemdevice, O_RDONLY);
  if (fd < 0)
    {
      perror (modemdevice);
      exit (-1);
    }

  printf ("Schnittstelle ok. ");
  fflush (stdout);

  tcgetattr (fd, &oldtio);	/* save current port settings */
  bzero (&newtio, sizeof (newtio));

  /* 
     BAUDRATE: Set bps rate. You could also use cfsetispeed and cfsetospeed.
     CRTSCTS : output hardware flow control (only used if the cable has
     all necessary lines. See sect. 7 of Serial-HOWTO)
     CS8     : 8n1 (8bit,no parity,1 stopbit)
     CLOCAL  : local connection, no modem contol
     CREAD   : enable receiving characters
   */

  newtio.c_cflag &= ~(PARENB | PARODD | CSIZE | CSTOPB);
  newtio.c_cflag |= BAUDRATE | CRTSCTS | CS8 | CLOCAL | CREAD;

  /* newtio.c_iflag = IGNPAR; */
  newtio.c_oflag = 0;

  /* set input mode (non-canonical, no echo,...) */
  newtio.c_lflag = 0;

  newtio.c_cc[VTIME] = 0;	/* inter-character timer unused */
  newtio.c_cc[VMIN] = 1;	/* blocking read until x chars received */


  /* Geschwindigkeit setzen */
  cfsetispeed (&newtio, BAUDRATE);
  cfsetospeed (&newtio, BAUDRATE);

  tcflush (fd, TCIFLUSH);
  tcsetattr (fd, TCSANOW, &newtio);

  /* gebraucht ??? */
  tcflush (fd, TCIOFLUSH);

  /* clear rts */
  if (rts)
    {
      res = TIOCM_RTS;
      ioctl (fd, TIOCMBIC, &res);
    }

  if (dtr)
    {
      res = TIOCM_DTR;
      ioctl (fd, TIOCMBIC, &res);
    }

}


void
shr59 (BIT59 bits, unsigned char inbit)
{
  unsigned char carry0, carry1, carry2, carry3;

  /* 59 Bit 1 x rechts schiften */
  carry0 = (bits[0] & 1);
  carry1 = (bits[1] & 1);
  carry2 = (bits[2] & 1);
  carry3 = (bits[3] & 1);
  bits[0] = shr (bits[0], 1);
  bits[1] = shr (bits[1], 1);
  bits[2] = shr (bits[2], 1);
  bits[3] = shr (bits[3], 1);
  if (carry1 == 1)
    bits[0] = (bits[0] | 0x8000);
  if (carry2 == 1)
    bits[1] = (bits[1] | 0x8000);
  if (carry3 == 1)
    bits[2] = (bits[2] | 0x8000);
  if (carry0 == 1)
    bits[3] = (bits[3] | 0x0400);

  /* neues Bit auf Position */
  if (inbit != 0)
    bits[2] = (bits[2] | 0x40);
  else
    bits[2] = (bits[2] & (~0x40));
}

void
readdcf ()
{
  unsigned char inbit;
  int n;

  n = read (fd, &inbit, sizeof (char));

  if (VALLES)
    fprintf (stderr, " %x", inbit);

  if ((inbit == 0) || (inbit == 128) || (inbit == 192) || (inbit == 224))
    inbit = 1;
  else
    inbit = 0;

  /* time1 in time2 schieben    */
  if (((time1[2] & 0x80)) != 0)
    shr59 (time2, 1);
  else
    shr59 (time2, 0);

  shr59 (time1, inbit);
}

static BIT59 *l_time;

static unsigned char
count_1 (unsigned char bits)
{
  unsigned char r_count, t, y;
  y = 0;

  for (t = 1; t <= bits; t++)
    {
      if ((((*l_time)[2] & 0x80)) == 0x80)
	y++;

      shr59 (*l_time, 0);
    }
  r_count = y;
  return (r_count);
}

unsigned int
parity_check (BIT59 v_time)
{
  BIT59 p_time;

  memmove (p_time, v_time, sizeof (BIT59));
  l_time = (BIT59 *) p_time;

  /* Header entfernen   */
  count_1 (20);

  /* Prfbit 1  */
  if (((count_1 (8) & 1)) == 1)
    return (FALSE);

  /* Prfbit 2  */
  if (((count_1 (7) & 1)) == 1)
    return (FALSE);

  /* Prfbit 3  */
  if (((count_1 (23) & 1)) == 1)
    return (FALSE);

  return (TRUE);
}

void
dcf2tm (BIT59 v_time, struct tm *ltime)
{
  BIT59 ti;
  unsigned mesz;

  memmove (ti, v_time, sizeof (BIT59));
  memset (ltime, 0, sizeof (struct tm));

  ltime->tm_sec = 0;
  ltime->tm_min = ((ti[0] & 0x0F)) + (((shr (ti[0], 4)) & 0x07)) * 10;
  ltime->tm_hour = (((shr (ti[0], 8)) & 0x0F)) + (((shr (ti[0], 12)) & 0x03)) * 10;
  ltime->tm_mday = (((shl (ti[1], 1)) & 0x0F)) + (((shr (ti[1], 3)) & 0x03)) * 10;
  if (((ti[0] & 0x8000)) == 0x8000)
    (ltime->tm_mday)++;

  ltime->tm_mon = (((shr (ti[1], 8)) & 0x0F)) + (((shr (ti[1], 12)) & 0x01)) * 10
    /* tm_monat beginnt bei 0 */
    -1;

  ltime->tm_year = (((shr (ti[1], 13)) & 0x07)) + 
    ((ti[2] & 0x01)) * 8 + 
    (((shr (ti[2], 1)) & 0x0F)) * 10;

  /* das funktioniert von 1970 bis 2069 */
  if (ltime->tm_year < 70)
    ltime->tm_year += 100;

  if (VALLES)
    fprintf (stderr, "\n ti3= %04x ti2= %04x ti1= %04x ti0= %04x\n", 
	       ti[3], ti[2], ti[1], ti[0]);
  
  if (ti[3] & 0x80)
    mesz = TRUE;
  else
    mesz = FALSE;

  if (mesz)
    ltime->tm_isdst = 1;

#ifndef TEST
  if (ti[3] & 0x40)
    sz_umsch = TRUE;
#endif

}

int
check_currtime (time_t ti, long max_diff)
{
  double diff;

  /* Test gegen aktuelle Systemzeit     */
  diff = difftime (ti, time (NULL));

  if (diff < (double)max_diff)
    {
      if (VMELD)
	fprintf (stderr, "dcf: Check_Currtime OK!\n");
      return (TRUE);
    }
  else
    {
      if (VERROR)
	{
	  fprintf (stderr, "dcf: gelesene DCF-Zeit weicht zu stark von der aktuellen Systemzeit ab\n");
	  fprintf (stderr, "Systemzeit wird nicht aktualisiert! diff=%.0f\n", diff);
	}
    }

  return (FALSE);
}

int
time_check (void)
{
  struct tm ltime1, ltime2;
  time_t t1, t2;
  int diff;

  /*  memset (&ltime1, 0, sizeof (struct tm));
  memset (&ltime2, 0, sizeof (struct tm));
  */

  /* pruefen, ob zwei Minuten richtig eingelesen wurden */
  if (((time1[3] & 0x041F) == 0x0400) &&	/* Startbit Zeit        */
      ((time1[2] & 0xFFC0) == 0) &&	/* Header                       */
      ((time2[3] & 0x041F) == 0x0400) &&
      ((time2[2] & 0xFFC0) == 0) &&
      (parity_check (time1) == TRUE) &&
      (parity_check (time2) == TRUE))
    {
      dcf2tm (time1, &ltime1);
      t1 = mktime (&ltime1);

      if (VMELD)
	{
	  printf ("dcf: DCF-Zeit 1 eingelesen\n");
	  printf ("dcf: Zeit : %.2u:%.2u:%.2u\n", ltime1.tm_hour, ltime1.tm_min, ltime1.tm_sec);
	  printf ("dcf: Datum: %.2u.%.2u.%.4u\n", ltime1.tm_mday, ltime1.tm_mon + 1, ltime1.tm_year+1900);
	  printf ("dcf: t1=%ld\n", t1);
	}

      dcf2tm (time2, &ltime2);
      t2 = mktime (&ltime2);

      if (VMELD)
	{
	  printf ("dcf: DCF-Zeit 2 eingelesen\n");
	  printf ("dcf: Zeit : %.2u:%.2u:%.2u\n", ltime2.tm_hour, ltime2.tm_min, ltime2.tm_sec);
	  printf ("dcf: Datum: %.2u.%.2u.%.4u\n", ltime2.tm_mday, ltime2.tm_mon + 1, ltime2.tm_year+1900);
	  printf ("dcf: t2=%ld\n", t2);
	}

      /*diff = difftime (t1, t2);*/
      diff = difftime (mktime (&ltime1), mktime (&ltime2));

      if (VMELD)
	{
	  printf ("dcf: diff=%d t1=%ld t2=%ld\n", diff, 
		  mktime (&ltime1), mktime (&ltime2));
	}


      if ((sz_umsch == TRUE) && VMELD)
	{
	  printf ("dcf: Sommerzeit=1!\n");
	}

#if 0
      if (sz_umsch == TRUE)
	/* Ausnahme SZ-Umschaltung      */
	{
	  if ((diff == 3660) || (diff == -3540))
	    {
	      if (check_currtime (t1, max_systime_diff + 3600L) == TRUE)
		{
		  sz_umsch = FALSE;
		  return (TRUE);
		}
	    }
	}
      else
#endif
	if (/*(diff == 60) &&*/ 
	    check_currtime (t1, max_systime_diff))
	  {
	    return (TRUE);
	  }
    }

  return (FALSE);
}


void settime(struct timeval gtime)
{
  if (settimeofday (&gtime, NULL))
    {
      if (VERROR)
	{
	  fprintf (stderr, "dcf: Fehler beim setzen der Uhrzeit: %s\n",
		   strerror (errno));
	}
    }
  else
    {
      if (VMELD)
	printf ("dcf: Zeit gesetzt!\n");
    }
}

int
gettimefromdcf ()
{
  struct timeval gtime;
  /* struct timezone tz; */

  struct tm ltime;
  time_t t, j, d;
  int ret;

  if (time_check () == TRUE)
    {
      dcf2tm (time1, &ltime);

      if (VMELD)
	{
	  printf ("dcf: DCF-Zeit eingelesen, wird gesetzt!\n");
	  printf ("dcf: Zeit : %.2u:%.2u:%.2u\n", ltime.tm_hour, ltime.tm_min, ltime.tm_sec);
	  printf ("dcf: Datum: %.2u.%.2u.%.4u\n", ltime.tm_mday, ltime.tm_mon + 1, ltime.tm_year+1900);
	}

      if (printtime)
	{
	  printf ("dcf: %.2u.%.2u.%.4u %.2u:%.2u:%.2u\n", ltime.tm_mday, ltime.tm_mon + 1, ltime.tm_year+1900, ltime.tm_hour, ltime.tm_min, ltime.tm_sec);
	  fflush(stdout);
	}

      /* Timer-Wert bilden      */
      t = mktime (&ltime);

      gtime.tv_sec = (unsigned long) t;
      gtime.tv_usec = 0L;

      if (setsystime)
	{
	  j = time(NULL); /* jetzt */

	  d = t - j;  /* delta von ist zur soll */
	  
	  /* unterschied ist grer als sein soll */
	  if ( abs(d) > (drift) ) {
	    /* System Uhr geht nach ? */
	    gtime.tv_sec = (unsigned long) (d<0)? j- drift: j+drift;

	    if (VMELD) {
              printf("dcf: setze drift %d Minuten!\n", drift/60);
            }

	  }

	  settime(gtime);

	}

      /* bei SZ-Wechsel angekndigt immer Netzupdate */
      ret = TRUE;
    }
  else
    ret = FALSE;

  return (ret);
}


void
signal_handler_kill (int status)
{
  if (VMELD)
    printf ("\ndcf: gekillt!\n");

  /* schnittstelle zurck */
  tcflush (fd, TCIFLUSH);
  tcsetattr (fd, TCSANOW, &oldtio);

  /* datei zu */
  close (fd);

  /* ohne Fehler raus */
  exit (0);
}
