#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# new_fax.sh -- Called by mgetty after fax reception.
# Creation: 12/04/98
# Update:   12/04/98
# V2.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell script is called by mgetty after fax reception and
#    uses the queued information context by mvm to forward that fax.
# BUGS
#    - Is $MODEM really set ?  Else won't work with multi-line.
# TODO
# NOTES
# BASED-ON
#    get_fax.sh V2.0 PV001 of 12/04/98.
# MODIFICATION-HISTORY
#    12/04/98  schaefer  Created this file.
# $Id: new_fax.sh,v 1.1 1998/04/12 14:36:53 schaefer Exp $

CONTEXT_FILE=/tmp/mvm_context_get_fax_${MODEM}

HANGUP_CODE=$1
SENDER_ID="$2"
NPAGES="$3"

PBM_UTILS=/usr/X11R6/bin/

shift;shift;shift


if [ -f $CONTEXT_FILE ]; then
   (read ACCOUNT
    read TO_FAX_NUMBER

    rm -f $CONTEXT_FILE

    NUMBER=1

    for i
    do
    (echo "Subject: fax from $SENDER_ID [$NUMBER/$NPAGES]"
     echo ""
     echo "Fax from $SENDER_ID with $NPAGES pages, this is page $NUMBER"
     echo "which has name $i. Received from account $ACCOUNT to be"
     echo "Forwarded to number $TO_FAX_NUMBER."
     echo ""

    # 2/2/96 separated because took too much swap

     $PBM_UTILS/g3topbm $i > $TMPFILE
     $PBM_UTILS/pnmscale -xscale .5 < $TMPFILE > $TMPFILE2
     rm $TMPFILE
     $PBM_UTILS/ppmtogif < $TMPFILE2 | uuencode a_fax.gif
     rm $TMPFILE2) | mail faxadm
     NUMBER=`expr $NUMBER + 1`
    done
   ) < $CONTEXT_FILE

else
   # normal behaviour
   NUMBER=1

   for i
   do
   (echo "Subject: fax from $SENDER_ID [$NUMBER/$NPAGES]"
    echo ""
    echo "Fax from $SENDER_ID with $NPAGES pages, this is page $NUMBER"
    echo "which has name $i."
    echo ""

   # 2/2/96 separated because took too much swap

    $PBM_UTILS/g3topbm $i > $TMPFILE
    $PBM_UTILS/pnmscale -xscale .5 < $TMPFILE > $TMPFILE2
    rm $TMPFILE
    $PBM_UTILS/ppmtogif < $TMPFILE2 | uuencode a_fax.gif
    rm $TMPFILE2) | mail faxadm
    NUMBER=`expr $NUMBER + 1`
   done
fi

exit 0
