#! /bin/sh
# convert.sh -- Initialization scripts french language
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 01/03/99
# Update:   01/03/99
# V1.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This generates the french language messages from the PVF sound
#    files for the format configured by the user.
# NOTES
# BUGS
# TODO
# BASED-ON
# MODIFICATION-HISTORY
#    01/03/99  schaefer  Created this file
# $Id: convert.sh,v 1.2 1999/03/01 18:10:14 schaefer Exp $

SAVED_SELECTED_LANGUAGE=$SELECTED_LANGUAGE
. /etc/mvm_definitions.sh
SELECTED_LANGUAGE=$SAVED_SELECTED_LANGUAGE

FRENCH_LIBRARY=$SCRIPTS_DIR/add_ons/french_numbers/library

if [ $# != 0 ]; then
   echo "$0" >&2
   echo "$0: bad args." >&2
   exit 2
fi

cd $FRENCH_LIBRARY

for i in numbers/*.pvf powers/*.pvf special/*.pvf ten/*.pvf
do
   DIRNAME=`dirname $i`
   FNAME=$DIRNAME/`basename $i .pvf`
   $PVF_TOOLS_DIR/$PVF_MODEM_FILTER < $i > $FNAME
done
