#! /bin/sh
# french_numbers.sh -- Say french numbers
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 10/05/97
# Update:   23/08/97
# V1.0 PV002
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    Attempts to say number in french based on a sample
#    library.
# NOTES
#    - Implementing the Swiss-french dialect (Neuchatel variant).
#    - Library data is modem-type specific for speed (and catting of
#      pvf does not work). Thus output is also in that format.
# BUGS
#    - Only support numbers upto 9999
# TODO
# ASSUMPTION
#    - The internal format of the library can be cat'ted to
#      generate a valid file.
# MODIFICATION-HISTORY
#    23/08/97  schaefer  Initial RCS register
# $Id: french_number.sh,v 1.3 1998/04/09 17:39:01 schaefer Exp $

. /etc/mvm_definitions.sh

SAMPLE_LIBRARY=$SCRIPTS_DIR/add_ons/french_numbers/library/

# SYNOPSIS
#    say_number(times, what) >> $OUTFILE
# RESULT
# DESCRIPTION
#    This function outputs a french synthesis.
# LOCAL-VARIABLES
#    TMP
# NOTES
# BUGS
# TODO

function say_number {
   case $2 in
      1) if [ $1 -gt 16 ]; then
            TMP=`expr $1 % 10`
            say_number `expr $1 / 10` 10
            if [ "$TMP" = "1" ]; then
               if [ `expr $1 / 10` != 8 ]; then
                  cat $SAMPLE_LIBRARY/special/et
               fi
            fi
            if [ "$TMP" != 0 ]; then
               cat $SAMPLE_LIBRARY/numbers/$TMP
            fi
         else
            cat $SAMPLE_LIBRARY/numbers/$1
         fi;;
      10) cat $SAMPLE_LIBRARY/ten/$1;;
      *) if [ "$1" != 1 ]; then
            cat $SAMPLE_LIBRARY/numbers/$1
         fi
         cat $SAMPLE_LIBRARY/powers/$2;;
   esac
}

if [ $# != 1 ]; then
   echo "$0 number"
   echo "$0: bad args."
   exit 2
fi

case $1 in
   [0-9]*) ;;
   *)   echo "$0 number outfile"
        echo "$0: bad args."
        exit 2;;
esac

NUMBER=$1

INITIAL_DIVIDER=1000

if [ `expr 1 + $NUMBER / 10` -gt $INITIAL_DIVIDER ]; then
   echo "Number too big $NUMBER" 1>&2
   exit 1
else
   if [ $NUMBER = 0 ]; then
      say_number 0 1
   else
      while [ $INITIAL_DIVIDER -gt 0 ];
      do
	 VALUE=`expr $NUMBER / $INITIAL_DIVIDER`
	 REMAINS=`expr $NUMBER % $INITIAL_DIVIDER`

	 if [ $VALUE -gt 0 ]; then
            if [ $NUMBER -gt 91 ]; then
	       say_number $VALUE $INITIAL_DIVIDER
            else
	       say_number $NUMBER 1
               INITIAL_DIVIDER=0
            fi
	 fi

	 NUMBER=$REMAINS

	 INITIAL_DIVIDER=`expr $INITIAL_DIVIDER / 10`
      done
   fi
fi

