#! /bin/sh
# speaches.sh -- Speak routines for french language
# Marc SCHAEFER <schaefer@alphanet.ch>
# Creation: 23/08/97
# Update:   01/03/99
# V1.0 PV002
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This implements french messages. This script must be used as follows:
#       --pre-formatted FILE_NAME.rmd --say-number NUMBER
#    Those arguments can figure multiple times.
# NOTES
# BUGS
# TODO
# BASED-ON
#    test.sh V1.0 PV002 of 23/08/97 (RCS: test.sh,v 1.1)
# MODIFICATION-HISTORY
#    23/08/97  schaefer  Initial RCS register
#    01/03/99  schaefer  Fixed cosmetic message error.
# $Id: speaches.sh,v 1.7 1999/03/01 18:22:59 schaefer Exp $

SAVED_SELECTED_LANGUAGE=$SELECTED_LANGUAGE
. /etc/mvm_definitions.sh
SELECTED_LANGUAGE=$SAVED_SELECTED_LANGUAGE

FRENCH_LIBRARY=$SCRIPTS_DIR/add_ons/french_numbers/french_number.sh

if [ $# = 0 ]; then
   echo "$0 [see comments for usage]" >&2
   echo "$0: bad args." >&2
   exit 2
fi

# Loop through arguments

while [ $# != 0 ];
do
   case $1 in
      --pre-formatted) shift
                       if [ $# != 0 ]; then
                          if [ -e "$1.$SELECTED_LANGUAGE" ]; then
   			     cat $1.$SELECTED_LANGUAGE
                          else
                             if [ -e "$1" ]; then
                                cat $1
                             else
                                echo "can't find $1.$SELECTED_LANGUAGE nor $1" >&2 
   			     fi
                          fi
                          shift
                       else
                          echo "$0: no argument to --pre-formatted" >&2
                       fi;;
      --say-number)    shift
                       if [ $# != 0 ]; then
                          $FRENCH_LIBRARY $1 | $PVF_TOOLS_DIR/rmdtopvf | $PVF_TOOLS_DIR/$PVF_MODEM_FILTER
                          shift
                       else
                          echo "$0: no argument to --say-number" >&2
                       fi;;
      *)               echo "$0: unknown argument $1" >&2
                       break;;
   esac
done


