#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# send_mvm.sh -- Mail to voicemail
# Creation: 08/03/98
# Update:   08/03/98
# V2.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell script transforms a textual message into an English
#    voicemail message. This effectively implements a mail-to-voicemail
#    gateway.
# BUGS
#    - (needs to) runs under root UID.
# TODO
# NOTES
# BASED-ON
#    older send_mvm.sh version.
# MODIFICATION-HISTORY
#    08/03/98  schaefer  Created this file.
# $Id: send_mvm.sh,v 1.3 1998/03/08 19:22:13 schaefer Exp $

. /etc/mvm_definitions.sh
. $SCRIPTS_DIR/mvm_low_level_library.sh

if [ $# != 1 ]; then
   echo "$0 [0-9]+"
   echo "$0: bad args."
   exit 2
fi

case $1 in
   [0-9]*) ;;
   *) echo "Not an numerical argument $1. Must be [0-9]+."
      exit 2;;
esac

umask 077

TMPFILE=/tmp/mvm_mail_to_voice_mail_tmp_$$

MSG_TEXT=`awk 'BEGIN { skip = 1; }
               /^From: / { print "Mail from";
                           for (i = 2; i <= NF; i++) {
                              printf "%s ", $i;
                           }
                           print "";
                         }
               { if (NF == 0) {
                    skip = 0;
                 }
                 else if (skip == 0) {
                    print;
                 }
               }'`

RESULT=`english_text_to_audio_file "$MSG_TEXT" $TMPFILE`
if [ "$RESULT" = "OK" ]; then
   case `send_voice_mail $1 -1 $TMPFILE` in
      INEXISTANT) echo "Unknown voicemail user $1."
                  rm $TMPFILE
                  exit 1;;
      OK)         ;;
      *)	  echo "Internal error 2"
                  rm $TMPFILE
		  exit 1;;
   esac
else
   echo "Internal error 1"
   rm $TMPFILE
   exit 1
fi

rm $TMPFILE

exit 0

