#! /bin/sh
# MVM Project (C) Marc SCHAEFER <schaefer@alphanet.ch>
# recall.sh -- Recall users of stored voicemail by e-mail.
# Creation: 08/03/98
# Update:   08/03/98
# V2.0 PV001
# DISCLAIMER
#    No warranty, either expressed or implied.
# COPYRIGHT
#    Fully protected under Berne Convention, use authorized except
#    if you make money from this use (contact me before).
# DESCRIPTION
#    This shell script implements everyday reminding of stored
#    e-mail. It should be run from crontab.
# BUGS
# TODO
# NOTES
#    - We trust the information in the .email-address file.
# BASED-ON
# MODIFICATION-HISTORY
#    08/03/98  schaefer  Created this file.
# $Id: recall.sh,v 1.1 1998/03/08 20:29:16 schaefer Exp $

. /etc/mvm_definitions.sh
. $SCRIPTS_DIR/mvm_low_level_library.sh

if [ $# != 0 ]; then
   echo "$0"
   echo "$0: bad args."
   exit 1
fi

for i in `eval_voice_mailbox_list`
do
   MAIL_LIST=`eval_voice_mails_list $i`
   if [ -f $MAILBOX_DIR/$i/.e-mail-address ]; then
      if [ -f $MAILBOX_DIR/$i/.recall-daily ]; then
         if [ "$MAIL_LIST" != "" ]; then
	    (echo "Subject: Still unread voice-mail"
	     echo ""
	     echo "You still have the following voice-mail on your account number $i:"
             `generate_detailed_voice_mails_list $MAIL_LIST`) | /usr/lib/sendmail -oi -f vmadm@alphanet.ch "`cat $MAILBOX_DIR/$1/.e-mail-address`"   
         fi
      fi
   fi
done

exit 0
