# usage:
# printpar /dev/hda | grep hda | awk -f printpar2table.awk > table.hda

/Partition table/ {
	sub(/CHS=/, "", $7);
	gsub(/\//, ", ", $7);
	print "(\$main::CYLINDERS, \$main::HEADS, \$main::SECTORS_PR_TRACK) = " $7 ";";
	print "\$main::DISKNAME = \"" $6 "\";";
	print "@main::table = (";
	print "\t#  name     bootable    system     start_cyl   end_cyl";
	next;
}

{
	if ($10 == "0") {
		print "\t[ '"$2"',    'unused'                                   ],";
	} else {
		printf "\t[ '%s',    '%s',    '%s',     %5d,     %5d,   ],\n", $2, $4, $10, $7, $13;
	}
}

END {
	print ");";
}

