/* $Id: html_table.c 1.4 Tue, 05 Jan 1999 21:32:12 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>

#include "partitiontable.h"
#include "globalvars.h"
#include "html_table.h"
#include "mk_partition_name.h"
#include "get_date_string.h"


void
html_table__print_mbr_partition(table_entry_t par_table[], const char *blockfilename, const char *header_description)
{
	unsigned int i;
	char date_str[32];
	char *partition_name[4];
	for (i = 0; i < 4; i++)
		partition_name[i] = mk_partition_name(blockfilename, i+1);
	fprintf(outfile,
		#define __HTML_PRIMARY
		#include "inc-html_table.h"
		);
	fprintf(outfile,
		#define __HTML_TABLE_START
		#include "inc-html_table.h"
		);
	html_table__print_table(par_table, partition_name);
	for (i = 0; i < 4; i++)
		free(partition_name[i]);
}

void
html_table__print_drive_table(table_entry_t par_table[], const char *blockfilename,
				loff_t sector, unsigned int par_no)
{
	char *partition_name[4] = {NULL, "&nbsp;", "&nbsp;", "&nbsp;"};
	partition_name[0] = mk_partition_name(blockfilename, par_no);
	fprintf(outfile,
		#define __HTML_DRIVE_TABLE
		#include "inc-html_table.h"
		);
	fprintf(outfile,
		#define __HTML_TABLE_START
		#include "inc-html_table.h"
		);
	html_table__print_table(par_table, partition_name);
	free(partition_name[0]);
}

void
html_table__print_table(table_entry_t par_table[], char *partition_name[])
{
	int i;
	for (i = 0; i < 4; i++)
		html_table__print_table_entry(&par_table[i], partition_name[i]);
	fprintf(outfile,
		#define __HTML_ENTRY_END
		#include "inc-html_table.h"
		);
}

void
html_table__print_table_entry(table_entry_t *te, const char *partition_name)
{
	char bootable_str[4+1], system_str[4+1];
	if (te->system == 0) {
		strcpy(system_str,   "0");
	} else {
		sprintf(system_str,   "0x%02X", te->system);
	}
	if (te->bootable == 0 && te->system == 0) {
		strcpy(bootable_str, "0");
	} else {
		sprintf(bootable_str, "0x%02X", te->bootable);
	}
	fprintf(outfile,
		#define __HTML_ENTRY
		#include "inc-html_table.h"
		);
}

