/* $Id: center_str.c 1.2 Tue, 01 Dec 1998 21:53:57 +0100 hlovdal $ */

#include <stdlib.h>
#include <sys/types.h>
#include <strings.h>

#include "center_str.h"

/*
 * This function returns a malloc'ed string,
 * see at the end for example on usage.
 */
char *
center_str(const char *pre_str, char *str, const char *post_str, size_t min)
{
	size_t	len = strlen(pre_str) + strlen(str) + strlen(post_str),
		spaces1, spaces2;
	char *ret;
	if (len >= min) {
		ret = malloc(len + 1);
		strcpy(ret, pre_str); strcat(ret, str); strcat(str, post_str);
		return ret;
	}
	spaces1 = (min - len) / 2;
	spaces2 = (min - len) - spaces1;
	ret = malloc(min + 1);
	strcpy(ret, pre_str);
	while(spaces1--) strcat(ret, " ");
	strcat(ret, str);
	while(spaces2--) strcat(ret, " ");
	strcat(ret, post_str);
	return ret;
}


#ifdef MAIN
#include <stdio.h>

/* this program prints this:
#                                      1                                       #
#                                      22                                      #
#                                     333                                      #
#                                     4444                                     #
#                                    55555                                     #
#                                    666666                                    #
#                                   7777777                                    #
#                                   88888888                                   #
*/

int main() {
	char *s;
	s = center_str("#", "1", "#", 80); puts(s); free(s);
	s = center_str("#", "22", "#", 80); puts(s); free(s);
	s = center_str("#", "333", "#", 80); puts(s); free(s);
	s = center_str("#", "4444", "#", 80); puts(s); free(s);
	s = center_str("#", "55555", "#", 80); puts(s); free(s);
	s = center_str("#", "666666", "#", 80); puts(s); free(s);
	s = center_str("#", "7777777", "#", 80); puts(s); free(s);
	s = center_str("#", "88888888", "#", 80); puts(s); free(s);
	return 0;
}
#endif

