/* $Id: compute_startend_cyl.c 1.1 Mon, 11 Jan 1999 22:30:10 +0100 hlovdal $ */

#include "partitiontable.h"
#include "globalvars.h"
#include "compute_startend_cyl.h"

void
compute_startend_cyl(table_entry_t *te, unsigned int *S, unsigned int *E)
{
	long int absolute_start_sector, absolute_end_sector;
	absolute_start_sector = te->relative_start_sector;
	if (te->entry_type == logical || te->entry_type == drive_table_link)
		absolute_start_sector += ext_par_absolute_start_sector;
	if (te->entry_type == logical)
		absolute_start_sector += saved_ext_par_relative_start_sect;
	absolute_end_sector = absolute_start_sector + te->number_of_sectors - 1;
	*S = sectors2C(absolute_start_sector);
	*E = sectors2C(absolute_end_sector);
}

