/* $Id: globalvars.h 1.7 Sun, 23 May 1999 14:18:02 +0200 hlovdal $ */

#ifdef NOEXTERN
  #ifdef __GLOBALVARS_H_WITHEXTERN
    #error "Error: this file is already included, but without without \
	NOEXTERN defined"
  #endif
#endif


#ifndef __GLOBALVARS_H
#define __GLOBALVARS_H

#ifdef NOEXTERN
  #undef EXTERN
  #define EXTERN
  #define init_value(val)	= val
#else
  #define __GLOBALVARS_H_WITHEXTERN
  #undef EXTERN
  #define EXTERN extern
  #define init_value(val)
#endif

#include <stdio.h>
#include <stdarg.h>
#include <sys/types.h>

#include "boolean.h"
#include "partitiontable.h"

typedef enum { TABLE, CHART, HEXPRINT } output_format_t;
typedef enum { PLAINTEXT, POSTSCRIPT, HTML } output_lang_t;
typedef enum {	no_encoding_specified = -1,
		StandardEncoding,
		ISOLatin1Encoding,
		ISOLatin2Encoding,
		ISOLatin3Encoding,
		ISOLatin4Encoding,
		ISOLatin5Encoding
} ps_encoding_t;

typedef struct {
	boolean_t	use_whole_page;
	char		*length_unit;
	double		one_hundred_mb_length;
} scale_t;


/* global variables */

EXTERN const char *encoding_str[]
#ifdef NOEXTERN
  = {	"StandardEncoding",	/* not used */
	"ISOLatin1Encoding",
	"ISOLatin2Encoding",
	"ISOLatin3Encoding",
	"ISOLatin4Encoding",
	"ISOLatin5Encoding"
  }
#endif /* NOEXTERN */
;

EXTERN scale_t scale
#ifdef NOEXTERN
  = { true, "cm", 0 }
#endif /* NOEXTERN */
;

EXTERN FILE		*outfile		init_value( stdout	      );
EXTERN output_lang_t	output_lang		init_value( PLAINTEXT	      );
EXTERN output_format_t	output_format		init_value( TABLE	      );
#define lines_pr_page_max INT_MAX
EXTERN int		lines_pr_page		init_value( 23		      );
EXTERN int		page_number		init_value( 0		      );
EXTERN int		width			init_value( 80		      );

EXTERN loff_t	ext_par_absolute_start_sector;
EXTERN loff_t	saved_ext_par_relative_start_sect;	/* used by *_chart__print_table_entry */


#undef init_value
#endif /* __GLOBALVARS_H */
