/* $Id: parse_scale.c 1.3 Tue, 01 Dec 1998 21:53:57 +0100 hlovdal $ */

#include <stdlib.h>
#include <ctype.h>
#include <strings.h>

#include "globalvars.h"
#include "parse_scale.h"
#include "error.h"

/*
 * the scale value returned is normalized to a disk unit of 100 Mb
 * example
 *	input:	optarg == "1024Mb:3lines"	// "100Mb:0.29296875lines"
 *	output:	scale_value == 0.29296875
 *		scale_unit  == "lines"
 */
void
parse_scale(const char *optarg, scale_t *scale)
{
	char *ptr;
	double disk_unit = 0;
	disk_unit = strtod(optarg, &ptr);
	if (ptr == optarg) {
		error("invalid number '%s'\n", optarg);
		exit(1);
	}
	if (ptr[0] == ':') {
		ptr++;
	} else {
		if (ptr[2] == ':' && (ptr[1] == 'b' || ptr[1] == 'B')) {
			switch (ptr[0]) {
			case 'k':
			case 'K':
				disk_unit *= 1024;
				break;
			case 'm':
			case 'M':
				disk_unit *= 1024*1024;
				break;
			case 'g':
			case 'G':
				disk_unit *= 1024*1024*1024;
				break;
			default:
				goto parse_exit;
			}
		} else {
parse_exit:
			error("invalid disk unit '%s'\n", ptr);
			exit(1);
		}
		ptr += 3;
	}
	if (! (isdigit(ptr[0]) || ptr[0] == '.')) {
		error("invalid unit value '%s'\n", ptr);
		exit(1);
	}
	scale->one_hundred_mb_length = 0;
	scale->one_hundred_mb_length = strtod(ptr, &ptr);
	scale->one_hundred_mb_length /= disk_unit;
	scale->one_hundred_mb_length *= 100 * 1024*1024;
	if (strcmp(ptr, "mm")    == 0 ||
	    strcmp(ptr, "cm")    == 0 ||
	    strcmp(ptr, "inch")  == 0 ||
	    strcmp(ptr, "lines") == 0)
		scale->length_unit = ptr;
	else {
		error("invalid unit '%s'\n", ptr);
		exit(1);
	}
}
