/* $Id: ps_chart.c 1.16 Wed, 10 Feb 1999 22:22:12 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#include "globalvars.h"
#include "ps_chart.h"
#include "mk_partition_name.h"
#include "get_date_string.h"
#include "encoding/ps_encoding.h"
#include "is_extended_partition.h"
#include "compute_startend_cyl.h"
#include "escape_parenthesis.h"

void
ps_chart__print_prolog(ps_encoding_t ps_encoding)
{
	fprintf(outfile,
		#define __PS_PROLOG_PART1
		#include "inc-ps_common.h"
		);
	print_ps_encoding(ps_encoding);
	fprintf(outfile,
		#define __PS_PROLOG_PART2
		#include "inc-ps_chart.h"
		);
}

void
ps_chart__print_trailer(void)
{
	fprintf(outfile,
		#define __PS_TRAILER
		#include "inc-ps_chart.h"
		);
}

void
ps_chart__print_mbr_partition(table_entry_t par_table[], const char *blockfilename, const char *header_description)
{
	unsigned int i;
	char date_str[32];
	const char *partition_name[4];
        for (i = 0; i < 4; i++)
		partition_name[i] = mk_partition_name(blockfilename, i+1);
	get_date_string(date_str, sizeof(date_str));
	header_description = escape_parenthesis(header_description);
	fprintf(outfile,
		#define __PS_PRIMARY
		#include "inc-ps_chart.h"
		);
	free((/*not const*/ char *)header_description);
	ps_chart__print_table(par_table, partition_name);
        for (i = 0; i < 4; i++)
		free((char *)partition_name[i]);
}


void
ps_chart__print_drive_table(table_entry_t par_table[],
				const char *blockfilename,
				loff_t sector __attribute__((__unused__)),
				unsigned int par_no)
{
	const char *partition_name[4] = {NULL, "", "", ""};
	partition_name[0] = mk_partition_name(blockfilename, par_no);
	ps_chart__print_table(par_table, partition_name);
	free((char *)partition_name[0]);
}


void
ps_chart__print_table(table_entry_t par_table[], const char *partition_name[])
{
	int i;
	for (i = 0; i < 4; i++)
		if (par_table[i].entry_type != unused) {
			ps_chart__print_table_entry(&par_table[i],
						partition_name[i]);
		}
}


void
ps_chart__print_table_entry(table_entry_t *te, const char *partition_name)
{
	unsigned int absolute_start_cyl, absolute_end_cyl, par_size;
	if (te->entry_type == drive_table_link) {
		saved_ext_par_relative_start_sect = te->relative_start_sector;
		return;
	}
	par_size = rint(te->number_of_sectors
			/ (double) (1024*1024/BYTES_PR_SECTOR));
	compute_startend_cyl(te, &absolute_start_cyl, &absolute_end_cyl);
	if (is_extended_partition(*te))
		fprintf(outfile, "\t\t(%s) %6u %6u draw_drive_table\n",
			partition_name, absolute_start_cyl, absolute_end_cyl);
	else
		fprintf(outfile, "(%u Mb)\t(%s) %6u %6u draw_partition\n",
			par_size, partition_name, absolute_start_cyl,
			absolute_end_cyl);
}

