/* $Id: ps_table.c 1.8 Wed, 10 Feb 1999 22:22:12 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>

#include "globalvars.h"
#include "ps_table.h"
#include "mk_partition_name.h"
#include "get_date_string.h"
#include "ps_encoding.h"
#include "escape_parenthesis.h"

void
ps_table__print_prolog(ps_encoding_t ps_encoding)
{
	fprintf(outfile,
		#define __PS_PROLOG_PART1
		#include "inc-ps_common.h"
		);
	print_ps_encoding(ps_encoding);
	fprintf(outfile,
		#define __PS_PROLOG_PART2
		#include "inc-ps_table.h"
		);
}

void
ps_table__print_trailer(void)
{
	fprintf(outfile,
		#define __PS_TRAILER
		#include "inc-ps_table.h"
		);
}


void
ps_table__print_mbr_partition(table_entry_t par_table[],
		const char *blockfilename, const char *header_description)
{
	unsigned int i;
	char date_str[32];
	char *partition_name[4];
	for (i = 0; i < 4; i++)
		partition_name[i] = mk_partition_name(blockfilename, i+1);
	get_date_string(date_str, sizeof(date_str));
	header_description = escape_parenthesis(header_description);
	fprintf(outfile,
		#define __PS_PRIMARY
		#include "inc-ps_table.h"
		);
	free((/* not const*/ char *)header_description);
	ps_table__print_table(par_table, partition_name);
	for (i = 0; i < 4; i++)
		free(partition_name[i]);
}



void
ps_table__print_drive_table(table_entry_t par_table[],
		const char *blockfilename, loff_t sector, unsigned int par_no)
{
	char *partition_name[4] = {NULL, "", "", ""};
	partition_name[0] = mk_partition_name(blockfilename, par_no);
	if (time_for_pagebreak(par_no)) {
		page_number++;
		fprintf(outfile,
			#define __PS_PAGEBREAK
			#include "inc-ps_table.h"
			);
	}
	fprintf(outfile,
		#define __PS_DRIVE_TABLE
		#include "inc-ps_table.h"
		);
	ps_table__print_table(par_table, partition_name);
	free(partition_name[0]);
}


void
ps_table__print_table(table_entry_t par_table[], char *partition_name[])
{
	int i;
	fprintf(outfile,
		#define __PS_PARTITION
		#include "inc-ps_table.h"
		);
	for (i = 0; i < 4; i++)
		ps_table__print_table_entry(&par_table[i], partition_name[i]);
}


void
ps_table__print_table_entry(table_entry_t *te, char *partition_name)
{
	fprintf(outfile, "(%u) ", te->number_of_sectors);
	fprintf(outfile, "(%u) ", te->relative_start_sector);
	fprintf(outfile, "(%u) (%u) (%u) ",
		te->end_sector,
		te->end_cylinder,
		te->end_head);
	if (te->system == 0)
		fprintf(outfile, "(0) ");
	else
		fprintf(outfile, "(0x%02X) ", te->system);
	fprintf(outfile, "(%u) (%u) (%u) ",
		te->start_sector,
		te->start_cylinder,
		te->start_head);
	if (te->bootable == 0 && te->system == 0)
		fprintf(outfile, "(0) ");
	else
		fprintf(outfile, "(0x%02X) ", te->bootable);
	fprintf(outfile,
		#define __PS_ENTRY
		#include "inc-ps_table.h"
		);
}
