/* $Id: tree.c 1.4 Fri, 08 Jan 1999 21:09:42 +0100 hlovdal $ */

#include <stdio.h>
#include <stdlib.h>
#include <search.h>
#include <string.h>
#include <math.h>

#include "globalvars.h"
#include "center_str.h"
#define NOEXTERN
#include "tree.h"
#undef NOEXTERN

char *get_prefix(int printed_ext_lines);

void
print_node(node_t *n)
{
	int num_lines = rint( ( (n->cyl_end - n->cyl_start + 1)
			/ (double)TOTAL_CYLINDERS )
			* lines_pr_page);
	if (num_lines == 0)
		num_lines++;
	if (n->cyl_start == 0)		/*  special case: the physical	*/
		print_separator(-1);	/*  first partition		*/
	switch (num_lines) {
		case 1:  print_node_1line(n);		break;
		case 2:  print_node_2lines(n);		break;
		default: print_node_lines(n, num_lines);
	}
	print_separator(n->cyl_end);
}


/* This function returns the first part of the line printed for logical
   partitions. For all cases except the middle line, the string returned
   contains a dot which is part of a vertical line. Example:
     + - - - - -
     .              (normal prefix)
     .              (normal prefix)
  h d a 1           (middle line)
     .              (normal prefix)
     .              (normal prefix)
     + - - - - -
 */
char *
get_prefix(int printed_ext_lines)
{
	static char s[] = "   .   ";
	if (printed_ext_lines == ((total_ext_lines+1)/2))
		return extended_data.par_name;
	else
		return s;
}

void
print_separator(int cylinder)
{
	const char *s1, *s2;
	if (extended_is_present && is_extended_border(cylinder)) {
		s1 = "   + - ";
		s2 = "- - - - - - - ";
	} else {
		s2 = "              ";
		if (extended_is_present && is_logical(cylinder)) {
			printed_ext_lines++;
			s1 = get_prefix(printed_ext_lines);
		} else
			s1 = "       ";
	}
	fprintf(outfile, "%9s%s+------------------------------+\n", s1, s2);
}

void
print_node_1line(node_t *n)
{
	const char *s = "       ";
	char *name;
	char tmp[CYL_MAX_DIGIT + 3 + CYL_MAX_DIGIT + 1];
	sprintf(tmp, "%u - %u", n->cyl_start, n->cyl_end);
	if (extended_is_present && is_logical(n->cyl_start)) {
		printed_ext_lines++;
		s = get_prefix(printed_ext_lines);
	}
	name = center_str("", n->name, "", 30);
	fprintf(outfile, "%9s %12s |%s|%7.0f Mb\n", s, tmp,name, rint(sectors2MB(n->nos)));
	free(name);
}

void
print_node_2lines(node_t *n)
{
	const char *s = "       ";
	char *name;
	if (extended_is_present && is_logical(n->cyl_start)) {
		printed_ext_lines++;
		s = get_prefix(printed_ext_lines);
	}
	name = center_str("", n->name, "", 30);
	fprintf(outfile,  "%9s   %10u |%s|%7.0f Mb\n",
		s, n->cyl_start, name, rint(sectors2MB(n->nos)));
	free(name);
	print_node_lines_first_or_last(n->cyl_end);
}


void
print_node_lines(node_t *n, int num_lines)
{
	int i;
	print_node_lines_first_or_last(n->cyl_start);
	for(i=2; i<(num_lines+1)/2; i++)
		print_node_lines_empty(extended_is_present && is_logical(n->cyl_start));
	print_node_lines_middle(n);
	for(; i<num_lines-1; i++)
		print_node_lines_empty(extended_is_present && is_logical(n->cyl_start));
	print_node_lines_first_or_last(n->cyl_end);
}

void
print_node_lines_first_or_last(unsigned int cylinder)
{
	const char *s = "       ";
	if (extended_is_present && is_logical(cylinder)) {
		printed_ext_lines++;
		s = get_prefix(printed_ext_lines);
	}
	fprintf(outfile,  "%9s   %10u |                              |\n", s, cylinder);
}

void
print_node_lines_empty(boolean_t logical)
{
	const char *s = "       ";
	if (logical) {
		printed_ext_lines++;
		s = get_prefix(printed_ext_lines);
	}
	fprintf(outfile, "%9s              |                              |\n", s);
}

void
print_node_lines_middle(node_t *n)
{
	const char *s = "       ";
	char *name;
	if (extended_is_present && is_logical(n->cyl_start)) {
		printed_ext_lines++;
		s = get_prefix(printed_ext_lines);
	}
	name = center_str("", n->name, "", 30);
	fprintf(outfile, "%9s              |%s|%7.0f Mb\n",
		s, name, rint(sectors2MB(n->nos)));
	free(name);
}




int
compare(const void *pa, const void *pb)
{
#define NODE(n)	((const node_t *)(n))
	if ( NODE(pa)->cyl_start < NODE(pb)->cyl_start) return -1;
	if ( NODE(pa)->cyl_start > NODE(pb)->cyl_start) return 1;
	return 0;
#undef NODE
}

void
add_node(void **rootp, unsigned int cyl_start, unsigned int cyl_end, unsigned int nos, const char *name)
{
	node_t *tmp = malloc(sizeof(node_t));
	tmp->cyl_start	= cyl_start;
	tmp->cyl_end	= cyl_end;
	tmp->nos	= nos;
	tmp->name	= strdup(name);
	txt_chart__number_of_separators++;
	if ( tsearch((void *)tmp, rootp, compare) == NULL) {
		free(tmp->name);
		fprintf(stderr, "unable to insert node\n");
	}
}

void
examine_freespace(const void *nodep, const VISIT which,
		const int depth __attribute__ ((__unused__)) )
{
	node_t *datap = *(node_t **)nodep;
	if (which == postorder || which == leaf) {
		if (datap->cyl_start > last_par_end + 1) {
			/* this is freespace */
			unsigned int start = last_par_end + 1;
			unsigned int end   = datap->cyl_start - 1;
			unsigned int nos   = (end - start + 1)
				* HEADS_PR_CYLINDER * SECTORS_PR_TRACK;
			if (partition_starts_on_head_1(start))
				nos -= SECTORS_PR_TRACK;
			add_node(&freespace_tree, start, end, nos, "freespace");
		}
		last_par_end = datap->cyl_end; 
	}
}

void
calculate_ext_numlines(const void *nodep, const VISIT which,
			const int depth __attribute__((__unused__)))
{
	node_t *datap = *(node_t **)nodep;
	if (which == postorder || which == leaf) {
		if (extended_is_present && is_logical(datap->cyl_start)) {
			int num_lines = rint( ( (datap->cyl_end -
					datap->cyl_start + 1)
					/ (double)TOTAL_CYLINDERS )
					* lines_pr_page);
			if (num_lines == 0)
				num_lines++;
			CEN_total_ext_lines += num_lines
				+ 1 /* include next separator */;
		}
	}
}

void
merge_ptree_and_delete_ftree(const void *nodep, const VISIT which,
				const int depth __attribute__((__unused__)))
{
	node_t *datap = *(node_t **)nodep;
	if (which == postorder || which == leaf) {
		add_node(&partition_tree, datap->cyl_start, datap->cyl_end,
			datap->nos, datap->name);
	}
	if (which == endorder || which == leaf) {
		free(datap->name);
		tdelete(datap, &freespace_tree, compare);
		free(datap);
	}
}

void
print_and_delete_tree(const void *nodep, const VISIT which,
			const int depth __attribute__((__unused__)))
{
	node_t *datap = *(node_t **)nodep;
	if (which == postorder || which == leaf)
		print_node(datap);
	if (which == endorder || which == leaf) {
		free(datap->name);
		tdelete(datap, &partition_tree, compare);
		free(datap);
	}
}

