/* $Id: tree.h 1.3 Tue, 01 Dec 1998 21:53:57 +0100 hlovdal $ */

#ifdef NOEXTERN
  #ifdef __TREE_H_WITHEXTERN
    #error "Error: this file is already included, but without without \
        NOEXTERN defined"
  #endif
#endif

#ifndef __TREE_H
#define __TREE_H

#ifdef NOEXTERN
  #undef EXTERN
  #define EXTERN
  #define init_value(val)       = (val)
#else
  #define __TREE_H_WITHEXTERN
  #undef EXTERN
  #define EXTERN extern
  #define init_value(val)
#endif




#include <search.h>
#include "boolean.h"

typedef struct {
	unsigned int	cyl_start;
#define CYL_MAX_DIGIT 10	/* UINT_MAX == 4294967295 */
	unsigned int	cyl_end;
	unsigned int	nos;	/* Number Of Sectors */
	char		*name;
} node_t;

#define is_logical(cyl)					\
(							\
	(cyl) >= extended_data.startcyl			\
		&&			 		\
	(cyl) <= extended_data.endcyl			\
)

#define is_extended_border(end_cyl)			\
(							\
	((end_cyl)+1) == extended_data.startcyl		\
		||			 		\
	(end_cyl) == extended_data.endcyl		\
)

#define partition_starts_on_head_1(start_cyl)		\
(							\
	(start_cyl) == 0				\
		||					\
	(extended_is_present && is_logical(start_cyl))	\
)

EXTERN struct {
	char *par_name;
	unsigned int startcyl;
	unsigned int endcyl;
} extended_data;

EXTERN boolean_t extended_is_present;

EXTERN void *partition_tree init_value(NULL);
EXTERN void *freespace_tree init_value(NULL);


EXTERN int total_ext_lines;
EXTERN int CEN_total_ext_lines;		/* CEN - calculate_ext_numlines */
EXTERN int printed_ext_lines;
EXTERN int last_par_end init_value(-1);

EXTERN int txt_chart__number_of_separators	init_value(1);
 

void print_node(node_t *n);
void print_separator(int cylinder);
void print_node_1line(node_t *n);
void print_node_2lines(node_t *n);
void print_node_lines(node_t *n, int num_lines);
void print_node_lines_first_or_last(unsigned int cylinder);
void print_node_lines_empty(boolean_t logical);
void print_node_lines_middle(node_t *n);

int compare(const void *pa, const void *pb);
void add_node(void **rootp,
    unsigned int cyl_start, unsigned int cyl_end, unsigned int nos, const char *name);

void examine_freespace		 (const void *nodep, const VISIT which,
					const int depth);
void calculate_ext_numlines	 (const void *nodep, const VISIT which,
					const int depth);
void merge_ptree_and_delete_ftree(const void *nodep, const VISIT which,
					const int depth);
void print_and_delete_tree	 (const void *nodep, const VISIT which,
					const int depth);

#undef init_value
#endif /* __TREE_H */

