/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <sys/types.h>
#endif
#include <stdio.h>
#include <string>
#include <time.h>

using namespace std;

#include "AtliDll.h"
#include "apptest.h"

#define RKEYWORD(key, ind, pn) {string(#key).replace(ind, 1, "::", 2), pn}

static struct _tag_sdkkeyword_  {
    string  keywordstring;
    int     paramnumber;
}g_APPkeyword[] = {
    RKEYWORD(APP_Mode, 3, 1),
    RKEYWORD(APP_Close, 3, 0),
    RKEYWORD(APP_Open, 3, 0),
    RKEYWORD(APP_Init, 3, 0),
    RKEYWORD(APP_Uninit, 3, 0),
};

int register_APP_keyword ()
{
    for (int i = 0; i < sizeof (g_APPkeyword) / sizeof (g_APPkeyword[1]); i++)
        printf ("%d\n", Atli_register_keyword (g_APPkeyword[i].keywordstring.c_str(), g_APPkeyword[i].paramnumber));

    return 0;
}


DWORD ProcessAPPCmd (int t, DWORD_PTR l, DWORD_PTR w)
{
    char *param = (char*)l;
    int ret = 0;
    LPATLI_PARAMLIST pl = (LPATLI_PARAMLIST) l;

    if (t == ATLI_wait) 
        return 0;

    if (t == ATLI_waitfor) {
        printf ("%s\n", pl->param[0]);
        return 0;
    }
/*
    if (w && ((char*)w)[0]) 
        printf ("%s\n",(char*)w);
*/
    if (t == ATLI_print)
        printf ("%s\n", pl->param[0]);

    if (t == ATLI_getvalue)
        return (DWORD)(DWORD_PTR)(char*)"**undefined value**";

    return (DWORD)ret;
}

#if 1
int main (int argc, char*argv[])
{
    int ret ;
    LPATLI_PARAMLIST pl;
    int pst = 2;

    if (argc >=2) {
        Atli_script_init ();
//        register_APP_keyword ();
        pl = (LPATLI_PARAMLIST)malloc (sizeof(LPATLI_PARAMLIST) + argc - 2);

        if (argc > 2)
        if (strcmp (argv[2], "-d") == 0) {
            Atli_script_ctrl (SCRIPT_DEBUG_LEVEL, 1, 0);
            pst = 3;
        }
        pl->number = argc - pst;

        for (int i = 0; i < argc - pst; i ++) 
            pl->param[i] = argv[i + pst];

        ret = Atli_parse_script (argv[1], pl);
        Atli_print_flow ();
        if (ret) {
            printf ((char*)Atli_get_error_string());
            return 1;
        }
        Atli_execute_script (ProcessAPPCmd);
        Atli_script_close ();
    }

    return 0;
}

#endif
