/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

#ifdef WIN32
#include <windows.h>
#endif

#include "AtliDll.h"
#include "Atli.h"

#ifdef WIN32
BOOL APIENTRY DllMain( HANDLE hModule, DWORD  ul_reason_for_call,  LPVOID lpReserved )
{
    switch (ul_reason_for_call)
    {
    case DLL_PROCESS_ATTACH:
		break;
    case DLL_PROCESS_DETACH:
		break;
    case DLL_THREAD_ATTACH:
		break;
    case DLL_THREAD_DETACH:
		break;
    }
    return TRUE;
}
#endif


int _ATLI_FUNC_ Atli_parse_script (const char* file, LPATLI_PARAMLIST pl)
{
    return script_parse_file (file, (LPPARAMLIST)pl);
}

int _ATLI_FUNC_ Atli_execute_script (ATLI_SCRIPT_EXE_FUNC func)
{
    return script_execute_script ((SCRIPT_EXE_FUNC) func);
}

int _ATLI_FUNC_ Atli_script_close ()
{
    return script_close ();
}

int _ATLI_FUNC_ Atli_script_init ()
{
    return script_init ();
}

int _ATLI_FUNC_ Atli_register_keyword (const char*key, int paramno)
{
    return script_register_keyword (key, paramno);
}

const LPWSTR _ATLI_FUNC_ Atli_get_error_string ()
{
    return (const LPWSTR)script_get_error_string ();
}

const LPWSTR _ATLI_FUNC_ Atli_get_value (const char* variable)
{
    return (const LPWSTR)script_get_value (variable);
}

const int _ATLI_FUNC_ Atli_get_current_line_no ()
{
    return script_get_current_line_no ();
}

const LPWSTR _ATLI_FUNC_ Atli_get_current_line ()
{
    return (const LPWSTR)script_get_current_line ();
}

const LPWSTR _ATLI_FUNC_ Atli_print_flow ()
{
    return (const LPWSTR)script_print_flow ();
}

int _ATLI_FUNC_ Atli_script_ctrl (int type, int v1, int v2)
{
    return script_ctrl (type, v1, v2);
}