/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

#ifndef _AtliDll_h_
#define _AtliDll_h_

#ifdef WIN32
    #ifdef ATLI_EXPORTS
    #define _ATLI_FUNC_ _declspec(dllexport)
    #else
    #define _ATLI_FUNC_ _declspec(dllimport)
    #endif
#else 
    #define _ATLI_FUNC_
#endif

#define SCRIPT_DEBUG_LEVEL  1000

typedef struct _tag_atli_param_list {
    int     number;
    char    *param[1];
}ATLI_PARAMLIST, *LPATLI_PARAMLIST;

enum {
    ATLI_getvalue = 2000,
    ATLI_wait,
    ATLI_waitfor,
    ATLI_print
};

#ifndef WIN32 
typedef char* LPWSTR;
typedef int   DWORD;
typedef int   DWORD_PTR;
#endif

#ifdef WIN32
#ifdef __cplusplus
extern "C" {
#endif
#endif

typedef DWORD (*ATLI_SCRIPT_EXE_FUNC) (int, DWORD_PTR, DWORD_PTR);


int _ATLI_FUNC_ Atli_parse_script (const char* file, LPATLI_PARAMLIST);

int _ATLI_FUNC_ Atli_execute_script (ATLI_SCRIPT_EXE_FUNC);

int _ATLI_FUNC_ Atli_script_init ();

int _ATLI_FUNC_ Atli_script_close ();

int _ATLI_FUNC_ Atli_register_keyword (const char*key, int paramno);

const LPWSTR _ATLI_FUNC_ Atli_get_error_string ();

const LPWSTR _ATLI_FUNC_ Atli_get_value (const char* variable);

const int _ATLI_FUNC_ Atli_get_current_line_no ();

const LPWSTR _ATLI_FUNC_ Atli_get_current_line ();

const LPWSTR _ATLI_FUNC_ Atli_print_flow ();

int _ATLI_FUNC_ Atli_script_ctrl (int, int, int);


#ifdef WIN32
#ifdef __cplusplus
}
#endif
#endif


#endif
