/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

 
#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliparse.h"
#include "Atliexe.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_goto.h"
#include "Atli_innerfunc.h"
#include "Atli_while.h"
#include "Atli_func.h"

static char *t_keywordlist[] = {"label", "wait", "waitfor", "goto", "foreach", "endeach", 
"set", "print", "if",
"else", "endif", "begin", "end", "function", "fend", "call", "exec", "fexec", 
"global", "for","endfor", "return",
"while", "endwhile"
};

Scriptor g_script = {sizeof(t_keywordlist)/sizeof(char*),  {
    {SCP_label, "label", 1},
    {SCP_wait,  "wait", 1},
    {SCP_waitfor, "waitfor", 1},
    {SCP_goto,  "goto", 1},
    {SCP_foreach, "foreach", 3},
    {SCP_endforeach, "endeach", 0},
    {SCP_set, "set", 3},
    {SCP_print, "print", -1},
    {SCP_if, "if", 1},
    {SCP_else, "else", 0},
    {SCP_endif, "endif", 0},
    {SCP_begin, "begin", 0},  
    {SCP_end, "end", 0},      
    {SCP_function, "function", -1},
    {SCP_fend, "fend", 0},
    {SCP_call, "call", -1},
    {SCP_exec, "exec", 1},
    {SCP_fexec, "fexec", 1},
    {SCP_global, "global", 0},
    {SCP_for, "for", 3},
    {SCP_endfor, "endfor", 0},
    {SCP_return, "return", 0},
    {SCP_while, "while", 0},
    {SCP_endwhile, "endwhile", 0},
    0},
};

#include "atli.inc"


int script_parse_one_line (const char *oneline)
{
    string line = oneline;
    return parse_script_line (line, -1);
}


static void release(PtrLineInfo p)
{
    if (p) {
        if (p->userdata) delete (char*)p->userdata;
        delete p;
    }
}

int script_init ()
{
    g_script.parse_error = "";
    for_each (g_script.script_stream.begin (), g_script.script_stream.end(), release);
    g_script.script_stream.clear ();
    g_script.script_stream.resize (0);
    g_script.function_list.clear();
    g_script.variable_set.clear();
    g_script.callstack.clear();
    g_script.callstack.resize (0);
    g_script.script_start = (unsigned int)-1;
    g_script.script_end   = (unsigned int)-1;   
    g_script.current_stream = -1;
    g_script.debug_level = 0;

    for (unsigned int i = 0; i < g_script.g_keywordnum; i ++)
        strcpy (g_script.g_keyword[i].keywordstring, t_keywordlist[i]);

    return 0;
}

static int insert_instruct_call_main ()
{
    string callmain;

    callmain = "begin";
    parse_script_line (callmain, -3);

    callmain = "main (";
    if (g_script.script_argv) {
        for (int i = 0; i < g_script.script_argv->number; i ++) {
            callmain += "\"";
            callmain += g_script.script_argv->param[i];
            if (i != g_script.script_argv->number -1)
                callmain += "\", ";
            else 
                callmain += "\"";
        }
    }
    callmain += ")";
    parse_script_line (callmain, -2);
    callmain = "end";
    parse_script_line (callmain, -1);
    return 0;
}

static int re_locate_function () 
{
    int num = (int)g_script.script_stream.size ();
    PtrLineInfo lineinfo;

    for (int i = 0; i < num; i ++) {
        lineinfo = g_script.script_stream[i];

        if (lineinfo->opertor == SCP_function)
            g_script.function_list[((LPFUNC_USER_DATA)lineinfo->userdata)->function_name] = 
                lineinfo->cno;

    }

    for (int i = 0; i < num; i ++) {
        lineinfo = g_script.script_stream[i];

        if (lineinfo->opertor == SCP_call)
            if (g_script.function_list.find (((LPFUNC_USER_DATA)lineinfo->userdata)->function_name) 
                != g_script.function_list.end())
                lineinfo->next = (int)g_script.function_list[((LPFUNC_USER_DATA)lineinfo->userdata)->function_name];
            else {
                lineinfo->next = -1;
                lineinfo->ornext = -1;
            }
    }

    return 0;
}

static int set_all_next ()
{
    int num = (int)g_script.script_stream.size ();
    PtrLineInfo lineinfo;
    int ret;

    for (int i = 0; i < num; i ++) {
        lineinfo = g_script.script_stream[i];
        if ((lineinfo->next != -1) && (lineinfo->ornext != -1)) continue;

        switch (lineinfo->opertor) {
            case SCP_goto:
                ret = set_goto_next (i);
                if (ret < 0) {
                    ostringstream msg;
                    msg <<"parse error(" << lineinfo->lineno << "): can not find label:" 
                        <<lineinfo->param_string[0] << endl;
                    g_script.parse_error = msg.str ();
                    return -1;
                }
                break;

            case SCP_return:
                ret = set_return_next (i);
                if (ret < 0) {
                    ostringstream msg;
                    msg <<"parse error(" << lineinfo->lineno << "): can not find \"fend\"." 
                        << endl;
                    g_script.parse_error = msg.str ();
                    return -1;
                }
                break;

            case SCP_endwhile:
                ret = set_endwhile_next (i);
                if (ret < 0) {
                    ostringstream msg;
                    msg <<"parse error(" << lineinfo->lineno << "): can not find \"endwhile\"." 
                        << endl;
                    g_script.parse_error = msg.str ();
                    return -1;
                }
                break;
        }
    }
    
    return 0;
}


int script_parse_file (const char* file, LPPARAMLIST pl)
{
    string line;
    ifstream infile;
    int ret;
    int lineno = 0;

    g_script.script_argv = pl;

    g_script.parse_error = "";
    for_each (g_script.script_stream.begin (), g_script.script_stream.end(), release);
    g_script.script_stream.clear ();
    g_script.script_stream.resize (0);
    g_script.function_list.clear();
    g_script.variable_set.clear();
    g_script.callstack.clear();
    g_script.callstack.resize (0);
    g_script.script_start = (unsigned int)-1;
    g_script.script_end   = (unsigned int)-1;   
    g_script.current_stream = -1;

    infile.open (file, ios_base::in);

    if (!infile) {
        g_script.parse_error = "error: can not find the script file: " + string(file);
        return -1;
    }

    
    insert_instruct_call_main ();

    while (getline (infile, line)) {
        lineno ++;
        if (line[0] == '#')
            continue;
        if (line[line.length()-1] == '\r')
            line.erase(line.length()-1,1);
        if (line.length() == 0 || line.find_first_not_of (" \t") == -1)
            continue;

        ret = parse_script_line(line, lineno);
        if (ret) {
            return -2;
        }
    }
    infile.close ();

    if (re_locate_function () < 0) 
        return -3;

    if (set_all_next() < 0)
        return -2;

    return 0;
}

const char* script_get_value (const char* variable)
{
    return get_value (variable);
}


const char * script_print_flow ()
{
    int i ;
    int num = (int)g_script.script_stream.size ();
    static string flow;
    char fp[256];

    flow.clear ();
    if (flow.length()) {
#ifdef debug_script_lib
        dbgprint (flow.c_str());
#endif
        return flow.c_str ();
    }
    for (i = 0; i < num; i ++) {
        sprintf (fp,"%d:->%d->%d: %s\n",
        g_script.script_stream[i]->cno,
        g_script.script_stream[i]->next, g_script.script_stream[i]->ornext,
        g_script.script_stream[i]->line.c_str());
        flow += fp;
#ifdef debug_script_lib
        dbgprint (fp);
#endif
    }
    return flow.c_str();
}


int script_ctrl (int type, int v1, int v2)
{
    switch (type) {
        case SCRIPT_DEBUG_LEVEL:
            g_script.debug_level = v1;
            break;
    }
    return 0;
}


int script_register_keyword (const char*key, int paramno)
{
    if (g_script.g_keywordnum >= KEYWORD_TT_NUMB)
        return -1;

    strcpy (g_script.g_keyword[g_script.g_keywordnum].keywordstring, key);
    g_script.g_keyword[g_script.g_keywordnum].paramnumber = paramno;
    g_script.g_keyword[g_script.g_keywordnum].scpoper = 3000 + g_script.g_keywordnum;
    g_script.g_keywordnum ++;
    return g_script.g_keyword[g_script.g_keywordnum - 1].scpoper;
}

const int script_get_current_line_no ()
{
    return g_script.script_stream[g_script.current_stream]->lineno;
}

const char* script_get_current_line ()
{
    return g_script.script_stream[g_script.current_stream]->line.c_str();
}

const char* script_get_error_string ()
{
    return g_script.parse_error.c_str();
}

int script_close ()
{
    for_each (g_script.script_stream.begin (), g_script.script_stream.end(), release);
    g_script.script_stream.clear ();
    g_script.script_stream.resize (0);
    g_script.function_list.clear();
    g_script.variable_set.clear();
    g_script.callstack.clear();
    g_script.callstack.resize (0);
    g_script.script_start = (unsigned int)-1;
    g_script.script_end   = (unsigned int)-1;   
    return 0;
}

#if 0
int main (int argc, char*argv[])
{
    int ret ;

    if (argc ==2) {
        ret = parse_script_file (argv[1]);
        print_flow ();
        if (ret) {
#ifdef debug_script_lib
            dbgprint (g_script.parse_error.c_str());
#endif
            return 1;
        }
        execute_script (NULL);
        script_close ();
    }

    return 0;
}

#endif
