/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

 

#ifndef _ATLI_LIB_H
#define _ATLI_LIB_H

typedef struct _tag_param_list {
    int     number;
    const char    *param[1];
}PARAMLIST, *LPPARAMLIST;



#ifdef LINUX
typedef int DWORD;
typedef int DWORD_PTR;
#endif

enum {
    SCP_getvalue = 2000,
    SCP_wait,
    SCP_waitfor,
    SCP_print,
};

#define SCRIPT_DEBUG_LEVEL  1000

typedef DWORD (*SCRIPT_EXE_FUNC) (int, DWORD_PTR, DWORD_PTR);

int script_init ();

int script_parse_file (const char* file, LPPARAMLIST pl);

int script_parse_one_line (const char *oneline);

int script_execute_script (SCRIPT_EXE_FUNC func);

int script_close ();

int script_register_keyword (const char*key, int paramno);

const char* script_get_error_string ();

const char* script_get_value (const char* variable);

const int script_get_current_line_no ();

const char* script_get_current_line ();

const char* script_print_flow ();

int script_ctrl (int type, int v1, int v2);


#endif
