/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_func.h"
#include "Atli_appfunc.h"

extern Scriptor g_script;
#include "atli.inc"



static LPPARAMLIST construct_param_list (PtrLineInfo lineinfo)
{
    LPPARAMLIST ppm;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
    int num  = (int)pfunc->parameter_list.get_parameter_no ();

    ppm = (LPPARAMLIST) malloc (sizeof(PARAMLIST) + sizeof(char*) * num);
    if (ppm == NULL) return NULL;

    ppm->number = num + 1;
    ppm->param[0] = pfunc->function_name.c_str();
    for (int i = 0; i < num; i++)
        ppm->param[i+1] = pfunc->parameter_list.get_expression_at(i)->get_expression_result();
    return ppm;
}

static int destruct_param_list (PtrLineInfo lineinfo, LPPARAMLIST ppm)
{
    delete ppm;
    return 0;
}

int exe_app_keyword (PtrLineInfo lineinfo)
{
    return 0;
}

int exe_app_func (PtrLineInfo lineinfo)
{
    int ret = 0;
    LPPARAMLIST ppm;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
    string rename;    

    rename = "__";
    rename += pfunc->function_name;

    ppm = construct_param_list (lineinfo);
    if (ppm == NULL) {
        ostringstream msg;
        msg << "execute error(" << lineinfo->lineno << "): can not construct parameter list" << endl;
        g_script.parse_error = msg.str ();
        return -1;
    }

    if (g_script.script_exe_func) {
        ret = g_script.script_exe_func (lineinfo->opertor, (DWORD_PTR)ppm, 
                (DWORD_PTR)lineinfo->line.c_str ());
        set_variable_value (RETURN_APP_VAR, (float)ret);
        set_variable_value (RETURN_VAR, (float)ret);
        set_variable_value (rename, (float)ret);
    }
    set_variable_value (RETURN_APP_VAR, (float)0);
    set_variable_value (RETURN_VAR, (float)0);
    set_variable_value (rename, (float)0);

    destruct_param_list (lineinfo, ppm);

    return 0;
}


