/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/


#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "mathparse.h"
#include "logiparse.h"


extern Scriptor g_script;

#include "atli.inc"


#define ATLIOPERATORS     "()+-*/&|!=<>%~"
#define BLANKCHAR " \t\r"
#define ALLNUMB "-.0123456789"
#define ALLALPHA "abcdefghijklmnopqrstuvwxyz""ABCDEFGHIJKLMNOPQRSTUVWXYZ"
#define VALIDVAR "0123456789" ALLALPHA "_"

expression::~expression ()
{
    m_elements.clear ();
}

int expression::parse_elements (const char*orgstr, int st) 
{
    m_original = orgstr + st; 
    return (parse_elements () + st); 
}


const char* expression::debug_get_all_elements ()
{
    int num = (int)m_elements.size ();

    debstr = "";

    for (int i = 0; i < num; i ++) {
        debstr = debstr + m_elements[i];
        debstr = debstr + "\n";
    }
    return debstr.c_str();
}

int expression::clean_null_element ()
{
    expstring elm;
    size_t st, ed;
    int num = (int) m_elements.size();

    for (int i = 0; i < num; i ++) {
        elm = m_elements[i];
        st = elm.find_first_not_of (BLANKCHAR, 0);
        if ((int)st == -1) {
            m_elements[i] = "";
            continue;
        }
        ed = elm.find_last_not_of (BLANKCHAR, elm.length());       
        ed ++;
        m_elements[i] = elm.substr (st, ed - st);        
    }

    vector <expstring>::iterator Iter;
    for (Iter = m_elements.begin(); Iter != m_elements.end(); Iter ++) {
        if (Iter->length () != 0) continue;
        m_elements.erase (Iter);
        Iter --;
    }

    return 0;
}


int  expression::get_expression_logic_result ()
{
    size_t num = m_elements.size ();
    result.clear ();
    int   ret_logic;
    string one;

    for (size_t i = 0; i < num; i ++) {
        if (m_elements[i].length () == 0) continue;
        if (m_elements[i][0] == '$') {
            one = get_value_for_variable (m_elements[i].c_str() + 1);
            if (one.length())
                result += one;
            else 
                result += "\"\"";
        }
        else {
            result += m_elements[i];
        }
    }
    ret_logic = get_value_logic (result.c_str());
    if (!(ret_logic == 0 && strlen(get_error_logic()))) {     // it is a logic string
        return ret_logic;
    }
    else
        return 0;
}

const char* expression::get_expression_result ()
{
    size_t num = m_elements.size ();
    result.clear ();
    float ret_arith;
    int   ret_logic;
    char  buf[32];
    string one;

    for (size_t i = 0; i < num; i ++) {
        if (m_elements[i].length () == 0) continue;
        if (m_elements[i][0] == '$') {
            one = get_value_for_variable (m_elements[i].c_str() + 1);
            if (one.length())
                result += one;
            else
                result += "0";
        }
        else
            result += m_elements[i];
    }
    ret_arith = get_value_arithmetic(result.c_str());
    if (!(ret_arith == 0.0f && strlen (get_error_airthm()))) {  // it is arithmetic string
        if ( (ret_arith - (int)ret_arith) < 0.00000001f)
            sprintf (buf, "%d", (int)ret_arith);
        else sprintf (buf,"%f", ret_arith);
        result = buf;
        return result.c_str ();
    }
    ret_logic = get_value_logic (result.c_str());
    if (!(ret_logic == 0 && strlen(get_error_logic()))) {     // it is a logic string
        sprintf (buf,"%d", ret_logic);
        result = buf;
        return result.c_str ();
    }
    // to support string caculation in future;
    return get_string_result ();
}

const char* expression::get_string_result(void)
{
    size_t num = m_elements.size ();
    result.clear ();
    string one;

    result = "\"";
    for (size_t i = 0; i < num; i ++) {
        if (m_elements[i].length () == 0) continue;

        if (m_elements[i][0] == '$') {
            one = get_value_for_variable (m_elements[i].c_str() + 1);
            if (one.length()) {
                if (one[0] == '"')
                    result += one.substr (1, one.length () - 2);
                else
                    result += one;
            }
            else
                result += "0";
        } else if (m_elements[i][0] == '+') {
            continue;
        } else if (m_elements[i][0] == '"') {
            result += m_elements[i].substr (1, m_elements[i].length () - 2);
        }
    }
    result += "\"";

    return result.c_str ();
}


int expression::exp_insert_call_function (size_t pos)
{
    size_t st, ed;
    string callfunc_line;
    string function_name;
    string rnd_var_name;
    string set_value_line;

    st = pos;
    ed = get_variable_string (m_original, st);
    if (((int) ed == -1) || (st == ed)) return -1;
    
    function_name = m_original.substr (st, ed - st);

    st = m_original.find_first_not_of (BLANKCHAR, ed);
    if (m_original[st] != '(') return -1;

    ed = find_correspond_blacket (m_original, st);
    if ((int)ed == -1) return -1;
    ed ++;

    callfunc_line = m_original.substr (pos, ed - pos);
    rnd_var_name = random_variable_name(function_name.c_str());

#ifdef debug_script_lib
    dbgprint ("replace: %s, %d:%d, %s\n", m_original.c_str(), pos, ed -pos, rnd_var_name.c_str());
#endif
    m_original.replace (pos, ed -pos , rnd_var_name.c_str());
#ifdef debug_script_lib
    dbgprint ("replaced: %s\n", m_original.c_str());
#endif
    m_compensate_len += (int)ed - (int)pos - (int)rnd_var_name.length ();

    set_value_line = rnd_var_name
        + string (" = $__") + function_name;
#ifdef debug_script_lib
    dbgprint ("insert line:%s\n", callfunc_line.c_str());
    dbgprint ("insert line:%s\n", set_value_line.c_str());
#endif

    if (m_test == 0) {
        insert_script_line (set_value_line.c_str(), g_script.current_line, g_script.current_stream, 1);
        insert_script_line (callfunc_line.c_str(), g_script.current_line, g_script.current_stream, 1);
    }

    return 0;
}

int expression::parse_elements ()
{
    int p = 0;
    int lastp;
    size_t st, ed;
    expstring element;

    lastp = p;
    while (1) {
        if (m_original[p] == '$') {
            element = m_original.substr (lastp, p - lastp);
            if (element.length()) {
                m_elements.push_back (element);
                lastp = p;
            }
            
            st = p + 1;
            ed = get_variable_string (m_original, st);
            p = (int)ed;

            element = m_original.substr (lastp, p - lastp);
            m_elements.push_back (element);
            lastp = p;
            continue;
        }
        else if (m_original[p] == '"') {
            element = m_original.substr (lastp, p - lastp);
            m_elements.push_back (element);
            lastp = p;

            p = find_correspond_quotation (m_original, lastp) + 1;
            if ((int)p == -1) return -1;

            string frelm = m_original.substr (lastp, p - lastp);
            copy_escape_string (element, frelm);  // copy string to element;
            m_elements.push_back (element);
            lastp = p;
            continue;
        } 
        else if (m_original[p]) {
            if (!strchr (ATLIOPERATORS BLANKCHAR ALLNUMB , m_original[p])) {
                if (exp_insert_call_function (p) < 0)
                    break;
                else {
                    continue;
                }
            } else {
                p++;
                continue;
            }
        }
        else {
            break;
        }
    }
    element = m_original.substr (lastp, p - lastp);
    m_elements.push_back (element);
    clean_null_element ();
    return (int)(m_compensate_len + p);
}

parameterlist::~parameterlist ()
{
    for (int i = 0; i < (int)m_list.size (); i ++)
        delete m_list[i];
    m_list.clear ();
}

const char* parameterlist::debug_get_all_expression ()
{
    int num = (int)m_list.size ();
    debstr = "";
    for (int i = 0; i < num; i ++) 
        if (m_list[i])
            debstr += m_list[i]->debug_get_all_elements ();

    return debstr.c_str ();
}

int parameterlist::add_expression (expression * nexp)
{
    if (nexp)
        m_list.push_back (nexp);
    return 0;
}

#if 0
int main (int argc, char* argv[])
{
    class expression myexp;

    printf ("%s\n", argv[1]);
    myexp.parse_elements (argv[1]);
    printf ("%s", myexp.debug_get_all_elements ());
    
}
#endif
