/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

#ifndef _ATLI_EXPRESSION_H_
#define _ATLI_EXPRESSION_H_

#include <string>
#include <vector>
using namespace std;

enum {
    exp_string = 1,
    exp_variable,
    exp_function,
    exp_operator
};

typedef string expstring;

class expression
{
public:
    string          m_name;
    vector<expstring>  m_elements;
    string          m_original;
    string          m_error;
    int             m_errno;
    string          debstr;
    string          result;
    int             m_test;
    int             m_compensate_len;

public:
    void init () {m_test = 0;  m_compensate_len = 0; m_name = "expression";
            m_errno = 0; m_error = "";};

    expression (string &orgstr) {init (); m_original = orgstr; };
    expression () {init (); }
    ~expression ();
    int parse_elements ();
    int parse_elements (const char*orgstr) {m_original = orgstr; return parse_elements(); };
    int parse_elements (const char*orgstr, int st);
    const char* get_error() { return m_error.c_str();};
    const char* debug_get_all_elements ();
    int get_error_no () {return m_errno;};
    const char* get_expression_result ();
    int         get_expression_logic_result ();
    const char* get_element_at (size_t i) {if (i < m_elements.size()) return m_elements[i].c_str ();else return NULL;};
    int   clean_null_element ();
    int exp_insert_call_function (size_t pos);
    const char* get_string_result(void);
};

class parameterlist 
{
public:
    vector<expression*>  m_list;
    string debstr;

public:
    parameterlist () {m_list.clear ();};
    ~parameterlist () ;
    int add_expression (expression * nexp);
    const char* debug_get_all_expression ();
    size_t  get_parameter_no () {return m_list.size();};
    expression * get_expression_at (size_t i) {if (i < m_list.size()) return m_list[i]; else return NULL;};
};

#endif

