/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_foreach.h"


extern Scriptor g_script;
#include "atli.inc"

static int get_param_foreach_value (PtrLineInfo lineinfo)
{
    size_t st, ed;
    string paramlist;
    LPFOREACH_USER_DATA pfor;

    pfor = new FOREACH_USER_DATA;

    pfor->for_type = FOREACH_VALU;
    pfor->nth   = 0;


    st = skip_keyword (lineinfo);

    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if ((int)st == -1) {delete pfor; return -2;}
    if (lineinfo->line[st] != '$') {delete pfor; return -1;}
    st ++;
    ed = get_variable_string (lineinfo->line, st);
    if (ed == st) {delete pfor; return -1;}
    pfor->variable_name = lineinfo->line.substr (st, ed - st);

    st = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if ((int)st == -1) {delete pfor; return -2;}
    ed = lineinfo->line.find_first_of (BLANKCHAR, st);
    if (ed == st) {delete pfor; return -1;}
    if (lineinfo->line.substr (st, ed - st) != "in") {delete pfor; return -1;}

    st = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if ((int)st == -1) {delete pfor; return -2;}
    if (lineinfo->line[st] != '(') {delete pfor; return -2;}
    ed = lineinfo->line.find_last_of (')', lineinfo->line.length ());
    if ((int) ed == -1) {delete pfor; return -2;}
    st ++;
    paramlist = lineinfo->line.substr (st, ed - st);

    if (get_function_parameter_list (paramlist, 0, pfor->parameter_list) < 0) {
        delete pfor;
        return -2;
    }

    lineinfo->userdata = pfor;

    return 0;
}

static int get_param_foreach_file (PtrLineInfo lineinfo)
{
    size_t st, ed;
    string paramlist;
    LPFOREACH_USER_DATA pfor;

    pfor = new FOREACH_USER_DATA;

    pfor->for_type = FOREACH_FILE;
    pfor->nth = 0;

    st = skip_keyword (lineinfo);

    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if ((int)st == -1) {delete pfor; return -2;}
    if (lineinfo->line[st] != '$') {delete pfor; return -1;}
    st ++;
    ed = get_variable_string (lineinfo->line, st);
    if (ed == st) {delete pfor; return -1;}
    pfor->variable_name = lineinfo->line.substr (st, ed - st);

    st = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if ((int)st == -1) {delete pfor; return -2;}
    ed = lineinfo->line.find_first_of (BLANKCHAR, st);
    if (ed == st) {delete pfor; return -1;}
    if (lineinfo->line.substr (st, ed - st) != "in") {delete pfor; return -1;}

    st = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if ((int)st == -1) {delete pfor; return -2;}
    if (lineinfo->line[st] == '"') {
        ed = lineinfo->line.find_first_of ('"', st + 1);
        if ((int) ed == -1) {
            delete pfor; return -2;
        }
        ed ++;
    }
    else if (lineinfo->line[st] == '$'){
        ed = get_variable_string (lineinfo->line, st + 1);
        if (st == ed) {delete pfor; return -2;}
    }
    pfor->path = lineinfo->line.substr (st, ed - st);
    
    lineinfo->userdata = pfor;

    return 0;
}

int get_param_foreach (PtrLineInfo lineinfo)
{
    if (get_param_foreach_value (lineinfo) == 0)
        return 0;
    else
        return get_param_foreach_file (lineinfo);
}



static int get_one_value (PtrLineInfo lineinfo)
{
    LPFOREACH_USER_DATA pfor = (LPFOREACH_USER_DATA) lineinfo->userdata;

    if (pfor->nth < (int)pfor->parameter_list.get_parameter_no ()) {
        set_variable_value (pfor->variable_name,
            pfor->parameter_list.get_expression_at (pfor->nth)->get_expression_result ());
        pfor->nth ++;
        return 0;
    }
    else {
        pfor->nth = 0;
        return 1;
    }
}

#ifdef WIN32
static int atli_get_one_file (PtrLineInfo lineinfo)
{
    int ret = 1;
    WIN32_FIND_DATA FindFileData;
    HANDLE hFind = INVALID_HANDLE_VALUE;
    int i = 0;
    string filename;
    DWORD attr;
    size_t lt;
    string feach;
    LPFOREACH_USER_DATA pfor = (LPFOREACH_USER_DATA) lineinfo->userdata;

    if (pfor->path[0] == '"')
        feach = pfor->path;
    else {
        feach = get_value_for_variable (pfor->path.c_str() + 1);
    }
    feach = feach.substr (1, feach.length() - 2);


    hFind = FindFirstFile(feach.c_str(), &FindFileData);
    if (hFind == INVALID_HANDLE_VALUE) {
        return (-1);
    } 

    ret = 1;
    for (i = 0; i <= pfor->nth; ret = FindNextFile(hFind, &FindFileData)){
        if (ret == 0) break;
        lt = feach.find_last_of ('\\') + 1;
        filename = feach.substr (0, lt) + FindFileData.cFileName;
        attr = GetFileAttributes (filename.c_str());
//        if (attr & FILE_ATTRIBUTE_DIRECTORY)
//            continue;
        if (i == pfor->nth) break;
        else i ++;
    }

    if (ret) {
        set_variable_value (pfor->variable_name, filename);
        pfor->nth ++;;
    }
    else {
        set_variable_value (pfor->variable_name, "");
    }

    FindClose(hFind);
    if (!ret) {
        ret = GetLastError();
        pfor->nth = 0;
        return 1;
    }
    return 0;
}
#endif
#ifdef LINUX
static int atli_get_one_file (PtrLineInfo lineinfo)
{
    int ret = 1;
    struct stat statbuf;
    struct dirent   *dirp;
    DIR     *dp;
    char    *ptr;
    string fpath;
    int  st;
    int  i = 0;
    char filename[512];
    string pattern = "*";
    LPFOREACH_USER_DATA pfor = (LPFOREACH_USER_DATA) lineinfo->userdata;

    if (pfor->path[0] == '"')
        fpath = pfor->path.substr (1, pfor->path.length() - 2);
    else
        fpath = get_value_for_variable (pfor->path.c_str() + 1);
    fpath = fpath.substr (1, fpath.length() - 2);

    if (lstat (fpath.c_str(), &statbuf) < 0) {
        st = fpath.find_last_of ("/", fpath.length());
        pattern = fpath.substr (st + 1, fpath.length() - st);
        if (st > 0) fpath[st] = 0;
    }

#ifdef debug_script_lib
            dbgprint ("path: %s, pattern: %s\n", fpath.c_str(), pattern.c_str());
#endif            
    if ( (dp = opendir (fpath.c_str())) == NULL)
        return 1;

    while ( (dirp = readdir (dp)) != NULL) {
        sprintf (filename, "%s/%s", fpath.c_str(), dirp->d_name);
        if (lstat (filename, &statbuf) < 0){
#ifdef debug_script_lib
            dbgprint ("lstat error: %s\n", filename);
#endif            
            return -1;
        }
        
 //       if (S_ISDIR (statbuf.st_mode) != 0) continue;
        if(fnmatch (pattern.c_str(), dirp->d_name, FNM_FILE_NAME)) continue;
        if (i == pfor->nth) break;
        i ++;
    }

    if (dirp) {
        set_variable_value (pfor->variable_name, filename);
        pfor->nth ++;
        ret = 0;
    }
    else {
        set_variable_value (pfor->variable_name, "");
        ret = 1;
        pfor->nth = 0;
    }

    closedir (dp);
    return ret;
}
#endif



int exe_foreach (PtrLineInfo lineinfo)
{
    int ret;
    LPFOREACH_USER_DATA pfor = (LPFOREACH_USER_DATA) lineinfo->userdata;

    if (pfor->for_type == FOREACH_FILE)
        ret = atli_get_one_file (lineinfo);
    else {
        ret = get_one_value (lineinfo);
    }
#ifdef debug_script_lib
    dbgprint ("get one value, %s = %s\n", pfor->variable_name.c_str(),
        get_value_for_variable (pfor->variable_name).c_str()); 
#endif
    if (ret) {
        ostringstream msg;
        msg << "execute error(" << lineinfo->lineno << "): can not get one value or file name" << endl;
        g_script.parse_error = msg.str ();
        return 1;
    }
    return 0;
}

int post_parse_foreach (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];

    return 0;
}


int post_parse_endforeach (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];
    PtrLineInfo pline;
    int i;
    int bem = 0;

    for (i = (int)num -1; i >= 0; i --) {
        pline = g_script.script_stream [(size_t)i];
        if (pline->opertor == SCP_endforeach)
            bem --;
        else if (pline->opertor == SCP_foreach) 
            bem ++;
        if (bem == 1) {
            lineinfo->next = (int)i;
            pline->ornext  = (int)(num + 1);
            return 0;
        }
    }
    g_script.parse_error = "can not find corresponding for";
    return -1;
}
