/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_func.h"

extern Scriptor g_script;
#include "atli.inc"

int  get_param_func (PtrLineInfo lineinfo)
{
    size_t st;

    st = skip_keyword (lineinfo);
    return try_as_call_function (lineinfo, st);
}


int try_as_call_function (PtrLineInfo lineinfo, size_t ost)
{
    size_t st, ed;
    LPFUNC_USER_DATA pUser = new FUNC_USER_DATA;

    st = ost;
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if (st == -1) { delete pUser; return -1;}
    ed = get_variable_string (lineinfo->line, st);
    if (ed == st) { delete pUser; return -1;}
    pUser->function_name = lineinfo->line.substr (st, ed - st);

    st = lineinfo->line.find_first_of ('(', st);
    if ((int) st == -1) {delete pUser; return -1;}
    st ++;
    ed = lineinfo->line.find_last_of (')', lineinfo->line.length ());
    string param_str = lineinfo->line.substr (st, ed - st);
    if (get_function_parameter_list (param_str, 0, pUser->parameter_list) < 0){
        delete pUser;
        return -1;
    }
    lineinfo->userdata = (void*) pUser;

    return 0;
}

int exe_call_func (PtrLineInfo lineinfo)
{
    LPFUNCSTACK psk = new FUNCSTACK;
    char vn[32];
    LPFUNC_USER_DATA pfu = (LPFUNC_USER_DATA) lineinfo->userdata;

    if (lineinfo->next < 0)
        return -1;

    psk->ret_pos = lineinfo->cno + 1;
    psk->func_variable_set.clear ();
    psk->function_name = pfu->function_name;

    sprintf (vn, "%d", pfu->parameter_list.get_parameter_no());
    psk->func_variable_set["_0"] = vn;
    for (int i = 0; i < (int)pfu->parameter_list.get_parameter_no(); i ++) {
        sprintf (vn, "_%d", i + 1);
        psk->func_variable_set[vn] = pfu->parameter_list.get_expression_at(i)->get_expression_result();
    }

    g_script.callstack.push_back (psk);

    return 0;
}

int exe_enter_func (PtrLineInfo lineinfo)
{
    char vn[32];
    LPFUNCSTACK psk = g_script.callstack.back ();
    LPFUNC_USER_DATA pfu;
    string param;
    const char *value;

    pfu = (LPFUNC_USER_DATA) lineinfo->userdata;

    for (int i = 0; i < (int)pfu->parameter_list.get_parameter_no() ; i ++) {
        sprintf (vn, "_%d", i + 1);
        param = pfu->parameter_list.get_expression_at(i)->get_element_at(0) + 1;
        value = get_func_value (vn);
        if (value == NULL)
            set_func_variable_value (param, string(""));
        else 
            set_func_variable_value (param, value);
    }

    return 0;
}

int exe_fend_func (PtrLineInfo lineinfo)
{
    LPFUNCSTACK psk = g_script.callstack.back ();

    if (NULL == psk)
        return -1;

    lineinfo->next = psk->ret_pos;
    g_script.callstack.pop_back ();

    string name;
    name = "__" + psk->function_name;
    set_variable_value (name, psk->func_variable_set[RETURN_VAR]);

    psk->func_variable_set.clear();
    delete psk;

    return 0;
}

int post_parse_function (PtrLineInfo lineinfo)
{
    g_script.function_list[((LPFUNC_USER_DATA)lineinfo->userdata)->function_name] = 
        lineinfo->cno;
    return 0;
}

int post_parse_fend (PtrLineInfo lineinfo)
{
    lineinfo->next = -1;
    lineinfo->ornext = -1;
    return 0;
}

