/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_goto.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"

extern Scriptor g_script;
#include "atli.inc"

 
int try_as_label_line (PtrLineInfo lineinfo)
{
    size_t st, ed, ll;

    st = 0;
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if (st == -1 ) return -1;
    ed = get_variable_string (lineinfo->line, st);
    if (ed == st) return -1;

    ll = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if ((int)ll == -1) return -1;
    if (lineinfo->line[ll] != ':') return -1;
    if ((int)lineinfo->line.find_first_not_of (BLANKCHAR, ll+1) != -1) return -1;

    lineinfo->opertor = SCP_label;
    lineinfo->param_num = 1;
    lineinfo->param_string.resize (1);
    lineinfo->param_string[0] = lineinfo->line.substr (st, ed - st);
    lineinfo->uidx = get_operator ("label");

    return 0;
}


int get_param_label (PtrLineInfo lineinfo)
{
    size_t st, ed;

    st = lineinfo->line.find_first_not_of (" \t", 0);
    if (st == -1) return -1;
    if (lineinfo->line.substr (st, 5) == "label") {
        if (lineinfo->line[st + 5] != ' ' &&
            lineinfo->line[st + 5] != '\t' )
            return -2;
        st = lineinfo->line.find_first_not_of (" \t", st + 5);
        if (st == -1) return -3;
    }
    ed = lineinfo->line.find_first_of (": \t", st);
    if (ed == -1) ed = lineinfo->line.length ();
    lineinfo->param_num = 1;
    lineinfo->param_string.resize (1);
    lineinfo->param_string[0] = lineinfo->line.substr (st, ed - st);
#ifdef debug_script_lib
    dbgprint ("Get paramter:%s\n", lineinfo->param_string[0].c_str());
#endif

    return 0;
}

int get_param_goto (PtrLineInfo lineinfo)
{
    size_t st, ed;

    st = skip_keyword (lineinfo);
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if ((int)st == -1) return -1;
    ed = get_variable_string (lineinfo->line, st);
    
    lineinfo->param_num = 1;
    lineinfo->param_string.resize (1);
    lineinfo->param_string[0] = lineinfo->line.substr (st, ed - st);
    return 0;
}

int set_goto_next (int num)
{
    int i;
    PtrLineInfo lineinfo, plinegoto;

    plinegoto = g_script.script_stream[num];

    for (i = (int)num -1; i >= 0; i --) {
        lineinfo = g_script.script_stream [(size_t)i];
        if ((lineinfo->opertor == SCP_label) &&
            (lineinfo->param_string[0] == plinegoto->param_string[0])) 
        {
            plinegoto->next = (int)i ;
            plinegoto->ornext = (int)i;
            return 0;
        }
        else if (lineinfo->opertor == SCP_function) {
            break;
        }
    }
    for (i = (int)num + 1; i < (int)g_script.script_stream.size (); i ++) {
        lineinfo = g_script.script_stream [(size_t)i];
        if ((lineinfo->opertor == SCP_label) &&
            (lineinfo->param_string[0] == plinegoto->param_string[0])) 
        {
            plinegoto->next = (int)i ;
            plinegoto->ornext = (int)i;
            return 0;
        }
        else if (lineinfo->opertor == SCP_fend) {
            break;
        }
    }

    g_script.parse_error = "can not find label:" + plinegoto->param_string[0];
    return -1;
}

int post_parse_goto (PtrLineInfo lineinfo)
{
    lineinfo->next = -1;
    lineinfo->ornext = -1;
    return 0;
}
