/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_if.h"

extern Scriptor g_script;
#include "atli.inc"


int get_param_if (PtrLineInfo lineinfo)
{
    size_t st, ed;
    LPIF_USER_DATA pif;

    st = skip_keyword (lineinfo);

    st = lineinfo->line.find_first_of ("(", st);
    if (st == -1) return -1;
    ed = lineinfo->line.find_last_of (")", lineinfo->line.length());
    if (ed == -1) return -1;
    
    st = st + 1;
    pif = new IF_USER_DATA;
    pif->exp.parse_elements (lineinfo->line.substr(st, ed - st).c_str());
    lineinfo->param_num = 0;
    lineinfo->userdata = (void*)pif;
    return 0;
}



int exe_if_value (PtrLineInfo lineinfo)
{
    int result;
    LPIF_USER_DATA pif = (LPIF_USER_DATA) lineinfo->userdata;

    result = pif->exp.get_expression_logic_result ();

    if (result < 0) 
        return -1;
    else
        return !result;
}


int post_parse_if (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];

    lineinfo->ornext = lineinfo->cno;

    return 0;
}

int post_parse_else (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];
    PtrLineInfo pline;
    int i;
    int bem = 0;

    for (i = (int)num -1; i >= 0; i --) {
        pline = g_script.script_stream [(size_t)i];
        if (pline->opertor == SCP_endif)
            bem --;
        else if (pline->opertor == SCP_if) 
            bem ++;
        if (bem == 1) {
            pline->ornext  = (int)(num + 1);
            return 0;
        }
    }
    g_script.parse_error = "can not find corresponding if";
    return -1;
}

int post_parse_endif (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];
    PtrLineInfo pline, pif, pelse;
    int i;
    int bem = 0;
    int elno = -1;
    
    pif = NULL; pelse = NULL;

    for (i = (int)num -1; i >= 0; i --) {
        pline = g_script.script_stream [(size_t)i];
        if (pline->opertor == SCP_endif) {
            bem --;
        }
        else if (pline->opertor == SCP_else && bem == 0) {
            pelse = pline;
            elno  = i;
        }
        else if (pline->opertor == SCP_if) {
            bem ++;
        }
        if (bem == 1) {
            if (pelse == NULL) {
                pline->ornext = (int)(num + 1);
            }
            else {
                g_script.script_stream[elno - 1]->next = (int)(num + 1);
            }
            return 0;
        }
    }
    g_script.parse_error = "can not find corresponding if";
    return -1;
}