/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/




#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_goto.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_innerfunc.h"
#include "Atli_func.h"

extern Scriptor g_script;
#include "atli.inc"


#ifdef LINUX
#define Sleep(t) usleep(1000* t)
#endif

int exe_waitfor (PtrLineInfo lineinfo)
{
    string param;
    int ret;
    PARAMLIST pl;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;

    if (!g_script.script_exe_func) {
        ostringstream msg;
        msg << "execute error("<< lineinfo->lineno << "): can find application-defined function" <<endl;
        g_script.parse_error = msg.str ();
        return 0;
    }

    param = pfunc->parameter_list.get_expression_at(0)->get_expression_result();
    pl.number = 1;
    pl.param[0] = (char*) param.c_str();

    while (0 == (ret = g_script.script_exe_func (lineinfo->opertor, 
        (DWORD_PTR)&pl, (DWORD_PTR)lineinfo->line.c_str ()))) {
        Sleep (200);
    }

    return 0;
}

int exe_print_string (PtrLineInfo lineinfo)
{
    size_t i;
    string ostr;
    PARAMLIST pl;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
    string one;

    ostr = "";
    for (i = 0; i < (size_t) pfunc->parameter_list.get_parameter_no (); i ++) {
        one = pfunc->parameter_list.get_expression_at(i)->get_expression_result ();
        if (one[0] == '"') {
            ostr += one.substr (1, one.length() - 2);
        } else
            ostr += one;
    }

    pl.number = 1;
    pl.param[0] = (char*)ostr.c_str();

    if (g_script.script_exe_func) 
        g_script.script_exe_func (lineinfo->opertor, (DWORD_PTR) &pl, 
        (DWORD_PTR) lineinfo->line.c_str());

#ifdef debug_script_lib
    dbgprint ("print string:%s\n", ostr.c_str());
#endif
    return 0;
}


int exe_wait_time (PtrLineInfo lineinfo)
{
    int ret;
    string param1;
    int slep;
    time_t st, ed;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;

    time (&st);
    
    slep  = atoi(pfunc->parameter_list.get_expression_at(0)->get_expression_result());
    for (int i = 0; i < slep; i ++) {
        time (&ed);

        if (10 * (ed - st) >= slep + 5)
            return 0;
        if (g_script.script_exe_func)
            ret = g_script.script_exe_func (lineinfo->opertor, 0 , 0);
        else ret = 0;
        if (ret < 0)
            return -1;
        time (&ed);

        if (10 * (ed - st) >= slep + 5)
            return 0;
        Sleep (100);
    }

    return 0;
}


#ifdef WIN32
int exe_fexec (PtrLineInfo lineinfo)
{
    int ret;
    char cmd [512];
    STARTUPINFO startup;
    PROCESS_INFORMATION procinfo;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
    int num = (int)pfunc->parameter_list.get_parameter_no(); 
    string syscmd;

    syscmd = "";
    syscmd = pfunc->parameter_list.get_expression_at(0)->get_expression_result ();
    syscmd = syscmd.substr (1, syscmd.length() - 2);
    for (int i = 1; i < num; i ++) {
        syscmd += string(" ");
        syscmd += pfunc->parameter_list.get_expression_at(i)->get_expression_result ();
    }

    memset (&startup, 0, sizeof startup);
    startup.cb = sizeof startup;
    strcpy (cmd, syscmd.c_str());
    ret = CreateProcess (NULL, cmd, NULL, NULL, TRUE, 
        NORMAL_PRIORITY_CLASS, NULL, NULL, &startup, &procinfo);

    if (ret == 0) {
#ifdef debug_script_lib
        dbgprint ("CreateProcess error:%d\n", GetLastError ());
#endif
        set_variable_value (RETURN_VAR, (float)1);
        set_variable_value ("__fexec", (float)1);
        return 1;
    }
    CloseHandle (procinfo.hThread);
    CloseHandle (procinfo.hProcess);
    set_variable_value (RETURN_VAR, (float)0);
    set_variable_value ("__fexec", (float)0);
    return 0;
}
#endif

#ifdef LINUX
int exe_fexec (PtrLineInfo lineinfo)
{
    pid_t pid;
    char cmd;

    if ((pid = fork ()) < 0 ) {
        set_variable_value (RETURN_VAR, (float)1);
        set_variable_value ("__fexec", (float)1);
        return 1;
    }
    else if (pid == 0) {
        LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
        int num = pfunc->parameter_list.get_parameter_no(); 
        string syscmd;

        syscmd = "";
        syscmd = pfunc->parameter_list.get_expression_at(0)->get_expression_result ();
        syscmd = syscmd.substr (1, syscmd.length() - 2);
        for (int i = 1; i < num; i ++) {
            syscmd += string(" ");
            syscmd += pfunc->parameter_list.get_expression_at(i)->get_expression_result ();
        }
#ifdef debug_script_lib
        dbgprint ("execute: %s\n", syscmd.c_str());
#endif
        system (syscmd.c_str());
        exit (0);
    }
    set_variable_value (RETURN_VAR, (float)0);
    set_variable_value ("__fexec", (float)0);
    return 0;
}
#endif

int exe_exec (PtrLineInfo lineinfo)
{
    int ret;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA) lineinfo->userdata;
    int num = (int)pfunc->parameter_list.get_parameter_no(); 
    string syscmd;

    syscmd = "";
    syscmd = pfunc->parameter_list.get_expression_at(0)->get_expression_result ();
    syscmd = syscmd.substr (1, syscmd.length() - 2);
    for (int i = 1; i < num; i ++) {
        syscmd += string(" ");
        syscmd += pfunc->parameter_list.get_expression_at(i)->get_expression_result ();
    }

    ret = system (syscmd.c_str());

    set_variable_value (RETURN_VAR, (float)ret);
    set_variable_value ("__exec", (float)ret);

    if (ret) {
        ostringstream msg;
        msg << "execute error(" << lineinfo->lineno << "): launch program error "
            << endl;
        g_script.parse_error = msg.str ();

#ifdef debug_script_lib
        dbgprint ("system error:%d\n", ret);
#endif
        return 1;
    }
    return 0;
}

int exe_return (PtrLineInfo lineinfo)
{
    string retval;
    LPFUNC_USER_DATA pfunc = (LPFUNC_USER_DATA)lineinfo->userdata;

    if (pfunc->parameter_list.get_parameter_no())
        set_variable_value (RETURN_VAR, pfunc->parameter_list.get_expression_at(0)->get_expression_result());
    else 
        set_variable_value (RETURN_VAR, "");

    return 0;
}

int set_return_next (int num)
{
    int i;
    PtrLineInfo lineinfo, plinereturn;

    plinereturn = g_script.script_stream[num];

    for (i = (int)num + 1; i < (int)g_script.script_stream.size (); i ++) {
        lineinfo = g_script.script_stream [(size_t)i];
        if (lineinfo->opertor == SCP_fend) {
            plinereturn->next = (int)i ;
            plinereturn->ornext = (int)i;
            return 0;
        }
        else if (lineinfo->opertor == SCP_function) 
            break;
    }

    return -1;
}
