/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/


#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli_func.h"

extern Scriptor g_script;
#include "atli.inc"

int get_operator (string &line)
{
    size_t len = line.length();
    size_t st, i, ed;
    string oper;

    st = line.find_first_not_of(" \t");
    ed = line.find_first_of (" \t\n\r(", st);
    if (ed == -1) ed = line.length ();
    oper = line.substr (st, ed - st);

    for (i = 0; i < g_script.g_keywordnum; i ++) {
        if (oper == g_script.g_keyword[i].keywordstring)
            return (int)i;
    }

    return -1;
}

int get_operator (const char*oline)
{
    string line = oline;
    return get_operator (line);
}

int invalidate_variable_string (string &v)
{
    for (int i = 0; i < (int) g_script.g_keywordnum; i ++) {
        if (0 == v.compare (0, strlen(g_script.g_keyword[i].keywordstring),
            g_script.g_keyword[i].keywordstring))
            return -1;
    }
    return 0;
}

int get_variable_string (string &line, size_t st)
{
    const char *p;

    p = line.c_str() + st;
    for (; *p != 0; p ++) {
        if ((*p >= '0' && *p <= '9') || (*p >= 'a' && *p <= 'z') || 
            (*p >= 'A' && *p <= 'Z') || (*p == '_'))
            continue;
        else 
            return (int)(p - line.c_str());
    }

    return (int)(p - line.c_str());
}

int get_expression_string (string &line, size_t st, expression *nexp)
{
    return (int)nexp->parse_elements (line.c_str(), (int)st);    
}


int get_expression_string (string &line, size_t st, expression &nexp)
{
    return (int)nexp.parse_elements (line.c_str(), (int)st);    
}

int get_expression_string (string &line, size_t st)
{
    expression nexp;

    nexp.m_test = 1;

    return (int)nexp.parse_elements (line.c_str(), (int)st);
}

int get_function_parameter_list (string line, size_t ost, parameterlist &pl)
{
    size_t st, ed;
    expression *pexp;

    st = ost;
    st = line.find_first_not_of (BLANKCHAR, st);
    if ((int)st == -1) return (int)ost;

    st = st;
    pexp = NULL;
    while (st < line.length ()) {
        st = line.find_first_not_of (BLANKCHAR, st);
        if (line[st] == ')') break;
        pexp = new expression;
        ed = get_expression_string (line, st, pexp);
#ifdef debug_script_lib
        dbgprint ("get one parameter expresion:%s\n",pexp->debug_get_all_elements());
#endif
        if ( st == ed) {
            delete pexp; return -1;
        }
        st = ed;
        if (line[st] == ',') st = st  + 1;
        pl.add_expression (pexp); pexp = NULL;
    } 
    pl.add_expression (pexp);

    return 0;
}

