/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/



#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "Atli_set.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"

extern Scriptor g_script;
#include "atli.inc"

int try_as_evaluate_line (PtrLineInfo lineinfo) 
{
    size_t st, ed;
    LPOP_SET_DATA pUser = new OP_SET_DATA;

    st = 0;
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if (lineinfo->line[st] != '$') {
        delete pUser; return -1;
    }

    st ++;
    ed = get_variable_string (lineinfo->line, st);
    if (ed == st) {
        delete pUser;
        return -1;
    }
    pUser->variable = lineinfo->line.substr (st, ed -st);

    st = ed;
    st = lineinfo->line.find_first_not_of (BLANKCHAR, ed);
    if (st == -1) {
        delete pUser;
        return -1;
    }
    if (lineinfo->line[st] != '=') {
        delete pUser;
        return -1;
    }

    st ++;
    ed = get_expression_string (lineinfo->line, st, pUser->exp);
    if (ed != lineinfo->line.length ()) {
        delete pUser;
        return -1;
    }

    lineinfo->userdata = (void*) pUser;

    return 0;
}


int try_as_expression (PtrLineInfo lineinfo)
{
    size_t st, ed;
    LPOP_SET_DATA pUser = new OP_SET_DATA;

    pUser->variable = "";

    st = 0;
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    ed = get_expression_string (lineinfo->line, st, pUser->exp);
    if (ed != lineinfo->line.length ()) {
        delete pUser;
        return -1;
    }

    lineinfo->userdata = (void*) pUser;

    return 0;
}


int get_set_param (PtrLineInfo lineinfo)
{
    size_t st, ed;
    string var, val;

    st = lineinfo->line.find_first_not_of (" \t");
    st = lineinfo->line.find_first_of (" \t", st);
    if (st == -1)  return -1;
    st = lineinfo->line.find_first_not_of (" \t", st);
    if (st == -1)  return -1;
    ed = lineinfo->line.find_first_of (" =",st);
    if (ed == -1)  return -1;
    var = lineinfo->line.substr (st,ed - st);
    if (invalidate_variable_string (var))
        return -1;
    if (lineinfo->line[ed] != '=') {
        ed = lineinfo->line.find_first_of ("=", ed);
        if (ed == -1)  return -1;
    }
    st = lineinfo->line.find_first_not_of (" \t", ed + 1);
    if (st == -1)  return -1;
    if (lineinfo->line[st] != '"') {
        ed = lineinfo->line.find_last_not_of (" \t", lineinfo->line.length());
        if (ed == -1) ed = lineinfo->line.length();
            else ed ++;
    } else {
        st ++;
        ed = lineinfo->line.find_first_of ('"', st);
    }
    if (ed == -1)
        ed = lineinfo->line.length ();
    val = lineinfo->line.substr (st, ed - st);

    lineinfo->param_num = 2;
    lineinfo->param_string.resize (2);
    lineinfo->param_string [0] = var;
    lineinfo->param_string [1] = val;    
#ifdef debug_script_lib
        dbgprint ("Get paramter:%s = %s\n", lineinfo->param_string[0].c_str(),
            lineinfo->param_string[1].c_str());
#endif

    return 0;
}

int exe_set_value (PtrLineInfo lineinfo)
{
    LPOP_SET_DATA pUser = (LPOP_SET_DATA)lineinfo->userdata;

    if (pUser == NULL) return -1;

    if (pUser->variable.length()) {
        set_variable_value (pUser->variable, pUser->exp.get_expression_result());
#ifdef debug_script_lib
        dbgprint ("set expression result:%s\n", get_value_for_variable (pUser->variable).c_str());
#endif
    }
    else
        pUser->exp.get_expression_result ();

    return 0;
}
