/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/


#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli_expression.h"
#include "Atli_parameter.h"
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atliparse.h"
#include "mathparse.h"
#include "logiparse.h"
#include "Atli_variable.h"


extern Scriptor g_script;

#include "atli.inc"


/// ***//

const char* get_func_value (string &var)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    

	if (psk && (psk->func_variable_set.find (var) != psk->func_variable_set.end())) 
		return psk->func_variable_set[var].c_str();
	else
		return NULL;
}

const char* get_func_value (const char *var)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    

	if (psk && (psk->func_variable_set.find (var) != psk->func_variable_set.end())) 
		return psk->func_variable_set[var].c_str();
	else
		return NULL;
}

const char* get_value (const char* variable)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    

    if (psk && psk->func_variable_set.find (variable) != psk->func_variable_set.end())
        return psk->func_variable_set[variable].c_str();
    else if (g_script.variable_set.find (variable) != g_script.variable_set.end())
        return g_script.variable_set[variable].c_str();
    else
        return NULL;
}

string &get_value_for_variable (const char* var)
{
    string lv = var;
    return get_value_for_variable (lv);
}

string &get_value_for_variable (string &var)
{
    static string val;
    char  rnd [32];

    val.clear ();
    val = var;
    if (val == "random") {
        sprintf (rnd, "%d", rand ());
        val = rnd;
        g_script.variable_set["random"] = rnd;
    }
    else {
        if (get_value (var.c_str()))
            val = get_value (var.c_str());
        else if (g_script.script_exe_func) {
            char *rv;
            PARAMLIST pml;
            pml.number = 1;
            pml.param[0] = (char*)var.c_str();
            rv = (char*) (DWORD_PTR)g_script.script_exe_func (SCP_getvalue, 
                (DWORD_PTR)&pml, (DWORD_PTR)(int)0);
            if (rv) val = (char*) rv;
            else val = "";
        }
        else
            val = "";
    }
    return val;
}


///  ** //
int set_variable_value (string var, const char* val)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    
    
    if ((NULL == psk) || (g_script.variable_set.find (var) != g_script.variable_set.end()))
        g_script.variable_set[var] = (val)?val:"";
    else {
        psk->func_variable_set[var] = (val)?val:"";
    }
	
    return 0;
}


int set_variable_value (string var, string val)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    
    
	if ((NULL == psk) || (g_script.variable_set.find (var) != g_script.variable_set.end()))
	    g_script.variable_set[var] = val;
	else {
	    psk->func_variable_set[var] = val;
	}
	
    return 0;
}

int set_variable_value (string var, float val)
{
    char buf[32];
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    

    if ((val - ((int) val)) <= 0.0000001)
        sprintf (buf, "%d", (int)val);
    else
        sprintf (buf, "%f", val);

	if ((NULL == psk) || (g_script.variable_set.find (var) != g_script.variable_set.end()))
	    g_script.variable_set[var] = buf;
	else {
	    psk->func_variable_set[var] = buf;
	}
    return 0;
}

///  ** //
int set_func_variable_value (string var, string val)
{
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    
    
	if (psk) 
	    psk->func_variable_set[var] = val;
	else 
		return -1;
	
    return 0;
}

int set_func_variable_value (string var, float val)
{
    char buf[32];
    LPFUNCSTACK psk = NULL;
    
    if (g_script.callstack.size())
	    psk = g_script.callstack.back ();	    

	if (psk == NULL)
		return -1;

    if ((val - ((int) val)) <= 0.0000001)
        sprintf (buf, "%d", (int)val);
    else
        sprintf (buf, "%f", val);

    psk->func_variable_set[var] = buf;

    return 0;
}

///  ** //
int set_global_variable_value (string var, string val)
{
    g_script.variable_set[var] = val;
	
    return 0;
}

int set_global_variable_value (string var, float val)
{
    char buf[32];

    if ((val - ((int) val)) <= 0.0000001)
        sprintf (buf, "%d", (int)val);
    else
        sprintf (buf, "%f", val);

    g_script.variable_set[var] = buf;
    return 0;
}

