/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/


#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliexe.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"

extern Scriptor g_script;
#include "atli.inc"
#include "Atli_appfunc.h"
#include "Atli_if.h"
#include "Atli_foreach.h"
#include "Atli_func.h"
#include "Atli_goto.h"
#include "Atli_set.h"
#include "Atli_innerfunc.h"
#include "Atli_while.h"

static int exe_one_line (PtrLineInfo lineinfo)
{
    string param1;
    int ret;

    switch (lineinfo->opertor) {
        case SCP_begin:
            return 0;

        case SCP_end:
            return 0;

        case SCP_call:
            ret = exe_call_func (lineinfo);
            if (ret < 0)
                ret = exe_app_func (lineinfo);
            return ret;
            break;

        case SCP_function:
            return exe_enter_func (lineinfo);
            break;

        case SCP_fend: 
            return exe_fend_func (lineinfo);
            break;

        case SCP_waitfor:
            return exe_waitfor (lineinfo);
            break;

        case SCP_print:
            return exe_print_string (lineinfo);     
            break;

        case SCP_wait:
            return exe_wait_time (lineinfo);
            break;        
        
        case SCP_foreach:
            return exe_foreach (lineinfo);
            break;

        case SCP_endforeach:
            return 0;

        case SCP_set:
            exe_set_value (lineinfo);
            break;

        case SCP_if:
            return exe_if_value (lineinfo);
            break;

        case SCP_else:
            return 0;

        case SCP_endif:
            return 0;

        case SCP_label:
            return 0;

        case SCP_goto:
            return 0;

        case SCP_exec:
            return exe_exec (lineinfo);
            return 0;

        case SCP_fexec:
            return exe_fexec (lineinfo);
            return 0;

        case SCP_return:
            return exe_return (lineinfo);
            break;

        case SCP_while:
            return exe_while (lineinfo);
            break;
            
        case SCP_endwhile:
            return exe_endwhile (lineinfo);
            break;

        default:
            return exe_app_keyword (lineinfo);
            break;
    }

    return 0;
}


int script_execute_script (SCRIPT_EXE_FUNC func)
{
    size_t i;
    size_t num = g_script.script_stream.size ();
    int ret;

    if (g_script.script_start == (unsigned int)-1) g_script.script_start = 0;
    if (g_script.script_end == (unsigned int)-1) g_script.script_end = (unsigned int)num;

    g_script.script_exe_func = func;

    srand ((unsigned int)time(NULL));
    for (i = g_script.script_start; i != g_script.script_end;) {
        if (i >= num || i < 0) break;
#ifdef debug_script_lib
        dbgprint ("execute line: %d: %s\n", g_script.script_stream[i]->lineno, g_script.script_stream[i]->line.c_str()); 
#endif
        g_script.current_stream = (int)i;
        ret = exe_one_line (g_script.script_stream[i]);
        if (!ret)
            i = g_script.script_stream[i]->next;
        else if (ret > 0)
            i = g_script.script_stream[i]->ornext;
        else
            return -1;
    }

    return 0;
}
