/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/


#ifdef WIN32
#define _WIN32_WINNT 0x0501
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <fnmatch.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <dirent.h>
#endif
#include <stdio.h>
#include <list>
#include <string>
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <algorithm>
#include <map>
#include <time.h>
#include "Atli.h"
#include "utility.h"
#include "mathparse.h"
#include "logiparse.h"
#include "atlidef.h"
#include "Atliparse.h"
#include "Atli_expression.h"
#include "Atli_parameter.h"
extern Scriptor g_script;
#include "atli.inc"
#include "Atli_appfunc.h"
#include "Atli_if.h"
#include "Atli_foreach.h"
#include "Atli_func.h"
#include "Atli_goto.h"
#include "Atli_set.h"
#include "Atli_innerfunc.h"
#include "Atli_while.h"



size_t skip_keyword (PtrLineInfo lineinfo)
{
    size_t st;

    st = lineinfo->line.find_first_not_of(" \t");
    st += strlen (g_script.g_keyword [lineinfo->uidx].keywordstring);
    
    return st;
}


static int get_param_global (PtrLineInfo lineinfo)
{
    size_t st, ed;

    st = skip_keyword (lineinfo);
    st = lineinfo->line.find_first_not_of (BLANKCHAR, st);
    if ((int)st == -1) return -1;
    st ++;
    ed = get_variable_string (lineinfo->line, st);
    
    lineinfo->param_num = 1;
    lineinfo->param_string.resize (1);
    lineinfo->param_string[0] = lineinfo->line.substr (st, ed - st);
    return 0;
}


static int get_parameter (PtrLineInfo lineinfo)
{
    string buf;
    int ret;

    switch (lineinfo->opertor) {
    case SCP_label:
        ret=  get_param_label (lineinfo);
#ifdef debug_script_lib
        dbgprint ("as label: %s\n", lineinfo->param_string[0].c_str());
#endif
        return ret;
        break;

    case SCP_goto:
        return get_param_goto (lineinfo);
        break;

    case SCP_global:
        ret = get_param_global (lineinfo);
#ifdef debug_script_lib
        dbgprint ("as global define: %s\n", lineinfo->param_string[0].c_str());
#endif
        return ret;
        break;

    case SCP_if:
        return get_param_if (lineinfo);
        break;

    case SCP_foreach:
        return get_param_foreach (lineinfo);
        break;

    case SCP_function:
        ret = get_param_func (lineinfo);
#ifdef debug_script_lib
        if (!ret)
        dbgprint ("as function define, function name: %s, parameterlist: %s\n", 
            ((LPFUNC_USER_DATA)lineinfo->userdata)->function_name.c_str(), 
            ((LPFUNC_USER_DATA)lineinfo->userdata)->parameter_list.debug_get_all_expression());
#endif        
        return ret;
        break;

    case SCP_print:
    case SCP_exec:
    case SCP_fexec:
    case SCP_wait:
    case SCP_waitfor:
    case SCP_return:
        ret = try_as_call_function (lineinfo, 0);
#ifdef debug_script_lib
        if (!ret)
        dbgprint ("as call function, function name: %s, parameter list %s\n", 
            ((LPFUNC_USER_DATA)lineinfo->userdata)->function_name.c_str(), 
            ((LPFUNC_USER_DATA)lineinfo->userdata)->parameter_list.debug_get_all_expression());
#endif
        return ret;
        break;

    case SCP_while:
        return get_param_while (lineinfo);
        break;

    case SCP_endwhile:
        return get_param_endwhile (lineinfo);
        break;
    }
    return 0;
}

static int parse_operator_parameter (PtrLineInfo lineinfo)
{
    //get operator 
#ifdef debug_script_lib
    dbgprint ("parse line:%d: %s\n", lineinfo->lineno, lineinfo->line.c_str());
#endif

    if ((lineinfo->uidx = get_operator (lineinfo->line)) != -1) {
        lineinfo->opertor = g_script.g_keyword[lineinfo->uidx].scpoper;

        return get_parameter (lineinfo);
    }

    //else try to guess
    if (!try_as_label_line (lineinfo)) {
        lineinfo->opertor = SCP_label;
        lineinfo->uidx = get_operator ("label");
#ifdef debug_script_lib
        dbgprint ("as label: %s\n", lineinfo->param_string[0].c_str());
#endif
        return 0;
    }

    if (!try_as_evaluate_line (lineinfo)) {
        lineinfo->opertor = SCP_set;
        lineinfo->uidx = get_operator ("set");


        return 0;
    }

    if (!try_as_call_function (lineinfo, 0)) {
        lineinfo->opertor = SCP_call;
        lineinfo->uidx = get_operator ("call");


        return 0;
    }

    if (!try_as_expression (lineinfo)) {
        lineinfo->opertor = SCP_set;
        lineinfo->uidx = get_operator ("set");
#ifdef debug_script_lib
        dbgprint ("as expression, variable: %s, expression: %s\n", 
            ((LPOP_SET_DATA)lineinfo->userdata)->variable.c_str(), 
            ((LPOP_SET_DATA)lineinfo->userdata)->exp.debug_get_all_elements());        
#endif
        return 0;
    }

    return -1;
}

int post_parse_begin (PtrLineInfo lineinfo)
{
    g_script.script_start = (unsigned int)lineinfo->cno;
    return 0;
}

int post_parse_end (PtrLineInfo lineinfo)
{
    g_script.script_end = (unsigned int)lineinfo->cno;
    lineinfo->next = -1;
    lineinfo->ornext = -1;
    return 0;
}

int post_parse_global (PtrLineInfo lineinfo)
{
    g_script.variable_set[lineinfo->param_string[0]] = "";
    return 0;
}

int post_parse_return (PtrLineInfo lineinfo)
{
    lineinfo->next = -1;
    lineinfo->ornext = -1;
    return 0;
}

static int post_parse (size_t num)
{
    PtrLineInfo lineinfo = g_script.script_stream[num];

    switch (lineinfo->opertor) {
        case SCP_return:
            return post_parse_return (lineinfo);
            break;

        case SCP_function:
            return post_parse_function (lineinfo);
            break;

        case SCP_begin:
            return post_parse_begin (lineinfo);
            break;

        case SCP_end:
            return post_parse_end (lineinfo);
            break;

        case SCP_set:
            break;

        case SCP_goto:
            return post_parse_goto (lineinfo);
            break;

        case SCP_endforeach:
            return post_parse_endforeach (num);

        case SCP_foreach:
            return post_parse_foreach (num);

        case SCP_if:
            return post_parse_if (num);

        case SCP_else:
            return post_parse_else (num);

        case SCP_endif:
            return post_parse_endif (num);

        case SCP_global:
            return post_parse_global (lineinfo);
            break;

        case SCP_fend:
            return post_parse_fend (lineinfo);
            break;

        case SCP_while:
            return post_parse_while (lineinfo);
            break;

        case SCP_endwhile:
            return post_parse_endwhile(lineinfo);
            break;
                
    }
    return 0;
}

static int flush_script_stream_index (int insertpos, int deriveline)
{
    int num = (int)g_script.script_stream.size ();
    int i;


    for (i = insertpos + 1; i < num; i ++) {
        g_script.script_stream[i]->cno ++;
    }

    for (i = 0; i < num; i ++) {
        if (i == insertpos) continue;
        if (g_script.script_stream[i]->next > insertpos)
            g_script.script_stream[i]->next ++;
        else if (g_script.script_stream[i]->next == insertpos) {
            if (deriveline != 1) 
                g_script.script_stream[i]->next ++;
        }

        if (g_script.script_stream[i]->ornext > insertpos)
            g_script.script_stream[i]->ornext ++;
        else if (g_script.script_stream[i]->ornext == insertpos) {
            if (deriveline != 1) 
                g_script.script_stream[i]->ornext ++;
        }
    }

    return 0;
}


int insert_script_line (const char* line, int no, int insertpos, int deriveline)
{
    ostringstream msg;
    int ret;

    g_script.current_stream = insertpos;
    g_script.current_line = no;
    g_script.script_stream.insert(g_script.script_stream.begin() + insertpos, new LineInfo);
    g_script.script_stream[insertpos]->line   = line;
    g_script.script_stream[insertpos]->ext    = deriveline;
    g_script.script_stream[insertpos]->next   = (int)insertpos + 1;
    g_script.script_stream[insertpos]->ornext = (int)insertpos + 1;
    g_script.script_stream[insertpos]->lineno = no;
    g_script.script_stream[insertpos]->cno    = (int)insertpos;
    g_script.script_stream[insertpos]->userdata = NULL;    

    flush_script_stream_index (insertpos, deriveline);


    if (parse_operator_parameter (g_script.script_stream[insertpos]) < 0) {
        msg.clear();
        msg <<"parse error(" << (unsigned int)g_script.script_stream[insertpos]->lineno 
            <<"): unknown keyword.";
        g_script.parse_error = msg.str ();
#ifdef debug_script_lib
        dbgprint ("%s\n", g_script.parse_error.c_str());
#endif
        return -1;
    }

    ret = post_parse (insertpos);
    if (ret != 0) {
        msg.clear ();
        msg <<"parse error(" 
            << (unsigned int)g_script.script_stream[insertpos]->lineno << "): " 
            << g_script.parse_error;
        g_script.parse_error = msg.str ();
#ifdef debug_script_lib
        dbgprint ("%s\n", g_script.parse_error.c_str());
#endif        
        return -3;
    }

    return 0;
}

int parse_script_line (string &line, int no)
{
    size_t num = g_script.script_stream.size ();
    ostringstream msg;
    int ret;

    g_script.current_stream = (int)num;
    g_script.current_line = no;
    g_script.script_stream.insert(g_script.script_stream.end(), new LineInfo);
    g_script.script_stream[num]->line   = line;
    g_script.script_stream[num]->ext    = 0;
    g_script.script_stream[num]->next   = (int)num + 1;
    g_script.script_stream[num]->ornext = (int)num + 1;
    g_script.script_stream[num]->lineno = no;
    g_script.script_stream[num]->cno    = (int)num;
    g_script.script_stream[num]->userdata = NULL;


    if (parse_operator_parameter (g_script.script_stream[num]) < 0) {
        msg.clear();
        msg <<"parse error(" << (unsigned int)g_script.script_stream[num]->lineno 
            <<"): unknown keyword.";
        g_script.parse_error = msg.str ();
#ifdef debug_script_lib
        dbgprint ("%s\n", g_script.parse_error.c_str());
#endif
        return -1;
    }

    ret = post_parse (num);
    if (ret != 0) {
        msg.clear ();
        msg <<"parse error(" 
            << (unsigned int)g_script.script_stream[num]->lineno << "): " 
            << g_script.parse_error;
        g_script.parse_error = msg.str ();
#ifdef debug_script_lib
        dbgprint ("%s\n", g_script.parse_error.c_str());
#endif        
        return -3;
    }

    return 0;
}

