/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

#ifndef _ATLI_DEF_H
#define _ATLI_DEF_H




#define KEYWORD_TT_NUMB 128

enum _tag_sdkkey_{
    SCP_label = 1000,
    SCP_goto,
    SCP_foreach,
    SCP_endforeach,
    SCP_set,
    SCP_if,
    SCP_else,
    SCP_endif,
    SCP_begin,
    SCP_end,
    SCP_function,
    SCP_fend,
    SCP_call,
    SCP_exec,
    SCP_fexec,
    SCP_global,
    SCP_for,
    SCP_endfor,
    SCP_return,
    SCP_n_return,
    SCP_while,
    SCP_endwhile
};

#define RETURN_VAR  "__return_value"
#define RETURN_APP_VAR  "__return_app_value"

using namespace std;

#ifdef  _DEBUG
#define debug_script_lib
#endif

#define KEYWORD(key, ind, pn) {key, string(#key).replace(ind, 1, "::", 2), pn}


struct _tag_keywordlist_ {
    int     scpoper;
    char    keywordstring[32];
    int     paramnumber;
};

typedef struct _tag_lineinfo {
    int             opertor;
    int             param_num;
    vector<string>  param_string;
    string          line;
    int             uidx;
    int             next;
    int             ornext;
    int             ext;
    int             lineno;
    int             cno;
    void*           userdata;
}LineInfo, *PtrLineInfo;

typedef struct _tag_stack {
    int                 ret_pos;
    string              function_name;
    map<string, string> func_variable_set;
}FUNCSTACK, *LPFUNCSTACK;

typedef struct _tag_script_intepretor {
    unsigned int            g_keywordnum;
    struct _tag_keywordlist_ g_keyword[KEYWORD_TT_NUMB];
    unsigned int            script_start;
    unsigned int            script_end;
    int                     current_stream;
    int                     current_line;
    vector<PtrLineInfo>     script_stream;
    string                  parse_error;
    map<string, string>     variable_set;
    map<string, size_t>     function_list;
    vector<LPFUNCSTACK>     callstack;
    SCRIPT_EXE_FUNC         script_exe_func;
    LPPARAMLIST             script_argv;
    int                     debug_level;
}Scriptor;


#endif

