/**
 *
 * Copyright (C) 2005 linxs<linxsy@gmail.com>
 *
 * Atli is controlled and maintained by the original author. Atli 
 * is a program originally targeting at providing a quick way to 
 * develop application script language, which is extensible and 
 * flexible.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 *
 *
**/

 

#ifdef WIN32
#define HAVE_FNMATCH 1
//#include "stdafx.h"
#include <windows.h>
#endif
#ifdef LINUX
#include <stdarg.h>
#include <config.h>
#endif
#include <vector>
#include <fstream>
#include <iterator>
#include <sstream>
#include <string>
#include <map>
#include <algorithm>
#include "logiparse.h"
#include "utility.h"
#if HAVE_FNMATCH
#include <fnmatch.h>
#endif


#define LOPERATORS "&!|><~=+-*/%)"
#define LOPERANDS  "!(\"-.0123456789"
#define LOPERANDS_END "(\"0123456789."


//#define _debug_logic_

using namespace std;

typedef struct _tag_lop_ {
    int     type;  // 0 is operand as string , 1 is operator, 2 is operand as float
        string  lop_operand;
        string  lop_operator;
        float   lop_float;
    
}LAOPER;

struct _tag_logic { 
    string          logic_string;
    string          error_string;
    int             result;
    int             knum;
    int             LPOP;
    vector<LAOPER>   oper_list;
    map<string,int>    operator_priority;
    vector<string>     logic_operand;
    vector<string>     logic_operator;
} g_logic;

#define LOPNDLIST g_logic.logic_operand
#define LOPRTLIST g_logic.logic_operator
#define LOPLIST   g_logic.oper_list
#define LOPPRTY   g_logic.operator_priority
#define LPOP      g_logic.LPOP

static int proc_error (char *str, int st, int ed)
{
    g_logic.error_string = str;
    g_logic.error_string += g_logic.logic_string.substr (st, ed -st);
    return 0;
}


static int initialize ()
{
    g_logic.logic_string  = "";
    g_logic.error_string   = "";
    g_logic.result         = 0;
    g_logic.knum           = 0;

    g_logic.oper_list.clear ();
    g_logic.logic_operand.clear ();
    g_logic.logic_operator.clear ();
    g_logic.operator_priority.clear ();

    g_logic.operator_priority[">"] = 1;
    g_logic.operator_priority["<"] = 1;
    g_logic.operator_priority[">="] = 1;
    g_logic.operator_priority["<="] = 1;
    g_logic.operator_priority["!="] = 1;
    g_logic.operator_priority["="] = 1;
    g_logic.operator_priority["~="] = 1;

    g_logic.operator_priority["|"] = 3;
    g_logic.operator_priority["&"] = 5;
    g_logic.operator_priority["!"] = 7;

    g_logic.operator_priority["+"] = 11;
    g_logic.operator_priority["-"] = 11;
    g_logic.operator_priority["*"] = 13;
    g_logic.operator_priority["/"] = 13;
    g_logic.operator_priority["%"] = 13;

    g_logic.operator_priority["("] = 20;
    g_logic.operator_priority[")"] = 0;
    return 0;
}

static int uninitialize ()
{
    g_logic.oper_list.clear ();
    g_logic.logic_operand.clear ();
    g_logic.logic_operator.clear ();
    g_logic.operator_priority.clear ();

    return 0;
}


static int operand_push (size_t st, size_t ed)
{
    string sop;
    LAOPER aop;

    if (g_logic.logic_string[st] == '"') {
        st ++;
        ed --;
    }
    sop = g_logic.logic_string.substr (st, ed - st);
#ifdef _debug_logic_
    dbgprint ("get one operand:%s\n", sop.c_str());
#endif
    aop.type = 0;
    aop.lop_operand = sop;
    g_logic.oper_list.push_back (aop);

    return 0;
}

static int operator_push (size_t st, size_t ed)
{
    string sop;
    LAOPER aop;

    sop = g_logic.logic_string.substr (st, ed - st);
    aop.type = 1;
    aop.lop_operator = sop;
    g_logic.oper_list.push_back (aop);
#ifdef _debug_logic_
    dbgprint ("get one operator:%s, op size:%d\n", sop.c_str(), LOPLIST.size());
#endif

    return 0;
}

static int get_one_operand (int &st)
{
    int ed, rst;

    st = (int)g_logic.logic_string.find_first_not_of (" \t", st);
    rst = (int)g_logic.logic_string.find_first_of (LOPERANDS, st);
    if (st != rst) return -1;

    do {
        st = (int)g_logic.logic_string.find_first_of (LOPERANDS, st);
        if (st < 0) return -1;

        if (g_logic.logic_string[st] == '(') {
            operator_push (st, st+1);
            st ++;
            g_logic.knum ++;
            continue;
        }
        else if (g_logic.logic_string[st] == '!'){
            operator_push (st, st+1);
            st ++;
            continue;
        }
        else break;
    }while (1);

    if (g_logic.logic_string [st] == '"') {
        ed = (int)g_logic.logic_string.find_first_of ('"', st+1);
        ed ++;
        if (ed == 0) ed = (int)g_logic.logic_string.length ();

    } else {
        ed = (int)g_logic.logic_string.find_first_not_of (LOPERANDS_END, st+1);
        if (ed < 0) ed = (int)g_logic.logic_string.length ();
    }

    return ed;
}

static int get_one_operator (int &st)
{
    int ed;
    int rst;

    st = (int)g_logic.logic_string.find_first_not_of (" \t", st);
    if (st < 0) return -1;
    rst = (int)g_logic.logic_string.find_first_of (LOPERATORS, st);
    if (rst < 0) return -2;
    if (st != rst) return -2;

    do {
        st = (int)g_logic.logic_string.find_first_of (LOPERATORS, st);
        if (st < 0) return 1;
        if (g_logic.logic_string[st] == ')') {
            operator_push (st, st + 1);
            st ++;
            g_logic.knum --;
            continue;
        }
        else break;
    }while (1);
    ed = (int)g_logic.logic_string.find_first_not_of (LOPERATORS, st);
    if (ed == -1) ed =(int) g_logic.logic_string.length ();
 
    return ed;
}


static int parse_logic_string ()
{
    int st, ed;
    int ret;

    st = 0; ed = 0;

    ed = get_one_operand (st);
    if (ed < 0) {
        g_logic.error_string = "Can not get any operand";
        return -1;
    }
    ret = operand_push (st, ed);
    if (ret < 0) {
        proc_error ("Can not get operand correct: ", st, ed);
        return -2;
    }

    while (ed < (int)g_logic.logic_string.length ()) {
        st = ed;
        ed = get_one_operator (st);
        if (ed == -2) {
            proc_error ("Can not get operator correct:", st, ed);
            return -1;
        }
        else if (st == -1 || ed == -1) break;
        ret = operator_push (st, ed);
        if (ret < 0) {
            proc_error( "Can not get correct operator:", st, ed);
            return -3;
        }

        st = ed;
        ed = get_one_operand (st);
        if (ed < 0) {
            proc_error ("Can not get correct operand:", st, ed);
            return -4;
        }
        ret = operand_push (st, ed);
        if (ret < 0) {
            proc_error ("Can not get correct operand:", st, ed);
            return -5;
        }
    }

    if (g_logic.knum) {
        g_logic.error_string = "( and ) are not corresponding to each other";
        return -1;
    }


    return 0;
}


static int logic_calc_one (string &opnd1, string &opnd2, string &oper)
{    

    if (oper == "!") {
        if (is_number (opnd2)) {
            if (as_number (opnd2)) return 0;
            else return 1;
        } else {
            return !opnd2.length ();
        }
    }

    if (oper == "&&") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) && as_number (opnd2);
        }
        else return opnd1.length () && opnd2.length();
    }

    if (oper == "||") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) || as_number (opnd2);
        }
        else return opnd1.length () || opnd2.length();
    }

    if (oper == "==") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) == as_number (opnd2);
        }
        else return opnd1 == opnd2;
    }

    if (oper == "!=") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) != as_number (opnd2);
        }
        else return opnd1 != opnd2;
    }

    if (oper == ">") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) > as_number (opnd2);
        }
        else return opnd1 > opnd2;
    }

    if (oper == ">=") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) >= as_number (opnd2);
        }
        else return opnd1 >= opnd2;
    }

    if (oper == "<") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) < as_number (opnd2);
        }
        else return opnd1 < opnd2;
    }

    if (oper == "<=") {
        if (is_number (opnd1) && is_number (opnd2)) {
            return as_number (opnd1) <= as_number (opnd2);
        }
        else return opnd1 <= opnd2;
    }

#if HAVE_FNMATCH
    if (oper == "~~") {
        return !fnmatch (opnd2.c_str(), opnd1.c_str(), 0);
    }
#else
    if (oper == "~~") {
        dbgprint ("error, ~= can not be used\n");
    }
#endif
    ostringstream msg;
    msg << "error operator: " << oper <<endl;
    g_logic.error_string = msg.str ();
    return 0;
}


int calc_one (string &opnd1, string &opnd2, string &oper, string &result)
{
    int log_ret;
    char buf[32];
               
    if (oper == "+") {
        if (is_number (opnd1) && is_number (opnd2)) {
            sprintf (buf, "%f", as_number(opnd1) + as_number (opnd2));
            result = buf;
            return 0;
        }
        else {
            result = opnd1 + opnd2;
            return 0;
        }
    }

    if (oper == "-") {
        if (is_number (opnd1) && is_number (opnd2)) {
            sprintf (buf, "%f", as_number(opnd1) - as_number (opnd2));
            result = buf;
            return 0;
        }
        else {
            result = opnd1 + opnd2;
            return 0;
        }
    }

    if (oper == "*") {
        if (is_number (opnd1) && is_number (opnd2)) {
            sprintf (buf, "%f", as_number(opnd1) * as_number (opnd2));
            result = buf;
            return 0;
        }
        else {
            result = opnd1 + opnd2;
            return 0;
        }
    }

    if (oper == "/") {
        if (is_number (opnd1) && is_number (opnd2)) {
            sprintf (buf, "%f", as_number(opnd1) / as_number (opnd2));
            result = buf;
            return 0;
        }
        else {
            result = opnd1 + opnd2;
            return 0;
        }
    }

    if (oper == "%") {
        if (is_number (opnd1) && is_number (opnd2)) {
            sprintf (buf, "%d", (int)as_number(opnd1) %(int) as_number (opnd2));
            result = buf;
            return 0;
        }
        else {
            result = opnd1 + opnd2;
            return 0;
        }
    }

    log_ret = logic_calc_one (opnd1, opnd2, oper);
    if (log_ret)
        result = "1";
    else
        result = "0";
    return 0;

}

static int calc_back ()
{
    string opnd1, opnd2;
    string result;
    string oper;

    if (LOPLIST[LPOP].lop_operator != "(") 
    while (LOPRTLIST.size() >0 && LOPPRTY [LOPLIST[LPOP].lop_operator] <= LOPPRTY[LOPRTLIST.back ()]) {
#ifdef _debug_logic_
    dbgprint ("process operator:%s\n", LOPRTLIST.back().c_str());
#endif
        if (LOPLIST[LPOP].lop_operator == ")" && LOPRTLIST.back() == "(") {
            LPOP++;
            LOPRTLIST.pop_back ();
            return 0;
        }
        if (LOPRTLIST.back() != "(" && LOPRTLIST.back() != ")") {
            oper = LOPRTLIST.back ();
            LOPRTLIST.pop_back ();
            opnd2 = LOPNDLIST.back ();
            LOPNDLIST.pop_back ();
            if (oper != "!") {
                opnd1 = LOPNDLIST.back ();
                LOPNDLIST.pop_back ();
            }
            else
                opnd1 = "";
        }
        else break;

        calc_one (opnd1, opnd2, oper, result);

        LOPNDLIST.push_back (result);

#ifdef _debug_logic_
        dbgprint ("CALC: %s  %s %s = %d\n", opnd1.c_str(), oper.c_str() ,opnd2.c_str(), result);
#endif
    }
    LOPRTLIST.push_back (LOPLIST[LPOP++].lop_operator);

    return 0;
}


static int calc_end ()
{
    string opnd1, opnd2;
    string result;
    string oper;

    while (LOPRTLIST.size() >0) {
#ifdef _debug_logic_
    dbgprint ("process operator:%s\n", LOPRTLIST.back().c_str());
#endif
    if (LOPRTLIST.back() != "(" && LOPRTLIST.back() != ")") {
            oper = LOPRTLIST.back ();
            LOPRTLIST.pop_back ();
            opnd2 = LOPNDLIST.back ();
            LOPNDLIST.pop_back ();
            if (oper != "!") {
                opnd1 = LOPNDLIST.back ();
                LOPNDLIST.pop_back ();
            }
            else
                opnd1 = "";
        }
        calc_one (opnd1, opnd2, oper, result);

        LOPNDLIST.push_back (result);

#ifdef _debug_logic_
        dbgprint ("CALC: %s  %s %s = %d\n", opnd1.c_str(), oper.c_str() ,opnd2.c_str(), result);
#endif
    }

    return 0;
}

static int calc_logic ()
{
    LPOP = 0;
#ifdef _debug_logic_
    dbgprint ("begin to calc\n");
#endif

    while (LPOP < (int)LOPLIST.size ()) {
#ifdef _debug_logic_
        if (LOPLIST[LPOP].type == 0) {
            dbgprint ("Operand: %s\n", LOPLIST[LPOP].lop_operand.c_str());
        }
        else {
            dbgprint ("Operator: %s\n", LOPLIST[LPOP].lop_operator.c_str());
        }
#endif
        switch (LOPLIST[LPOP].type) {
            case 0:
                LOPNDLIST.push_back (LOPLIST[LPOP++].lop_operand);
                break;
            case 1:
                if (LOPLIST[LPOP].lop_operator == "(" || LOPRTLIST.size() == 0) {
                    LOPRTLIST.push_back (LOPLIST[LPOP++].lop_operator);
                } else {
                    calc_back ();// go on here next time.
                }
                break;
        }
    }
    calc_end ();
    if (is_number (LOPNDLIST.back().c_str()))
        g_logic.result = atoi (LOPNDLIST.back ().c_str());
    else {
        g_logic.error_string = "logic expression is wrong";
        return -1;
    }
#ifdef _debug_logic_
    dbgprint ("Result:%d\n", g_logic.result);
#endif

    return 0;
}

int get_value_logic (const char *logic)
{
    int ret;

    initialize ();
    g_logic.logic_string  = logic;
#ifdef _debug_logic_
    dbgprint ("logic: %s\n", logic);
#endif        

    ret = parse_logic_string ();
    if (ret) goto error;

    ret = calc_logic ();
    if (ret) goto error;

    uninitialize ();
    return g_logic.result;
error:
#ifdef _debug_logic_
    dbgprint ("error: %s\n", g_logic.error_string.c_str());
#endif 
    uninitialize ();
    return 0;
}

const char   *get_error_logic ()
{
    return g_logic.error_string.c_str ();
}

#if 0
int main (int argc, char*argv[])
{
    if (argc < 2) return -1;

    get_value_logic (argv[1]);
    return 0;
}
#endif
